######################################################################
#
# 1153_utf8jp_by_letsj.t
#
# Copyright (c) 2018 INABA Hitoshi <ina@cpan.org> in a CPAN
######################################################################

use strict;
use FindBin;
use lib "$FindBin::Bin/../lib";

BEGIN {
    use vars qw(@test);
    @test = (
        ["\x00",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x80"],
        ["\x01",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x81"],
        ["\x02",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x82"],
        ["\x03",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x83"],
        ["\x04",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x84"],
        ["\x05",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x85"],
        ["\x06",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x86"],
        ["\x07",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x87"],
        ["\x08",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x88"],
        ["\x09",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x89"],
        ["\x0A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8A"],
        ["\x0B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8B"],
        ["\x0C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8C"],
        ["\x0D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8D"],
        ["\x0E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8E"],
        ["\x0F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x8F"],
        ["\x10",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x90"],
        ["\x11",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x91"],
        ["\x12",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x92"],
        ["\x13",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x93"],
        ["\x14",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x94"],
        ["\x15",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x95"],
        ["\x16",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x96"],
        ["\x17",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x97"],
        ["\x18",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x98"],
        ["\x19",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x99"],
        ["\x1A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9A"],
        ["\x1B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9B"],
        ["\x1C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9C"],
        ["\x1D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9D"],
        ["\x1E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9E"],
        ["\x1F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\x9F"],
        ["\x20",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA0"],
        ["\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA1"],
        ["\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA2"],
        ["\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA3"],
        ["\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA4"],
        ["\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA5"],
        ["\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA6"],
        ["\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA7"],
        ["\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA8"],
        ["\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xA9"],
        ["\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAA"],
        ["\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAB"],
        ["\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAC"],
        ["\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAD"],
        ["\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAE"],
        ["\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xAF"],
        ["\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB0"],
        ["\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB1"],
        ["\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB2"],
        ["\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB3"],
        ["\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB4"],
        ["\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB5"],
        ["\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB6"],
        ["\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB7"],
        ["\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB8"],
        ["\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xB9"],
        ["\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBA"],
        ["\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBB"],
        ["\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBC"],
        ["\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBD"],
        ["\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBE"],
        ["\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x80\xBF"],
        ["\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x80"],
        ["\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x81"],
        ["\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x82"],
        ["\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x83"],
        ["\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x84"],
        ["\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x85"],
        ["\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x86"],
        ["\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x87"],
        ["\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x88"],
        ["\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x89"],
        ["\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8A"],
        ["\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8B"],
        ["\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8C"],
        ["\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8D"],
        ["\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8E"],
        ["\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x8F"],
        ["\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x90"],
        ["\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x91"],
        ["\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x92"],
        ["\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x93"],
        ["\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x94"],
        ["\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x95"],
        ["\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x96"],
        ["\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x97"],
        ["\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x98"],
        ["\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x99"],
        ["\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9A"],
        ["\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9B"],
        ["\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9C"],
        ["\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9D"],
        ["\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9E"],
        ["\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\x9F"],
        ["\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA0"],
        ["\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA1"],
        ["\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA2"],
        ["\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA3"],
        ["\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA4"],
        ["\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA5"],
        ["\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA6"],
        ["\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA7"],
        ["\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA8"],
        ["\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xA9"],
        ["\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAA"],
        ["\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAB"],
        ["\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAC"],
        ["\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAD"],
        ["\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAE"],
        ["\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xAF"],
        ["\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB0"],
        ["\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB1"],
        ["\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB2"],
        ["\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB3"],
        ["\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB4"],
        ["\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB5"],
        ["\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB6"],
        ["\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB7"],
        ["\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB8"],
        ["\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xB9"],
        ["\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBA"],
        ["\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBB"],
        ["\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBC"],
        ["\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBD"],
        ["\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBE"],
        ["\x7F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x81\xBF"],
        ["\x80",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x80"],
        ["\x81",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x81"],
        ["\x82",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x82"],
        ["\x83",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x83"],
        ["\x84",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x84"],
        ["\x85",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x85"],
        ["\x86",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x86"],
        ["\x87",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x87"],
        ["\x88",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x88"],
        ["\x89",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x89"],
        ["\x8A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8A"],
        ["\x8B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8B"],
        ["\x8C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8C"],
        ["\x8D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8D"],
        ["\x8E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8E"],
        ["\x8F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x8F"],
        ["\x90",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x90"],
        ["\x91",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x91"],
        ["\x92",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x92"],
        ["\x93",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x93"],
        ["\x94",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x94"],
        ["\x95",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x95"],
        ["\x96",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x96"],
        ["\x97",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x97"],
        ["\x98",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x98"],
        ["\x99",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x99"],
        ["\x9A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9A"],
        ["\x9B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9B"],
        ["\x9C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9C"],
        ["\x9D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9D"],
        ["\x9E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9E"],
        ["\x9F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\x9F"],
        ["\xA0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA0"],
        ["\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA1"],
        ["\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA2"],
        ["\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA3"],
        ["\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA4"],
        ["\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA5"],
        ["\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA6"],
        ["\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA7"],
        ["\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA8"],
        ["\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xA9"],
        ["\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAA"],
        ["\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAB"],
        ["\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAC"],
        ["\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAD"],
        ["\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAE"],
        ["\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xAF"],
        ["\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB0"],
        ["\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB1"],
        ["\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB2"],
        ["\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB3"],
        ["\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB4"],
        ["\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB5"],
        ["\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB6"],
        ["\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB7"],
        ["\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB8"],
        ["\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xB9"],
        ["\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBA"],
        ["\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBB"],
        ["\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBC"],
        ["\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBD"],
        ["\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBE"],
        ["\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x82\xBF"],
        ["\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x80"],
        ["\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x81"],
        ["\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x82"],
        ["\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x83"],
        ["\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x84"],
        ["\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x85"],
        ["\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x86"],
        ["\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x87"],
        ["\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x88"],
        ["\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x89"],
        ["\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8A"],
        ["\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8B"],
        ["\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8C"],
        ["\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8D"],
        ["\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8E"],
        ["\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x8F"],
        ["\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x90"],
        ["\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x91"],
        ["\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x92"],
        ["\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x93"],
        ["\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x94"],
        ["\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x95"],
        ["\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x96"],
        ["\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x97"],
        ["\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x98"],
        ["\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x99"],
        ["\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9A"],
        ["\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9B"],
        ["\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9C"],
        ["\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9D"],
        ["\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9E"],
        ["\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\x9F"],
        ["\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA0"],
        ["\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA1"],
        ["\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA2"],
        ["\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA3"],
        ["\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA4"],
        ["\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA5"],
        ["\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA6"],
        ["\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA7"],
        ["\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA8"],
        ["\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xA9"],
        ["\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAA"],
        ["\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAB"],
        ["\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAC"],
        ["\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAD"],
        ["\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAE"],
        ["\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xAF"],
        ["\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB0"],
        ["\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB1"],
        ["\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB2"],
        ["\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB3"],
        ["\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB4"],
        ["\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB5"],
        ["\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB6"],
        ["\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB7"],
        ["\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB8"],
        ["\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xB9"],
        ["\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBA"],
        ["\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBB"],
        ["\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBC"],
        ["\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBD"],
        ["\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBE"],
        ["\xFF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'S'},"\xF3\xB0\x83\xBF"],
        ["\x20\x20",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x80"],
        ["\xA1\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x81"],
        ["\xA1\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x82"],
        ["\xA1\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x83"],
        ["\xA1\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x84"],
        ["\xA1\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x85"],
        ["\xA1\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x86"],
        ["\xA1\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x87"],
        ["\xA1\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x88"],
        ["\xA1\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x89"],
        ["\xA1\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8A"],
        ["\xA1\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8B"],
        ["\xA1\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8C"],
        ["\xA1\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8D"],
        ["\xA1\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8E"],
        ["\xA1\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x8F"],
        ["\xA1\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x90"],
        ["\xA1\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x91"],
        ["\xA1\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x92"],
        ["\xA1\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x93"],
        ["\xA1\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x94"],
        ["\xA1\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x95"],
        ["\xA1\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x96"],
        ["\xA1\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x97"],
        ["\xA1\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x98"],
        ["\xA1\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x99"],
        ["\xA1\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9A"],
        ["\xA1\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9B"],
        ["\xA1\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9C"],
        ["\xA1\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9D"],
        ["\xA1\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\x9E"],
        ["\xA1\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA0"],
        ["\xA1\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA2"],
        ["\xA1\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA3"],
        ["\xA1\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA4"],
        ["\xA1\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA5"],
        ["\xA1\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA6"],
        ["\xA1\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA7"],
        ["\xA1\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA8"],
        ["\xA1\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xA9"],
        ["\xA1\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAA"],
        ["\xA1\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAB"],
        ["\xA1\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAC"],
        ["\xA1\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAD"],
        ["\xA1\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAE"],
        ["\xA1\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xAF"],
        ["\xA1\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB0"],
        ["\xA1\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB1"],
        ["\xA1\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB2"],
        ["\xA1\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB3"],
        ["\xA1\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB4"],
        ["\xA1\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB5"],
        ["\xA1\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB6"],
        ["\xA1\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB7"],
        ["\xA1\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB8"],
        ["\xA1\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xB9"],
        ["\xA1\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBA"],
        ["\xA1\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBB"],
        ["\xA1\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBD"],
        ["\xA1\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBE"],
        ["\xA1\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x84\xBF"],
        ["\xA1\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x80"],
        ["\xA1\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x81"],
        ["\xA1\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x82"],
        ["\xA1\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x83"],
        ["\xA1\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x84"],
        ["\xA1\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x85"],
        ["\xA1\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x86"],
        ["\xA1\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x87"],
        ["\xA1\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x88"],
        ["\xA1\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x89"],
        ["\xA1\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8A"],
        ["\xA1\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8B"],
        ["\xA1\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8C"],
        ["\xA1\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8D"],
        ["\xA1\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8E"],
        ["\xA1\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x8F"],
        ["\xA1\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x92"],
        ["\xA1\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x93"],
        ["\xA1\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x94"],
        ["\xA1\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x95"],
        ["\xA1\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x96"],
        ["\xA1\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x97"],
        ["\xA1\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x98"],
        ["\xA1\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x99"],
        ["\xA1\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9A"],
        ["\xA1\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9B"],
        ["\xA1\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9C"],
        ["\xA1\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9D"],
        ["\xA2\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9E"],
        ["\xA2\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\x9F"],
        ["\xA2\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA0"],
        ["\xA2\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA1"],
        ["\xA2\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA2"],
        ["\xA2\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA3"],
        ["\xA2\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA4"],
        ["\xA2\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA5"],
        ["\xA2\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA6"],
        ["\xA2\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA7"],
        ["\xA2\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA8"],
        ["\xA2\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xA9"],
        ["\xA2\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAA"],
        ["\xA2\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xAB"],
        ["\xA2\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB7"],
        ["\xA2\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB8"],
        ["\xA2\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xB9"],
        ["\xA2\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBA"],
        ["\xA2\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBB"],
        ["\xA2\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBC"],
        ["\xA2\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBD"],
        ["\xA2\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x85\xBE"],
        ["\xA2\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x87"],
        ["\xA2\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x88"],
        ["\xA2\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8A"],
        ["\xA2\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8B"],
        ["\xA2\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8C"],
        ["\xA2\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x8D"],
        ["\xA2\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x99"],
        ["\xA2\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9A"],
        ["\xA2\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9B"],
        ["\xA2\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9C"],
        ["\xA2\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9D"],
        ["\xA2\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9E"],
        ["\xA2\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\x9F"],
        ["\xA2\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA0"],
        ["\xA2\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA1"],
        ["\xA2\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA2"],
        ["\xA2\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA3"],
        ["\xA2\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA4"],
        ["\xA2\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA5"],
        ["\xA2\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA6"],
        ["\xA2\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xA7"],
        ["\xA2\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xAF"],
        ["\xA2\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB0"],
        ["\xA2\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB1"],
        ["\xA2\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB2"],
        ["\xA2\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB3"],
        ["\xA2\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB4"],
        ["\xA2\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB5"],
        ["\xA2\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xB6"],
        ["\xA2\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x86\xBB"],
        ["\xA3\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8B"],
        ["\xA3\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8C"],
        ["\xA3\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8D"],
        ["\xA3\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8E"],
        ["\xA3\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x8F"],
        ["\xA3\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x90"],
        ["\xA3\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x91"],
        ["\xA3\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x92"],
        ["\xA3\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x93"],
        ["\xA3\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x94"],
        ["\xA3\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9C"],
        ["\xA3\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9D"],
        ["\xA3\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9E"],
        ["\xA3\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\x9F"],
        ["\xA3\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA0"],
        ["\xA3\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA1"],
        ["\xA3\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA2"],
        ["\xA3\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA3"],
        ["\xA3\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA4"],
        ["\xA3\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA5"],
        ["\xA3\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA6"],
        ["\xA3\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA7"],
        ["\xA3\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA8"],
        ["\xA3\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xA9"],
        ["\xA3\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAA"],
        ["\xA3\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAB"],
        ["\xA3\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAC"],
        ["\xA3\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAD"],
        ["\xA3\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAE"],
        ["\xA3\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xAF"],
        ["\xA3\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB0"],
        ["\xA3\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB1"],
        ["\xA3\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB2"],
        ["\xA3\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB3"],
        ["\xA3\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB4"],
        ["\xA3\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xB5"],
        ["\xA3\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBC"],
        ["\xA3\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBD"],
        ["\xA3\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBE"],
        ["\xA3\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x87\xBF"],
        ["\xA3\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x80"],
        ["\xA3\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x81"],
        ["\xA3\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x82"],
        ["\xA3\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x83"],
        ["\xA3\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x84"],
        ["\xA3\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x85"],
        ["\xA3\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x86"],
        ["\xA3\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x87"],
        ["\xA3\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x88"],
        ["\xA3\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x89"],
        ["\xA3\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8A"],
        ["\xA3\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8B"],
        ["\xA3\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8C"],
        ["\xA3\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8D"],
        ["\xA3\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8E"],
        ["\xA3\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x8F"],
        ["\xA3\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x90"],
        ["\xA3\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x91"],
        ["\xA3\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x92"],
        ["\xA3\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x93"],
        ["\xA3\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x94"],
        ["\xA3\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x95"],
        ["\xA4\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9A"],
        ["\xA4\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9B"],
        ["\xA4\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9C"],
        ["\xA4\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9D"],
        ["\xA4\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9E"],
        ["\xA4\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\x9F"],
        ["\xA4\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA0"],
        ["\xA4\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA1"],
        ["\xA4\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA2"],
        ["\xA4\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA3"],
        ["\xA4\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA4"],
        ["\xA4\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA5"],
        ["\xA4\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA6"],
        ["\xA4\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA7"],
        ["\xA4\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA8"],
        ["\xA4\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xA9"],
        ["\xA4\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAA"],
        ["\xA4\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAB"],
        ["\xA4\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAC"],
        ["\xA4\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAD"],
        ["\xA4\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAE"],
        ["\xA4\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xAF"],
        ["\xA4\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB0"],
        ["\xA4\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB1"],
        ["\xA4\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB2"],
        ["\xA4\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB3"],
        ["\xA4\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB4"],
        ["\xA4\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB5"],
        ["\xA4\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB6"],
        ["\xA4\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB7"],
        ["\xA4\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB8"],
        ["\xA4\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xB9"],
        ["\xA4\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBA"],
        ["\xA4\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBB"],
        ["\xA4\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBC"],
        ["\xA4\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBD"],
        ["\xA4\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBE"],
        ["\xA4\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x88\xBF"],
        ["\xA4\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x80"],
        ["\xA4\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x81"],
        ["\xA4\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x82"],
        ["\xA4\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x83"],
        ["\xA4\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x84"],
        ["\xA4\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x85"],
        ["\xA4\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x86"],
        ["\xA4\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x87"],
        ["\xA4\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x88"],
        ["\xA4\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x89"],
        ["\xA4\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8A"],
        ["\xA4\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8B"],
        ["\xA4\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8C"],
        ["\xA4\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8D"],
        ["\xA4\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8E"],
        ["\xA4\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x8F"],
        ["\xA4\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x90"],
        ["\xA4\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x91"],
        ["\xA4\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x92"],
        ["\xA4\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x93"],
        ["\xA4\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x94"],
        ["\xA4\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x95"],
        ["\xA4\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x96"],
        ["\xA4\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x97"],
        ["\xA4\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x98"],
        ["\xA4\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x99"],
        ["\xA4\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9A"],
        ["\xA4\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9B"],
        ["\xA4\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9C"],
        ["\xA4\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9D"],
        ["\xA4\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9E"],
        ["\xA4\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\x9F"],
        ["\xA4\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA0"],
        ["\xA4\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA1"],
        ["\xA4\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA2"],
        ["\xA4\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA3"],
        ["\xA4\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA4"],
        ["\xA4\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA5"],
        ["\xA4\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA6"],
        ["\xA4\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA7"],
        ["\xA4\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA8"],
        ["\xA4\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xA9"],
        ["\xA4\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAA"],
        ["\xA4\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAB"],
        ["\xA4\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xAC"],
        ["\xA5\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB8"],
        ["\xA5\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xB9"],
        ["\xA5\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBA"],
        ["\xA5\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBB"],
        ["\xA5\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBC"],
        ["\xA5\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBD"],
        ["\xA5\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBE"],
        ["\xA5\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x89\xBF"],
        ["\xA5\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x80"],
        ["\xA5\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x81"],
        ["\xA5\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x82"],
        ["\xA5\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x83"],
        ["\xA5\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x84"],
        ["\xA5\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x85"],
        ["\xA5\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x86"],
        ["\xA5\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x87"],
        ["\xA5\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x88"],
        ["\xA5\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x89"],
        ["\xA5\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8A"],
        ["\xA5\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8B"],
        ["\xA5\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8C"],
        ["\xA5\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8D"],
        ["\xA5\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8E"],
        ["\xA5\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x8F"],
        ["\xA5\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x90"],
        ["\xA5\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x91"],
        ["\xA5\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x92"],
        ["\xA5\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x93"],
        ["\xA5\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x94"],
        ["\xA5\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x95"],
        ["\xA5\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x96"],
        ["\xA5\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x97"],
        ["\xA5\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x98"],
        ["\xA5\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x99"],
        ["\xA5\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9A"],
        ["\xA5\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9B"],
        ["\xA5\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9C"],
        ["\xA5\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9D"],
        ["\xA5\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9E"],
        ["\xA5\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\x9F"],
        ["\xA5\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA0"],
        ["\xA5\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA1"],
        ["\xA5\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA2"],
        ["\xA5\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA3"],
        ["\xA5\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA4"],
        ["\xA5\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA5"],
        ["\xA5\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA6"],
        ["\xA5\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA7"],
        ["\xA5\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA8"],
        ["\xA5\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xA9"],
        ["\xA5\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAA"],
        ["\xA5\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAB"],
        ["\xA5\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAC"],
        ["\xA5\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAD"],
        ["\xA5\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAE"],
        ["\xA5\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xAF"],
        ["\xA5\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB0"],
        ["\xA5\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB1"],
        ["\xA5\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB2"],
        ["\xA5\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB3"],
        ["\xA5\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB4"],
        ["\xA5\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB5"],
        ["\xA5\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB6"],
        ["\xA5\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB7"],
        ["\xA5\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB8"],
        ["\xA5\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xB9"],
        ["\xA5\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBA"],
        ["\xA5\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBB"],
        ["\xA5\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBC"],
        ["\xA5\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBD"],
        ["\xA5\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBE"],
        ["\xA5\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8A\xBF"],
        ["\xA5\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x80"],
        ["\xA5\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x81"],
        ["\xA5\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x82"],
        ["\xA5\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x83"],
        ["\xA5\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x84"],
        ["\xA5\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x85"],
        ["\xA5\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x86"],
        ["\xA5\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x87"],
        ["\xA5\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x88"],
        ["\xA5\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x89"],
        ["\xA5\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8A"],
        ["\xA5\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8B"],
        ["\xA5\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8C"],
        ["\xA5\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x8D"],
        ["\xA6\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x96"],
        ["\xA6\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x97"],
        ["\xA6\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x98"],
        ["\xA6\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x99"],
        ["\xA6\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9A"],
        ["\xA6\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9B"],
        ["\xA6\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9C"],
        ["\xA6\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9D"],
        ["\xA6\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9E"],
        ["\xA6\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\x9F"],
        ["\xA6\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA0"],
        ["\xA6\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA1"],
        ["\xA6\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA2"],
        ["\xA6\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA3"],
        ["\xA6\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA4"],
        ["\xA6\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA5"],
        ["\xA6\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA6"],
        ["\xA6\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA7"],
        ["\xA6\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA8"],
        ["\xA6\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xA9"],
        ["\xA6\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAA"],
        ["\xA6\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAB"],
        ["\xA6\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAC"],
        ["\xA6\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xAD"],
        ["\xA6\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB6"],
        ["\xA6\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB7"],
        ["\xA6\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB8"],
        ["\xA6\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xB9"],
        ["\xA6\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBA"],
        ["\xA6\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBB"],
        ["\xA6\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBC"],
        ["\xA6\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBD"],
        ["\xA6\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBE"],
        ["\xA6\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8B\xBF"],
        ["\xA6\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x80"],
        ["\xA6\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x81"],
        ["\xA6\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x82"],
        ["\xA6\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x83"],
        ["\xA6\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x84"],
        ["\xA6\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x85"],
        ["\xA6\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x86"],
        ["\xA6\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x87"],
        ["\xA6\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x88"],
        ["\xA6\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x89"],
        ["\xA6\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8A"],
        ["\xA6\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8B"],
        ["\xA6\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8C"],
        ["\xA6\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\x8D"],
        ["\xA7\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB4"],
        ["\xA7\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB5"],
        ["\xA7\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB6"],
        ["\xA7\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB7"],
        ["\xA7\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB8"],
        ["\xA7\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xB9"],
        ["\xA7\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBA"],
        ["\xA7\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBB"],
        ["\xA7\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBC"],
        ["\xA7\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBD"],
        ["\xA7\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBE"],
        ["\xA7\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8C\xBF"],
        ["\xA7\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x80"],
        ["\xA7\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x81"],
        ["\xA7\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x82"],
        ["\xA7\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x83"],
        ["\xA7\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x84"],
        ["\xA7\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x85"],
        ["\xA7\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x86"],
        ["\xA7\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x87"],
        ["\xA7\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x88"],
        ["\xA7\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x89"],
        ["\xA7\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8A"],
        ["\xA7\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8B"],
        ["\xA7\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8C"],
        ["\xA7\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8D"],
        ["\xA7\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8E"],
        ["\xA7\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x8F"],
        ["\xA7\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x90"],
        ["\xA7\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x91"],
        ["\xA7\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x92"],
        ["\xA7\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x93"],
        ["\xA7\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\x94"],
        ["\xA7\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA4"],
        ["\xA7\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA5"],
        ["\xA7\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA6"],
        ["\xA7\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA7"],
        ["\xA7\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA8"],
        ["\xA7\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xA9"],
        ["\xA7\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAA"],
        ["\xA7\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAB"],
        ["\xA7\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAC"],
        ["\xA7\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAD"],
        ["\xA7\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAE"],
        ["\xA7\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xAF"],
        ["\xA7\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB0"],
        ["\xA7\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB1"],
        ["\xA7\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB2"],
        ["\xA7\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB3"],
        ["\xA7\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB4"],
        ["\xA7\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB5"],
        ["\xA7\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB6"],
        ["\xA7\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB7"],
        ["\xA7\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB8"],
        ["\xA7\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xB9"],
        ["\xA7\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBA"],
        ["\xA7\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBB"],
        ["\xA7\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBC"],
        ["\xA7\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBD"],
        ["\xA7\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBE"],
        ["\xA7\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8D\xBF"],
        ["\xA7\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x80"],
        ["\xA7\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x81"],
        ["\xA7\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x82"],
        ["\xA7\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x83"],
        ["\xA7\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x84"],
        ["\xA8\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x92"],
        ["\xA8\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x93"],
        ["\xA8\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x94"],
        ["\xA8\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x95"],
        ["\xA8\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x96"],
        ["\xA8\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x97"],
        ["\xA8\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x98"],
        ["\xA8\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x99"],
        ["\xA8\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9A"],
        ["\xA8\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9B"],
        ["\xA8\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9C"],
        ["\xA8\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9D"],
        ["\xA8\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9E"],
        ["\xA8\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\x9F"],
        ["\xA8\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA0"],
        ["\xA8\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA1"],
        ["\xA8\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA2"],
        ["\xA8\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA3"],
        ["\xA8\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA4"],
        ["\xA8\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA5"],
        ["\xA8\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA6"],
        ["\xA8\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA7"],
        ["\xA8\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA8"],
        ["\xA8\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xA9"],
        ["\xA8\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAA"],
        ["\xA8\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAB"],
        ["\xA8\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAC"],
        ["\xA8\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAD"],
        ["\xA8\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAE"],
        ["\xA8\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xAF"],
        ["\xA8\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB0"],
        ["\xA8\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x8E\xB1"],
        ["\xA2\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x96\xA9"],
        ["\xB0\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x82"],
        ["\xB0\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x83"],
        ["\xB0\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x84"],
        ["\xB0\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x85"],
        ["\xB0\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x86"],
        ["\xB0\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x87"],
        ["\xB0\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x88"],
        ["\xB0\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x89"],
        ["\xB0\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8A"],
        ["\xB0\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8B"],
        ["\xB0\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8C"],
        ["\xB0\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8D"],
        ["\xB0\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8E"],
        ["\xB0\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x8F"],
        ["\xB0\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x90"],
        ["\xB0\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x91"],
        ["\xB0\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x92"],
        ["\xB0\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x93"],
        ["\xB0\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x94"],
        ["\xB0\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x95"],
        ["\xB0\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x96"],
        ["\xB0\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x97"],
        ["\xB0\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x98"],
        ["\xB0\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x99"],
        ["\xB0\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9A"],
        ["\xB0\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9B"],
        ["\xB0\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9C"],
        ["\xB0\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9D"],
        ["\xB0\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9E"],
        ["\xB0\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\x9F"],
        ["\xB0\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA0"],
        ["\xB0\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA1"],
        ["\xB0\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA2"],
        ["\xB0\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA3"],
        ["\xB0\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA4"],
        ["\xB0\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA5"],
        ["\xB0\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA6"],
        ["\xB0\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA7"],
        ["\xB0\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA8"],
        ["\xB0\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xA9"],
        ["\xB0\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAA"],
        ["\xB0\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAB"],
        ["\xB0\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAC"],
        ["\xB0\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAD"],
        ["\xB0\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAE"],
        ["\xB0\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xAF"],
        ["\xB0\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB0"],
        ["\xB0\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB1"],
        ["\xB0\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB2"],
        ["\xB0\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB3"],
        ["\xB0\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB4"],
        ["\xB0\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB5"],
        ["\xB0\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB6"],
        ["\xB0\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB7"],
        ["\xB0\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB8"],
        ["\xB0\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xB9"],
        ["\xB0\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBA"],
        ["\xB0\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBB"],
        ["\xB0\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBC"],
        ["\xB0\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBD"],
        ["\xB0\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBE"],
        ["\xB0\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9A\xBF"],
        ["\xB0\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x80"],
        ["\xB0\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x81"],
        ["\xB0\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x82"],
        ["\xB0\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x83"],
        ["\xB0\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x84"],
        ["\xB0\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x85"],
        ["\xB0\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x86"],
        ["\xB0\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x87"],
        ["\xB0\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x88"],
        ["\xB0\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x89"],
        ["\xB0\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8A"],
        ["\xB0\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8B"],
        ["\xB0\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8C"],
        ["\xB0\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8D"],
        ["\xB0\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8E"],
        ["\xB0\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x8F"],
        ["\xB0\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x90"],
        ["\xB0\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x91"],
        ["\xB0\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x92"],
        ["\xB0\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x93"],
        ["\xB0\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x94"],
        ["\xB0\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x95"],
        ["\xB0\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x96"],
        ["\xB0\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x97"],
        ["\xB0\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x98"],
        ["\xB0\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x99"],
        ["\xB0\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9A"],
        ["\xB0\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9B"],
        ["\xB0\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9C"],
        ["\xB0\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9D"],
        ["\xB0\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9E"],
        ["\xB0\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\x9F"],
        ["\xB1\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA0"],
        ["\xB1\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA1"],
        ["\xB1\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA2"],
        ["\xB1\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA3"],
        ["\xB1\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA4"],
        ["\xB1\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA5"],
        ["\xB1\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA6"],
        ["\xB1\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA7"],
        ["\xB1\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA8"],
        ["\xB1\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xA9"],
        ["\xB1\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAA"],
        ["\xB1\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAB"],
        ["\xB1\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAC"],
        ["\xB1\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAD"],
        ["\xB1\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAE"],
        ["\xB1\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xAF"],
        ["\xB1\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB0"],
        ["\xB1\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB1"],
        ["\xB1\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB2"],
        ["\xB1\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB3"],
        ["\xB1\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB4"],
        ["\xB1\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB5"],
        ["\xB1\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB6"],
        ["\xB1\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB7"],
        ["\xB1\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB8"],
        ["\xB1\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xB9"],
        ["\xB1\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBA"],
        ["\xB1\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBB"],
        ["\xB1\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBC"],
        ["\xB1\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBD"],
        ["\xB1\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBE"],
        ["\xB1\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9B\xBF"],
        ["\xB1\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x80"],
        ["\xB1\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x81"],
        ["\xB1\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x82"],
        ["\xB1\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x83"],
        ["\xB1\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x84"],
        ["\xB1\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x85"],
        ["\xB1\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x86"],
        ["\xB1\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x87"],
        ["\xB1\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x88"],
        ["\xB1\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x89"],
        ["\xB1\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8A"],
        ["\xB1\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8B"],
        ["\xB1\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8C"],
        ["\xB1\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8D"],
        ["\xB1\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8E"],
        ["\xB1\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x8F"],
        ["\xB1\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x90"],
        ["\xB1\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x91"],
        ["\xB1\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x92"],
        ["\xB1\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x93"],
        ["\xB1\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x94"],
        ["\xB1\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x95"],
        ["\xB1\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x96"],
        ["\xB1\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x97"],
        ["\xB1\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x98"],
        ["\xB1\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x99"],
        ["\xB1\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9A"],
        ["\xB1\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9B"],
        ["\xB1\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9C"],
        ["\xB1\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9D"],
        ["\xB1\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9E"],
        ["\xB1\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\x9F"],
        ["\xB1\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA0"],
        ["\xB1\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA1"],
        ["\xB1\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA2"],
        ["\xB1\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA3"],
        ["\xB1\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA4"],
        ["\xB1\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA5"],
        ["\xB1\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA6"],
        ["\xB1\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA7"],
        ["\xB1\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA8"],
        ["\xB1\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xA9"],
        ["\xB1\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAA"],
        ["\xB1\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAB"],
        ["\xB1\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAC"],
        ["\xB1\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAD"],
        ["\xB1\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAE"],
        ["\xB1\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xAF"],
        ["\xB1\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB0"],
        ["\xB1\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB1"],
        ["\xB1\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB2"],
        ["\xB1\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB3"],
        ["\xB1\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB4"],
        ["\xB1\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB5"],
        ["\xB1\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB6"],
        ["\xB1\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB7"],
        ["\xB1\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB8"],
        ["\xB1\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xB9"],
        ["\xB1\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBA"],
        ["\xB1\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBB"],
        ["\xB1\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBC"],
        ["\xB1\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBD"],
        ["\xB2\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBE"],
        ["\xB2\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9C\xBF"],
        ["\xB2\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x80"],
        ["\xB2\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x81"],
        ["\xB2\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x82"],
        ["\xB2\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x83"],
        ["\xB2\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x84"],
        ["\xB2\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x85"],
        ["\xB2\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x86"],
        ["\xB2\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x87"],
        ["\xB2\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x88"],
        ["\xB2\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x89"],
        ["\xB2\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8A"],
        ["\xB2\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8B"],
        ["\xB2\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8C"],
        ["\xB2\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8D"],
        ["\xB2\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8E"],
        ["\xB2\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x8F"],
        ["\xB2\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x90"],
        ["\xB2\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x91"],
        ["\xB2\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x92"],
        ["\xB2\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x93"],
        ["\xB2\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x94"],
        ["\xB2\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x95"],
        ["\xB2\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x96"],
        ["\xB2\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x97"],
        ["\xB2\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x98"],
        ["\xB2\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x99"],
        ["\xB2\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9A"],
        ["\xB2\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9B"],
        ["\xB2\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9C"],
        ["\xB2\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9D"],
        ["\xB2\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9E"],
        ["\xB2\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\x9F"],
        ["\xB2\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA0"],
        ["\xB2\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA1"],
        ["\xB2\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA2"],
        ["\xB2\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA3"],
        ["\xB2\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA4"],
        ["\xB2\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA5"],
        ["\xB2\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA6"],
        ["\xB2\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA7"],
        ["\xB2\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA8"],
        ["\xB2\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xA9"],
        ["\xB2\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAA"],
        ["\xB2\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAB"],
        ["\xB2\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAC"],
        ["\xB2\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAD"],
        ["\xB2\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAE"],
        ["\xB2\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xAF"],
        ["\xB2\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB0"],
        ["\xB2\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB1"],
        ["\xB2\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB2"],
        ["\xB2\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB3"],
        ["\xB2\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB4"],
        ["\xB2\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB5"],
        ["\xB2\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB6"],
        ["\xB2\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB7"],
        ["\xB2\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB8"],
        ["\xB2\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xB9"],
        ["\xB2\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBA"],
        ["\xB2\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBB"],
        ["\xB2\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBC"],
        ["\xB2\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBD"],
        ["\xB2\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBE"],
        ["\xB2\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9D\xBF"],
        ["\xB2\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x80"],
        ["\xB2\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x81"],
        ["\xB2\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x82"],
        ["\xB2\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x83"],
        ["\xB2\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x84"],
        ["\xB2\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x85"],
        ["\xB2\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x86"],
        ["\xB2\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x87"],
        ["\xB2\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x88"],
        ["\xB2\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x89"],
        ["\xB2\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8A"],
        ["\xB2\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8B"],
        ["\xB2\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8C"],
        ["\xB2\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8D"],
        ["\xB2\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8E"],
        ["\xB2\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x8F"],
        ["\xB2\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x90"],
        ["\xB2\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x91"],
        ["\xB2\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x92"],
        ["\xB2\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x93"],
        ["\xB2\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x94"],
        ["\xB2\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x95"],
        ["\xB2\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x96"],
        ["\xB2\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x97"],
        ["\xB2\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x98"],
        ["\xB2\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x99"],
        ["\xB2\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9A"],
        ["\xB2\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9B"],
        ["\xB3\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9C"],
        ["\xB3\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9D"],
        ["\xB3\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9E"],
        ["\xB3\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\x9F"],
        ["\xB3\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA0"],
        ["\xB3\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA1"],
        ["\xB3\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA2"],
        ["\xB3\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA3"],
        ["\xB3\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA4"],
        ["\xB3\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA5"],
        ["\xB3\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA6"],
        ["\xB3\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA7"],
        ["\xB3\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA8"],
        ["\xB3\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xA9"],
        ["\xB3\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAA"],
        ["\xB3\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAB"],
        ["\xB3\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAC"],
        ["\xB3\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAD"],
        ["\xB3\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAE"],
        ["\xB3\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xAF"],
        ["\xB3\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB0"],
        ["\xB3\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB1"],
        ["\xB3\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB2"],
        ["\xB3\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB3"],
        ["\xB3\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB4"],
        ["\xB3\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB5"],
        ["\xB3\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB6"],
        ["\xB3\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB7"],
        ["\xB3\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB8"],
        ["\xB3\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xB9"],
        ["\xB3\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBA"],
        ["\xB3\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBB"],
        ["\xB3\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBC"],
        ["\xB3\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBD"],
        ["\xB3\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBE"],
        ["\xB3\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9E\xBF"],
        ["\xB3\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x80"],
        ["\xB3\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x81"],
        ["\xB3\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x82"],
        ["\xB3\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x83"],
        ["\xB3\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x84"],
        ["\xB3\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x85"],
        ["\xB3\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x86"],
        ["\xB3\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x87"],
        ["\xB3\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x88"],
        ["\xB3\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x89"],
        ["\xB3\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8A"],
        ["\xB3\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8B"],
        ["\xB3\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8C"],
        ["\xB3\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8D"],
        ["\xB3\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8E"],
        ["\xB3\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x8F"],
        ["\xB3\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x90"],
        ["\xB3\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x91"],
        ["\xB3\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x92"],
        ["\xB3\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x93"],
        ["\xB3\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x94"],
        ["\xB3\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x95"],
        ["\xB3\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x96"],
        ["\xB3\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x97"],
        ["\xB3\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x98"],
        ["\xB3\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x99"],
        ["\xB3\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9A"],
        ["\xB3\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9B"],
        ["\xB3\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9C"],
        ["\xB3\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9D"],
        ["\xB3\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9E"],
        ["\xB3\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\x9F"],
        ["\xB3\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA0"],
        ["\xB3\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA1"],
        ["\xB3\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA2"],
        ["\xB3\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA3"],
        ["\xB3\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA4"],
        ["\xB3\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA5"],
        ["\xB3\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA6"],
        ["\xB3\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA7"],
        ["\xB3\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA8"],
        ["\xB3\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xA9"],
        ["\xB3\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAA"],
        ["\xB3\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAB"],
        ["\xB3\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAC"],
        ["\xB3\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAD"],
        ["\xB3\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAE"],
        ["\xB3\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xAF"],
        ["\xB3\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB0"],
        ["\xB3\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB1"],
        ["\xB3\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB2"],
        ["\xB3\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB3"],
        ["\xB3\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB4"],
        ["\xB3\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB5"],
        ["\xB3\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB6"],
        ["\xB3\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB7"],
        ["\xB3\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB8"],
        ["\xB3\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xB9"],
        ["\xB4\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBA"],
        ["\xB4\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBB"],
        ["\xB4\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBC"],
        ["\xB4\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBD"],
        ["\xB4\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBE"],
        ["\xB4\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\x9F\xBF"],
        ["\xB4\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x80"],
        ["\xB4\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x81"],
        ["\xB4\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x82"],
        ["\xB4\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x83"],
        ["\xB4\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x84"],
        ["\xB4\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x85"],
        ["\xB4\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x86"],
        ["\xB4\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x87"],
        ["\xB4\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x88"],
        ["\xB4\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x89"],
        ["\xB4\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8A"],
        ["\xB4\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8B"],
        ["\xB4\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8C"],
        ["\xB4\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8D"],
        ["\xB4\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8E"],
        ["\xB4\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x8F"],
        ["\xB4\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x90"],
        ["\xB4\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x91"],
        ["\xB4\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x92"],
        ["\xB4\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x93"],
        ["\xB4\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x94"],
        ["\xB4\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x95"],
        ["\xB4\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x96"],
        ["\xB4\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x97"],
        ["\xB4\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x98"],
        ["\xB4\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x99"],
        ["\xB4\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9A"],
        ["\xB4\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9B"],
        ["\xB4\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9C"],
        ["\xB4\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9D"],
        ["\xB4\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9E"],
        ["\xB4\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\x9F"],
        ["\xB4\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA0"],
        ["\xB4\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA1"],
        ["\xB4\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA2"],
        ["\xB4\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA3"],
        ["\xB4\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA4"],
        ["\xB4\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA5"],
        ["\xB4\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA6"],
        ["\xB4\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA7"],
        ["\xB4\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA8"],
        ["\xB4\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xA9"],
        ["\xB4\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAA"],
        ["\xB4\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAB"],
        ["\xB4\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAC"],
        ["\xB4\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAD"],
        ["\xB4\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAE"],
        ["\xB4\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xAF"],
        ["\xB4\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB0"],
        ["\xB4\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB1"],
        ["\xB4\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB2"],
        ["\xB4\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB3"],
        ["\xB4\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB4"],
        ["\xB4\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB5"],
        ["\xB4\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB6"],
        ["\xB4\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB7"],
        ["\xB4\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB8"],
        ["\xB4\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xB9"],
        ["\xB4\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBA"],
        ["\xB4\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBB"],
        ["\xB4\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBC"],
        ["\xB4\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBD"],
        ["\xB4\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBE"],
        ["\xB4\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA0\xBF"],
        ["\xB4\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x80"],
        ["\xB4\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x81"],
        ["\xB4\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x82"],
        ["\xB4\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x83"],
        ["\xB4\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x84"],
        ["\xB4\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x85"],
        ["\xB4\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x86"],
        ["\xB4\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x87"],
        ["\xB4\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x88"],
        ["\xB4\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x89"],
        ["\xB4\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8A"],
        ["\xB4\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8B"],
        ["\xB4\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8C"],
        ["\xB4\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8D"],
        ["\xB4\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8E"],
        ["\xB4\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x8F"],
        ["\xB4\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x90"],
        ["\xB4\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x91"],
        ["\xB4\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x92"],
        ["\xB4\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x93"],
        ["\xB4\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x94"],
        ["\xB4\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x95"],
        ["\xB4\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x96"],
        ["\xB4\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x97"],
        ["\xB5\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x98"],
        ["\xB5\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x99"],
        ["\xB5\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9A"],
        ["\xB5\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9B"],
        ["\xB5\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9C"],
        ["\xB5\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9D"],
        ["\xB5\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9E"],
        ["\xB5\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\x9F"],
        ["\xB5\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA0"],
        ["\xB5\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA1"],
        ["\xB5\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA2"],
        ["\xB5\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA3"],
        ["\xB5\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA4"],
        ["\xB5\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA5"],
        ["\xB5\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA6"],
        ["\xB5\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA7"],
        ["\xB5\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA8"],
        ["\xB5\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xA9"],
        ["\xB5\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAA"],
        ["\xB5\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAB"],
        ["\xB5\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAC"],
        ["\xB5\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAD"],
        ["\xB5\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAE"],
        ["\xB5\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xAF"],
        ["\xB5\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB0"],
        ["\xB5\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB1"],
        ["\xB5\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB2"],
        ["\xB5\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB3"],
        ["\xB5\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB4"],
        ["\xB5\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB5"],
        ["\xB5\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB6"],
        ["\xB5\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB7"],
        ["\xB5\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB8"],
        ["\xB5\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xB9"],
        ["\xB5\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBA"],
        ["\xB5\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBB"],
        ["\xB5\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBC"],
        ["\xB5\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBD"],
        ["\xB5\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBE"],
        ["\xB5\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA1\xBF"],
        ["\xB5\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x80"],
        ["\xB5\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x81"],
        ["\xB5\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x82"],
        ["\xB5\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x83"],
        ["\xB5\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x84"],
        ["\xB5\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x85"],
        ["\xB5\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x86"],
        ["\xB5\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x87"],
        ["\xB5\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x88"],
        ["\xB5\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x89"],
        ["\xB5\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8A"],
        ["\xB5\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8B"],
        ["\xB5\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8C"],
        ["\xB5\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8D"],
        ["\xB5\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8E"],
        ["\xB5\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x8F"],
        ["\xB5\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x90"],
        ["\xB5\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x91"],
        ["\xB5\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x92"],
        ["\xB5\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x93"],
        ["\xB5\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x94"],
        ["\xB5\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x95"],
        ["\xB5\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x96"],
        ["\xB5\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x97"],
        ["\xB5\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x98"],
        ["\xB5\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x99"],
        ["\xB5\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9A"],
        ["\xB5\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9B"],
        ["\xB5\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9C"],
        ["\xB5\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9D"],
        ["\xB5\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9E"],
        ["\xB5\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\x9F"],
        ["\xB5\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA0"],
        ["\xB5\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA1"],
        ["\xB5\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA2"],
        ["\xB5\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA3"],
        ["\xB5\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA4"],
        ["\xB5\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA5"],
        ["\xB5\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA6"],
        ["\xB5\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA7"],
        ["\xB5\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA8"],
        ["\xB5\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xA9"],
        ["\xB5\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAA"],
        ["\xB5\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAB"],
        ["\xB5\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAC"],
        ["\xB5\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAD"],
        ["\xB5\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAE"],
        ["\xB5\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xAF"],
        ["\xB5\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB0"],
        ["\xB5\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB1"],
        ["\xB5\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB2"],
        ["\xB5\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB3"],
        ["\xB5\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB4"],
        ["\xB5\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB5"],
        ["\xB6\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB6"],
        ["\xB6\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB7"],
        ["\xB6\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB8"],
        ["\xB6\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xB9"],
        ["\xB6\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBA"],
        ["\xB6\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBB"],
        ["\xB6\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBC"],
        ["\xB6\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBD"],
        ["\xB6\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBE"],
        ["\xB6\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA2\xBF"],
        ["\xB6\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x80"],
        ["\xB6\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x81"],
        ["\xB6\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x82"],
        ["\xB6\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x83"],
        ["\xB6\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x84"],
        ["\xB6\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x85"],
        ["\xB6\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x86"],
        ["\xB6\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x87"],
        ["\xB6\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x88"],
        ["\xB6\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x89"],
        ["\xB6\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8A"],
        ["\xB6\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8B"],
        ["\xB6\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8C"],
        ["\xB6\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8D"],
        ["\xB6\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8E"],
        ["\xB6\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x8F"],
        ["\xB6\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x90"],
        ["\xB6\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x91"],
        ["\xB6\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x92"],
        ["\xB6\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x93"],
        ["\xB6\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x94"],
        ["\xB6\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x95"],
        ["\xB6\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x96"],
        ["\xB6\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x97"],
        ["\xB6\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x98"],
        ["\xB6\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x99"],
        ["\xB6\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9A"],
        ["\xB6\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9B"],
        ["\xB6\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9C"],
        ["\xB6\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9D"],
        ["\xB6\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9E"],
        ["\xB6\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\x9F"],
        ["\xB6\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA0"],
        ["\xB6\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA1"],
        ["\xB6\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA2"],
        ["\xB6\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA3"],
        ["\xB6\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA4"],
        ["\xB6\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA5"],
        ["\xB6\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA6"],
        ["\xB6\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA7"],
        ["\xB6\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA8"],
        ["\xB6\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xA9"],
        ["\xB6\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAA"],
        ["\xB6\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAB"],
        ["\xB6\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAC"],
        ["\xB6\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAD"],
        ["\xB6\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAE"],
        ["\xB6\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xAF"],
        ["\xB6\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB0"],
        ["\xB6\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB1"],
        ["\xB6\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB2"],
        ["\xB6\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB3"],
        ["\xB6\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB4"],
        ["\xB6\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB5"],
        ["\xB6\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB6"],
        ["\xB6\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB7"],
        ["\xB6\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB8"],
        ["\xB6\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xB9"],
        ["\xB6\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBA"],
        ["\xB6\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBB"],
        ["\xB6\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBC"],
        ["\xB6\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBD"],
        ["\xB6\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBE"],
        ["\xB6\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA3\xBF"],
        ["\xB6\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x80"],
        ["\xB6\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x81"],
        ["\xB6\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x82"],
        ["\xB6\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x83"],
        ["\xB6\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x84"],
        ["\xB6\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x85"],
        ["\xB6\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x86"],
        ["\xB6\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x87"],
        ["\xB6\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x88"],
        ["\xB6\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x89"],
        ["\xB6\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8A"],
        ["\xB6\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8B"],
        ["\xB6\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8C"],
        ["\xB6\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8D"],
        ["\xB6\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8E"],
        ["\xB6\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x8F"],
        ["\xB6\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x90"],
        ["\xB6\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x91"],
        ["\xB6\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x92"],
        ["\xB6\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x93"],
        ["\xB7\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x94"],
        ["\xB7\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x95"],
        ["\xB7\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x96"],
        ["\xB7\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x97"],
        ["\xB7\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x98"],
        ["\xB7\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x99"],
        ["\xB7\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9A"],
        ["\xB7\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9B"],
        ["\xB7\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9C"],
        ["\xB7\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9D"],
        ["\xB7\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9E"],
        ["\xB7\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\x9F"],
        ["\xB7\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA0"],
        ["\xB7\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA1"],
        ["\xB7\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA2"],
        ["\xB7\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA3"],
        ["\xB7\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA4"],
        ["\xB7\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA5"],
        ["\xB7\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA6"],
        ["\xB7\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA7"],
        ["\xB7\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA8"],
        ["\xB7\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xA9"],
        ["\xB7\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAA"],
        ["\xB7\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAB"],
        ["\xB7\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAC"],
        ["\xB7\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAD"],
        ["\xB7\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAE"],
        ["\xB7\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xAF"],
        ["\xB7\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB0"],
        ["\xB7\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB1"],
        ["\xB7\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB2"],
        ["\xB7\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB3"],
        ["\xB7\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB4"],
        ["\xB7\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB5"],
        ["\xB7\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB6"],
        ["\xB7\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB7"],
        ["\xB7\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB8"],
        ["\xB7\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xB9"],
        ["\xB7\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBA"],
        ["\xB7\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBB"],
        ["\xB7\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBC"],
        ["\xB7\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBD"],
        ["\xB7\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBE"],
        ["\xB7\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA4\xBF"],
        ["\xB7\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x80"],
        ["\xB7\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x81"],
        ["\xB7\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x82"],
        ["\xB7\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x83"],
        ["\xB7\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x84"],
        ["\xB7\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x85"],
        ["\xB7\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x86"],
        ["\xB7\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x87"],
        ["\xB7\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x88"],
        ["\xB7\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x89"],
        ["\xB7\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8A"],
        ["\xB7\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8B"],
        ["\xB7\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8C"],
        ["\xB7\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8D"],
        ["\xB7\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8E"],
        ["\xB7\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x8F"],
        ["\xB7\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x90"],
        ["\xB7\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x91"],
        ["\xB7\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x92"],
        ["\xB7\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x93"],
        ["\xB7\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x94"],
        ["\xB7\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x95"],
        ["\xB7\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x96"],
        ["\xB7\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x97"],
        ["\xB7\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x98"],
        ["\xB7\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x99"],
        ["\xB7\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9A"],
        ["\xB7\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9B"],
        ["\xB7\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9C"],
        ["\xB7\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9D"],
        ["\xB7\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9E"],
        ["\xB7\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\x9F"],
        ["\xB7\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA0"],
        ["\xB7\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA1"],
        ["\xB7\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA2"],
        ["\xB7\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA3"],
        ["\xB7\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA4"],
        ["\xB7\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA5"],
        ["\xB7\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA6"],
        ["\xB7\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA7"],
        ["\xB7\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA8"],
        ["\xB7\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xA9"],
        ["\xB7\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAA"],
        ["\xB7\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAB"],
        ["\xB7\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAC"],
        ["\xB7\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAD"],
        ["\xB7\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAE"],
        ["\xB7\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xAF"],
        ["\xB7\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB0"],
        ["\xB7\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB1"],
        ["\xB8\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB2"],
        ["\xB8\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB3"],
        ["\xB8\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB4"],
        ["\xB8\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB5"],
        ["\xB8\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB6"],
        ["\xB8\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB7"],
        ["\xB8\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB8"],
        ["\xB8\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xB9"],
        ["\xB8\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBA"],
        ["\xB8\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBB"],
        ["\xB8\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBC"],
        ["\xB8\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBD"],
        ["\xB8\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBE"],
        ["\xB8\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA5\xBF"],
        ["\xB8\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x80"],
        ["\xB8\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x81"],
        ["\xB8\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x82"],
        ["\xB8\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x83"],
        ["\xB8\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x84"],
        ["\xB8\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x85"],
        ["\xB8\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x86"],
        ["\xB8\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x87"],
        ["\xB8\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x88"],
        ["\xB8\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x89"],
        ["\xB8\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8A"],
        ["\xB8\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8B"],
        ["\xB8\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8C"],
        ["\xB8\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8D"],
        ["\xB8\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8E"],
        ["\xB8\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x8F"],
        ["\xB8\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x90"],
        ["\xB8\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x91"],
        ["\xB8\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x92"],
        ["\xB8\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x93"],
        ["\xB8\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x94"],
        ["\xB8\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x95"],
        ["\xB8\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x96"],
        ["\xB8\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x97"],
        ["\xB8\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x98"],
        ["\xB8\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x99"],
        ["\xB8\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9A"],
        ["\xB8\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9B"],
        ["\xB8\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9C"],
        ["\xB8\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9D"],
        ["\xB8\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9E"],
        ["\xB8\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\x9F"],
        ["\xB8\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA0"],
        ["\xB8\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA1"],
        ["\xB8\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA2"],
        ["\xB8\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA3"],
        ["\xB8\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA4"],
        ["\xB8\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA5"],
        ["\xB8\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA6"],
        ["\xB8\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA7"],
        ["\xB8\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA8"],
        ["\xB8\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xA9"],
        ["\xB8\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAA"],
        ["\xB8\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAB"],
        ["\xB8\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAC"],
        ["\xB8\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAD"],
        ["\xB8\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAE"],
        ["\xB8\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xAF"],
        ["\xB8\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB0"],
        ["\xB8\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB1"],
        ["\xB8\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB2"],
        ["\xB8\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB3"],
        ["\xB8\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB4"],
        ["\xB8\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB5"],
        ["\xB8\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB6"],
        ["\xB8\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB7"],
        ["\xB8\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB8"],
        ["\xB8\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xB9"],
        ["\xB8\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBA"],
        ["\xB8\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBB"],
        ["\xB8\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBC"],
        ["\xB8\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBD"],
        ["\xB8\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBE"],
        ["\xB8\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA6\xBF"],
        ["\xB8\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x80"],
        ["\xB8\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x81"],
        ["\xB8\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x82"],
        ["\xB8\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x83"],
        ["\xB8\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x84"],
        ["\xB8\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x85"],
        ["\xB8\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x86"],
        ["\xB8\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x87"],
        ["\xB8\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x88"],
        ["\xB8\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x89"],
        ["\xB8\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8A"],
        ["\xB8\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8B"],
        ["\xB8\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8C"],
        ["\xB8\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8D"],
        ["\xB8\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8E"],
        ["\xB8\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x8F"],
        ["\xB9\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x90"],
        ["\xB9\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x91"],
        ["\xB9\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x92"],
        ["\xB9\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x93"],
        ["\xB9\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x94"],
        ["\xB9\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x95"],
        ["\xB9\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x96"],
        ["\xB9\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x97"],
        ["\xB9\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x98"],
        ["\xB9\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x99"],
        ["\xB9\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9A"],
        ["\xB9\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9B"],
        ["\xB9\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9C"],
        ["\xB9\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9D"],
        ["\xB9\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9E"],
        ["\xB9\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\x9F"],
        ["\xB9\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA0"],
        ["\xB9\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA1"],
        ["\xB9\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA2"],
        ["\xB9\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA3"],
        ["\xB9\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA4"],
        ["\xB9\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA5"],
        ["\xB9\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA6"],
        ["\xB9\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA7"],
        ["\xB9\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA8"],
        ["\xB9\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xA9"],
        ["\xB9\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAA"],
        ["\xB9\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAB"],
        ["\xB9\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAC"],
        ["\xB9\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAD"],
        ["\xB9\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAE"],
        ["\xB9\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xAF"],
        ["\xB9\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB0"],
        ["\xB9\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB1"],
        ["\xB9\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB2"],
        ["\xB9\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB3"],
        ["\xB9\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB4"],
        ["\xB9\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB5"],
        ["\xB9\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB6"],
        ["\xB9\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB7"],
        ["\xB9\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB8"],
        ["\xB9\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xB9"],
        ["\xB9\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBA"],
        ["\xB9\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBB"],
        ["\xB9\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBC"],
        ["\xB9\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBD"],
        ["\xB9\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBE"],
        ["\xB9\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA7\xBF"],
        ["\xB9\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x80"],
        ["\xB9\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x81"],
        ["\xB9\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x82"],
        ["\xB9\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x83"],
        ["\xB9\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x84"],
        ["\xB9\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x85"],
        ["\xB9\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x86"],
        ["\xB9\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x87"],
        ["\xB9\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x88"],
        ["\xB9\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x89"],
        ["\xB9\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8A"],
        ["\xB9\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8B"],
        ["\xB9\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8C"],
        ["\xB9\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8D"],
        ["\xB9\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8E"],
        ["\xB9\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x8F"],
        ["\xB9\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x90"],
        ["\xB9\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x91"],
        ["\xB9\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x92"],
        ["\xB9\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x93"],
        ["\xB9\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x94"],
        ["\xB9\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x95"],
        ["\xB9\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x96"],
        ["\xB9\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x97"],
        ["\xB9\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x98"],
        ["\xB9\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x99"],
        ["\xB9\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9A"],
        ["\xB9\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9B"],
        ["\xB9\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9C"],
        ["\xB9\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9D"],
        ["\xB9\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9E"],
        ["\xB9\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\x9F"],
        ["\xB9\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA0"],
        ["\xB9\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA1"],
        ["\xB9\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA2"],
        ["\xB9\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA3"],
        ["\xB9\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA4"],
        ["\xB9\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA5"],
        ["\xB9\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA6"],
        ["\xB9\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA7"],
        ["\xB9\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA8"],
        ["\xB9\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xA9"],
        ["\xB9\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAA"],
        ["\xB9\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAB"],
        ["\xB9\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAC"],
        ["\xB9\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAD"],
        ["\xBA\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAE"],
        ["\xBA\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xAF"],
        ["\xBA\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB0"],
        ["\xBA\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB1"],
        ["\xBA\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB2"],
        ["\xBA\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB3"],
        ["\xBA\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB4"],
        ["\xBA\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB5"],
        ["\xBA\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB6"],
        ["\xBA\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB7"],
        ["\xBA\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB8"],
        ["\xBA\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xB9"],
        ["\xBA\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBA"],
        ["\xBA\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBB"],
        ["\xBA\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBC"],
        ["\xBA\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBD"],
        ["\xBA\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBE"],
        ["\xBA\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA8\xBF"],
        ["\xBA\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x80"],
        ["\xBA\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x81"],
        ["\xBA\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x82"],
        ["\xBA\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x83"],
        ["\xBA\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x84"],
        ["\xBA\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x85"],
        ["\xBA\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x86"],
        ["\xBA\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x87"],
        ["\xBA\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x88"],
        ["\xBA\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x89"],
        ["\xBA\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8A"],
        ["\xBA\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8B"],
        ["\xBA\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8C"],
        ["\xBA\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8D"],
        ["\xBA\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8E"],
        ["\xBA\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x8F"],
        ["\xBA\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x90"],
        ["\xBA\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x91"],
        ["\xBA\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x92"],
        ["\xBA\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x93"],
        ["\xBA\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x94"],
        ["\xBA\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x95"],
        ["\xBA\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x96"],
        ["\xBA\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x97"],
        ["\xBA\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x98"],
        ["\xBA\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x99"],
        ["\xBA\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9A"],
        ["\xBA\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9B"],
        ["\xBA\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9C"],
        ["\xBA\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9D"],
        ["\xBA\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9E"],
        ["\xBA\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\x9F"],
        ["\xBA\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA0"],
        ["\xBA\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA1"],
        ["\xBA\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA2"],
        ["\xBA\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA3"],
        ["\xBA\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA4"],
        ["\xBA\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA5"],
        ["\xBA\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA6"],
        ["\xBA\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA7"],
        ["\xBA\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA8"],
        ["\xBA\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xA9"],
        ["\xBA\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAA"],
        ["\xBA\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAB"],
        ["\xBA\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAC"],
        ["\xBA\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAD"],
        ["\xBA\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAE"],
        ["\xBA\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xAF"],
        ["\xBA\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB0"],
        ["\xBA\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB1"],
        ["\xBA\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB2"],
        ["\xBA\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB3"],
        ["\xBA\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB4"],
        ["\xBA\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB5"],
        ["\xBA\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB6"],
        ["\xBA\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB7"],
        ["\xBA\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB8"],
        ["\xBA\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xB9"],
        ["\xBA\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBA"],
        ["\xBA\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBB"],
        ["\xBA\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBC"],
        ["\xBA\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBD"],
        ["\xBA\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBE"],
        ["\xBA\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xA9\xBF"],
        ["\xBA\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x80"],
        ["\xBA\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x81"],
        ["\xBA\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x82"],
        ["\xBA\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x83"],
        ["\xBA\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x84"],
        ["\xBA\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x85"],
        ["\xBA\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x86"],
        ["\xBA\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x87"],
        ["\xBA\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x88"],
        ["\xBA\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x89"],
        ["\xBA\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8A"],
        ["\xBA\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8B"],
        ["\xBB\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8C"],
        ["\xBB\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8D"],
        ["\xBB\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8E"],
        ["\xBB\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x8F"],
        ["\xBB\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x90"],
        ["\xBB\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x91"],
        ["\xBB\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x92"],
        ["\xBB\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x93"],
        ["\xBB\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x94"],
        ["\xBB\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x95"],
        ["\xBB\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x96"],
        ["\xBB\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x97"],
        ["\xBB\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x98"],
        ["\xBB\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x99"],
        ["\xBB\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9A"],
        ["\xBB\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9B"],
        ["\xBB\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9C"],
        ["\xBB\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9D"],
        ["\xBB\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9E"],
        ["\xBB\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\x9F"],
        ["\xBB\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA0"],
        ["\xBB\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA1"],
        ["\xBB\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA2"],
        ["\xBB\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA3"],
        ["\xBB\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA4"],
        ["\xBB\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA5"],
        ["\xBB\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA6"],
        ["\xBB\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA7"],
        ["\xBB\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA8"],
        ["\xBB\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xA9"],
        ["\xBB\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAA"],
        ["\xBB\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAB"],
        ["\xBB\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAC"],
        ["\xBB\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAD"],
        ["\xBB\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAE"],
        ["\xBB\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xAF"],
        ["\xBB\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB0"],
        ["\xBB\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB1"],
        ["\xBB\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB2"],
        ["\xBB\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB3"],
        ["\xBB\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB4"],
        ["\xBB\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB5"],
        ["\xBB\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB6"],
        ["\xBB\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB7"],
        ["\xBB\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB8"],
        ["\xBB\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xB9"],
        ["\xBB\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBA"],
        ["\xBB\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBB"],
        ["\xBB\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBC"],
        ["\xBB\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBD"],
        ["\xBB\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBE"],
        ["\xBB\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAA\xBF"],
        ["\xBB\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x80"],
        ["\xBB\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x81"],
        ["\xBB\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x82"],
        ["\xBB\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x83"],
        ["\xBB\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x84"],
        ["\xBB\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x85"],
        ["\xBB\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x86"],
        ["\xBB\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x87"],
        ["\xBB\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x88"],
        ["\xBB\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x89"],
        ["\xBB\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8A"],
        ["\xBB\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8B"],
        ["\xBB\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8C"],
        ["\xBB\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8D"],
        ["\xBB\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8E"],
        ["\xBB\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x8F"],
        ["\xBB\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x90"],
        ["\xBB\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x91"],
        ["\xBB\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x92"],
        ["\xBB\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x93"],
        ["\xBB\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x94"],
        ["\xBB\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x95"],
        ["\xBB\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x96"],
        ["\xBB\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x97"],
        ["\xBB\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x98"],
        ["\xBB\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x99"],
        ["\xBB\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9A"],
        ["\xBB\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9B"],
        ["\xBB\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9C"],
        ["\xBB\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9D"],
        ["\xBB\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9E"],
        ["\xBB\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\x9F"],
        ["\xBB\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA0"],
        ["\xBB\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA1"],
        ["\xBB\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA2"],
        ["\xBB\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA3"],
        ["\xBB\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA4"],
        ["\xBB\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA5"],
        ["\xBB\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA6"],
        ["\xBB\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA7"],
        ["\xBB\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA8"],
        ["\xBB\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xA9"],
        ["\xBC\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAA"],
        ["\xBC\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAB"],
        ["\xBC\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAC"],
        ["\xBC\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAD"],
        ["\xBC\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAE"],
        ["\xBC\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xAF"],
        ["\xBC\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB0"],
        ["\xBC\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB1"],
        ["\xBC\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB2"],
        ["\xBC\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB3"],
        ["\xBC\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB4"],
        ["\xBC\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB5"],
        ["\xBC\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB6"],
        ["\xBC\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB7"],
        ["\xBC\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB8"],
        ["\xBC\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xB9"],
        ["\xBC\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBA"],
        ["\xBC\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBB"],
        ["\xBC\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBC"],
        ["\xBC\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBD"],
        ["\xBC\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBE"],
        ["\xBC\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAB\xBF"],
        ["\xBC\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x80"],
        ["\xBC\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x81"],
        ["\xBC\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x82"],
        ["\xBC\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x83"],
        ["\xBC\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x84"],
        ["\xBC\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x85"],
        ["\xBC\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x86"],
        ["\xBC\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x87"],
        ["\xBC\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x88"],
        ["\xBC\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x89"],
        ["\xBC\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8A"],
        ["\xBC\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8B"],
        ["\xBC\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8C"],
        ["\xBC\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8D"],
        ["\xBC\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8E"],
        ["\xBC\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x8F"],
        ["\xBC\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x90"],
        ["\xBC\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x91"],
        ["\xBC\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x92"],
        ["\xBC\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x93"],
        ["\xBC\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x94"],
        ["\xBC\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x95"],
        ["\xBC\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x96"],
        ["\xBC\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x97"],
        ["\xBC\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x98"],
        ["\xBC\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x99"],
        ["\xBC\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9A"],
        ["\xBC\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9B"],
        ["\xBC\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9C"],
        ["\xBC\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9D"],
        ["\xBC\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9E"],
        ["\xBC\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\x9F"],
        ["\xBC\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA0"],
        ["\xBC\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA1"],
        ["\xBC\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA2"],
        ["\xBC\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA3"],
        ["\xBC\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA4"],
        ["\xBC\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA5"],
        ["\xBC\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA6"],
        ["\xBC\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA7"],
        ["\xBC\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA8"],
        ["\xBC\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xA9"],
        ["\xBC\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAA"],
        ["\xBC\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAB"],
        ["\xBC\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAC"],
        ["\xBC\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAD"],
        ["\xBC\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAE"],
        ["\xBC\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xAF"],
        ["\xBC\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB0"],
        ["\xBC\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB1"],
        ["\xBC\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB2"],
        ["\xBC\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB3"],
        ["\xBC\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB4"],
        ["\xBC\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB5"],
        ["\xBC\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB6"],
        ["\xBC\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB7"],
        ["\xBC\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB8"],
        ["\xBC\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xB9"],
        ["\xBC\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBA"],
        ["\xBC\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBB"],
        ["\xBC\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBC"],
        ["\xBC\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBD"],
        ["\xBC\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBE"],
        ["\xBC\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAC\xBF"],
        ["\xBC\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x80"],
        ["\xBC\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x81"],
        ["\xBC\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x82"],
        ["\xBC\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x83"],
        ["\xBC\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x84"],
        ["\xBC\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x85"],
        ["\xBC\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x86"],
        ["\xBC\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x87"],
        ["\xBD\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x88"],
        ["\xBD\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x89"],
        ["\xBD\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8A"],
        ["\xBD\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8B"],
        ["\xBD\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8C"],
        ["\xBD\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8D"],
        ["\xBD\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8E"],
        ["\xBD\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x8F"],
        ["\xBD\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x90"],
        ["\xBD\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x91"],
        ["\xBD\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x92"],
        ["\xBD\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x93"],
        ["\xBD\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x94"],
        ["\xBD\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x95"],
        ["\xBD\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x96"],
        ["\xBD\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x97"],
        ["\xBD\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x98"],
        ["\xBD\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x99"],
        ["\xBD\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9A"],
        ["\xBD\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9B"],
        ["\xBD\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9C"],
        ["\xBD\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9D"],
        ["\xBD\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9E"],
        ["\xBD\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\x9F"],
        ["\xBD\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA0"],
        ["\xBD\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA1"],
        ["\xBD\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA2"],
        ["\xBD\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA3"],
        ["\xBD\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA4"],
        ["\xBD\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA5"],
        ["\xBD\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA6"],
        ["\xBD\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA7"],
        ["\xBD\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA8"],
        ["\xBD\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xA9"],
        ["\xBD\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAA"],
        ["\xBD\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAB"],
        ["\xBD\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAC"],
        ["\xBD\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAD"],
        ["\xBD\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAE"],
        ["\xBD\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xAF"],
        ["\xBD\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB0"],
        ["\xBD\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB1"],
        ["\xBD\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB2"],
        ["\xBD\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB3"],
        ["\xBD\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB4"],
        ["\xBD\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB5"],
        ["\xBD\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB6"],
        ["\xBD\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB7"],
        ["\xBD\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB8"],
        ["\xBD\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xB9"],
        ["\xBD\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBA"],
        ["\xBD\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBB"],
        ["\xBD\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBC"],
        ["\xBD\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBD"],
        ["\xBD\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBE"],
        ["\xBD\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAD\xBF"],
        ["\xBD\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x80"],
        ["\xBD\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x81"],
        ["\xBD\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x82"],
        ["\xBD\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x83"],
        ["\xBD\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x84"],
        ["\xBD\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x85"],
        ["\xBD\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x86"],
        ["\xBD\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x87"],
        ["\xBD\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x88"],
        ["\xBD\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x89"],
        ["\xBD\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8A"],
        ["\xBD\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8B"],
        ["\xBD\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8C"],
        ["\xBD\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8D"],
        ["\xBD\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8E"],
        ["\xBD\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x8F"],
        ["\xBD\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x90"],
        ["\xBD\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x91"],
        ["\xBD\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x92"],
        ["\xBD\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x93"],
        ["\xBD\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x94"],
        ["\xBD\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x95"],
        ["\xBD\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x96"],
        ["\xBD\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x97"],
        ["\xBD\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x98"],
        ["\xBD\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x99"],
        ["\xBD\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9A"],
        ["\xBD\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9B"],
        ["\xBD\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9C"],
        ["\xBD\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9D"],
        ["\xBD\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9E"],
        ["\xBD\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\x9F"],
        ["\xBD\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA0"],
        ["\xBD\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA1"],
        ["\xBD\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA2"],
        ["\xBD\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA3"],
        ["\xBD\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA4"],
        ["\xBD\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA5"],
        ["\xBE\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA6"],
        ["\xBE\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA7"],
        ["\xBE\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA8"],
        ["\xBE\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xA9"],
        ["\xBE\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAA"],
        ["\xBE\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAB"],
        ["\xBE\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAC"],
        ["\xBE\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAD"],
        ["\xBE\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAE"],
        ["\xBE\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xAF"],
        ["\xBE\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB0"],
        ["\xBE\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB1"],
        ["\xBE\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB2"],
        ["\xBE\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB3"],
        ["\xBE\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB4"],
        ["\xBE\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB5"],
        ["\xBE\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB6"],
        ["\xBE\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB7"],
        ["\xBE\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB8"],
        ["\xBE\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xB9"],
        ["\xBE\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBA"],
        ["\xBE\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBB"],
        ["\xBE\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBC"],
        ["\xBE\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBD"],
        ["\xBE\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBE"],
        ["\xBE\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAE\xBF"],
        ["\xBE\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x80"],
        ["\xBE\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x81"],
        ["\xBE\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x82"],
        ["\xBE\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x83"],
        ["\xBE\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x84"],
        ["\xBE\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x85"],
        ["\xBE\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x86"],
        ["\xBE\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x87"],
        ["\xBE\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x88"],
        ["\xBE\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x89"],
        ["\xBE\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8A"],
        ["\xBE\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8B"],
        ["\xBE\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8C"],
        ["\xBE\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8D"],
        ["\xBE\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8E"],
        ["\xBE\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x8F"],
        ["\xBE\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x90"],
        ["\xBE\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x91"],
        ["\xBE\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x92"],
        ["\xBE\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x93"],
        ["\xBE\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x94"],
        ["\xBE\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x95"],
        ["\xBE\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x96"],
        ["\xBE\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x97"],
        ["\xBE\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x98"],
        ["\xBE\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x99"],
        ["\xBE\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9A"],
        ["\xBE\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9B"],
        ["\xBE\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9C"],
        ["\xBE\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9D"],
        ["\xBE\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9E"],
        ["\xBE\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\x9F"],
        ["\xBE\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA0"],
        ["\xBE\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA1"],
        ["\xBE\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA2"],
        ["\xBE\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA3"],
        ["\xBE\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA4"],
        ["\xBE\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA5"],
        ["\xBE\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA6"],
        ["\xBE\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA7"],
        ["\xBE\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA8"],
        ["\xBE\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xA9"],
        ["\xBE\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAA"],
        ["\xBE\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAB"],
        ["\xBE\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAC"],
        ["\xBE\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAD"],
        ["\xBE\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAE"],
        ["\xBE\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xAF"],
        ["\xBE\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB0"],
        ["\xBE\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB1"],
        ["\xBE\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB2"],
        ["\xBE\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB3"],
        ["\xBE\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB4"],
        ["\xBE\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB5"],
        ["\xBE\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB6"],
        ["\xBE\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB7"],
        ["\xBE\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB8"],
        ["\xBE\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xB9"],
        ["\xBE\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBA"],
        ["\xBE\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBB"],
        ["\xBE\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBC"],
        ["\xBE\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBD"],
        ["\xBE\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBE"],
        ["\xBE\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xAF\xBF"],
        ["\xBE\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x80"],
        ["\xBE\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x81"],
        ["\xBE\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x82"],
        ["\xBE\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x83"],
        ["\xBF\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x84"],
        ["\xBF\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x85"],
        ["\xBF\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x86"],
        ["\xBF\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x87"],
        ["\xBF\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x88"],
        ["\xBF\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x89"],
        ["\xBF\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8A"],
        ["\xBF\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8B"],
        ["\xBF\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8C"],
        ["\xBF\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8D"],
        ["\xBF\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8E"],
        ["\xBF\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x8F"],
        ["\xBF\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x90"],
        ["\xBF\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x91"],
        ["\xBF\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x92"],
        ["\xBF\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x93"],
        ["\xBF\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x94"],
        ["\xBF\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x95"],
        ["\xBF\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x96"],
        ["\xBF\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x97"],
        ["\xBF\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x98"],
        ["\xBF\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x99"],
        ["\xBF\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9A"],
        ["\xBF\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9B"],
        ["\xBF\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9C"],
        ["\xBF\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9D"],
        ["\xBF\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9E"],
        ["\xBF\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\x9F"],
        ["\xBF\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA0"],
        ["\xBF\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA1"],
        ["\xBF\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA2"],
        ["\xBF\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA3"],
        ["\xBF\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA4"],
        ["\xBF\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA5"],
        ["\xBF\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA6"],
        ["\xBF\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA7"],
        ["\xBF\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA8"],
        ["\xBF\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xA9"],
        ["\xBF\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAA"],
        ["\xBF\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAB"],
        ["\xBF\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAC"],
        ["\xBF\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAD"],
        ["\xBF\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAE"],
        ["\xBF\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xAF"],
        ["\xBF\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB0"],
        ["\xBF\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB1"],
        ["\xBF\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB2"],
        ["\xBF\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB3"],
        ["\xBF\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB4"],
        ["\xBF\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB5"],
        ["\xBF\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB6"],
        ["\xBF\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB7"],
        ["\xBF\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB8"],
        ["\xBF\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xB9"],
        ["\xBF\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBA"],
        ["\xBF\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBB"],
        ["\xBF\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBC"],
        ["\xBF\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBD"],
        ["\xBF\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBE"],
        ["\xBF\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB0\xBF"],
        ["\xBF\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x80"],
        ["\xBF\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x81"],
        ["\xBF\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x82"],
        ["\xBF\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x83"],
        ["\xBF\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x84"],
        ["\xBF\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x85"],
        ["\xBF\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x86"],
        ["\xBF\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x87"],
        ["\xBF\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x88"],
        ["\xBF\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x89"],
        ["\xBF\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8A"],
        ["\xBF\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8B"],
        ["\xBF\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8C"],
        ["\xBF\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8D"],
        ["\xBF\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8E"],
        ["\xBF\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x8F"],
        ["\xBF\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x90"],
        ["\xBF\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x91"],
        ["\xBF\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x92"],
        ["\xBF\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x93"],
        ["\xBF\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x94"],
        ["\xBF\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x95"],
        ["\xBF\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x96"],
        ["\xBF\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x97"],
        ["\xBF\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x98"],
        ["\xBF\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x99"],
        ["\xBF\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9A"],
        ["\xBF\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9B"],
        ["\xBF\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9C"],
        ["\xBF\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9D"],
        ["\xBF\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9E"],
        ["\xBF\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\x9F"],
        ["\xBF\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA0"],
        ["\xBF\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA1"],
        ["\xC0\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA2"],
        ["\xC0\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA3"],
        ["\xC0\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA4"],
        ["\xC0\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA5"],
        ["\xC0\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA6"],
        ["\xC0\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA7"],
        ["\xC0\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA8"],
        ["\xC0\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xA9"],
        ["\xC0\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAA"],
        ["\xC0\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAB"],
        ["\xC0\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAC"],
        ["\xC0\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAD"],
        ["\xC0\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAE"],
        ["\xC0\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xAF"],
        ["\xC0\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB0"],
        ["\xC0\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB1"],
        ["\xC0\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB2"],
        ["\xC0\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB3"],
        ["\xC0\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB4"],
        ["\xC0\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB5"],
        ["\xC0\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB6"],
        ["\xC0\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB7"],
        ["\xC0\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB8"],
        ["\xC0\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xB9"],
        ["\xC0\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBA"],
        ["\xC0\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBB"],
        ["\xC0\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBC"],
        ["\xC0\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBD"],
        ["\xC0\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBE"],
        ["\xC0\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB1\xBF"],
        ["\xC0\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x80"],
        ["\xC0\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x81"],
        ["\xC0\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x82"],
        ["\xC0\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x83"],
        ["\xC0\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x84"],
        ["\xC0\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x85"],
        ["\xC0\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x86"],
        ["\xC0\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x87"],
        ["\xC0\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x88"],
        ["\xC0\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x89"],
        ["\xC0\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8A"],
        ["\xC0\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8B"],
        ["\xC0\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8C"],
        ["\xC0\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8D"],
        ["\xC0\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8E"],
        ["\xC0\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x8F"],
        ["\xC0\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x90"],
        ["\xC0\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x91"],
        ["\xC0\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x92"],
        ["\xC0\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x93"],
        ["\xC0\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x94"],
        ["\xC0\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x95"],
        ["\xC0\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x96"],
        ["\xC0\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x97"],
        ["\xC0\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x98"],
        ["\xC0\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x99"],
        ["\xC0\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9A"],
        ["\xC0\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9B"],
        ["\xC0\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9C"],
        ["\xC0\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9D"],
        ["\xC0\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9E"],
        ["\xC0\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\x9F"],
        ["\xC0\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA0"],
        ["\xC0\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA1"],
        ["\xC0\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA2"],
        ["\xC0\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA3"],
        ["\xC0\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA4"],
        ["\xC0\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA5"],
        ["\xC0\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA6"],
        ["\xC0\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA7"],
        ["\xC0\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA8"],
        ["\xC0\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xA9"],
        ["\xC0\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAA"],
        ["\xC0\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAB"],
        ["\xC0\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAC"],
        ["\xC0\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAD"],
        ["\xC0\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAE"],
        ["\xC0\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xAF"],
        ["\xC0\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB0"],
        ["\xC0\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB1"],
        ["\xC0\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB2"],
        ["\xC0\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB3"],
        ["\xC0\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB4"],
        ["\xC0\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB5"],
        ["\xC0\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB6"],
        ["\xC0\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB7"],
        ["\xC0\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB8"],
        ["\xC0\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xB9"],
        ["\xC0\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBA"],
        ["\xC0\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBB"],
        ["\xC0\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBC"],
        ["\xC0\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBD"],
        ["\xC0\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBE"],
        ["\xC0\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB2\xBF"],
        ["\xC1\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x80"],
        ["\xC1\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x81"],
        ["\xC1\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x82"],
        ["\xC1\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x83"],
        ["\xC1\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x84"],
        ["\xC1\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x85"],
        ["\xC1\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x86"],
        ["\xC1\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x87"],
        ["\xC1\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x88"],
        ["\xC1\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x89"],
        ["\xC1\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8A"],
        ["\xC1\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8B"],
        ["\xC1\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8C"],
        ["\xC1\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8D"],
        ["\xC1\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8E"],
        ["\xC1\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x8F"],
        ["\xC1\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x90"],
        ["\xC1\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x91"],
        ["\xC1\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x92"],
        ["\xC1\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x93"],
        ["\xC1\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x94"],
        ["\xC1\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x95"],
        ["\xC1\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x96"],
        ["\xC1\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x97"],
        ["\xC1\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x98"],
        ["\xC1\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x99"],
        ["\xC1\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9A"],
        ["\xC1\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9B"],
        ["\xC1\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9C"],
        ["\xC1\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9D"],
        ["\xC1\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9E"],
        ["\xC1\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\x9F"],
        ["\xC1\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA0"],
        ["\xC1\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA1"],
        ["\xC1\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA2"],
        ["\xC1\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA3"],
        ["\xC1\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA4"],
        ["\xC1\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA5"],
        ["\xC1\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA6"],
        ["\xC1\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA7"],
        ["\xC1\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA8"],
        ["\xC1\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xA9"],
        ["\xC1\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAA"],
        ["\xC1\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAB"],
        ["\xC1\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAC"],
        ["\xC1\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAD"],
        ["\xC1\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAE"],
        ["\xC1\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xAF"],
        ["\xC1\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB0"],
        ["\xC1\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB1"],
        ["\xC1\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB2"],
        ["\xC1\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB3"],
        ["\xC1\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB4"],
        ["\xC1\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB5"],
        ["\xC1\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB6"],
        ["\xC1\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB7"],
        ["\xC1\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB8"],
        ["\xC1\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xB9"],
        ["\xC1\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBA"],
        ["\xC1\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBB"],
        ["\xC1\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBC"],
        ["\xC1\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBD"],
        ["\xC1\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBE"],
        ["\xC1\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB3\xBF"],
        ["\xC1\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x80"],
        ["\xC1\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x81"],
        ["\xC1\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x82"],
        ["\xC1\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x83"],
        ["\xC1\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x84"],
        ["\xC1\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x85"],
        ["\xC1\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x86"],
        ["\xC1\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x87"],
        ["\xC1\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x88"],
        ["\xC1\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x89"],
        ["\xC1\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8A"],
        ["\xC1\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8B"],
        ["\xC1\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8C"],
        ["\xC1\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8D"],
        ["\xC1\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8E"],
        ["\xC1\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x8F"],
        ["\xC1\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x90"],
        ["\xC1\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x91"],
        ["\xC1\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x92"],
        ["\xC1\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x93"],
        ["\xC1\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x94"],
        ["\xC1\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x95"],
        ["\xC1\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x96"],
        ["\xC1\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x97"],
        ["\xC1\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x98"],
        ["\xC1\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x99"],
        ["\xC1\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9A"],
        ["\xC1\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9B"],
        ["\xC1\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9C"],
        ["\xC1\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9D"],
        ["\xC2\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9E"],
        ["\xC2\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\x9F"],
        ["\xC2\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA0"],
        ["\xC2\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA1"],
        ["\xC2\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA2"],
        ["\xC2\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA3"],
        ["\xC2\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA4"],
        ["\xC2\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA5"],
        ["\xC2\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA6"],
        ["\xC2\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA7"],
        ["\xC2\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA8"],
        ["\xC2\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xA9"],
        ["\xC2\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAA"],
        ["\xC2\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAB"],
        ["\xC2\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAC"],
        ["\xC2\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAD"],
        ["\xC2\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAE"],
        ["\xC2\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xAF"],
        ["\xC2\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB0"],
        ["\xC2\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB1"],
        ["\xC2\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB2"],
        ["\xC2\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB3"],
        ["\xC2\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB4"],
        ["\xC2\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB5"],
        ["\xC2\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB6"],
        ["\xC2\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB7"],
        ["\xC2\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB8"],
        ["\xC2\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xB9"],
        ["\xC2\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBA"],
        ["\xC2\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBB"],
        ["\xC2\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBC"],
        ["\xC2\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBD"],
        ["\xC2\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBE"],
        ["\xC2\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB4\xBF"],
        ["\xC2\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x80"],
        ["\xC2\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x81"],
        ["\xC2\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x82"],
        ["\xC2\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x83"],
        ["\xC2\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x84"],
        ["\xC2\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x85"],
        ["\xC2\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x86"],
        ["\xC2\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x87"],
        ["\xC2\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x88"],
        ["\xC2\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x89"],
        ["\xC2\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8A"],
        ["\xC2\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8B"],
        ["\xC2\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8C"],
        ["\xC2\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8D"],
        ["\xC2\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8E"],
        ["\xC2\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x8F"],
        ["\xC2\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x90"],
        ["\xC2\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x91"],
        ["\xC2\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x92"],
        ["\xC2\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x93"],
        ["\xC2\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x94"],
        ["\xC2\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x95"],
        ["\xC2\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x96"],
        ["\xC2\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x97"],
        ["\xC2\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x98"],
        ["\xC2\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x99"],
        ["\xC2\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9A"],
        ["\xC2\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9B"],
        ["\xC2\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9C"],
        ["\xC2\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9D"],
        ["\xC2\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9E"],
        ["\xC2\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\x9F"],
        ["\xC2\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA0"],
        ["\xC2\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA1"],
        ["\xC2\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA2"],
        ["\xC2\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA3"],
        ["\xC2\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA4"],
        ["\xC2\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA5"],
        ["\xC2\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA6"],
        ["\xC2\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA7"],
        ["\xC2\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA8"],
        ["\xC2\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xA9"],
        ["\xC2\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAA"],
        ["\xC2\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAB"],
        ["\xC2\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAC"],
        ["\xC2\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAD"],
        ["\xC2\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAE"],
        ["\xC2\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xAF"],
        ["\xC2\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB0"],
        ["\xC2\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB1"],
        ["\xC2\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB2"],
        ["\xC2\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB3"],
        ["\xC2\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB4"],
        ["\xC2\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB5"],
        ["\xC2\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB6"],
        ["\xC2\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB7"],
        ["\xC2\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB8"],
        ["\xC2\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xB9"],
        ["\xC2\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBA"],
        ["\xC2\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBB"],
        ["\xC3\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBC"],
        ["\xC3\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBD"],
        ["\xC3\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBE"],
        ["\xC3\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB5\xBF"],
        ["\xC3\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x80"],
        ["\xC3\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x81"],
        ["\xC3\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x82"],
        ["\xC3\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x83"],
        ["\xC3\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x84"],
        ["\xC3\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x85"],
        ["\xC3\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x86"],
        ["\xC3\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x87"],
        ["\xC3\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x88"],
        ["\xC3\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x89"],
        ["\xC3\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8A"],
        ["\xC3\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8B"],
        ["\xC3\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8C"],
        ["\xC3\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8D"],
        ["\xC3\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8E"],
        ["\xC3\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x8F"],
        ["\xC3\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x90"],
        ["\xC3\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x91"],
        ["\xC3\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x92"],
        ["\xC3\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x93"],
        ["\xC3\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x94"],
        ["\xC3\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x95"],
        ["\xC3\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x96"],
        ["\xC3\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x97"],
        ["\xC3\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x98"],
        ["\xC3\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x99"],
        ["\xC3\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9A"],
        ["\xC3\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9B"],
        ["\xC3\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9C"],
        ["\xC3\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9D"],
        ["\xC3\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9E"],
        ["\xC3\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\x9F"],
        ["\xC3\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA0"],
        ["\xC3\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA1"],
        ["\xC3\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA2"],
        ["\xC3\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA3"],
        ["\xC3\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA4"],
        ["\xC3\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA5"],
        ["\xC3\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA6"],
        ["\xC3\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA7"],
        ["\xC3\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA8"],
        ["\xC3\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xA9"],
        ["\xC3\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAA"],
        ["\xC3\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAB"],
        ["\xC3\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAC"],
        ["\xC3\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAD"],
        ["\xC3\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAE"],
        ["\xC3\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xAF"],
        ["\xC3\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB0"],
        ["\xC3\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB1"],
        ["\xC3\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB2"],
        ["\xC3\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB3"],
        ["\xC3\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB4"],
        ["\xC3\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB5"],
        ["\xC3\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB6"],
        ["\xC3\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB7"],
        ["\xC3\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB8"],
        ["\xC3\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xB9"],
        ["\xC3\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBA"],
        ["\xC3\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBB"],
        ["\xC3\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBC"],
        ["\xC3\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBD"],
        ["\xC3\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBE"],
        ["\xC3\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB6\xBF"],
        ["\xC3\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x80"],
        ["\xC3\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x81"],
        ["\xC3\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x82"],
        ["\xC3\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x83"],
        ["\xC3\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x84"],
        ["\xC3\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x85"],
        ["\xC3\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x86"],
        ["\xC3\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x87"],
        ["\xC3\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x88"],
        ["\xC3\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x89"],
        ["\xC3\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8A"],
        ["\xC3\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8B"],
        ["\xC3\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8C"],
        ["\xC3\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8D"],
        ["\xC3\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8E"],
        ["\xC3\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x8F"],
        ["\xC3\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x90"],
        ["\xC3\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x91"],
        ["\xC3\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x92"],
        ["\xC3\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x93"],
        ["\xC3\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x94"],
        ["\xC3\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x95"],
        ["\xC3\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x96"],
        ["\xC3\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x97"],
        ["\xC3\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x98"],
        ["\xC3\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x99"],
        ["\xC4\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9A"],
        ["\xC4\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9B"],
        ["\xC4\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9C"],
        ["\xC4\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9D"],
        ["\xC4\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9E"],
        ["\xC4\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\x9F"],
        ["\xC4\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA0"],
        ["\xC4\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA1"],
        ["\xC4\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA2"],
        ["\xC4\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA3"],
        ["\xC4\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA4"],
        ["\xC4\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA5"],
        ["\xC4\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA6"],
        ["\xC4\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA7"],
        ["\xC4\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA8"],
        ["\xC4\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xA9"],
        ["\xC4\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAA"],
        ["\xC4\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAB"],
        ["\xC4\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAC"],
        ["\xC4\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAD"],
        ["\xC4\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAE"],
        ["\xC4\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xAF"],
        ["\xC4\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB0"],
        ["\xC4\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB1"],
        ["\xC4\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB2"],
        ["\xC4\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB3"],
        ["\xC4\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB4"],
        ["\xC4\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB5"],
        ["\xC4\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB6"],
        ["\xC4\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB7"],
        ["\xC4\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB8"],
        ["\xC4\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xB9"],
        ["\xC4\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBA"],
        ["\xC4\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBB"],
        ["\xC4\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBC"],
        ["\xC4\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBD"],
        ["\xC4\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBE"],
        ["\xC4\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB7\xBF"],
        ["\xC4\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x80"],
        ["\xC4\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x81"],
        ["\xC4\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x82"],
        ["\xC4\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x83"],
        ["\xC4\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x84"],
        ["\xC4\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x85"],
        ["\xC4\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x86"],
        ["\xC4\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x87"],
        ["\xC4\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x88"],
        ["\xC4\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x89"],
        ["\xC4\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8A"],
        ["\xC4\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8B"],
        ["\xC4\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8C"],
        ["\xC4\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8D"],
        ["\xC4\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8E"],
        ["\xC4\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x8F"],
        ["\xC4\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x90"],
        ["\xC4\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x91"],
        ["\xC4\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x92"],
        ["\xC4\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x93"],
        ["\xC4\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x94"],
        ["\xC4\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x95"],
        ["\xC4\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x96"],
        ["\xC4\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x97"],
        ["\xC4\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x98"],
        ["\xC4\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x99"],
        ["\xC4\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9A"],
        ["\xC4\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9B"],
        ["\xC4\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9C"],
        ["\xC4\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9D"],
        ["\xC4\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9E"],
        ["\xC4\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\x9F"],
        ["\xC4\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA0"],
        ["\xC4\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA1"],
        ["\xC4\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA2"],
        ["\xC4\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA3"],
        ["\xC4\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA4"],
        ["\xC4\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA5"],
        ["\xC4\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA6"],
        ["\xC4\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA7"],
        ["\xC4\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA8"],
        ["\xC4\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xA9"],
        ["\xC4\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAA"],
        ["\xC4\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAB"],
        ["\xC4\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAC"],
        ["\xC4\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAD"],
        ["\xC4\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAE"],
        ["\xC4\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xAF"],
        ["\xC4\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB0"],
        ["\xC4\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB1"],
        ["\xC4\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB2"],
        ["\xC4\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB3"],
        ["\xC4\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB4"],
        ["\xC4\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB5"],
        ["\xC4\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB6"],
        ["\xC4\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB7"],
        ["\xC5\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB8"],
        ["\xC5\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xB9"],
        ["\xC5\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBA"],
        ["\xC5\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBB"],
        ["\xC5\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBC"],
        ["\xC5\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBD"],
        ["\xC5\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBE"],
        ["\xC5\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB8\xBF"],
        ["\xC5\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x80"],
        ["\xC5\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x81"],
        ["\xC5\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x82"],
        ["\xC5\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x83"],
        ["\xC5\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x84"],
        ["\xC5\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x85"],
        ["\xC5\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x86"],
        ["\xC5\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x87"],
        ["\xC5\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x88"],
        ["\xC5\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x89"],
        ["\xC5\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8A"],
        ["\xC5\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8B"],
        ["\xC5\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8C"],
        ["\xC5\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8D"],
        ["\xC5\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8E"],
        ["\xC5\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x8F"],
        ["\xC5\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x90"],
        ["\xC5\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x91"],
        ["\xC5\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x92"],
        ["\xC5\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x93"],
        ["\xC5\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x94"],
        ["\xC5\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x95"],
        ["\xC5\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x96"],
        ["\xC5\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x97"],
        ["\xC5\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x98"],
        ["\xC5\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x99"],
        ["\xC5\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9A"],
        ["\xC5\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9B"],
        ["\xC5\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9C"],
        ["\xC5\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9D"],
        ["\xC5\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9E"],
        ["\xC5\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\x9F"],
        ["\xC5\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA0"],
        ["\xC5\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA1"],
        ["\xC5\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA2"],
        ["\xC5\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA3"],
        ["\xC5\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA4"],
        ["\xC5\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA5"],
        ["\xC5\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA6"],
        ["\xC5\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA7"],
        ["\xC5\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA8"],
        ["\xC5\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xA9"],
        ["\xC5\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAA"],
        ["\xC5\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAB"],
        ["\xC5\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAC"],
        ["\xC5\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAD"],
        ["\xC5\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAE"],
        ["\xC5\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xAF"],
        ["\xC5\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB0"],
        ["\xC5\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB1"],
        ["\xC5\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB2"],
        ["\xC5\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB3"],
        ["\xC5\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB4"],
        ["\xC5\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB5"],
        ["\xC5\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB6"],
        ["\xC5\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB7"],
        ["\xC5\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB8"],
        ["\xC5\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xB9"],
        ["\xC5\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBA"],
        ["\xC5\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBB"],
        ["\xC5\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBC"],
        ["\xC5\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBD"],
        ["\xC5\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBE"],
        ["\xC5\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xB9\xBF"],
        ["\xC5\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x80"],
        ["\xC5\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x81"],
        ["\xC5\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x82"],
        ["\xC5\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x83"],
        ["\xC5\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x84"],
        ["\xC5\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x85"],
        ["\xC5\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x86"],
        ["\xC5\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x87"],
        ["\xC5\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x88"],
        ["\xC5\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x89"],
        ["\xC5\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8A"],
        ["\xC5\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8B"],
        ["\xC5\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8C"],
        ["\xC5\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8D"],
        ["\xC5\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8E"],
        ["\xC5\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x8F"],
        ["\xC5\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x90"],
        ["\xC5\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x91"],
        ["\xC5\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x92"],
        ["\xC5\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x93"],
        ["\xC5\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x94"],
        ["\xC5\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x95"],
        ["\xC6\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x96"],
        ["\xC6\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x97"],
        ["\xC6\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x98"],
        ["\xC6\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x99"],
        ["\xC6\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9A"],
        ["\xC6\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9B"],
        ["\xC6\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9C"],
        ["\xC6\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9D"],
        ["\xC6\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9E"],
        ["\xC6\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\x9F"],
        ["\xC6\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA0"],
        ["\xC6\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA1"],
        ["\xC6\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA2"],
        ["\xC6\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA3"],
        ["\xC6\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA4"],
        ["\xC6\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA5"],
        ["\xC6\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA6"],
        ["\xC6\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA7"],
        ["\xC6\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA8"],
        ["\xC6\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xA9"],
        ["\xC6\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAA"],
        ["\xC6\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAB"],
        ["\xC6\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAC"],
        ["\xC6\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAD"],
        ["\xC6\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAE"],
        ["\xC6\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xAF"],
        ["\xC6\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB0"],
        ["\xC6\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB1"],
        ["\xC6\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB2"],
        ["\xC6\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB3"],
        ["\xC6\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB4"],
        ["\xC6\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB5"],
        ["\xC6\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB6"],
        ["\xC6\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB7"],
        ["\xC6\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB8"],
        ["\xC6\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xB9"],
        ["\xC6\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBA"],
        ["\xC6\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBB"],
        ["\xC6\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBC"],
        ["\xC6\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBD"],
        ["\xC6\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBE"],
        ["\xC6\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBA\xBF"],
        ["\xC6\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x80"],
        ["\xC6\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x81"],
        ["\xC6\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x82"],
        ["\xC6\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x83"],
        ["\xC6\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x84"],
        ["\xC6\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x85"],
        ["\xC6\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x86"],
        ["\xC6\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x87"],
        ["\xC6\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x88"],
        ["\xC6\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x89"],
        ["\xC6\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8A"],
        ["\xC6\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8B"],
        ["\xC6\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8C"],
        ["\xC6\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8D"],
        ["\xC6\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8E"],
        ["\xC6\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x8F"],
        ["\xC6\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x90"],
        ["\xC6\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x91"],
        ["\xC6\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x92"],
        ["\xC6\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x93"],
        ["\xC6\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x94"],
        ["\xC6\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x95"],
        ["\xC6\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x96"],
        ["\xC6\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x97"],
        ["\xC6\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x98"],
        ["\xC6\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x99"],
        ["\xC6\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9A"],
        ["\xC6\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9B"],
        ["\xC6\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9C"],
        ["\xC6\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9D"],
        ["\xC6\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9E"],
        ["\xC6\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\x9F"],
        ["\xC6\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA0"],
        ["\xC6\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA1"],
        ["\xC6\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA2"],
        ["\xC6\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA3"],
        ["\xC6\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA4"],
        ["\xC6\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA5"],
        ["\xC6\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA6"],
        ["\xC6\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA7"],
        ["\xC6\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA8"],
        ["\xC6\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xA9"],
        ["\xC6\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAA"],
        ["\xC6\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAB"],
        ["\xC6\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAC"],
        ["\xC6\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAD"],
        ["\xC6\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAE"],
        ["\xC6\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xAF"],
        ["\xC6\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB0"],
        ["\xC6\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB1"],
        ["\xC6\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB2"],
        ["\xC6\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB3"],
        ["\xC7\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB4"],
        ["\xC7\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB5"],
        ["\xC7\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB6"],
        ["\xC7\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB7"],
        ["\xC7\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB8"],
        ["\xC7\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xB9"],
        ["\xC7\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBA"],
        ["\xC7\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBB"],
        ["\xC7\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBC"],
        ["\xC7\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBD"],
        ["\xC7\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBE"],
        ["\xC7\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBB\xBF"],
        ["\xC7\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x80"],
        ["\xC7\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x81"],
        ["\xC7\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x82"],
        ["\xC7\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x83"],
        ["\xC7\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x84"],
        ["\xC7\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x85"],
        ["\xC7\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x86"],
        ["\xC7\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x87"],
        ["\xC7\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x88"],
        ["\xC7\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x89"],
        ["\xC7\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8A"],
        ["\xC7\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8B"],
        ["\xC7\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8C"],
        ["\xC7\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8D"],
        ["\xC7\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8E"],
        ["\xC7\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x8F"],
        ["\xC7\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x90"],
        ["\xC7\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x91"],
        ["\xC7\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x92"],
        ["\xC7\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x93"],
        ["\xC7\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x94"],
        ["\xC7\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x95"],
        ["\xC7\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x96"],
        ["\xC7\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x97"],
        ["\xC7\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x98"],
        ["\xC7\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x99"],
        ["\xC7\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9A"],
        ["\xC7\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9B"],
        ["\xC7\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9C"],
        ["\xC7\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9D"],
        ["\xC7\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9E"],
        ["\xC7\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\x9F"],
        ["\xC7\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA0"],
        ["\xC7\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA1"],
        ["\xC7\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA2"],
        ["\xC7\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA3"],
        ["\xC7\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA4"],
        ["\xC7\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA5"],
        ["\xC7\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA6"],
        ["\xC7\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA7"],
        ["\xC7\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA8"],
        ["\xC7\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xA9"],
        ["\xC7\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAA"],
        ["\xC7\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAB"],
        ["\xC7\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAC"],
        ["\xC7\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAD"],
        ["\xC7\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAE"],
        ["\xC7\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xAF"],
        ["\xC7\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB0"],
        ["\xC7\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB1"],
        ["\xC7\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB2"],
        ["\xC7\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB3"],
        ["\xC7\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB4"],
        ["\xC7\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB5"],
        ["\xC7\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB6"],
        ["\xC7\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB7"],
        ["\xC7\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB8"],
        ["\xC7\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xB9"],
        ["\xC7\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBA"],
        ["\xC7\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBB"],
        ["\xC7\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBC"],
        ["\xC7\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBD"],
        ["\xC7\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBE"],
        ["\xC7\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBC\xBF"],
        ["\xC7\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x80"],
        ["\xC7\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x81"],
        ["\xC7\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x82"],
        ["\xC7\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x83"],
        ["\xC7\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x84"],
        ["\xC7\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x85"],
        ["\xC7\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x86"],
        ["\xC7\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x87"],
        ["\xC7\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x88"],
        ["\xC7\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x89"],
        ["\xC7\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8A"],
        ["\xC7\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8B"],
        ["\xC7\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8C"],
        ["\xC7\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8D"],
        ["\xC7\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8E"],
        ["\xC7\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x8F"],
        ["\xC7\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x90"],
        ["\xC7\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x91"],
        ["\xC8\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x92"],
        ["\xC8\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x93"],
        ["\xC8\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x94"],
        ["\xC8\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x95"],
        ["\xC8\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x96"],
        ["\xC8\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x97"],
        ["\xC8\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x98"],
        ["\xC8\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x99"],
        ["\xC8\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9A"],
        ["\xC8\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9B"],
        ["\xC8\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9C"],
        ["\xC8\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9D"],
        ["\xC8\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9E"],
        ["\xC8\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\x9F"],
        ["\xC8\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA0"],
        ["\xC8\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA1"],
        ["\xC8\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA2"],
        ["\xC8\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA3"],
        ["\xC8\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA4"],
        ["\xC8\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA5"],
        ["\xC8\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA6"],
        ["\xC8\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA7"],
        ["\xC8\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA8"],
        ["\xC8\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xA9"],
        ["\xC8\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAA"],
        ["\xC8\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAB"],
        ["\xC8\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAC"],
        ["\xC8\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAD"],
        ["\xC8\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAE"],
        ["\xC8\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xAF"],
        ["\xC8\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB0"],
        ["\xC8\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB1"],
        ["\xC8\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB2"],
        ["\xC8\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB3"],
        ["\xC8\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB4"],
        ["\xC8\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB5"],
        ["\xC8\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB6"],
        ["\xC8\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB7"],
        ["\xC8\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB8"],
        ["\xC8\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xB9"],
        ["\xC8\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBA"],
        ["\xC8\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBB"],
        ["\xC8\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBC"],
        ["\xC8\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBD"],
        ["\xC8\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBE"],
        ["\xC8\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBD\xBF"],
        ["\xC8\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x80"],
        ["\xC8\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x81"],
        ["\xC8\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x82"],
        ["\xC8\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x83"],
        ["\xC8\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x84"],
        ["\xC8\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x85"],
        ["\xC8\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x86"],
        ["\xC8\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x87"],
        ["\xC8\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x88"],
        ["\xC8\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x89"],
        ["\xC8\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8A"],
        ["\xC8\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8B"],
        ["\xC8\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8C"],
        ["\xC8\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8D"],
        ["\xC8\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8E"],
        ["\xC8\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x8F"],
        ["\xC8\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x90"],
        ["\xC8\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x91"],
        ["\xC8\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x92"],
        ["\xC8\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x93"],
        ["\xC8\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x94"],
        ["\xC8\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x95"],
        ["\xC8\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x96"],
        ["\xC8\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x97"],
        ["\xC8\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x98"],
        ["\xC8\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x99"],
        ["\xC8\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9A"],
        ["\xC8\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9B"],
        ["\xC8\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9C"],
        ["\xC8\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9D"],
        ["\xC8\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9E"],
        ["\xC8\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\x9F"],
        ["\xC8\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA0"],
        ["\xC8\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA1"],
        ["\xC8\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA2"],
        ["\xC8\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA3"],
        ["\xC8\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA4"],
        ["\xC8\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA5"],
        ["\xC8\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA6"],
        ["\xC8\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA7"],
        ["\xC8\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA8"],
        ["\xC8\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xA9"],
        ["\xC8\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAA"],
        ["\xC8\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAB"],
        ["\xC8\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAC"],
        ["\xC8\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAD"],
        ["\xC8\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAE"],
        ["\xC8\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xAF"],
        ["\xC9\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB0"],
        ["\xC9\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB1"],
        ["\xC9\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB2"],
        ["\xC9\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB3"],
        ["\xC9\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB4"],
        ["\xC9\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB5"],
        ["\xC9\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB6"],
        ["\xC9\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB7"],
        ["\xC9\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB8"],
        ["\xC9\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xB9"],
        ["\xC9\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBA"],
        ["\xC9\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBB"],
        ["\xC9\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBC"],
        ["\xC9\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBD"],
        ["\xC9\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBE"],
        ["\xC9\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBE\xBF"],
        ["\xC9\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x80"],
        ["\xC9\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x81"],
        ["\xC9\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x82"],
        ["\xC9\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x83"],
        ["\xC9\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x84"],
        ["\xC9\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x85"],
        ["\xC9\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x86"],
        ["\xC9\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x87"],
        ["\xC9\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x88"],
        ["\xC9\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x89"],
        ["\xC9\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8A"],
        ["\xC9\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8B"],
        ["\xC9\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8C"],
        ["\xC9\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8D"],
        ["\xC9\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8E"],
        ["\xC9\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x8F"],
        ["\xC9\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x90"],
        ["\xC9\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x91"],
        ["\xC9\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x92"],
        ["\xC9\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x93"],
        ["\xC9\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x94"],
        ["\xC9\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x95"],
        ["\xC9\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x96"],
        ["\xC9\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x97"],
        ["\xC9\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x98"],
        ["\xC9\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x99"],
        ["\xC9\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9A"],
        ["\xC9\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9B"],
        ["\xC9\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9C"],
        ["\xC9\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9D"],
        ["\xC9\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9E"],
        ["\xC9\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\x9F"],
        ["\xC9\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA0"],
        ["\xC9\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA1"],
        ["\xC9\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA2"],
        ["\xC9\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA3"],
        ["\xC9\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA4"],
        ["\xC9\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA5"],
        ["\xC9\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA6"],
        ["\xC9\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA7"],
        ["\xC9\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA8"],
        ["\xC9\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xA9"],
        ["\xC9\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAA"],
        ["\xC9\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAB"],
        ["\xC9\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAC"],
        ["\xC9\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAD"],
        ["\xC9\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAE"],
        ["\xC9\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xAF"],
        ["\xC9\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB0"],
        ["\xC9\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB1"],
        ["\xC9\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB2"],
        ["\xC9\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB3"],
        ["\xC9\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB4"],
        ["\xC9\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB5"],
        ["\xC9\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB6"],
        ["\xC9\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB7"],
        ["\xC9\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB8"],
        ["\xC9\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xB9"],
        ["\xC9\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBA"],
        ["\xC9\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBB"],
        ["\xC9\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBC"],
        ["\xC9\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBD"],
        ["\xC9\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBE"],
        ["\xC9\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB0\xBF\xBF"],
        ["\xC9\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x80"],
        ["\xC9\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x81"],
        ["\xC9\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x82"],
        ["\xC9\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x83"],
        ["\xC9\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x84"],
        ["\xC9\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x85"],
        ["\xC9\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x86"],
        ["\xC9\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x87"],
        ["\xC9\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x88"],
        ["\xC9\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x89"],
        ["\xC9\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8A"],
        ["\xC9\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8B"],
        ["\xC9\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8C"],
        ["\xC9\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8D"],
        ["\xCA\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8E"],
        ["\xCA\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x8F"],
        ["\xCA\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x90"],
        ["\xCA\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x91"],
        ["\xCA\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x92"],
        ["\xCA\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x93"],
        ["\xCA\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x94"],
        ["\xCA\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x95"],
        ["\xCA\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x96"],
        ["\xCA\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x97"],
        ["\xCA\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x98"],
        ["\xCA\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x99"],
        ["\xCA\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9A"],
        ["\xCA\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9B"],
        ["\xCA\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9C"],
        ["\xCA\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9D"],
        ["\xCA\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9E"],
        ["\xCA\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\x9F"],
        ["\xCA\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA0"],
        ["\xCA\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA1"],
        ["\xCA\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA2"],
        ["\xCA\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA3"],
        ["\xCA\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA4"],
        ["\xCA\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA5"],
        ["\xCA\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA6"],
        ["\xCA\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA7"],
        ["\xCA\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA8"],
        ["\xCA\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xA9"],
        ["\xCA\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAA"],
        ["\xCA\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAB"],
        ["\xCA\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAC"],
        ["\xCA\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAD"],
        ["\xCA\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAE"],
        ["\xCA\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xAF"],
        ["\xCA\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB0"],
        ["\xCA\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB1"],
        ["\xCA\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB2"],
        ["\xCA\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB3"],
        ["\xCA\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB4"],
        ["\xCA\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB5"],
        ["\xCA\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB6"],
        ["\xCA\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB7"],
        ["\xCA\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB8"],
        ["\xCA\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xB9"],
        ["\xCA\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBA"],
        ["\xCA\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBB"],
        ["\xCA\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBC"],
        ["\xCA\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBD"],
        ["\xCA\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBE"],
        ["\xCA\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x80\xBF"],
        ["\xCA\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x80"],
        ["\xCA\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x81"],
        ["\xCA\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x82"],
        ["\xCA\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x83"],
        ["\xCA\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x84"],
        ["\xCA\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x85"],
        ["\xCA\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x86"],
        ["\xCA\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x87"],
        ["\xCA\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x88"],
        ["\xCA\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x89"],
        ["\xCA\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8A"],
        ["\xCA\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8B"],
        ["\xCA\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8C"],
        ["\xCA\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8D"],
        ["\xCA\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8E"],
        ["\xCA\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x8F"],
        ["\xCA\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x90"],
        ["\xCA\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x91"],
        ["\xCA\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x92"],
        ["\xCA\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x93"],
        ["\xCA\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x94"],
        ["\xCA\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x95"],
        ["\xCA\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x96"],
        ["\xCA\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x97"],
        ["\xCA\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x98"],
        ["\xCA\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x99"],
        ["\xCA\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9A"],
        ["\xCA\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9B"],
        ["\xCA\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9C"],
        ["\xCA\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9D"],
        ["\xCA\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9E"],
        ["\xCA\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\x9F"],
        ["\xCA\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA0"],
        ["\xCA\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA1"],
        ["\xCA\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA2"],
        ["\xCA\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA3"],
        ["\xCA\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA4"],
        ["\xCA\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA5"],
        ["\xCA\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA6"],
        ["\xCA\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA7"],
        ["\xCA\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA8"],
        ["\xCA\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xA9"],
        ["\xCA\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAA"],
        ["\xCA\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAB"],
        ["\xCB\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAC"],
        ["\xCB\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAD"],
        ["\xCB\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAE"],
        ["\xCB\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xAF"],
        ["\xCB\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB0"],
        ["\xCB\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB1"],
        ["\xCB\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB2"],
        ["\xCB\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB3"],
        ["\xCB\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB4"],
        ["\xCB\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB5"],
        ["\xCB\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB6"],
        ["\xCB\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB7"],
        ["\xCB\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB8"],
        ["\xCB\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xB9"],
        ["\xCB\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBA"],
        ["\xCB\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBB"],
        ["\xCB\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBC"],
        ["\xCB\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBD"],
        ["\xCB\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBE"],
        ["\xCB\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x81\xBF"],
        ["\xCB\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x80"],
        ["\xCB\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x81"],
        ["\xCB\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x82"],
        ["\xCB\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x83"],
        ["\xCB\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x84"],
        ["\xCB\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x85"],
        ["\xCB\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x86"],
        ["\xCB\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x87"],
        ["\xCB\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x88"],
        ["\xCB\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x89"],
        ["\xCB\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8A"],
        ["\xCB\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8B"],
        ["\xCB\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8C"],
        ["\xCB\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8D"],
        ["\xCB\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8E"],
        ["\xCB\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x8F"],
        ["\xCB\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x90"],
        ["\xCB\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x91"],
        ["\xCB\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x92"],
        ["\xCB\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x93"],
        ["\xCB\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x94"],
        ["\xCB\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x95"],
        ["\xCB\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x96"],
        ["\xCB\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x97"],
        ["\xCB\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x98"],
        ["\xCB\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x99"],
        ["\xCB\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9A"],
        ["\xCB\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9B"],
        ["\xCB\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9C"],
        ["\xCB\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9D"],
        ["\xCB\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9E"],
        ["\xCB\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\x9F"],
        ["\xCB\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA0"],
        ["\xCB\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA1"],
        ["\xCB\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA2"],
        ["\xCB\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA3"],
        ["\xCB\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA4"],
        ["\xCB\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA5"],
        ["\xCB\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA6"],
        ["\xCB\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA7"],
        ["\xCB\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA8"],
        ["\xCB\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xA9"],
        ["\xCB\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAA"],
        ["\xCB\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAB"],
        ["\xCB\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAC"],
        ["\xCB\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAD"],
        ["\xCB\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAE"],
        ["\xCB\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xAF"],
        ["\xCB\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB0"],
        ["\xCB\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB1"],
        ["\xCB\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB2"],
        ["\xCB\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB3"],
        ["\xCB\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB4"],
        ["\xCB\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB5"],
        ["\xCB\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB6"],
        ["\xCB\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB7"],
        ["\xCB\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB8"],
        ["\xCB\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xB9"],
        ["\xCB\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBA"],
        ["\xCB\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBB"],
        ["\xCB\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBC"],
        ["\xCB\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBD"],
        ["\xCB\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBE"],
        ["\xCB\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x82\xBF"],
        ["\xCB\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x80"],
        ["\xCB\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x81"],
        ["\xCB\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x82"],
        ["\xCB\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x83"],
        ["\xCB\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x84"],
        ["\xCB\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x85"],
        ["\xCB\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x86"],
        ["\xCB\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x87"],
        ["\xCB\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x88"],
        ["\xCB\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x89"],
        ["\xCC\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8A"],
        ["\xCC\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8B"],
        ["\xCC\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8C"],
        ["\xCC\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8D"],
        ["\xCC\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8E"],
        ["\xCC\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x8F"],
        ["\xCC\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x90"],
        ["\xCC\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x91"],
        ["\xCC\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x92"],
        ["\xCC\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x93"],
        ["\xCC\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x94"],
        ["\xCC\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x95"],
        ["\xCC\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x96"],
        ["\xCC\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x97"],
        ["\xCC\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x98"],
        ["\xCC\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x99"],
        ["\xCC\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9A"],
        ["\xCC\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9B"],
        ["\xCC\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9C"],
        ["\xCC\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9D"],
        ["\xCC\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9E"],
        ["\xCC\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\x9F"],
        ["\xCC\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA0"],
        ["\xCC\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA1"],
        ["\xCC\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA2"],
        ["\xCC\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA3"],
        ["\xCC\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA4"],
        ["\xCC\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA5"],
        ["\xCC\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA6"],
        ["\xCC\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA7"],
        ["\xCC\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA8"],
        ["\xCC\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xA9"],
        ["\xCC\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAA"],
        ["\xCC\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAB"],
        ["\xCC\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAC"],
        ["\xCC\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAD"],
        ["\xCC\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAE"],
        ["\xCC\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xAF"],
        ["\xCC\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB0"],
        ["\xCC\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB1"],
        ["\xCC\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB2"],
        ["\xCC\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB3"],
        ["\xCC\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB4"],
        ["\xCC\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB5"],
        ["\xCC\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB6"],
        ["\xCC\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB7"],
        ["\xCC\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB8"],
        ["\xCC\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xB9"],
        ["\xCC\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBA"],
        ["\xCC\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBB"],
        ["\xCC\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBC"],
        ["\xCC\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBD"],
        ["\xCC\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBE"],
        ["\xCC\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x83\xBF"],
        ["\xCC\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x80"],
        ["\xCC\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x81"],
        ["\xCC\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x82"],
        ["\xCC\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x83"],
        ["\xCC\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x84"],
        ["\xCC\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x85"],
        ["\xCC\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x86"],
        ["\xCC\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x87"],
        ["\xCC\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x88"],
        ["\xCC\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x89"],
        ["\xCC\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8A"],
        ["\xCC\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8B"],
        ["\xCC\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8C"],
        ["\xCC\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8D"],
        ["\xCC\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8E"],
        ["\xCC\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x8F"],
        ["\xCC\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x90"],
        ["\xCC\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x91"],
        ["\xCC\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x92"],
        ["\xCC\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x93"],
        ["\xCC\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x94"],
        ["\xCC\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x95"],
        ["\xCC\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x96"],
        ["\xCC\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x97"],
        ["\xCC\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x98"],
        ["\xCC\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x99"],
        ["\xCC\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9A"],
        ["\xCC\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9B"],
        ["\xCC\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9C"],
        ["\xCC\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9D"],
        ["\xCC\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9E"],
        ["\xCC\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\x9F"],
        ["\xCC\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA0"],
        ["\xCC\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA1"],
        ["\xCC\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA2"],
        ["\xCC\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA3"],
        ["\xCC\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA4"],
        ["\xCC\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA5"],
        ["\xCC\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA6"],
        ["\xCC\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA7"],
        ["\xCD\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA8"],
        ["\xCD\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xA9"],
        ["\xCD\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAA"],
        ["\xCD\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAB"],
        ["\xCD\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAC"],
        ["\xCD\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAD"],
        ["\xCD\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAE"],
        ["\xCD\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xAF"],
        ["\xCD\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB0"],
        ["\xCD\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB1"],
        ["\xCD\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB2"],
        ["\xCD\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB3"],
        ["\xCD\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB4"],
        ["\xCD\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB5"],
        ["\xCD\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB6"],
        ["\xCD\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB7"],
        ["\xCD\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB8"],
        ["\xCD\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xB9"],
        ["\xCD\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBA"],
        ["\xCD\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBB"],
        ["\xCD\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBC"],
        ["\xCD\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBD"],
        ["\xCD\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBE"],
        ["\xCD\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x84\xBF"],
        ["\xCD\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x80"],
        ["\xCD\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x81"],
        ["\xCD\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x82"],
        ["\xCD\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x83"],
        ["\xCD\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x84"],
        ["\xCD\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x85"],
        ["\xCD\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x86"],
        ["\xCD\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x87"],
        ["\xCD\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x88"],
        ["\xCD\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x89"],
        ["\xCD\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8A"],
        ["\xCD\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8B"],
        ["\xCD\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8C"],
        ["\xCD\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8D"],
        ["\xCD\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8E"],
        ["\xCD\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x8F"],
        ["\xCD\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x90"],
        ["\xCD\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x91"],
        ["\xCD\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x92"],
        ["\xCD\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x93"],
        ["\xCD\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x94"],
        ["\xCD\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x95"],
        ["\xCD\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x96"],
        ["\xCD\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x97"],
        ["\xCD\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x98"],
        ["\xCD\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x99"],
        ["\xCD\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9A"],
        ["\xCD\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9B"],
        ["\xCD\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9C"],
        ["\xCD\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9D"],
        ["\xCD\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9E"],
        ["\xCD\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\x9F"],
        ["\xCD\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA0"],
        ["\xCD\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA1"],
        ["\xCD\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA2"],
        ["\xCD\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA3"],
        ["\xCD\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA4"],
        ["\xCD\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA5"],
        ["\xCD\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA6"],
        ["\xCD\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA7"],
        ["\xCD\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA8"],
        ["\xCD\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xA9"],
        ["\xCD\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAA"],
        ["\xCD\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAB"],
        ["\xCD\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAC"],
        ["\xCD\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAD"],
        ["\xCD\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAE"],
        ["\xCD\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xAF"],
        ["\xCD\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB0"],
        ["\xCD\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB1"],
        ["\xCD\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB2"],
        ["\xCD\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB3"],
        ["\xCD\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB4"],
        ["\xCD\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB5"],
        ["\xCD\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB6"],
        ["\xCD\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB7"],
        ["\xCD\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB8"],
        ["\xCD\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xB9"],
        ["\xCD\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBA"],
        ["\xCD\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBB"],
        ["\xCD\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBC"],
        ["\xCD\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBD"],
        ["\xCD\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBE"],
        ["\xCD\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x85\xBF"],
        ["\xCD\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x80"],
        ["\xCD\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x81"],
        ["\xCD\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x82"],
        ["\xCD\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x83"],
        ["\xCD\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x84"],
        ["\xCD\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x85"],
        ["\xCE\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x86"],
        ["\xCE\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x87"],
        ["\xCE\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x88"],
        ["\xCE\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x89"],
        ["\xCE\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8A"],
        ["\xCE\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8B"],
        ["\xCE\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8C"],
        ["\xCE\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8D"],
        ["\xCE\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8E"],
        ["\xCE\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x8F"],
        ["\xCE\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x90"],
        ["\xCE\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x91"],
        ["\xCE\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x92"],
        ["\xCE\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x93"],
        ["\xCE\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x94"],
        ["\xCE\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x95"],
        ["\xCE\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x96"],
        ["\xCE\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x97"],
        ["\xCE\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x98"],
        ["\xCE\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x99"],
        ["\xCE\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9A"],
        ["\xCE\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9B"],
        ["\xCE\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9C"],
        ["\xCE\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9D"],
        ["\xCE\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9E"],
        ["\xCE\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\x9F"],
        ["\xCE\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA0"],
        ["\xCE\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA1"],
        ["\xCE\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA2"],
        ["\xCE\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA3"],
        ["\xCE\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA4"],
        ["\xCE\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA5"],
        ["\xCE\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA6"],
        ["\xCE\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA7"],
        ["\xCE\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA8"],
        ["\xCE\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xA9"],
        ["\xCE\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAA"],
        ["\xCE\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAB"],
        ["\xCE\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAC"],
        ["\xCE\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAD"],
        ["\xCE\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAE"],
        ["\xCE\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xAF"],
        ["\xCE\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB0"],
        ["\xCE\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB1"],
        ["\xCE\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB2"],
        ["\xCE\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB3"],
        ["\xCE\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB4"],
        ["\xCE\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB5"],
        ["\xCE\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB6"],
        ["\xCE\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB7"],
        ["\xCE\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB8"],
        ["\xCE\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xB9"],
        ["\xCE\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBA"],
        ["\xCE\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBB"],
        ["\xCE\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBC"],
        ["\xCE\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBD"],
        ["\xCE\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBE"],
        ["\xCE\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x86\xBF"],
        ["\xCE\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x80"],
        ["\xCE\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x81"],
        ["\xCE\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x82"],
        ["\xCE\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x83"],
        ["\xCE\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x84"],
        ["\xCE\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x85"],
        ["\xCE\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x86"],
        ["\xCE\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x87"],
        ["\xCE\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x88"],
        ["\xCE\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x89"],
        ["\xCE\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8A"],
        ["\xCE\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8B"],
        ["\xCE\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8C"],
        ["\xCE\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8D"],
        ["\xCE\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8E"],
        ["\xCE\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x8F"],
        ["\xCE\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x90"],
        ["\xCE\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x91"],
        ["\xCE\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x92"],
        ["\xCE\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x93"],
        ["\xCE\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x94"],
        ["\xCE\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x95"],
        ["\xCE\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x96"],
        ["\xCE\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x97"],
        ["\xCE\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x98"],
        ["\xCE\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x99"],
        ["\xCE\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9A"],
        ["\xCE\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9B"],
        ["\xCE\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9C"],
        ["\xCE\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9D"],
        ["\xCE\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9E"],
        ["\xCE\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\x9F"],
        ["\xCE\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA0"],
        ["\xCE\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA1"],
        ["\xCE\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA2"],
        ["\xCE\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA3"],
        ["\xCF\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA4"],
        ["\xCF\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA5"],
        ["\xCF\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA6"],
        ["\xCF\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA7"],
        ["\xCF\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA8"],
        ["\xCF\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xA9"],
        ["\xCF\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAA"],
        ["\xCF\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAB"],
        ["\xCF\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAC"],
        ["\xCF\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAD"],
        ["\xCF\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAE"],
        ["\xCF\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xAF"],
        ["\xCF\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB0"],
        ["\xCF\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB1"],
        ["\xCF\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB2"],
        ["\xCF\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB3"],
        ["\xCF\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB4"],
        ["\xCF\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB5"],
        ["\xCF\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB6"],
        ["\xCF\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB7"],
        ["\xCF\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB8"],
        ["\xCF\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xB9"],
        ["\xCF\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBA"],
        ["\xCF\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBB"],
        ["\xCF\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBC"],
        ["\xCF\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBD"],
        ["\xCF\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBE"],
        ["\xCF\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x87\xBF"],
        ["\xCF\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x80"],
        ["\xCF\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x81"],
        ["\xCF\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x82"],
        ["\xCF\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x83"],
        ["\xCF\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x84"],
        ["\xCF\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x85"],
        ["\xCF\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x86"],
        ["\xCF\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x87"],
        ["\xCF\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x88"],
        ["\xCF\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x89"],
        ["\xCF\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8A"],
        ["\xCF\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8B"],
        ["\xCF\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8C"],
        ["\xCF\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8D"],
        ["\xCF\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8E"],
        ["\xCF\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x8F"],
        ["\xCF\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x90"],
        ["\xCF\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x91"],
        ["\xCF\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x92"],
        ["\xCF\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x93"],
        ["\xCF\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x94"],
        ["\xCF\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x95"],
        ["\xCF\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x88\x96"],
        ["\xD0\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x82"],
        ["\xD0\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x83"],
        ["\xD0\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x84"],
        ["\xD0\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x85"],
        ["\xD0\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x86"],
        ["\xD0\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x87"],
        ["\xD0\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x88"],
        ["\xD0\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x89"],
        ["\xD0\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8A"],
        ["\xD0\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8B"],
        ["\xD0\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8C"],
        ["\xD0\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8D"],
        ["\xD0\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8E"],
        ["\xD0\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x8F"],
        ["\xD0\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x90"],
        ["\xD0\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x91"],
        ["\xD0\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x92"],
        ["\xD0\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x93"],
        ["\xD0\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x94"],
        ["\xD0\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x95"],
        ["\xD0\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x96"],
        ["\xD0\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x97"],
        ["\xD0\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x98"],
        ["\xD0\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x99"],
        ["\xD0\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9A"],
        ["\xD0\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9B"],
        ["\xD0\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9C"],
        ["\xD0\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9D"],
        ["\xD0\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9E"],
        ["\xD0\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\x9F"],
        ["\xD0\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA0"],
        ["\xD0\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA1"],
        ["\xD0\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA2"],
        ["\xD0\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA3"],
        ["\xD0\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA4"],
        ["\xD0\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA5"],
        ["\xD0\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA6"],
        ["\xD0\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA7"],
        ["\xD0\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA8"],
        ["\xD0\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xA9"],
        ["\xD0\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAA"],
        ["\xD0\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAB"],
        ["\xD0\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAC"],
        ["\xD0\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAD"],
        ["\xD0\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAE"],
        ["\xD0\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xAF"],
        ["\xD0\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB0"],
        ["\xD0\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB1"],
        ["\xD0\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB2"],
        ["\xD0\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB3"],
        ["\xD0\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB4"],
        ["\xD0\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB5"],
        ["\xD0\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB6"],
        ["\xD0\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB7"],
        ["\xD0\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB8"],
        ["\xD0\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xB9"],
        ["\xD0\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBA"],
        ["\xD0\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBB"],
        ["\xD0\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBC"],
        ["\xD0\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBD"],
        ["\xD0\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBE"],
        ["\xD0\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x89\xBF"],
        ["\xD0\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x80"],
        ["\xD0\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x81"],
        ["\xD0\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x82"],
        ["\xD0\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x83"],
        ["\xD0\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x84"],
        ["\xD0\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x85"],
        ["\xD0\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x86"],
        ["\xD0\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x87"],
        ["\xD0\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x88"],
        ["\xD0\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x89"],
        ["\xD0\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8A"],
        ["\xD0\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8B"],
        ["\xD0\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8C"],
        ["\xD0\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8D"],
        ["\xD0\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8E"],
        ["\xD0\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x8F"],
        ["\xD0\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x90"],
        ["\xD0\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x91"],
        ["\xD0\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x92"],
        ["\xD0\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x93"],
        ["\xD0\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x94"],
        ["\xD0\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x95"],
        ["\xD0\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x96"],
        ["\xD0\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x97"],
        ["\xD0\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x98"],
        ["\xD0\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x99"],
        ["\xD0\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9A"],
        ["\xD0\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9B"],
        ["\xD0\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9C"],
        ["\xD0\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9D"],
        ["\xD0\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9E"],
        ["\xD0\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\x9F"],
        ["\xD1\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA0"],
        ["\xD1\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA1"],
        ["\xD1\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA2"],
        ["\xD1\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA3"],
        ["\xD1\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA4"],
        ["\xD1\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA5"],
        ["\xD1\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA6"],
        ["\xD1\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA7"],
        ["\xD1\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA8"],
        ["\xD1\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xA9"],
        ["\xD1\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAA"],
        ["\xD1\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAB"],
        ["\xD1\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAC"],
        ["\xD1\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAD"],
        ["\xD1\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAE"],
        ["\xD1\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xAF"],
        ["\xD1\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB0"],
        ["\xD1\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB1"],
        ["\xD1\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB2"],
        ["\xD1\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB3"],
        ["\xD1\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB4"],
        ["\xD1\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB5"],
        ["\xD1\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB6"],
        ["\xD1\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB7"],
        ["\xD1\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB8"],
        ["\xD1\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xB9"],
        ["\xD1\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBA"],
        ["\xD1\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBB"],
        ["\xD1\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBC"],
        ["\xD1\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBD"],
        ["\xD1\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBE"],
        ["\xD1\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8A\xBF"],
        ["\xD1\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x80"],
        ["\xD1\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x81"],
        ["\xD1\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x82"],
        ["\xD1\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x83"],
        ["\xD1\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x84"],
        ["\xD1\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x85"],
        ["\xD1\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x86"],
        ["\xD1\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x87"],
        ["\xD1\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x88"],
        ["\xD1\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x89"],
        ["\xD1\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8A"],
        ["\xD1\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8B"],
        ["\xD1\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8C"],
        ["\xD1\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8D"],
        ["\xD1\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8E"],
        ["\xD1\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x8F"],
        ["\xD1\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x90"],
        ["\xD1\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x91"],
        ["\xD1\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x92"],
        ["\xD1\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x93"],
        ["\xD1\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x94"],
        ["\xD1\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x95"],
        ["\xD1\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x96"],
        ["\xD1\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x97"],
        ["\xD1\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x98"],
        ["\xD1\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x99"],
        ["\xD1\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9A"],
        ["\xD1\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9B"],
        ["\xD1\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9C"],
        ["\xD1\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9D"],
        ["\xD1\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9E"],
        ["\xD1\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\x9F"],
        ["\xD1\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA0"],
        ["\xD1\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA1"],
        ["\xD1\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA2"],
        ["\xD1\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA3"],
        ["\xD1\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA4"],
        ["\xD1\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA5"],
        ["\xD1\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA6"],
        ["\xD1\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA7"],
        ["\xD1\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA8"],
        ["\xD1\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xA9"],
        ["\xD1\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAA"],
        ["\xD1\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAB"],
        ["\xD1\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAC"],
        ["\xD1\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAD"],
        ["\xD1\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAE"],
        ["\xD1\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xAF"],
        ["\xD1\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB0"],
        ["\xD1\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB1"],
        ["\xD1\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB2"],
        ["\xD1\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB3"],
        ["\xD1\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB4"],
        ["\xD1\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB5"],
        ["\xD1\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB6"],
        ["\xD1\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB7"],
        ["\xD1\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB8"],
        ["\xD1\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xB9"],
        ["\xD1\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBA"],
        ["\xD1\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBB"],
        ["\xD1\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBC"],
        ["\xD1\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBD"],
        ["\xD2\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBE"],
        ["\xD2\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8B\xBF"],
        ["\xD2\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x80"],
        ["\xD2\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x81"],
        ["\xD2\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x82"],
        ["\xD2\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x83"],
        ["\xD2\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x84"],
        ["\xD2\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x85"],
        ["\xD2\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x86"],
        ["\xD2\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x87"],
        ["\xD2\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x88"],
        ["\xD2\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x89"],
        ["\xD2\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8A"],
        ["\xD2\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8B"],
        ["\xD2\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8C"],
        ["\xD2\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8D"],
        ["\xD2\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8E"],
        ["\xD2\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x8F"],
        ["\xD2\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x90"],
        ["\xD2\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x91"],
        ["\xD2\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x92"],
        ["\xD2\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x93"],
        ["\xD2\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x94"],
        ["\xD2\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x95"],
        ["\xD2\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x96"],
        ["\xD2\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x97"],
        ["\xD2\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x98"],
        ["\xD2\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x99"],
        ["\xD2\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9A"],
        ["\xD2\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9B"],
        ["\xD2\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9C"],
        ["\xD2\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9D"],
        ["\xD2\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9E"],
        ["\xD2\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\x9F"],
        ["\xD2\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA0"],
        ["\xD2\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA1"],
        ["\xD2\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA2"],
        ["\xD2\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA3"],
        ["\xD2\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA4"],
        ["\xD2\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA5"],
        ["\xD2\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA6"],
        ["\xD2\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA7"],
        ["\xD2\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA8"],
        ["\xD2\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xA9"],
        ["\xD2\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAA"],
        ["\xD2\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAB"],
        ["\xD2\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAC"],
        ["\xD2\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAD"],
        ["\xD2\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAE"],
        ["\xD2\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xAF"],
        ["\xD2\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB0"],
        ["\xD2\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB1"],
        ["\xD2\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB2"],
        ["\xD2\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB3"],
        ["\xD2\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB4"],
        ["\xD2\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB5"],
        ["\xD2\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB6"],
        ["\xD2\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB7"],
        ["\xD2\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB8"],
        ["\xD2\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xB9"],
        ["\xD2\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBA"],
        ["\xD2\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBB"],
        ["\xD2\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBC"],
        ["\xD2\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBD"],
        ["\xD2\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBE"],
        ["\xD2\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8C\xBF"],
        ["\xD2\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x80"],
        ["\xD2\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x81"],
        ["\xD2\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x82"],
        ["\xD2\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x83"],
        ["\xD2\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x84"],
        ["\xD2\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x85"],
        ["\xD2\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x86"],
        ["\xD2\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x87"],
        ["\xD2\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x88"],
        ["\xD2\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x89"],
        ["\xD2\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8A"],
        ["\xD2\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8B"],
        ["\xD2\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8C"],
        ["\xD2\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8D"],
        ["\xD2\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8E"],
        ["\xD2\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x8F"],
        ["\xD2\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x90"],
        ["\xD2\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x91"],
        ["\xD2\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x92"],
        ["\xD2\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x93"],
        ["\xD2\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x94"],
        ["\xD2\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x95"],
        ["\xD2\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x96"],
        ["\xD2\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x97"],
        ["\xD2\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x98"],
        ["\xD2\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x99"],
        ["\xD2\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9A"],
        ["\xD2\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9B"],
        ["\xD3\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9C"],
        ["\xD3\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9D"],
        ["\xD3\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9E"],
        ["\xD3\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\x9F"],
        ["\xD3\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA0"],
        ["\xD3\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA1"],
        ["\xD3\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA2"],
        ["\xD3\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA3"],
        ["\xD3\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA4"],
        ["\xD3\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA5"],
        ["\xD3\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA6"],
        ["\xD3\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA7"],
        ["\xD3\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA8"],
        ["\xD3\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xA9"],
        ["\xD3\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAA"],
        ["\xD3\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAB"],
        ["\xD3\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAC"],
        ["\xD3\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAD"],
        ["\xD3\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAE"],
        ["\xD3\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xAF"],
        ["\xD3\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB0"],
        ["\xD3\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB1"],
        ["\xD3\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB2"],
        ["\xD3\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB3"],
        ["\xD3\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB4"],
        ["\xD3\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB5"],
        ["\xD3\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB6"],
        ["\xD3\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB7"],
        ["\xD3\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB8"],
        ["\xD3\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xB9"],
        ["\xD3\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBA"],
        ["\xD3\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBB"],
        ["\xD3\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBC"],
        ["\xD3\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBD"],
        ["\xD3\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBE"],
        ["\xD3\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8D\xBF"],
        ["\xD3\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x80"],
        ["\xD3\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x81"],
        ["\xD3\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x82"],
        ["\xD3\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x83"],
        ["\xD3\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x84"],
        ["\xD3\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x85"],
        ["\xD3\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x86"],
        ["\xD3\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x87"],
        ["\xD3\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x88"],
        ["\xD3\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x89"],
        ["\xD3\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8A"],
        ["\xD3\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8B"],
        ["\xD3\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8C"],
        ["\xD3\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8D"],
        ["\xD3\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8E"],
        ["\xD3\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x8F"],
        ["\xD3\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x90"],
        ["\xD3\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x91"],
        ["\xD3\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x92"],
        ["\xD3\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x93"],
        ["\xD3\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x94"],
        ["\xD3\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x95"],
        ["\xD3\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x96"],
        ["\xD3\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x97"],
        ["\xD3\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x98"],
        ["\xD3\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x99"],
        ["\xD3\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9A"],
        ["\xD3\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9B"],
        ["\xD3\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9C"],
        ["\xD3\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9D"],
        ["\xD3\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9E"],
        ["\xD3\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\x9F"],
        ["\xD3\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA0"],
        ["\xD3\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA1"],
        ["\xD3\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA2"],
        ["\xD3\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA3"],
        ["\xD3\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA4"],
        ["\xD3\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA5"],
        ["\xD3\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA6"],
        ["\xD3\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA7"],
        ["\xD3\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA8"],
        ["\xD3\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xA9"],
        ["\xD3\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAA"],
        ["\xD3\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAB"],
        ["\xD3\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAC"],
        ["\xD3\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAD"],
        ["\xD3\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAE"],
        ["\xD3\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xAF"],
        ["\xD3\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB0"],
        ["\xD3\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB1"],
        ["\xD3\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB2"],
        ["\xD3\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB3"],
        ["\xD3\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB4"],
        ["\xD3\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB5"],
        ["\xD3\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB6"],
        ["\xD3\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB7"],
        ["\xD3\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB8"],
        ["\xD3\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xB9"],
        ["\xD4\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBA"],
        ["\xD4\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBB"],
        ["\xD4\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBC"],
        ["\xD4\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBD"],
        ["\xD4\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBE"],
        ["\xD4\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8E\xBF"],
        ["\xD4\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x80"],
        ["\xD4\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x81"],
        ["\xD4\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x82"],
        ["\xD4\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x83"],
        ["\xD4\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x84"],
        ["\xD4\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x85"],
        ["\xD4\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x86"],
        ["\xD4\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x87"],
        ["\xD4\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x88"],
        ["\xD4\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x89"],
        ["\xD4\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8A"],
        ["\xD4\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8B"],
        ["\xD4\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8C"],
        ["\xD4\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8D"],
        ["\xD4\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8E"],
        ["\xD4\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x8F"],
        ["\xD4\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x90"],
        ["\xD4\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x91"],
        ["\xD4\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x92"],
        ["\xD4\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x93"],
        ["\xD4\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x94"],
        ["\xD4\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x95"],
        ["\xD4\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x96"],
        ["\xD4\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x97"],
        ["\xD4\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x98"],
        ["\xD4\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x99"],
        ["\xD4\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9A"],
        ["\xD4\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9B"],
        ["\xD4\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9C"],
        ["\xD4\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9D"],
        ["\xD4\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9E"],
        ["\xD4\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\x9F"],
        ["\xD4\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA0"],
        ["\xD4\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA1"],
        ["\xD4\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA2"],
        ["\xD4\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA3"],
        ["\xD4\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA4"],
        ["\xD4\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA5"],
        ["\xD4\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA6"],
        ["\xD4\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA7"],
        ["\xD4\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA8"],
        ["\xD4\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xA9"],
        ["\xD4\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAA"],
        ["\xD4\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAB"],
        ["\xD4\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAC"],
        ["\xD4\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAD"],
        ["\xD4\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAE"],
        ["\xD4\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xAF"],
        ["\xD4\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB0"],
        ["\xD4\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB1"],
        ["\xD4\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB2"],
        ["\xD4\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB3"],
        ["\xD4\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB4"],
        ["\xD4\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB5"],
        ["\xD4\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB6"],
        ["\xD4\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB7"],
        ["\xD4\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB8"],
        ["\xD4\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xB9"],
        ["\xD4\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBA"],
        ["\xD4\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBB"],
        ["\xD4\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBC"],
        ["\xD4\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBD"],
        ["\xD4\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBE"],
        ["\xD4\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x8F\xBF"],
        ["\xD4\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x80"],
        ["\xD4\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x81"],
        ["\xD4\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x82"],
        ["\xD4\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x83"],
        ["\xD4\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x84"],
        ["\xD4\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x85"],
        ["\xD4\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x86"],
        ["\xD4\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x87"],
        ["\xD4\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x88"],
        ["\xD4\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x89"],
        ["\xD4\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8A"],
        ["\xD4\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8B"],
        ["\xD4\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8C"],
        ["\xD4\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8D"],
        ["\xD4\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8E"],
        ["\xD4\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x8F"],
        ["\xD4\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x90"],
        ["\xD4\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x91"],
        ["\xD4\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x92"],
        ["\xD4\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x93"],
        ["\xD4\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x94"],
        ["\xD4\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x95"],
        ["\xD4\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x96"],
        ["\xD4\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x97"],
        ["\xD5\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x98"],
        ["\xD5\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x99"],
        ["\xD5\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9A"],
        ["\xD5\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9B"],
        ["\xD5\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9C"],
        ["\xD5\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9D"],
        ["\xD5\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9E"],
        ["\xD5\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\x9F"],
        ["\xD5\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA0"],
        ["\xD5\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA1"],
        ["\xD5\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA2"],
        ["\xD5\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA3"],
        ["\xD5\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA4"],
        ["\xD5\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA5"],
        ["\xD5\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA6"],
        ["\xD5\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA7"],
        ["\xD5\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA8"],
        ["\xD5\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xA9"],
        ["\xD5\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAA"],
        ["\xD5\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAB"],
        ["\xD5\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAC"],
        ["\xD5\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAD"],
        ["\xD5\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAE"],
        ["\xD5\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xAF"],
        ["\xD5\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB0"],
        ["\xD5\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB1"],
        ["\xD5\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB2"],
        ["\xD5\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB3"],
        ["\xD5\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB4"],
        ["\xD5\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB5"],
        ["\xD5\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB6"],
        ["\xD5\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB7"],
        ["\xD5\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB8"],
        ["\xD5\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xB9"],
        ["\xD5\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBA"],
        ["\xD5\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBB"],
        ["\xD5\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBC"],
        ["\xD5\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBD"],
        ["\xD5\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBE"],
        ["\xD5\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x90\xBF"],
        ["\xD5\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x80"],
        ["\xD5\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x81"],
        ["\xD5\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x82"],
        ["\xD5\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x83"],
        ["\xD5\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x84"],
        ["\xD5\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x85"],
        ["\xD5\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x86"],
        ["\xD5\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x87"],
        ["\xD5\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x88"],
        ["\xD5\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x89"],
        ["\xD5\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8A"],
        ["\xD5\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8B"],
        ["\xD5\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8C"],
        ["\xD5\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8D"],
        ["\xD5\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8E"],
        ["\xD5\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x8F"],
        ["\xD5\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x90"],
        ["\xD5\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x91"],
        ["\xD5\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x92"],
        ["\xD5\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x93"],
        ["\xD5\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x94"],
        ["\xD5\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x95"],
        ["\xD5\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x96"],
        ["\xD5\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x97"],
        ["\xD5\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x98"],
        ["\xD5\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x99"],
        ["\xD5\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9A"],
        ["\xD5\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9B"],
        ["\xD5\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9C"],
        ["\xD5\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9D"],
        ["\xD5\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9E"],
        ["\xD5\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\x9F"],
        ["\xD5\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA0"],
        ["\xD5\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA1"],
        ["\xD5\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA2"],
        ["\xD5\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA3"],
        ["\xD5\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA4"],
        ["\xD5\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA5"],
        ["\xD5\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA6"],
        ["\xD5\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA7"],
        ["\xD5\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA8"],
        ["\xD5\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xA9"],
        ["\xD5\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAA"],
        ["\xD5\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAB"],
        ["\xD5\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAC"],
        ["\xD5\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAD"],
        ["\xD5\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAE"],
        ["\xD5\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xAF"],
        ["\xD5\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB0"],
        ["\xD5\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB1"],
        ["\xD5\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB2"],
        ["\xD5\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB3"],
        ["\xD5\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB4"],
        ["\xD5\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB5"],
        ["\xD6\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB6"],
        ["\xD6\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB7"],
        ["\xD6\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB8"],
        ["\xD6\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xB9"],
        ["\xD6\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBA"],
        ["\xD6\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBB"],
        ["\xD6\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBC"],
        ["\xD6\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBD"],
        ["\xD6\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBE"],
        ["\xD6\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x91\xBF"],
        ["\xD6\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x80"],
        ["\xD6\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x81"],
        ["\xD6\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x82"],
        ["\xD6\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x83"],
        ["\xD6\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x84"],
        ["\xD6\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x85"],
        ["\xD6\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x86"],
        ["\xD6\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x87"],
        ["\xD6\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x88"],
        ["\xD6\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x89"],
        ["\xD6\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8A"],
        ["\xD6\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8B"],
        ["\xD6\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8C"],
        ["\xD6\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8D"],
        ["\xD6\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8E"],
        ["\xD6\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x8F"],
        ["\xD6\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x90"],
        ["\xD6\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x91"],
        ["\xD6\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x92"],
        ["\xD6\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x93"],
        ["\xD6\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x94"],
        ["\xD6\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x95"],
        ["\xD6\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x96"],
        ["\xD6\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x97"],
        ["\xD6\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x98"],
        ["\xD6\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x99"],
        ["\xD6\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9A"],
        ["\xD6\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9B"],
        ["\xD6\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9C"],
        ["\xD6\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9D"],
        ["\xD6\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9E"],
        ["\xD6\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\x9F"],
        ["\xD6\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA0"],
        ["\xD6\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA1"],
        ["\xD6\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA2"],
        ["\xD6\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA3"],
        ["\xD6\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA4"],
        ["\xD6\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA5"],
        ["\xD6\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA6"],
        ["\xD6\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA7"],
        ["\xD6\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA8"],
        ["\xD6\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xA9"],
        ["\xD6\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAA"],
        ["\xD6\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAB"],
        ["\xD6\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAC"],
        ["\xD6\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAD"],
        ["\xD6\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAE"],
        ["\xD6\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xAF"],
        ["\xD6\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB0"],
        ["\xD6\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB1"],
        ["\xD6\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB2"],
        ["\xD6\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB3"],
        ["\xD6\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB4"],
        ["\xD6\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB5"],
        ["\xD6\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB6"],
        ["\xD6\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB7"],
        ["\xD6\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB8"],
        ["\xD6\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xB9"],
        ["\xD6\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBA"],
        ["\xD6\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBB"],
        ["\xD6\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBC"],
        ["\xD6\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBD"],
        ["\xD6\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBE"],
        ["\xD6\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x92\xBF"],
        ["\xD6\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x80"],
        ["\xD6\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x81"],
        ["\xD6\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x82"],
        ["\xD6\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x83"],
        ["\xD6\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x84"],
        ["\xD6\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x85"],
        ["\xD6\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x86"],
        ["\xD6\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x87"],
        ["\xD6\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x88"],
        ["\xD6\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x89"],
        ["\xD6\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8A"],
        ["\xD6\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8B"],
        ["\xD6\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8C"],
        ["\xD6\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8D"],
        ["\xD6\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8E"],
        ["\xD6\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x8F"],
        ["\xD6\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x90"],
        ["\xD6\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x91"],
        ["\xD6\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x92"],
        ["\xD6\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x93"],
        ["\xD7\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x94"],
        ["\xD7\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x95"],
        ["\xD7\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x96"],
        ["\xD7\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x97"],
        ["\xD7\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x98"],
        ["\xD7\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x99"],
        ["\xD7\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9A"],
        ["\xD7\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9B"],
        ["\xD7\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9C"],
        ["\xD7\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9D"],
        ["\xD7\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9E"],
        ["\xD7\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\x9F"],
        ["\xD7\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA0"],
        ["\xD7\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA1"],
        ["\xD7\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA2"],
        ["\xD7\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA3"],
        ["\xD7\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA4"],
        ["\xD7\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA5"],
        ["\xD7\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA6"],
        ["\xD7\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA7"],
        ["\xD7\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA8"],
        ["\xD7\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xA9"],
        ["\xD7\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAA"],
        ["\xD7\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAB"],
        ["\xD7\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAC"],
        ["\xD7\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAD"],
        ["\xD7\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xAF"],
        ["\xD7\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB0"],
        ["\xD7\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB1"],
        ["\xD7\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB2"],
        ["\xD7\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB3"],
        ["\xD7\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB4"],
        ["\xD7\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB5"],
        ["\xD7\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB6"],
        ["\xD7\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB7"],
        ["\xD7\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB8"],
        ["\xD7\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xB9"],
        ["\xD7\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBA"],
        ["\xD7\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBB"],
        ["\xD7\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBC"],
        ["\xD7\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBD"],
        ["\xD7\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBE"],
        ["\xD7\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x93\xBF"],
        ["\xD7\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x80"],
        ["\xD7\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x81"],
        ["\xD7\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x82"],
        ["\xD7\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x83"],
        ["\xD7\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x84"],
        ["\xD7\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x85"],
        ["\xD7\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x86"],
        ["\xD7\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x87"],
        ["\xD7\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x88"],
        ["\xD7\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x89"],
        ["\xD7\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8A"],
        ["\xD7\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8B"],
        ["\xD7\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8C"],
        ["\xD7\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8D"],
        ["\xD7\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8E"],
        ["\xD7\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x8F"],
        ["\xD7\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x90"],
        ["\xD7\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x91"],
        ["\xD7\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x92"],
        ["\xD7\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x93"],
        ["\xD7\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x94"],
        ["\xD7\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x95"],
        ["\xD7\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x96"],
        ["\xD7\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x97"],
        ["\xD7\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x98"],
        ["\xD7\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x99"],
        ["\xD7\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9A"],
        ["\xD7\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9B"],
        ["\xD7\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9C"],
        ["\xD7\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9D"],
        ["\xD7\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9E"],
        ["\xD7\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\x9F"],
        ["\xD7\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA0"],
        ["\xD7\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA1"],
        ["\xD7\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA2"],
        ["\xD7\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA3"],
        ["\xD7\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA4"],
        ["\xD7\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA5"],
        ["\xD7\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA6"],
        ["\xD7\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA7"],
        ["\xD7\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA8"],
        ["\xD7\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xA9"],
        ["\xD7\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAA"],
        ["\xD7\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAB"],
        ["\xD7\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAC"],
        ["\xD7\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAD"],
        ["\xD7\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAE"],
        ["\xD7\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xAF"],
        ["\xD7\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB0"],
        ["\xD7\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB1"],
        ["\xD8\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB2"],
        ["\xD8\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB3"],
        ["\xD8\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB4"],
        ["\xD8\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB5"],
        ["\xD8\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB6"],
        ["\xD8\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB7"],
        ["\xD8\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB8"],
        ["\xD8\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xB9"],
        ["\xD8\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBA"],
        ["\xD8\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBB"],
        ["\xD8\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBC"],
        ["\xD8\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBD"],
        ["\xD8\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBE"],
        ["\xD8\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x94\xBF"],
        ["\xD8\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x80"],
        ["\xD8\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x81"],
        ["\xD8\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x82"],
        ["\xD8\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x83"],
        ["\xD8\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x84"],
        ["\xD8\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x85"],
        ["\xD8\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x86"],
        ["\xD8\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x87"],
        ["\xD8\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x88"],
        ["\xD8\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x89"],
        ["\xD8\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8A"],
        ["\xD8\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8B"],
        ["\xD8\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8C"],
        ["\xD8\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8D"],
        ["\xD8\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8E"],
        ["\xD8\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x8F"],
        ["\xD8\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x90"],
        ["\xD8\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x91"],
        ["\xD8\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x92"],
        ["\xD8\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x93"],
        ["\xD8\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x94"],
        ["\xD8\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x95"],
        ["\xD8\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x96"],
        ["\xD8\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x97"],
        ["\xD8\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x98"],
        ["\xD8\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x99"],
        ["\xD8\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9A"],
        ["\xD8\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9B"],
        ["\xD8\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9C"],
        ["\xD8\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9D"],
        ["\xD8\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9E"],
        ["\xD8\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\x9F"],
        ["\xD8\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA0"],
        ["\xD8\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA1"],
        ["\xD8\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA2"],
        ["\xD8\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA3"],
        ["\xD8\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA4"],
        ["\xD8\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA5"],
        ["\xD8\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA6"],
        ["\xD8\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA7"],
        ["\xD8\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA8"],
        ["\xD8\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xA9"],
        ["\xD8\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAA"],
        ["\xD8\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAB"],
        ["\xD8\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAC"],
        ["\xD8\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAD"],
        ["\xD8\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAE"],
        ["\xD8\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xAF"],
        ["\xD8\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB0"],
        ["\xD8\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB1"],
        ["\xD8\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB2"],
        ["\xD8\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB3"],
        ["\xD8\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB4"],
        ["\xD8\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB5"],
        ["\xD8\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB6"],
        ["\xD8\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB7"],
        ["\xD8\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB8"],
        ["\xD8\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xB9"],
        ["\xD8\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBA"],
        ["\xD8\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBB"],
        ["\xD8\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBC"],
        ["\xD8\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBD"],
        ["\xD8\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBE"],
        ["\xD8\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x95\xBF"],
        ["\xD8\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x80"],
        ["\xD8\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x81"],
        ["\xD8\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x82"],
        ["\xD8\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x83"],
        ["\xD8\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x84"],
        ["\xD8\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x85"],
        ["\xD8\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x86"],
        ["\xD8\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x87"],
        ["\xD8\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x88"],
        ["\xD8\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x89"],
        ["\xD8\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8A"],
        ["\xD8\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8B"],
        ["\xD8\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8C"],
        ["\xD8\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8D"],
        ["\xD8\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8E"],
        ["\xD8\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x8F"],
        ["\xD9\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x90"],
        ["\xD9\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x91"],
        ["\xD9\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x92"],
        ["\xD9\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x93"],
        ["\xD9\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x94"],
        ["\xD9\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x95"],
        ["\xD9\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x96"],
        ["\xD9\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x97"],
        ["\xD9\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x98"],
        ["\xD9\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x99"],
        ["\xD9\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9A"],
        ["\xD9\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9B"],
        ["\xD9\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9C"],
        ["\xD9\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9D"],
        ["\xD9\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9E"],
        ["\xD9\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\x9F"],
        ["\xD9\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA0"],
        ["\xD9\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA1"],
        ["\xD9\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA2"],
        ["\xD9\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA3"],
        ["\xD9\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA4"],
        ["\xD9\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA5"],
        ["\xD9\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA6"],
        ["\xD9\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA7"],
        ["\xD9\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA8"],
        ["\xD9\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xA9"],
        ["\xD9\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAA"],
        ["\xD9\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAB"],
        ["\xD9\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAC"],
        ["\xD9\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAD"],
        ["\xD9\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAE"],
        ["\xD9\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xAF"],
        ["\xD9\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB0"],
        ["\xD9\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB1"],
        ["\xD9\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB2"],
        ["\xD9\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB3"],
        ["\xD9\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB4"],
        ["\xD9\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB5"],
        ["\xD9\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB6"],
        ["\xD9\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB7"],
        ["\xD9\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB8"],
        ["\xD9\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xB9"],
        ["\xD9\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBA"],
        ["\xD9\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBB"],
        ["\xD9\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBC"],
        ["\xD9\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBD"],
        ["\xD9\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBE"],
        ["\xD9\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x96\xBF"],
        ["\xD9\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x80"],
        ["\xD9\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x81"],
        ["\xD9\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x82"],
        ["\xD9\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x83"],
        ["\xD9\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x84"],
        ["\xD9\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x85"],
        ["\xD9\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x86"],
        ["\xD9\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x87"],
        ["\xD9\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x88"],
        ["\xD9\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x89"],
        ["\xD9\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8A"],
        ["\xD9\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8B"],
        ["\xD9\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8C"],
        ["\xD9\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8D"],
        ["\xD9\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8E"],
        ["\xD9\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x8F"],
        ["\xD9\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x90"],
        ["\xD9\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x91"],
        ["\xD9\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x92"],
        ["\xD9\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x93"],
        ["\xD9\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x94"],
        ["\xD9\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x95"],
        ["\xD9\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x96"],
        ["\xD9\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x97"],
        ["\xD9\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x98"],
        ["\xD9\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x99"],
        ["\xD9\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9A"],
        ["\xD9\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9B"],
        ["\xD9\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9C"],
        ["\xD9\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9D"],
        ["\xD9\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9E"],
        ["\xD9\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\x9F"],
        ["\xD9\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA0"],
        ["\xD9\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA1"],
        ["\xD9\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA2"],
        ["\xD9\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA3"],
        ["\xD9\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA4"],
        ["\xD9\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA5"],
        ["\xD9\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA6"],
        ["\xD9\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA7"],
        ["\xD9\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA8"],
        ["\xD9\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xA9"],
        ["\xD9\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAA"],
        ["\xD9\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAB"],
        ["\xD9\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAC"],
        ["\xD9\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAD"],
        ["\xDA\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAE"],
        ["\xDA\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xAF"],
        ["\xDA\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB0"],
        ["\xDA\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB1"],
        ["\xDA\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB2"],
        ["\xDA\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB3"],
        ["\xDA\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB4"],
        ["\xDA\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB5"],
        ["\xDA\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB6"],
        ["\xDA\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB7"],
        ["\xDA\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB8"],
        ["\xDA\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xB9"],
        ["\xDA\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBA"],
        ["\xDA\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBB"],
        ["\xDA\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBC"],
        ["\xDA\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBD"],
        ["\xDA\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBE"],
        ["\xDA\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x97\xBF"],
        ["\xDA\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x80"],
        ["\xDA\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x81"],
        ["\xDA\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x82"],
        ["\xDA\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x83"],
        ["\xDA\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x84"],
        ["\xDA\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x85"],
        ["\xDA\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x86"],
        ["\xDA\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x87"],
        ["\xDA\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x88"],
        ["\xDA\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x89"],
        ["\xDA\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8A"],
        ["\xDA\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8B"],
        ["\xDA\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8C"],
        ["\xDA\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8D"],
        ["\xDA\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8E"],
        ["\xDA\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x8F"],
        ["\xDA\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x90"],
        ["\xDA\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x91"],
        ["\xDA\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x92"],
        ["\xDA\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x93"],
        ["\xDA\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x94"],
        ["\xDA\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x95"],
        ["\xDA\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x96"],
        ["\xDA\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x97"],
        ["\xDA\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x98"],
        ["\xDA\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x99"],
        ["\xDA\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9A"],
        ["\xDA\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9B"],
        ["\xDA\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9C"],
        ["\xDA\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9D"],
        ["\xDA\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9E"],
        ["\xDA\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\x9F"],
        ["\xDA\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA0"],
        ["\xDA\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA1"],
        ["\xDA\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA2"],
        ["\xDA\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA3"],
        ["\xDA\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA4"],
        ["\xDA\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA5"],
        ["\xDA\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA6"],
        ["\xDA\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA7"],
        ["\xDA\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA8"],
        ["\xDA\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xA9"],
        ["\xDA\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAA"],
        ["\xDA\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAB"],
        ["\xDA\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAC"],
        ["\xDA\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAD"],
        ["\xDA\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAE"],
        ["\xDA\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xAF"],
        ["\xDA\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB0"],
        ["\xDA\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB1"],
        ["\xDA\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB2"],
        ["\xDA\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB3"],
        ["\xDA\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB4"],
        ["\xDA\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB5"],
        ["\xDA\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB6"],
        ["\xDA\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB7"],
        ["\xDA\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB8"],
        ["\xDA\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xB9"],
        ["\xDA\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBA"],
        ["\xDA\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBB"],
        ["\xDA\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBC"],
        ["\xDA\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBD"],
        ["\xDA\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBE"],
        ["\xDA\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x98\xBF"],
        ["\xDA\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x80"],
        ["\xDA\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x81"],
        ["\xDA\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x82"],
        ["\xDA\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x83"],
        ["\xDA\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x84"],
        ["\xDA\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x85"],
        ["\xDA\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x86"],
        ["\xDA\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x87"],
        ["\xDA\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x88"],
        ["\xDA\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x89"],
        ["\xDA\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8A"],
        ["\xDA\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8B"],
        ["\xDB\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8C"],
        ["\xDB\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8D"],
        ["\xDB\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8E"],
        ["\xDB\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x8F"],
        ["\xDB\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x90"],
        ["\xDB\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x91"],
        ["\xDB\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x92"],
        ["\xDB\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x93"],
        ["\xDB\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x94"],
        ["\xDB\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x95"],
        ["\xDB\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x96"],
        ["\xDB\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x97"],
        ["\xDB\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x98"],
        ["\xDB\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x99"],
        ["\xDB\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9A"],
        ["\xDB\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9B"],
        ["\xDB\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9C"],
        ["\xDB\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9D"],
        ["\xDB\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9E"],
        ["\xDB\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\x9F"],
        ["\xDB\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA0"],
        ["\xDB\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA1"],
        ["\xDB\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA2"],
        ["\xDB\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA3"],
        ["\xDB\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA4"],
        ["\xDB\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA5"],
        ["\xDB\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA6"],
        ["\xDB\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA7"],
        ["\xDB\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA8"],
        ["\xDB\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xA9"],
        ["\xDB\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAA"],
        ["\xDB\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAB"],
        ["\xDB\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAC"],
        ["\xDB\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAD"],
        ["\xDB\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAE"],
        ["\xDB\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xAF"],
        ["\xDB\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB0"],
        ["\xDB\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB1"],
        ["\xDB\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB2"],
        ["\xDB\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB3"],
        ["\xDB\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB4"],
        ["\xDB\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB5"],
        ["\xDB\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB6"],
        ["\xDB\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB7"],
        ["\xDB\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB8"],
        ["\xDB\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xB9"],
        ["\xDB\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBA"],
        ["\xDB\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBB"],
        ["\xDB\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBC"],
        ["\xDB\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBD"],
        ["\xDB\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBE"],
        ["\xDB\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x99\xBF"],
        ["\xDB\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x80"],
        ["\xDB\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x81"],
        ["\xDB\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x82"],
        ["\xDB\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x83"],
        ["\xDB\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x84"],
        ["\xDB\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x85"],
        ["\xDB\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x86"],
        ["\xDB\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x87"],
        ["\xDB\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x88"],
        ["\xDB\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x89"],
        ["\xDB\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8A"],
        ["\xDB\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8B"],
        ["\xDB\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8C"],
        ["\xDB\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8D"],
        ["\xDB\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8E"],
        ["\xDB\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x8F"],
        ["\xDB\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x90"],
        ["\xDB\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x91"],
        ["\xDB\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x92"],
        ["\xDB\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x93"],
        ["\xDB\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x94"],
        ["\xDB\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x95"],
        ["\xDB\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x96"],
        ["\xDB\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x97"],
        ["\xDB\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x98"],
        ["\xDB\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x99"],
        ["\xDB\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9A"],
        ["\xDB\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9B"],
        ["\xDB\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9C"],
        ["\xDB\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9D"],
        ["\xDB\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9E"],
        ["\xDB\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\x9F"],
        ["\xDB\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA0"],
        ["\xDB\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA1"],
        ["\xDB\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA2"],
        ["\xDB\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA3"],
        ["\xDB\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA4"],
        ["\xDB\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA5"],
        ["\xDB\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA6"],
        ["\xDB\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA7"],
        ["\xDB\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA8"],
        ["\xDB\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xA9"],
        ["\xDC\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAA"],
        ["\xDC\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAB"],
        ["\xDC\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAC"],
        ["\xDC\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAD"],
        ["\xDC\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAE"],
        ["\xDC\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xAF"],
        ["\xDC\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB0"],
        ["\xDC\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB1"],
        ["\xDC\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB2"],
        ["\xDC\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB3"],
        ["\xDC\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB4"],
        ["\xDC\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB5"],
        ["\xDC\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB6"],
        ["\xDC\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB7"],
        ["\xDC\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB8"],
        ["\xDC\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xB9"],
        ["\xDC\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBA"],
        ["\xDC\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBB"],
        ["\xDC\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBC"],
        ["\xDC\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBD"],
        ["\xDC\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBE"],
        ["\xDC\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9A\xBF"],
        ["\xDC\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x80"],
        ["\xDC\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x81"],
        ["\xDC\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x82"],
        ["\xDC\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x83"],
        ["\xDC\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x84"],
        ["\xDC\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x85"],
        ["\xDC\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x86"],
        ["\xDC\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x87"],
        ["\xDC\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x88"],
        ["\xDC\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x89"],
        ["\xDC\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8A"],
        ["\xDC\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8B"],
        ["\xDC\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8C"],
        ["\xDC\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8D"],
        ["\xDC\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8E"],
        ["\xDC\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x8F"],
        ["\xDC\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x90"],
        ["\xDC\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x91"],
        ["\xDC\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x92"],
        ["\xDC\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x93"],
        ["\xDC\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x94"],
        ["\xDC\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x95"],
        ["\xDC\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x96"],
        ["\xDC\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x97"],
        ["\xDC\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x98"],
        ["\xDC\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x99"],
        ["\xDC\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9A"],
        ["\xDC\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9B"],
        ["\xDC\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9C"],
        ["\xDC\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9D"],
        ["\xDC\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9E"],
        ["\xDC\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\x9F"],
        ["\xDC\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA0"],
        ["\xDC\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA1"],
        ["\xDC\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA2"],
        ["\xDC\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA3"],
        ["\xDC\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA4"],
        ["\xDC\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA5"],
        ["\xDC\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA6"],
        ["\xDC\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA7"],
        ["\xDC\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA8"],
        ["\xDC\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xA9"],
        ["\xDC\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAA"],
        ["\xDC\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAB"],
        ["\xDC\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAC"],
        ["\xDC\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAD"],
        ["\xDC\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAE"],
        ["\xDC\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xAF"],
        ["\xDC\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB0"],
        ["\xDC\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB1"],
        ["\xDC\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB2"],
        ["\xDC\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB3"],
        ["\xDC\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB4"],
        ["\xDC\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB5"],
        ["\xDC\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB6"],
        ["\xDC\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB7"],
        ["\xDC\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB8"],
        ["\xDC\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xB9"],
        ["\xDC\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBA"],
        ["\xDC\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBB"],
        ["\xDC\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBC"],
        ["\xDC\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBD"],
        ["\xDC\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBE"],
        ["\xDC\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9B\xBF"],
        ["\xDC\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x80"],
        ["\xDC\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x81"],
        ["\xDC\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x82"],
        ["\xDC\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x83"],
        ["\xDC\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x84"],
        ["\xDC\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x85"],
        ["\xDC\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x86"],
        ["\xDC\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x87"],
        ["\xDD\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x88"],
        ["\xDD\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x89"],
        ["\xDD\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8A"],
        ["\xDD\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8B"],
        ["\xDD\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8C"],
        ["\xDD\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8D"],
        ["\xDD\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8E"],
        ["\xDD\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x8F"],
        ["\xDD\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x90"],
        ["\xDD\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x91"],
        ["\xDD\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x92"],
        ["\xDD\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x93"],
        ["\xDD\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x94"],
        ["\xDD\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x95"],
        ["\xDD\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x96"],
        ["\xDD\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x97"],
        ["\xDD\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x98"],
        ["\xDD\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x99"],
        ["\xDD\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9A"],
        ["\xDD\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9B"],
        ["\xDD\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9C"],
        ["\xDD\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9D"],
        ["\xDD\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9E"],
        ["\xDD\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\x9F"],
        ["\xDD\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA0"],
        ["\xDD\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA1"],
        ["\xDD\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA2"],
        ["\xDD\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA3"],
        ["\xDD\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA4"],
        ["\xDD\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA5"],
        ["\xDD\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA6"],
        ["\xDD\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA7"],
        ["\xDD\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA8"],
        ["\xDD\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xA9"],
        ["\xDD\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAA"],
        ["\xDD\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAB"],
        ["\xDD\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAC"],
        ["\xDD\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAD"],
        ["\xDD\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAE"],
        ["\xDD\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xAF"],
        ["\xDD\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB0"],
        ["\xDD\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB1"],
        ["\xDD\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB2"],
        ["\xDD\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB3"],
        ["\xDD\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB4"],
        ["\xDD\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB5"],
        ["\xDD\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB6"],
        ["\xDD\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB7"],
        ["\xDD\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB8"],
        ["\xDD\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xB9"],
        ["\xDD\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBA"],
        ["\xDD\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBB"],
        ["\xDD\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBC"],
        ["\xDD\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBD"],
        ["\xDD\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBE"],
        ["\xDD\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9C\xBF"],
        ["\xDD\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x80"],
        ["\xDD\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x81"],
        ["\xDD\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x82"],
        ["\xDD\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x83"],
        ["\xDD\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x84"],
        ["\xDD\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x85"],
        ["\xDD\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x86"],
        ["\xDD\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x87"],
        ["\xDD\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x88"],
        ["\xDD\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x89"],
        ["\xDD\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8A"],
        ["\xDD\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8B"],
        ["\xDD\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8C"],
        ["\xDD\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8D"],
        ["\xDD\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8E"],
        ["\xDD\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x8F"],
        ["\xDD\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x90"],
        ["\xDD\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x91"],
        ["\xDD\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x92"],
        ["\xDD\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x93"],
        ["\xDD\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x94"],
        ["\xDD\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x95"],
        ["\xDD\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x96"],
        ["\xDD\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x97"],
        ["\xDD\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x98"],
        ["\xDD\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x99"],
        ["\xDD\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9A"],
        ["\xDD\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9B"],
        ["\xDD\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9C"],
        ["\xDD\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9D"],
        ["\xDD\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9E"],
        ["\xDD\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\x9F"],
        ["\xDD\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA0"],
        ["\xDD\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA1"],
        ["\xDD\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA2"],
        ["\xDD\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA3"],
        ["\xDD\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA4"],
        ["\xDD\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA5"],
        ["\xDE\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA6"],
        ["\xDE\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA7"],
        ["\xDE\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA8"],
        ["\xDE\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xA9"],
        ["\xDE\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAA"],
        ["\xDE\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAB"],
        ["\xDE\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAC"],
        ["\xDE\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAD"],
        ["\xDE\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAE"],
        ["\xDE\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xAF"],
        ["\xDE\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB0"],
        ["\xDE\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB1"],
        ["\xDE\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB2"],
        ["\xDE\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB3"],
        ["\xDE\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB4"],
        ["\xDE\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB5"],
        ["\xDE\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB6"],
        ["\xDE\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB7"],
        ["\xDE\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB8"],
        ["\xDE\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xB9"],
        ["\xDE\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBA"],
        ["\xDE\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBB"],
        ["\xDE\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBC"],
        ["\xDE\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBD"],
        ["\xDE\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBE"],
        ["\xDE\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9D\xBF"],
        ["\xDE\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x80"],
        ["\xDE\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x81"],
        ["\xDE\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x82"],
        ["\xDE\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x83"],
        ["\xDE\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x84"],
        ["\xDE\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x85"],
        ["\xDE\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x86"],
        ["\xDE\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x87"],
        ["\xDE\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x88"],
        ["\xDE\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x89"],
        ["\xDE\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8A"],
        ["\xDE\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8B"],
        ["\xDE\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8C"],
        ["\xDE\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8D"],
        ["\xDE\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8E"],
        ["\xDE\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x8F"],
        ["\xDE\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x90"],
        ["\xDE\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x91"],
        ["\xDE\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x92"],
        ["\xDE\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x93"],
        ["\xDE\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x94"],
        ["\xDE\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x95"],
        ["\xDE\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x96"],
        ["\xDE\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x97"],
        ["\xDE\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x98"],
        ["\xDE\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x99"],
        ["\xDE\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9A"],
        ["\xDE\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9B"],
        ["\xDE\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9C"],
        ["\xDE\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9D"],
        ["\xDE\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9E"],
        ["\xDE\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\x9F"],
        ["\xDE\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA0"],
        ["\xDE\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA1"],
        ["\xDE\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA2"],
        ["\xDE\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA3"],
        ["\xDE\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA4"],
        ["\xDE\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA5"],
        ["\xDE\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA6"],
        ["\xDE\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA7"],
        ["\xDE\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA8"],
        ["\xDE\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xA9"],
        ["\xDE\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAA"],
        ["\xDE\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAB"],
        ["\xDE\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAC"],
        ["\xDE\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAD"],
        ["\xDE\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAE"],
        ["\xDE\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xAF"],
        ["\xDE\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB0"],
        ["\xDE\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB1"],
        ["\xDE\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB2"],
        ["\xDE\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB3"],
        ["\xDE\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB4"],
        ["\xDE\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB5"],
        ["\xDE\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB6"],
        ["\xDE\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB7"],
        ["\xDE\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB8"],
        ["\xDE\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xB9"],
        ["\xDE\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBA"],
        ["\xDE\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBB"],
        ["\xDE\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBC"],
        ["\xDE\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBD"],
        ["\xDE\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBE"],
        ["\xDE\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9E\xBF"],
        ["\xDE\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x80"],
        ["\xDE\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x81"],
        ["\xDE\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x82"],
        ["\xDE\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x83"],
        ["\xDF\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x84"],
        ["\xDF\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x85"],
        ["\xDF\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x86"],
        ["\xDF\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x87"],
        ["\xDF\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x88"],
        ["\xDF\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x89"],
        ["\xDF\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8A"],
        ["\xDF\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8B"],
        ["\xDF\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8C"],
        ["\xDF\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8D"],
        ["\xDF\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8E"],
        ["\xDF\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x8F"],
        ["\xDF\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x90"],
        ["\xDF\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x91"],
        ["\xDF\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x92"],
        ["\xDF\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x93"],
        ["\xDF\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x94"],
        ["\xDF\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x95"],
        ["\xDF\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x96"],
        ["\xDF\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x97"],
        ["\xDF\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x98"],
        ["\xDF\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x99"],
        ["\xDF\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9A"],
        ["\xDF\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9B"],
        ["\xDF\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9C"],
        ["\xDF\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9D"],
        ["\xDF\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9E"],
        ["\xDF\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\x9F"],
        ["\xDF\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA0"],
        ["\xDF\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA1"],
        ["\xDF\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA2"],
        ["\xDF\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA3"],
        ["\xDF\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA4"],
        ["\xDF\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA5"],
        ["\xDF\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA6"],
        ["\xDF\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA7"],
        ["\xDF\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA8"],
        ["\xDF\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xA9"],
        ["\xDF\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAA"],
        ["\xDF\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAB"],
        ["\xDF\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAC"],
        ["\xDF\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAD"],
        ["\xDF\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAE"],
        ["\xDF\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xAF"],
        ["\xDF\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB0"],
        ["\xDF\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB1"],
        ["\xDF\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB2"],
        ["\xDF\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB3"],
        ["\xDF\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB4"],
        ["\xDF\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB5"],
        ["\xDF\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB6"],
        ["\xDF\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB7"],
        ["\xDF\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB8"],
        ["\xDF\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xB9"],
        ["\xDF\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBA"],
        ["\xDF\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBB"],
        ["\xDF\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBC"],
        ["\xDF\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBD"],
        ["\xDF\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBE"],
        ["\xDF\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\x9F\xBF"],
        ["\xDF\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x80"],
        ["\xDF\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x81"],
        ["\xDF\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x82"],
        ["\xDF\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x83"],
        ["\xDF\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x84"],
        ["\xDF\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x85"],
        ["\xDF\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x86"],
        ["\xDF\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x87"],
        ["\xDF\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x88"],
        ["\xDF\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x89"],
        ["\xDF\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8A"],
        ["\xDF\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8B"],
        ["\xDF\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8C"],
        ["\xDF\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8D"],
        ["\xDF\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8E"],
        ["\xDF\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x8F"],
        ["\xDF\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x90"],
        ["\xDF\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x91"],
        ["\xDF\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x92"],
        ["\xDF\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x93"],
        ["\xDF\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x94"],
        ["\xDF\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x95"],
        ["\xDF\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x96"],
        ["\xDF\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x97"],
        ["\xDF\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x98"],
        ["\xDF\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x99"],
        ["\xDF\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9A"],
        ["\xDF\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9B"],
        ["\xDF\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9C"],
        ["\xDF\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9D"],
        ["\xDF\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9E"],
        ["\xDF\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\x9F"],
        ["\xDF\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA0"],
        ["\xDF\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA1"],
        ["\xE0\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA2"],
        ["\xE0\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA3"],
        ["\xE0\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA4"],
        ["\xE0\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA5"],
        ["\xE0\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA6"],
        ["\xE0\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA7"],
        ["\xE0\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA8"],
        ["\xE0\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xA9"],
        ["\xE0\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAA"],
        ["\xE0\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAB"],
        ["\xE0\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAC"],
        ["\xE0\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAD"],
        ["\xE0\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAE"],
        ["\xE0\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xAF"],
        ["\xE0\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB0"],
        ["\xE0\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB1"],
        ["\xE0\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB2"],
        ["\xE0\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB3"],
        ["\xE0\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB4"],
        ["\xE0\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB5"],
        ["\xE0\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB6"],
        ["\xE0\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB7"],
        ["\xE0\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB8"],
        ["\xE0\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xB9"],
        ["\xE0\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBA"],
        ["\xE0\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBB"],
        ["\xE0\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBC"],
        ["\xE0\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBD"],
        ["\xE0\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBE"],
        ["\xE0\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA0\xBF"],
        ["\xE0\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x80"],
        ["\xE0\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x81"],
        ["\xE0\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x82"],
        ["\xE0\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x83"],
        ["\xE0\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x84"],
        ["\xE0\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x85"],
        ["\xE0\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x86"],
        ["\xE0\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x87"],
        ["\xE0\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x88"],
        ["\xE0\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x89"],
        ["\xE0\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8A"],
        ["\xE0\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8B"],
        ["\xE0\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8C"],
        ["\xE0\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8D"],
        ["\xE0\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8E"],
        ["\xE0\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x8F"],
        ["\xE0\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x90"],
        ["\xE0\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x91"],
        ["\xE0\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x92"],
        ["\xE0\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x93"],
        ["\xE0\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x94"],
        ["\xE0\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x95"],
        ["\xE0\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x96"],
        ["\xE0\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x97"],
        ["\xE0\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x98"],
        ["\xE0\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x99"],
        ["\xE0\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9A"],
        ["\xE0\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9B"],
        ["\xE0\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9C"],
        ["\xE0\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9D"],
        ["\xE0\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9E"],
        ["\xE0\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\x9F"],
        ["\xE0\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA0"],
        ["\xE0\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA1"],
        ["\xE0\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA2"],
        ["\xE0\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA3"],
        ["\xE0\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA4"],
        ["\xE0\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA5"],
        ["\xE0\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA6"],
        ["\xE0\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA7"],
        ["\xE0\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA8"],
        ["\xE0\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xA9"],
        ["\xE0\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAA"],
        ["\xE0\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAB"],
        ["\xE0\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAC"],
        ["\xE0\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAD"],
        ["\xE0\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAE"],
        ["\xE0\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xAF"],
        ["\xE0\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB0"],
        ["\xE0\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB1"],
        ["\xE0\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB2"],
        ["\xE0\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB3"],
        ["\xE0\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB4"],
        ["\xE0\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB5"],
        ["\xE0\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB6"],
        ["\xE0\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB7"],
        ["\xE0\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB8"],
        ["\xE0\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xB9"],
        ["\xE0\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBA"],
        ["\xE0\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBB"],
        ["\xE0\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBC"],
        ["\xE0\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBD"],
        ["\xE0\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBE"],
        ["\xE0\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA1\xBF"],
        ["\xE1\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x80"],
        ["\xE1\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x81"],
        ["\xE1\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x82"],
        ["\xE1\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x83"],
        ["\xE1\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x84"],
        ["\xE1\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x85"],
        ["\xE1\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x86"],
        ["\xE1\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x87"],
        ["\xE1\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x88"],
        ["\xE1\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x89"],
        ["\xE1\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8A"],
        ["\xE1\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8B"],
        ["\xE1\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8C"],
        ["\xE1\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8D"],
        ["\xE1\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8E"],
        ["\xE1\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x8F"],
        ["\xE1\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x90"],
        ["\xE1\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x91"],
        ["\xE1\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x92"],
        ["\xE1\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x93"],
        ["\xE1\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x94"],
        ["\xE1\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x95"],
        ["\xE1\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x96"],
        ["\xE1\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x97"],
        ["\xE1\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x98"],
        ["\xE1\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x99"],
        ["\xE1\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9A"],
        ["\xE1\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9B"],
        ["\xE1\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9C"],
        ["\xE1\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9D"],
        ["\xE1\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9E"],
        ["\xE1\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\x9F"],
        ["\xE1\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA0"],
        ["\xE1\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA1"],
        ["\xE1\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA2"],
        ["\xE1\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA3"],
        ["\xE1\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA4"],
        ["\xE1\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA5"],
        ["\xE1\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA6"],
        ["\xE1\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA7"],
        ["\xE1\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA8"],
        ["\xE1\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xA9"],
        ["\xE1\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAA"],
        ["\xE1\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAB"],
        ["\xE1\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAC"],
        ["\xE1\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAD"],
        ["\xE1\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAE"],
        ["\xE1\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xAF"],
        ["\xE1\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB0"],
        ["\xE1\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB1"],
        ["\xE1\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB2"],
        ["\xE1\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB3"],
        ["\xE1\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB4"],
        ["\xE1\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB5"],
        ["\xE1\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB6"],
        ["\xE1\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB7"],
        ["\xE1\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB8"],
        ["\xE1\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xB9"],
        ["\xE1\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBA"],
        ["\xE1\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBB"],
        ["\xE1\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBC"],
        ["\xE1\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBD"],
        ["\xE1\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBE"],
        ["\xE1\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA2\xBF"],
        ["\xE1\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x80"],
        ["\xE1\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x81"],
        ["\xE1\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x82"],
        ["\xE1\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x83"],
        ["\xE1\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x84"],
        ["\xE1\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x85"],
        ["\xE1\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x86"],
        ["\xE1\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x87"],
        ["\xE1\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x88"],
        ["\xE1\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x89"],
        ["\xE1\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8A"],
        ["\xE1\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8B"],
        ["\xE1\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8C"],
        ["\xE1\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8D"],
        ["\xE1\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8E"],
        ["\xE1\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x8F"],
        ["\xE1\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x90"],
        ["\xE1\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x91"],
        ["\xE1\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x92"],
        ["\xE1\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x93"],
        ["\xE1\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x94"],
        ["\xE1\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x95"],
        ["\xE1\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x96"],
        ["\xE1\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x97"],
        ["\xE1\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x98"],
        ["\xE1\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x99"],
        ["\xE1\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9A"],
        ["\xE1\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9B"],
        ["\xE1\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9C"],
        ["\xE1\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9D"],
        ["\xE2\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9E"],
        ["\xE2\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\x9F"],
        ["\xE2\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA0"],
        ["\xE2\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA1"],
        ["\xE2\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA2"],
        ["\xE2\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA3"],
        ["\xE2\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA4"],
        ["\xE2\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA5"],
        ["\xE2\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA6"],
        ["\xE2\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA7"],
        ["\xE2\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA8"],
        ["\xE2\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xA9"],
        ["\xE2\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAA"],
        ["\xE2\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAB"],
        ["\xE2\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAC"],
        ["\xE2\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAD"],
        ["\xE2\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAE"],
        ["\xE2\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xAF"],
        ["\xE2\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB0"],
        ["\xE2\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB1"],
        ["\xE2\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB2"],
        ["\xE2\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB3"],
        ["\xE2\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB4"],
        ["\xE2\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB5"],
        ["\xE2\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB6"],
        ["\xE2\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB7"],
        ["\xE2\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB8"],
        ["\xE2\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xB9"],
        ["\xE2\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBA"],
        ["\xE2\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBB"],
        ["\xE2\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBC"],
        ["\xE2\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBD"],
        ["\xE2\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBE"],
        ["\xE2\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA3\xBF"],
        ["\xE2\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x80"],
        ["\xE2\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x81"],
        ["\xE2\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x82"],
        ["\xE2\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x83"],
        ["\xE2\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x84"],
        ["\xE2\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x85"],
        ["\xE2\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x86"],
        ["\xE2\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x87"],
        ["\xE2\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x88"],
        ["\xE2\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x89"],
        ["\xE2\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8A"],
        ["\xE2\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8B"],
        ["\xE2\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8C"],
        ["\xE2\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8D"],
        ["\xE2\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8E"],
        ["\xE2\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x8F"],
        ["\xE2\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x90"],
        ["\xE2\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x91"],
        ["\xE2\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x92"],
        ["\xE2\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x93"],
        ["\xE2\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x94"],
        ["\xE2\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x95"],
        ["\xE2\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x96"],
        ["\xE2\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x97"],
        ["\xE2\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x98"],
        ["\xE2\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x99"],
        ["\xE2\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9A"],
        ["\xE2\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9B"],
        ["\xE2\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9C"],
        ["\xE2\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9D"],
        ["\xE2\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9E"],
        ["\xE2\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\x9F"],
        ["\xE2\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA0"],
        ["\xE2\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA1"],
        ["\xE2\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA2"],
        ["\xE2\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA3"],
        ["\xE2\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA4"],
        ["\xE2\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA5"],
        ["\xE2\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA6"],
        ["\xE2\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA7"],
        ["\xE2\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA8"],
        ["\xE2\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xA9"],
        ["\xE2\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAA"],
        ["\xE2\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAB"],
        ["\xE2\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAC"],
        ["\xE2\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAD"],
        ["\xE2\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAE"],
        ["\xE2\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xAF"],
        ["\xE2\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB0"],
        ["\xE2\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB1"],
        ["\xE2\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB2"],
        ["\xE2\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB3"],
        ["\xE2\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB4"],
        ["\xE2\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB5"],
        ["\xE2\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB6"],
        ["\xE2\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB7"],
        ["\xE2\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB8"],
        ["\xE2\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xB9"],
        ["\xE2\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBA"],
        ["\xE2\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBB"],
        ["\xE3\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBC"],
        ["\xE3\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBD"],
        ["\xE3\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBE"],
        ["\xE3\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA4\xBF"],
        ["\xE3\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x80"],
        ["\xE3\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x81"],
        ["\xE3\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x82"],
        ["\xE3\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x83"],
        ["\xE3\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x84"],
        ["\xE3\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x85"],
        ["\xE3\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x86"],
        ["\xE3\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x87"],
        ["\xE3\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x88"],
        ["\xE3\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x89"],
        ["\xE3\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8A"],
        ["\xE3\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8B"],
        ["\xE3\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8C"],
        ["\xE3\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8D"],
        ["\xE3\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8E"],
        ["\xE3\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x8F"],
        ["\xE3\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x90"],
        ["\xE3\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x91"],
        ["\xE3\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x92"],
        ["\xE3\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x93"],
        ["\xE3\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x94"],
        ["\xE3\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x95"],
        ["\xE3\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x96"],
        ["\xE3\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x97"],
        ["\xE3\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x98"],
        ["\xE3\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x99"],
        ["\xE3\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9A"],
        ["\xE3\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9B"],
        ["\xE3\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9C"],
        ["\xE3\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9D"],
        ["\xE3\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9E"],
        ["\xE3\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\x9F"],
        ["\xE3\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA0"],
        ["\xE3\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA1"],
        ["\xE3\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA2"],
        ["\xE3\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA3"],
        ["\xE3\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA4"],
        ["\xE3\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA5"],
        ["\xE3\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA6"],
        ["\xE3\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA7"],
        ["\xE3\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA8"],
        ["\xE3\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xA9"],
        ["\xE3\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAA"],
        ["\xE3\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAB"],
        ["\xE3\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAC"],
        ["\xE3\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAD"],
        ["\xE3\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAE"],
        ["\xE3\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xAF"],
        ["\xE3\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB0"],
        ["\xE3\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB1"],
        ["\xE3\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB2"],
        ["\xE3\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB3"],
        ["\xE3\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB4"],
        ["\xE3\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB5"],
        ["\xE3\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB6"],
        ["\xE3\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB7"],
        ["\xE3\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB8"],
        ["\xE3\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xB9"],
        ["\xE3\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBA"],
        ["\xE3\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBB"],
        ["\xE3\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBC"],
        ["\xE3\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBD"],
        ["\xE3\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBE"],
        ["\xE3\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA5\xBF"],
        ["\xE3\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x80"],
        ["\xE3\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x81"],
        ["\xE3\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x82"],
        ["\xE3\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x83"],
        ["\xE3\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x84"],
        ["\xE3\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x85"],
        ["\xE3\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x86"],
        ["\xE3\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x87"],
        ["\xE3\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x88"],
        ["\xE3\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x89"],
        ["\xE3\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8A"],
        ["\xE3\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8B"],
        ["\xE3\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8C"],
        ["\xE3\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8D"],
        ["\xE3\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8E"],
        ["\xE3\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x8F"],
        ["\xE3\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x90"],
        ["\xE3\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x91"],
        ["\xE3\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x92"],
        ["\xE3\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x93"],
        ["\xE3\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x94"],
        ["\xE3\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x95"],
        ["\xE3\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x96"],
        ["\xE3\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x97"],
        ["\xE3\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x98"],
        ["\xE3\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x99"],
        ["\xE4\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9A"],
        ["\xE4\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9B"],
        ["\xE4\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9C"],
        ["\xE4\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9D"],
        ["\xE4\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9E"],
        ["\xE4\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\x9F"],
        ["\xE4\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA0"],
        ["\xE4\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA1"],
        ["\xE4\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA2"],
        ["\xE4\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA3"],
        ["\xE4\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA4"],
        ["\xE4\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA5"],
        ["\xE4\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA6"],
        ["\xE4\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA7"],
        ["\xE4\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA8"],
        ["\xE4\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xA9"],
        ["\xE4\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAA"],
        ["\xE4\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAB"],
        ["\xE4\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAC"],
        ["\xE4\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAD"],
        ["\xE4\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAE"],
        ["\xE4\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xAF"],
        ["\xE4\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB0"],
        ["\xE4\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB1"],
        ["\xE4\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB2"],
        ["\xE4\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB3"],
        ["\xE4\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB4"],
        ["\xE4\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB5"],
        ["\xE4\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB6"],
        ["\xE4\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB7"],
        ["\xE4\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB8"],
        ["\xE4\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xB9"],
        ["\xE4\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBA"],
        ["\xE4\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBB"],
        ["\xE4\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBC"],
        ["\xE4\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBD"],
        ["\xE4\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBE"],
        ["\xE4\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA6\xBF"],
        ["\xE4\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x80"],
        ["\xE4\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x81"],
        ["\xE4\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x82"],
        ["\xE4\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x83"],
        ["\xE4\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x84"],
        ["\xE4\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x85"],
        ["\xE4\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x86"],
        ["\xE4\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x87"],
        ["\xE4\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x88"],
        ["\xE4\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x89"],
        ["\xE4\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8A"],
        ["\xE4\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8B"],
        ["\xE4\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8C"],
        ["\xE4\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8D"],
        ["\xE4\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8E"],
        ["\xE4\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x8F"],
        ["\xE4\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x90"],
        ["\xE4\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x91"],
        ["\xE4\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x92"],
        ["\xE4\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x93"],
        ["\xE4\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x94"],
        ["\xE4\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x95"],
        ["\xE4\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x96"],
        ["\xE4\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x97"],
        ["\xE4\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x98"],
        ["\xE4\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x99"],
        ["\xE4\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9A"],
        ["\xE4\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9B"],
        ["\xE4\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9C"],
        ["\xE4\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9D"],
        ["\xE4\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9E"],
        ["\xE4\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\x9F"],
        ["\xE4\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA0"],
        ["\xE4\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA1"],
        ["\xE4\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA2"],
        ["\xE4\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA3"],
        ["\xE4\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA4"],
        ["\xE4\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA5"],
        ["\xE4\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA6"],
        ["\xE4\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA7"],
        ["\xE4\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA8"],
        ["\xE4\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xA9"],
        ["\xE4\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAA"],
        ["\xE4\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAB"],
        ["\xE4\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAC"],
        ["\xE4\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAD"],
        ["\xE4\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAE"],
        ["\xE4\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xAF"],
        ["\xE4\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB0"],
        ["\xE4\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB1"],
        ["\xE4\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB2"],
        ["\xE4\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB3"],
        ["\xE4\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB4"],
        ["\xE4\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB5"],
        ["\xE4\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB6"],
        ["\xE4\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB7"],
        ["\xE5\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB8"],
        ["\xE5\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xB9"],
        ["\xE5\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBA"],
        ["\xE5\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBB"],
        ["\xE5\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBC"],
        ["\xE5\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBD"],
        ["\xE5\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBE"],
        ["\xE5\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA7\xBF"],
        ["\xE5\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x80"],
        ["\xE5\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x81"],
        ["\xE5\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x82"],
        ["\xE5\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x83"],
        ["\xE5\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x84"],
        ["\xE5\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x85"],
        ["\xE5\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x86"],
        ["\xE5\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x87"],
        ["\xE5\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x88"],
        ["\xE5\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x89"],
        ["\xE5\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8A"],
        ["\xE5\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8B"],
        ["\xE5\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8C"],
        ["\xE5\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8D"],
        ["\xE5\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8E"],
        ["\xE5\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x8F"],
        ["\xE5\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x90"],
        ["\xE5\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x91"],
        ["\xE5\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x92"],
        ["\xE5\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x93"],
        ["\xE5\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x94"],
        ["\xE5\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x95"],
        ["\xE5\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x96"],
        ["\xE5\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x97"],
        ["\xE5\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x98"],
        ["\xE5\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x99"],
        ["\xE5\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9A"],
        ["\xE5\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9B"],
        ["\xE5\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9C"],
        ["\xE5\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9D"],
        ["\xE5\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9E"],
        ["\xE5\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\x9F"],
        ["\xE5\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA0"],
        ["\xE5\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA1"],
        ["\xE5\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA2"],
        ["\xE5\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA3"],
        ["\xE5\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA4"],
        ["\xE5\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA5"],
        ["\xE5\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA6"],
        ["\xE5\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA7"],
        ["\xE5\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA8"],
        ["\xE5\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xA9"],
        ["\xE5\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAA"],
        ["\xE5\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAB"],
        ["\xE5\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAC"],
        ["\xE5\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAD"],
        ["\xE5\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAE"],
        ["\xE5\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xAF"],
        ["\xE5\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB0"],
        ["\xE5\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB1"],
        ["\xE5\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB2"],
        ["\xE5\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB3"],
        ["\xE5\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB4"],
        ["\xE5\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB5"],
        ["\xE5\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB6"],
        ["\xE5\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB7"],
        ["\xE5\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB8"],
        ["\xE5\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xB9"],
        ["\xE5\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBA"],
        ["\xE5\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBB"],
        ["\xE5\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBC"],
        ["\xE5\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBD"],
        ["\xE5\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBE"],
        ["\xE5\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA8\xBF"],
        ["\xE5\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x80"],
        ["\xE5\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x81"],
        ["\xE5\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x82"],
        ["\xE5\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x83"],
        ["\xE5\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x84"],
        ["\xE5\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x85"],
        ["\xE5\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x86"],
        ["\xE5\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x87"],
        ["\xE5\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x88"],
        ["\xE5\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x89"],
        ["\xE5\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8A"],
        ["\xE5\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8B"],
        ["\xE5\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8C"],
        ["\xE5\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8D"],
        ["\xE5\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8E"],
        ["\xE5\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x8F"],
        ["\xE5\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x90"],
        ["\xE5\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x91"],
        ["\xE5\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x92"],
        ["\xE5\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x93"],
        ["\xE5\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x94"],
        ["\xE5\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x95"],
        ["\xE6\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x96"],
        ["\xE6\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x97"],
        ["\xE6\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x98"],
        ["\xE6\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x99"],
        ["\xE6\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9A"],
        ["\xE6\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9B"],
        ["\xE6\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9C"],
        ["\xE6\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9D"],
        ["\xE6\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9E"],
        ["\xE6\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\x9F"],
        ["\xE6\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA0"],
        ["\xE6\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA1"],
        ["\xE6\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA2"],
        ["\xE6\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA3"],
        ["\xE6\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA4"],
        ["\xE6\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA5"],
        ["\xE6\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA6"],
        ["\xE6\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA7"],
        ["\xE6\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA8"],
        ["\xE6\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xA9"],
        ["\xE6\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAA"],
        ["\xE6\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAB"],
        ["\xE6\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAC"],
        ["\xE6\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAD"],
        ["\xE6\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAE"],
        ["\xE6\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xAF"],
        ["\xE6\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB0"],
        ["\xE6\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB1"],
        ["\xE6\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB2"],
        ["\xE6\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB3"],
        ["\xE6\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB4"],
        ["\xE6\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB5"],
        ["\xE6\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB6"],
        ["\xE6\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB7"],
        ["\xE6\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB8"],
        ["\xE6\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xB9"],
        ["\xE6\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBA"],
        ["\xE6\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBB"],
        ["\xE6\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBC"],
        ["\xE6\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBD"],
        ["\xE6\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBE"],
        ["\xE6\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xA9\xBF"],
        ["\xE6\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x80"],
        ["\xE6\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x81"],
        ["\xE6\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x82"],
        ["\xE6\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x83"],
        ["\xE6\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x84"],
        ["\xE6\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x85"],
        ["\xE6\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x86"],
        ["\xE6\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x87"],
        ["\xE6\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x88"],
        ["\xE6\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x89"],
        ["\xE6\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8A"],
        ["\xE6\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8B"],
        ["\xE6\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8C"],
        ["\xE6\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8D"],
        ["\xE6\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8E"],
        ["\xE6\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x8F"],
        ["\xE6\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x90"],
        ["\xE6\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x91"],
        ["\xE6\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x92"],
        ["\xE6\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x93"],
        ["\xE6\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x94"],
        ["\xE6\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x95"],
        ["\xE6\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x96"],
        ["\xE6\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x97"],
        ["\xE6\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x98"],
        ["\xE6\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x99"],
        ["\xE6\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9A"],
        ["\xE6\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9B"],
        ["\xE6\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9C"],
        ["\xE6\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9D"],
        ["\xE6\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9E"],
        ["\xE6\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\x9F"],
        ["\xE6\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA0"],
        ["\xE6\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA1"],
        ["\xE6\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA2"],
        ["\xE6\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA3"],
        ["\xE6\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA4"],
        ["\xE6\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA5"],
        ["\xE6\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA6"],
        ["\xE6\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA7"],
        ["\xE6\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA8"],
        ["\xE6\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xA9"],
        ["\xE6\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAA"],
        ["\xE6\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAB"],
        ["\xE6\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAC"],
        ["\xE6\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAD"],
        ["\xE6\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAE"],
        ["\xE6\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xAF"],
        ["\xE6\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB0"],
        ["\xE6\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB1"],
        ["\xE6\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB2"],
        ["\xE6\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB3"],
        ["\xE7\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB4"],
        ["\xE7\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB5"],
        ["\xE7\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB6"],
        ["\xE7\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB7"],
        ["\xE7\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB8"],
        ["\xE7\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xB9"],
        ["\xE7\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBA"],
        ["\xE7\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBB"],
        ["\xE7\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBC"],
        ["\xE7\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBD"],
        ["\xE7\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBE"],
        ["\xE7\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAA\xBF"],
        ["\xE7\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x80"],
        ["\xE7\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x81"],
        ["\xE7\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x82"],
        ["\xE7\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x83"],
        ["\xE7\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x84"],
        ["\xE7\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x85"],
        ["\xE7\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x86"],
        ["\xE7\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x87"],
        ["\xE7\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x88"],
        ["\xE7\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x89"],
        ["\xE7\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8A"],
        ["\xE7\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8B"],
        ["\xE7\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8C"],
        ["\xE7\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8D"],
        ["\xE7\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8E"],
        ["\xE7\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x8F"],
        ["\xE7\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x90"],
        ["\xE7\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x91"],
        ["\xE7\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x92"],
        ["\xE7\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x93"],
        ["\xE7\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x94"],
        ["\xE7\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x95"],
        ["\xE7\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x96"],
        ["\xE7\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x97"],
        ["\xE7\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x98"],
        ["\xE7\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x99"],
        ["\xE7\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9A"],
        ["\xE7\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9B"],
        ["\xE7\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9C"],
        ["\xE7\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9D"],
        ["\xE7\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9E"],
        ["\xE7\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\x9F"],
        ["\xE7\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA0"],
        ["\xE7\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA1"],
        ["\xE7\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA2"],
        ["\xE7\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA3"],
        ["\xE7\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA4"],
        ["\xE7\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA5"],
        ["\xE7\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA6"],
        ["\xE7\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA7"],
        ["\xE7\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA8"],
        ["\xE7\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xA9"],
        ["\xE7\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAA"],
        ["\xE7\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAB"],
        ["\xE7\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAC"],
        ["\xE7\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAD"],
        ["\xE7\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAE"],
        ["\xE7\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xAF"],
        ["\xE7\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB0"],
        ["\xE7\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB1"],
        ["\xE7\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB2"],
        ["\xE7\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB3"],
        ["\xE7\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB4"],
        ["\xE7\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB5"],
        ["\xE7\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB6"],
        ["\xE7\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB7"],
        ["\xE7\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB8"],
        ["\xE7\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xB9"],
        ["\xE7\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBA"],
        ["\xE7\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBB"],
        ["\xE7\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBC"],
        ["\xE7\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBD"],
        ["\xE7\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBE"],
        ["\xE7\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAB\xBF"],
        ["\xE7\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x80"],
        ["\xE7\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x81"],
        ["\xE7\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x82"],
        ["\xE7\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x83"],
        ["\xE7\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x84"],
        ["\xE7\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x85"],
        ["\xE7\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x86"],
        ["\xE7\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x87"],
        ["\xE7\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x88"],
        ["\xE7\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x89"],
        ["\xE7\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8A"],
        ["\xE7\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8B"],
        ["\xE7\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8C"],
        ["\xE7\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8D"],
        ["\xE7\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8E"],
        ["\xE7\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x8F"],
        ["\xE7\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x90"],
        ["\xE7\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x91"],
        ["\xE8\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x92"],
        ["\xE8\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x93"],
        ["\xE8\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x94"],
        ["\xE8\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x95"],
        ["\xE8\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x96"],
        ["\xE8\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x97"],
        ["\xE8\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x98"],
        ["\xE8\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x99"],
        ["\xE8\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9A"],
        ["\xE8\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9B"],
        ["\xE8\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9C"],
        ["\xE8\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9D"],
        ["\xE8\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9E"],
        ["\xE8\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\x9F"],
        ["\xE8\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA0"],
        ["\xE8\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA1"],
        ["\xE8\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA2"],
        ["\xE8\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA3"],
        ["\xE8\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA4"],
        ["\xE8\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA5"],
        ["\xE8\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA6"],
        ["\xE8\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA7"],
        ["\xE8\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA8"],
        ["\xE8\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xA9"],
        ["\xE8\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAA"],
        ["\xE8\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAB"],
        ["\xE8\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAC"],
        ["\xE8\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAD"],
        ["\xE8\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAE"],
        ["\xE8\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xAF"],
        ["\xE8\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB0"],
        ["\xE8\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB1"],
        ["\xE8\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB2"],
        ["\xE8\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB3"],
        ["\xE8\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB4"],
        ["\xE8\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB5"],
        ["\xE8\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB6"],
        ["\xE8\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB7"],
        ["\xE8\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB8"],
        ["\xE8\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xB9"],
        ["\xE8\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBA"],
        ["\xE8\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBB"],
        ["\xE8\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBC"],
        ["\xE8\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBD"],
        ["\xE8\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBE"],
        ["\xE8\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAC\xBF"],
        ["\xE8\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x80"],
        ["\xE8\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x81"],
        ["\xE8\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x82"],
        ["\xE8\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x83"],
        ["\xE8\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x84"],
        ["\xE8\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x85"],
        ["\xE8\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x86"],
        ["\xE8\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x87"],
        ["\xE8\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x88"],
        ["\xE8\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x89"],
        ["\xE8\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8A"],
        ["\xE8\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8B"],
        ["\xE8\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8C"],
        ["\xE8\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8D"],
        ["\xE8\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8E"],
        ["\xE8\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x8F"],
        ["\xE8\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x90"],
        ["\xE8\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x91"],
        ["\xE8\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x92"],
        ["\xE8\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x93"],
        ["\xE8\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x94"],
        ["\xE8\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x95"],
        ["\xE8\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x96"],
        ["\xE8\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x97"],
        ["\xE8\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x98"],
        ["\xE8\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x99"],
        ["\xE8\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9A"],
        ["\xE8\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9B"],
        ["\xE8\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9C"],
        ["\xE8\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9D"],
        ["\xE8\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9E"],
        ["\xE8\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\x9F"],
        ["\xE8\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA0"],
        ["\xE8\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA1"],
        ["\xE8\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA2"],
        ["\xE8\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA3"],
        ["\xE8\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA4"],
        ["\xE8\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA5"],
        ["\xE8\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA6"],
        ["\xE8\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA7"],
        ["\xE8\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA8"],
        ["\xE8\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xA9"],
        ["\xE8\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAA"],
        ["\xE8\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAB"],
        ["\xE8\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAC"],
        ["\xE8\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAD"],
        ["\xE8\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAE"],
        ["\xE8\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xAF"],
        ["\xE9\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB0"],
        ["\xE9\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB1"],
        ["\xE9\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB2"],
        ["\xE9\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB3"],
        ["\xE9\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB4"],
        ["\xE9\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB5"],
        ["\xE9\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB6"],
        ["\xE9\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB7"],
        ["\xE9\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB8"],
        ["\xE9\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xB9"],
        ["\xE9\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBA"],
        ["\xE9\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBB"],
        ["\xE9\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBC"],
        ["\xE9\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBD"],
        ["\xE9\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBE"],
        ["\xE9\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAD\xBF"],
        ["\xE9\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x80"],
        ["\xE9\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x81"],
        ["\xE9\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x82"],
        ["\xE9\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x83"],
        ["\xE9\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x84"],
        ["\xE9\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x85"],
        ["\xE9\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x86"],
        ["\xE9\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x87"],
        ["\xE9\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x88"],
        ["\xE9\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x89"],
        ["\xE9\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8A"],
        ["\xE9\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8B"],
        ["\xE9\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8C"],
        ["\xE9\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8D"],
        ["\xE9\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8E"],
        ["\xE9\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x8F"],
        ["\xE9\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x90"],
        ["\xE9\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x91"],
        ["\xE9\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x92"],
        ["\xE9\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x93"],
        ["\xE9\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x94"],
        ["\xE9\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x95"],
        ["\xE9\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x96"],
        ["\xE9\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x97"],
        ["\xE9\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x98"],
        ["\xE9\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x99"],
        ["\xE9\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9A"],
        ["\xE9\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9B"],
        ["\xE9\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9C"],
        ["\xE9\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9D"],
        ["\xE9\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9E"],
        ["\xE9\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\x9F"],
        ["\xE9\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA0"],
        ["\xE9\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA1"],
        ["\xE9\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA2"],
        ["\xE9\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA3"],
        ["\xE9\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA4"],
        ["\xE9\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA5"],
        ["\xE9\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA6"],
        ["\xE9\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA7"],
        ["\xE9\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA8"],
        ["\xE9\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xA9"],
        ["\xE9\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAA"],
        ["\xE9\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAB"],
        ["\xE9\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAC"],
        ["\xE9\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAD"],
        ["\xE9\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAE"],
        ["\xE9\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xAF"],
        ["\xE9\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB0"],
        ["\xE9\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB1"],
        ["\xE9\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB2"],
        ["\xE9\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB3"],
        ["\xE9\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB4"],
        ["\xE9\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB5"],
        ["\xE9\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB6"],
        ["\xE9\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB7"],
        ["\xE9\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB8"],
        ["\xE9\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xB9"],
        ["\xE9\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBA"],
        ["\xE9\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBB"],
        ["\xE9\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBC"],
        ["\xE9\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBD"],
        ["\xE9\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBE"],
        ["\xE9\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAE\xBF"],
        ["\xE9\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x80"],
        ["\xE9\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x81"],
        ["\xE9\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x82"],
        ["\xE9\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x83"],
        ["\xE9\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x84"],
        ["\xE9\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x85"],
        ["\xE9\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x86"],
        ["\xE9\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x87"],
        ["\xE9\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x88"],
        ["\xE9\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x89"],
        ["\xE9\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8A"],
        ["\xE9\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8B"],
        ["\xE9\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8C"],
        ["\xE9\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8D"],
        ["\xEA\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8E"],
        ["\xEA\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x8F"],
        ["\xEA\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x90"],
        ["\xEA\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x91"],
        ["\xEA\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x92"],
        ["\xEA\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x93"],
        ["\xEA\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x94"],
        ["\xEA\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x95"],
        ["\xEA\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x96"],
        ["\xEA\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x97"],
        ["\xEA\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x98"],
        ["\xEA\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x99"],
        ["\xEA\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9A"],
        ["\xEA\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9B"],
        ["\xEA\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9C"],
        ["\xEA\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9D"],
        ["\xEA\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9E"],
        ["\xEA\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\x9F"],
        ["\xEA\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA0"],
        ["\xEA\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA1"],
        ["\xEA\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA2"],
        ["\xEA\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA3"],
        ["\xEA\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA4"],
        ["\xEA\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA5"],
        ["\xEA\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA6"],
        ["\xEA\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA7"],
        ["\xEA\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA8"],
        ["\xEA\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xA9"],
        ["\xEA\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAA"],
        ["\xEA\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAB"],
        ["\xEA\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAC"],
        ["\xEA\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAD"],
        ["\xEA\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAE"],
        ["\xEA\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xAF"],
        ["\xEA\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB0"],
        ["\xEA\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB1"],
        ["\xEA\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB2"],
        ["\xEA\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB3"],
        ["\xEA\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB4"],
        ["\xEA\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB5"],
        ["\xEA\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB6"],
        ["\xEA\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB7"],
        ["\xEA\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB8"],
        ["\xEA\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xB9"],
        ["\xEA\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBA"],
        ["\xEA\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBB"],
        ["\xEA\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBC"],
        ["\xEA\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBD"],
        ["\xEA\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBE"],
        ["\xEA\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xAF\xBF"],
        ["\xEA\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x80"],
        ["\xEA\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x81"],
        ["\xEA\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x82"],
        ["\xEA\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x83"],
        ["\xEA\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x84"],
        ["\xEA\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x85"],
        ["\xEA\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x86"],
        ["\xEA\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x87"],
        ["\xEA\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x88"],
        ["\xEA\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x89"],
        ["\xEA\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8A"],
        ["\xEA\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8B"],
        ["\xEA\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8C"],
        ["\xEA\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8D"],
        ["\xEA\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8E"],
        ["\xEA\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x8F"],
        ["\xEA\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x90"],
        ["\xEA\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x91"],
        ["\xEA\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x92"],
        ["\xEA\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x93"],
        ["\xEA\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x94"],
        ["\xEA\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x95"],
        ["\xEA\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x96"],
        ["\xEA\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x97"],
        ["\xEA\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x98"],
        ["\xEA\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x99"],
        ["\xEA\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9A"],
        ["\xEA\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9B"],
        ["\xEA\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9C"],
        ["\xEA\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9D"],
        ["\xEA\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9E"],
        ["\xEA\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\x9F"],
        ["\xEA\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA0"],
        ["\xEA\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA1"],
        ["\xEA\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA2"],
        ["\xEA\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA3"],
        ["\xEA\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA4"],
        ["\xEA\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA5"],
        ["\xEA\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA6"],
        ["\xEA\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA7"],
        ["\xEA\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA8"],
        ["\xEA\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xA9"],
        ["\xEA\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAA"],
        ["\xEA\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAB"],
        ["\xEB\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAC"],
        ["\xEB\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAD"],
        ["\xEB\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAE"],
        ["\xEB\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xAF"],
        ["\xEB\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB0"],
        ["\xEB\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB1"],
        ["\xEB\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB2"],
        ["\xEB\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB3"],
        ["\xEB\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB4"],
        ["\xEB\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB5"],
        ["\xEB\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB6"],
        ["\xEB\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB7"],
        ["\xEB\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB8"],
        ["\xEB\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xB9"],
        ["\xEB\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBA"],
        ["\xEB\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBB"],
        ["\xEB\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBC"],
        ["\xEB\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBD"],
        ["\xEB\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBE"],
        ["\xEB\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB0\xBF"],
        ["\xEB\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x80"],
        ["\xEB\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x81"],
        ["\xEB\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x82"],
        ["\xEB\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x83"],
        ["\xEB\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x84"],
        ["\xEB\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x85"],
        ["\xEB\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x86"],
        ["\xEB\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x87"],
        ["\xEB\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x88"],
        ["\xEB\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x89"],
        ["\xEB\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8A"],
        ["\xEB\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8B"],
        ["\xEB\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8C"],
        ["\xEB\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8D"],
        ["\xEB\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8E"],
        ["\xEB\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x8F"],
        ["\xEB\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x90"],
        ["\xEB\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x91"],
        ["\xEB\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x92"],
        ["\xEB\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x93"],
        ["\xEB\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x94"],
        ["\xEB\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x95"],
        ["\xEB\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x96"],
        ["\xEB\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x97"],
        ["\xEB\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x98"],
        ["\xEB\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x99"],
        ["\xEB\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9A"],
        ["\xEB\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9B"],
        ["\xEB\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9C"],
        ["\xEB\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9D"],
        ["\xEB\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9E"],
        ["\xEB\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\x9F"],
        ["\xEB\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA0"],
        ["\xEB\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA1"],
        ["\xEB\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA2"],
        ["\xEB\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA3"],
        ["\xEB\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA4"],
        ["\xEB\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA5"],
        ["\xEB\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA6"],
        ["\xEB\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA7"],
        ["\xEB\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA8"],
        ["\xEB\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xA9"],
        ["\xEB\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAA"],
        ["\xEB\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAB"],
        ["\xEB\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAC"],
        ["\xEB\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAD"],
        ["\xEB\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAE"],
        ["\xEB\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xAF"],
        ["\xEB\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB0"],
        ["\xEB\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB1"],
        ["\xEB\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB2"],
        ["\xEB\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB3"],
        ["\xEB\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB4"],
        ["\xEB\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB5"],
        ["\xEB\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB6"],
        ["\xEB\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB7"],
        ["\xEB\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB8"],
        ["\xEB\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xB9"],
        ["\xEB\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBA"],
        ["\xEB\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBB"],
        ["\xEB\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBC"],
        ["\xEB\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBD"],
        ["\xEB\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBE"],
        ["\xEB\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB1\xBF"],
        ["\xEB\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x80"],
        ["\xEB\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x81"],
        ["\xEB\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x82"],
        ["\xEB\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x83"],
        ["\xEB\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x84"],
        ["\xEB\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x85"],
        ["\xEB\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x86"],
        ["\xEB\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x87"],
        ["\xEB\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x88"],
        ["\xEB\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x89"],
        ["\xEC\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8A"],
        ["\xEC\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8B"],
        ["\xEC\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8C"],
        ["\xEC\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8D"],
        ["\xEC\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8E"],
        ["\xEC\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x8F"],
        ["\xEC\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x90"],
        ["\xEC\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x91"],
        ["\xEC\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x92"],
        ["\xEC\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x93"],
        ["\xEC\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x94"],
        ["\xEC\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x95"],
        ["\xEC\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x96"],
        ["\xEC\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x97"],
        ["\xEC\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x98"],
        ["\xEC\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x99"],
        ["\xEC\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9A"],
        ["\xEC\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9B"],
        ["\xEC\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9C"],
        ["\xEC\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9D"],
        ["\xEC\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9E"],
        ["\xEC\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\x9F"],
        ["\xEC\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA0"],
        ["\xEC\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA1"],
        ["\xEC\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA2"],
        ["\xEC\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA3"],
        ["\xEC\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA4"],
        ["\xEC\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA5"],
        ["\xEC\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA6"],
        ["\xEC\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA7"],
        ["\xEC\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA8"],
        ["\xEC\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xA9"],
        ["\xEC\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAA"],
        ["\xEC\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAB"],
        ["\xEC\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAC"],
        ["\xEC\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAD"],
        ["\xEC\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAE"],
        ["\xEC\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xAF"],
        ["\xEC\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB0"],
        ["\xEC\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB1"],
        ["\xEC\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB2"],
        ["\xEC\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB3"],
        ["\xEC\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB4"],
        ["\xEC\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB5"],
        ["\xEC\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB6"],
        ["\xEC\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB7"],
        ["\xEC\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB8"],
        ["\xEC\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xB9"],
        ["\xEC\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBA"],
        ["\xEC\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBB"],
        ["\xEC\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBC"],
        ["\xEC\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBD"],
        ["\xEC\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBE"],
        ["\xEC\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB2\xBF"],
        ["\xEC\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x80"],
        ["\xEC\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x81"],
        ["\xEC\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x82"],
        ["\xEC\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x83"],
        ["\xEC\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x84"],
        ["\xEC\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x85"],
        ["\xEC\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x86"],
        ["\xEC\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x87"],
        ["\xEC\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x88"],
        ["\xEC\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x89"],
        ["\xEC\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8A"],
        ["\xEC\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8B"],
        ["\xEC\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8C"],
        ["\xEC\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8D"],
        ["\xEC\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8E"],
        ["\xEC\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x8F"],
        ["\xEC\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x90"],
        ["\xEC\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x91"],
        ["\xEC\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x92"],
        ["\xEC\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x93"],
        ["\xEC\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x94"],
        ["\xEC\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x95"],
        ["\xEC\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x96"],
        ["\xEC\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x97"],
        ["\xEC\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x98"],
        ["\xEC\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x99"],
        ["\xEC\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9A"],
        ["\xEC\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9B"],
        ["\xEC\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9C"],
        ["\xEC\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9D"],
        ["\xEC\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9E"],
        ["\xEC\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\x9F"],
        ["\xEC\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA0"],
        ["\xEC\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA1"],
        ["\xEC\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA2"],
        ["\xEC\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA3"],
        ["\xEC\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA4"],
        ["\xEC\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA5"],
        ["\xEC\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA6"],
        ["\xEC\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA7"],
        ["\xED\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA8"],
        ["\xED\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xA9"],
        ["\xED\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAA"],
        ["\xED\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAB"],
        ["\xED\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAC"],
        ["\xED\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAD"],
        ["\xED\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAE"],
        ["\xED\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xAF"],
        ["\xED\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB0"],
        ["\xED\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB1"],
        ["\xED\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB2"],
        ["\xED\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB3"],
        ["\xED\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB4"],
        ["\xED\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB5"],
        ["\xED\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB6"],
        ["\xED\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB7"],
        ["\xED\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB8"],
        ["\xED\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xB9"],
        ["\xED\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBA"],
        ["\xED\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBB"],
        ["\xED\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBC"],
        ["\xED\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBD"],
        ["\xED\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBE"],
        ["\xED\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB3\xBF"],
        ["\xED\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x80"],
        ["\xED\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x81"],
        ["\xED\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x82"],
        ["\xED\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x83"],
        ["\xED\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x84"],
        ["\xED\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x85"],
        ["\xED\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x86"],
        ["\xED\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x87"],
        ["\xED\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x88"],
        ["\xED\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x89"],
        ["\xED\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8A"],
        ["\xED\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8B"],
        ["\xED\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8C"],
        ["\xED\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8D"],
        ["\xED\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8E"],
        ["\xED\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x8F"],
        ["\xED\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x90"],
        ["\xED\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x91"],
        ["\xED\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x92"],
        ["\xED\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x93"],
        ["\xED\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x94"],
        ["\xED\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x95"],
        ["\xED\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x96"],
        ["\xED\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x97"],
        ["\xED\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x98"],
        ["\xED\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x99"],
        ["\xED\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9A"],
        ["\xED\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9B"],
        ["\xED\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9C"],
        ["\xED\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9D"],
        ["\xED\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9E"],
        ["\xED\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\x9F"],
        ["\xED\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA0"],
        ["\xED\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA1"],
        ["\xED\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA2"],
        ["\xED\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA3"],
        ["\xED\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA4"],
        ["\xED\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA5"],
        ["\xED\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA6"],
        ["\xED\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA7"],
        ["\xED\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA8"],
        ["\xED\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xA9"],
        ["\xED\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAA"],
        ["\xED\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAB"],
        ["\xED\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAC"],
        ["\xED\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAD"],
        ["\xED\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAE"],
        ["\xED\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xAF"],
        ["\xED\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB0"],
        ["\xED\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB1"],
        ["\xED\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB2"],
        ["\xED\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB3"],
        ["\xED\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB4"],
        ["\xED\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB5"],
        ["\xED\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB6"],
        ["\xED\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB7"],
        ["\xED\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB8"],
        ["\xED\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xB9"],
        ["\xED\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBA"],
        ["\xED\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBB"],
        ["\xED\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBC"],
        ["\xED\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBD"],
        ["\xED\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBE"],
        ["\xED\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB4\xBF"],
        ["\xED\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x80"],
        ["\xED\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x81"],
        ["\xED\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x82"],
        ["\xED\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x83"],
        ["\xED\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x84"],
        ["\xED\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x85"],
        ["\xEE\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x86"],
        ["\xEE\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x87"],
        ["\xEE\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x88"],
        ["\xEE\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x89"],
        ["\xEE\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8A"],
        ["\xEE\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8B"],
        ["\xEE\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8C"],
        ["\xEE\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8D"],
        ["\xEE\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8E"],
        ["\xEE\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x8F"],
        ["\xEE\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x90"],
        ["\xEE\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x91"],
        ["\xEE\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x92"],
        ["\xEE\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x93"],
        ["\xEE\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x94"],
        ["\xEE\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x95"],
        ["\xEE\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x96"],
        ["\xEE\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x97"],
        ["\xEE\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x98"],
        ["\xEE\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x99"],
        ["\xEE\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9A"],
        ["\xEE\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9B"],
        ["\xEE\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9C"],
        ["\xEE\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9D"],
        ["\xEE\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9E"],
        ["\xEE\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\x9F"],
        ["\xEE\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA0"],
        ["\xEE\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA1"],
        ["\xEE\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA2"],
        ["\xEE\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA3"],
        ["\xEE\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA4"],
        ["\xEE\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA5"],
        ["\xEE\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA6"],
        ["\xEE\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA7"],
        ["\xEE\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA8"],
        ["\xEE\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xA9"],
        ["\xEE\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAA"],
        ["\xEE\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAB"],
        ["\xEE\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAC"],
        ["\xEE\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAD"],
        ["\xEE\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAE"],
        ["\xEE\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xAF"],
        ["\xEE\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB0"],
        ["\xEE\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB1"],
        ["\xEE\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB2"],
        ["\xEE\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB3"],
        ["\xEE\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB4"],
        ["\xEE\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB5"],
        ["\xEE\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB6"],
        ["\xEE\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB7"],
        ["\xEE\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB8"],
        ["\xEE\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xB9"],
        ["\xEE\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBA"],
        ["\xEE\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBB"],
        ["\xEE\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBC"],
        ["\xEE\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBD"],
        ["\xEE\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBE"],
        ["\xEE\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB5\xBF"],
        ["\xEE\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x80"],
        ["\xEE\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x81"],
        ["\xEE\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x82"],
        ["\xEE\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x83"],
        ["\xEE\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x84"],
        ["\xEE\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x85"],
        ["\xEE\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x86"],
        ["\xEE\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x87"],
        ["\xEE\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x88"],
        ["\xEE\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x89"],
        ["\xEE\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8A"],
        ["\xEE\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8B"],
        ["\xEE\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8C"],
        ["\xEE\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8D"],
        ["\xEE\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8E"],
        ["\xEE\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x8F"],
        ["\xEE\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x90"],
        ["\xEE\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x91"],
        ["\xEE\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x92"],
        ["\xEE\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x93"],
        ["\xEE\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x94"],
        ["\xEE\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x95"],
        ["\xEE\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x96"],
        ["\xEE\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x97"],
        ["\xEE\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x98"],
        ["\xEE\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x99"],
        ["\xEE\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9A"],
        ["\xEE\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9B"],
        ["\xEE\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9C"],
        ["\xEE\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9D"],
        ["\xEE\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9E"],
        ["\xEE\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\x9F"],
        ["\xEE\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA0"],
        ["\xEE\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA1"],
        ["\xEE\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA2"],
        ["\xEE\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA3"],
        ["\xEF\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA4"],
        ["\xEF\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA5"],
        ["\xEF\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA6"],
        ["\xEF\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA7"],
        ["\xEF\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA8"],
        ["\xEF\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xA9"],
        ["\xEF\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAA"],
        ["\xEF\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAB"],
        ["\xEF\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAC"],
        ["\xEF\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAD"],
        ["\xEF\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAE"],
        ["\xEF\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xAF"],
        ["\xEF\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB0"],
        ["\xEF\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB1"],
        ["\xEF\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB2"],
        ["\xEF\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB3"],
        ["\xEF\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB4"],
        ["\xEF\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB5"],
        ["\xEF\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB6"],
        ["\xEF\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB7"],
        ["\xEF\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB8"],
        ["\xEF\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xB9"],
        ["\xEF\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBA"],
        ["\xEF\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBB"],
        ["\xEF\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBC"],
        ["\xEF\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBD"],
        ["\xEF\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBE"],
        ["\xEF\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB6\xBF"],
        ["\xEF\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x80"],
        ["\xEF\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x81"],
        ["\xEF\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x82"],
        ["\xEF\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x83"],
        ["\xEF\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x84"],
        ["\xEF\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x85"],
        ["\xEF\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x86"],
        ["\xEF\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x87"],
        ["\xEF\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x88"],
        ["\xEF\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x89"],
        ["\xEF\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8A"],
        ["\xEF\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8B"],
        ["\xEF\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8C"],
        ["\xEF\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8D"],
        ["\xEF\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8E"],
        ["\xEF\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x8F"],
        ["\xEF\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x90"],
        ["\xEF\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x91"],
        ["\xEF\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x92"],
        ["\xEF\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x93"],
        ["\xEF\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x94"],
        ["\xEF\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x95"],
        ["\xEF\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x96"],
        ["\xEF\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x97"],
        ["\xEF\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x98"],
        ["\xEF\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x99"],
        ["\xEF\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9A"],
        ["\xEF\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9B"],
        ["\xEF\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9C"],
        ["\xEF\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9D"],
        ["\xEF\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9E"],
        ["\xEF\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\x9F"],
        ["\xEF\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA0"],
        ["\xEF\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA1"],
        ["\xEF\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA2"],
        ["\xEF\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA3"],
        ["\xEF\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA4"],
        ["\xEF\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA5"],
        ["\xEF\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA6"],
        ["\xEF\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA7"],
        ["\xEF\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA8"],
        ["\xEF\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xA9"],
        ["\xEF\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAA"],
        ["\xEF\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAB"],
        ["\xEF\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAC"],
        ["\xEF\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAD"],
        ["\xEF\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAE"],
        ["\xEF\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xAF"],
        ["\xEF\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB0"],
        ["\xEF\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB1"],
        ["\xEF\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB2"],
        ["\xEF\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB3"],
        ["\xEF\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB4"],
        ["\xEF\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB5"],
        ["\xEF\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB6"],
        ["\xEF\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB7"],
        ["\xEF\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB8"],
        ["\xEF\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xB9"],
        ["\xEF\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBA"],
        ["\xEF\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBB"],
        ["\xEF\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBC"],
        ["\xEF\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBD"],
        ["\xEF\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBE"],
        ["\xEF\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB7\xBF"],
        ["\xEF\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x80"],
        ["\xEF\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x81"],
        ["\xF0\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x82"],
        ["\xF0\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x83"],
        ["\xF0\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x84"],
        ["\xF0\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x85"],
        ["\xF0\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x86"],
        ["\xF0\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x87"],
        ["\xF0\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x88"],
        ["\xF0\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x89"],
        ["\xF0\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8A"],
        ["\xF0\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8B"],
        ["\xF0\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8C"],
        ["\xF0\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8D"],
        ["\xF0\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8E"],
        ["\xF0\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x8F"],
        ["\xF0\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x90"],
        ["\xF0\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x91"],
        ["\xF0\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x92"],
        ["\xF0\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x93"],
        ["\xF0\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x94"],
        ["\xF0\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x95"],
        ["\xF0\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x96"],
        ["\xF0\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x97"],
        ["\xF0\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x98"],
        ["\xF0\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x99"],
        ["\xF0\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9A"],
        ["\xF0\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9B"],
        ["\xF0\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9C"],
        ["\xF0\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9D"],
        ["\xF0\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9E"],
        ["\xF0\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\x9F"],
        ["\xF0\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA0"],
        ["\xF0\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA1"],
        ["\xF0\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA2"],
        ["\xF0\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA3"],
        ["\xF0\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA4"],
        ["\xF0\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA5"],
        ["\xF0\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA6"],
        ["\xF0\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA7"],
        ["\xF0\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA8"],
        ["\xF0\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xA9"],
        ["\xF0\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAA"],
        ["\xF0\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAB"],
        ["\xF0\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAC"],
        ["\xF0\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAD"],
        ["\xF0\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAE"],
        ["\xF0\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xAF"],
        ["\xF0\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB0"],
        ["\xF0\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB1"],
        ["\xF0\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB2"],
        ["\xF0\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB3"],
        ["\xF0\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB4"],
        ["\xF0\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB5"],
        ["\xF0\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB6"],
        ["\xF0\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB7"],
        ["\xF0\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB8"],
        ["\xF0\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xB9"],
        ["\xF0\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBA"],
        ["\xF0\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBB"],
        ["\xF0\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBC"],
        ["\xF0\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBD"],
        ["\xF0\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBE"],
        ["\xF0\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB8\xBF"],
        ["\xF0\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x80"],
        ["\xF0\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x81"],
        ["\xF0\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x82"],
        ["\xF0\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x83"],
        ["\xF0\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x84"],
        ["\xF0\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x85"],
        ["\xF0\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x86"],
        ["\xF0\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x87"],
        ["\xF0\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x88"],
        ["\xF0\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x89"],
        ["\xF0\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8A"],
        ["\xF0\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8B"],
        ["\xF0\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8C"],
        ["\xF0\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8D"],
        ["\xF0\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8E"],
        ["\xF0\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x8F"],
        ["\xF0\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x90"],
        ["\xF0\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x91"],
        ["\xF0\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x92"],
        ["\xF0\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x93"],
        ["\xF0\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x94"],
        ["\xF0\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x95"],
        ["\xF0\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x96"],
        ["\xF0\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x97"],
        ["\xF0\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x98"],
        ["\xF0\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x99"],
        ["\xF0\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9A"],
        ["\xF0\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9B"],
        ["\xF0\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9C"],
        ["\xF0\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9D"],
        ["\xF0\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9E"],
        ["\xF0\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\x9F"],
        ["\xF1\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA0"],
        ["\xF1\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA1"],
        ["\xF1\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA2"],
        ["\xF1\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA3"],
        ["\xF1\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA4"],
        ["\xF1\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA5"],
        ["\xF1\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA6"],
        ["\xF1\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA7"],
        ["\xF1\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA8"],
        ["\xF1\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xA9"],
        ["\xF1\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAA"],
        ["\xF1\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAB"],
        ["\xF1\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAC"],
        ["\xF1\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAD"],
        ["\xF1\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAE"],
        ["\xF1\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xAF"],
        ["\xF1\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB0"],
        ["\xF1\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB1"],
        ["\xF1\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB2"],
        ["\xF1\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB3"],
        ["\xF1\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB4"],
        ["\xF1\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB5"],
        ["\xF1\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB6"],
        ["\xF1\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB7"],
        ["\xF1\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB8"],
        ["\xF1\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xB9"],
        ["\xF1\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBA"],
        ["\xF1\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBB"],
        ["\xF1\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBC"],
        ["\xF1\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBD"],
        ["\xF1\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBE"],
        ["\xF1\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xB9\xBF"],
        ["\xF1\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x80"],
        ["\xF1\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x81"],
        ["\xF1\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x82"],
        ["\xF1\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x83"],
        ["\xF1\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x84"],
        ["\xF1\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x85"],
        ["\xF1\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x86"],
        ["\xF1\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x87"],
        ["\xF1\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x88"],
        ["\xF1\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x89"],
        ["\xF1\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8A"],
        ["\xF1\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8B"],
        ["\xF1\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8C"],
        ["\xF1\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8D"],
        ["\xF1\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8E"],
        ["\xF1\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x8F"],
        ["\xF1\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x90"],
        ["\xF1\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x91"],
        ["\xF1\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x92"],
        ["\xF1\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x93"],
        ["\xF1\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x94"],
        ["\xF1\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x95"],
        ["\xF1\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x96"],
        ["\xF1\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x97"],
        ["\xF1\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x98"],
        ["\xF1\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x99"],
        ["\xF1\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9A"],
        ["\xF1\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9B"],
        ["\xF1\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9C"],
        ["\xF1\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9D"],
        ["\xF1\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9E"],
        ["\xF1\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\x9F"],
        ["\xF1\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA0"],
        ["\xF1\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA1"],
        ["\xF1\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA2"],
        ["\xF1\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA3"],
        ["\xF1\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA4"],
        ["\xF1\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA5"],
        ["\xF1\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA6"],
        ["\xF1\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA7"],
        ["\xF1\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA8"],
        ["\xF1\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xA9"],
        ["\xF1\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAA"],
        ["\xF1\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAB"],
        ["\xF1\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAC"],
        ["\xF1\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAD"],
        ["\xF1\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAE"],
        ["\xF1\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xAF"],
        ["\xF1\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB0"],
        ["\xF1\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB1"],
        ["\xF1\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB2"],
        ["\xF1\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB3"],
        ["\xF1\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB4"],
        ["\xF1\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB5"],
        ["\xF1\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB6"],
        ["\xF1\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB7"],
        ["\xF1\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB8"],
        ["\xF1\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xB9"],
        ["\xF1\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBA"],
        ["\xF1\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBB"],
        ["\xF1\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBC"],
        ["\xF1\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBD"],
        ["\xF2\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBE"],
        ["\xF2\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBA\xBF"],
        ["\xF2\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x80"],
        ["\xF2\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x81"],
        ["\xF2\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x82"],
        ["\xF2\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x83"],
        ["\xF2\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x84"],
        ["\xF2\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x85"],
        ["\xF2\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x86"],
        ["\xF2\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x87"],
        ["\xF2\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x88"],
        ["\xF2\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x89"],
        ["\xF2\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8A"],
        ["\xF2\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8B"],
        ["\xF2\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8C"],
        ["\xF2\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8D"],
        ["\xF2\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8E"],
        ["\xF2\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x8F"],
        ["\xF2\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x90"],
        ["\xF2\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x91"],
        ["\xF2\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x92"],
        ["\xF2\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x93"],
        ["\xF2\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x94"],
        ["\xF2\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x95"],
        ["\xF2\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x96"],
        ["\xF2\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x97"],
        ["\xF2\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x98"],
        ["\xF2\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x99"],
        ["\xF2\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9A"],
        ["\xF2\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9B"],
        ["\xF2\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9C"],
        ["\xF2\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9D"],
        ["\xF2\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9E"],
        ["\xF2\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\x9F"],
        ["\xF2\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA0"],
        ["\xF2\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA1"],
        ["\xF2\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA2"],
        ["\xF2\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA3"],
        ["\xF2\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA4"],
        ["\xF2\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA5"],
        ["\xF2\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA6"],
        ["\xF2\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA7"],
        ["\xF2\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA8"],
        ["\xF2\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xA9"],
        ["\xF2\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAA"],
        ["\xF2\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAB"],
        ["\xF2\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAC"],
        ["\xF2\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAD"],
        ["\xF2\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAE"],
        ["\xF2\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xAF"],
        ["\xF2\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB0"],
        ["\xF2\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB1"],
        ["\xF2\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB2"],
        ["\xF2\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB3"],
        ["\xF2\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB4"],
        ["\xF2\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB5"],
        ["\xF2\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB6"],
        ["\xF2\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB7"],
        ["\xF2\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB8"],
        ["\xF2\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xB9"],
        ["\xF2\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBA"],
        ["\xF2\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBB"],
        ["\xF2\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBC"],
        ["\xF2\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBD"],
        ["\xF2\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBE"],
        ["\xF2\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBB\xBF"],
        ["\xF2\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x80"],
        ["\xF2\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x81"],
        ["\xF2\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x82"],
        ["\xF2\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x83"],
        ["\xF2\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x84"],
        ["\xF2\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x85"],
        ["\xF2\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x86"],
        ["\xF2\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x87"],
        ["\xF2\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x88"],
        ["\xF2\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x89"],
        ["\xF2\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8A"],
        ["\xF2\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8B"],
        ["\xF2\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8C"],
        ["\xF2\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8D"],
        ["\xF2\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8E"],
        ["\xF2\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x8F"],
        ["\xF2\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x90"],
        ["\xF2\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x91"],
        ["\xF2\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x92"],
        ["\xF2\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x93"],
        ["\xF2\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x94"],
        ["\xF2\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x95"],
        ["\xF2\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x96"],
        ["\xF2\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x97"],
        ["\xF2\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x98"],
        ["\xF2\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x99"],
        ["\xF2\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9A"],
        ["\xF2\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9B"],
        ["\xF3\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9C"],
        ["\xF3\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9D"],
        ["\xF3\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9E"],
        ["\xF3\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\x9F"],
        ["\xF3\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA0"],
        ["\xF3\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA1"],
        ["\xF3\xA7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA2"],
        ["\xF3\xA8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA3"],
        ["\xF3\xA9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA4"],
        ["\xF3\xAA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA5"],
        ["\xF3\xAB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA6"],
        ["\xF3\xAC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA7"],
        ["\xF3\xAD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA8"],
        ["\xF3\xAE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xA9"],
        ["\xF3\xAF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAA"],
        ["\xF3\xB0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAB"],
        ["\xF3\xB1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAC"],
        ["\xF3\xB2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAD"],
        ["\xF3\xB3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAE"],
        ["\xF3\xB4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xAF"],
        ["\xF3\xB5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB0"],
        ["\xF3\xB6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB1"],
        ["\xF3\xB7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB2"],
        ["\xF3\xB8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB3"],
        ["\xF3\xB9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB4"],
        ["\xF3\xBA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB5"],
        ["\xF3\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB6"],
        ["\xF3\xBC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB7"],
        ["\xF3\xBD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB8"],
        ["\xF3\xBE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xB9"],
        ["\xF3\xBF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBA"],
        ["\xF3\xC0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBB"],
        ["\xF3\xC1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBC"],
        ["\xF3\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBD"],
        ["\xF3\xC3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBE"],
        ["\xF3\xC4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBC\xBF"],
        ["\xF3\xC5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x80"],
        ["\xF3\xC6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x81"],
        ["\xF3\xC7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x82"],
        ["\xF3\xC8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x83"],
        ["\xF3\xC9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x84"],
        ["\xF3\xCA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x85"],
        ["\xF3\xCB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x86"],
        ["\xF3\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x87"],
        ["\xF3\xCD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x88"],
        ["\xF3\xCE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x89"],
        ["\xF3\xCF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8A"],
        ["\xF3\xD0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8B"],
        ["\xF3\xD1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8C"],
        ["\xF3\xD2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8D"],
        ["\xF3\xD3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8E"],
        ["\xF3\xD4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x8F"],
        ["\xF3\xD5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x90"],
        ["\xF3\xD6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x91"],
        ["\xF3\xD7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x92"],
        ["\xF3\xD8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x93"],
        ["\xF3\xD9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x94"],
        ["\xF3\xDA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x95"],
        ["\xF3\xDB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x96"],
        ["\xF3\xDC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x97"],
        ["\xF3\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x98"],
        ["\xF3\xDE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x99"],
        ["\xF3\xDF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9A"],
        ["\xF3\xE0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9B"],
        ["\xF3\xE1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9C"],
        ["\xF3\xE2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9D"],
        ["\xF3\xE3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9E"],
        ["\xF3\xE4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\x9F"],
        ["\xF3\xE5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA0"],
        ["\xF3\xE6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA1"],
        ["\xF3\xE7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA2"],
        ["\xF3\xE8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA3"],
        ["\xF3\xE9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA4"],
        ["\xF3\xEA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA5"],
        ["\xF3\xEB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA6"],
        ["\xF3\xEC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA7"],
        ["\xF3\xED",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA8"],
        ["\xF3\xEE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xA9"],
        ["\xF3\xEF",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAA"],
        ["\xF3\xF0",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAB"],
        ["\xF3\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAC"],
        ["\xF3\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAD"],
        ["\xF3\xF3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAE"],
        ["\xF3\xF4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xAF"],
        ["\xF3\xF5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB0"],
        ["\xF3\xF6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB1"],
        ["\xF3\xF7",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB2"],
        ["\xF3\xF8",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB3"],
        ["\xF3\xF9",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB4"],
        ["\xF3\xFA",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB5"],
        ["\xF3\xFB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB6"],
        ["\xF3\xFC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB7"],
        ["\xF3\xFD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB8"],
        ["\xF3\xFE",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xB9"],
        ["\xF4\xA1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBA"],
        ["\xF4\xA2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBB"],
        ["\xF4\xA3",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBC"],
        ["\xF4\xA4",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBD"],
        ["\xF4\xA5",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBE"],
        ["\xF4\xA6",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB1\xBD\xBF"],
        ["\xD4\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB8"],
        ["\xDC\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xB9"],
        ["\xE4\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBA"],
        ["\xE3\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBB"],
        ["\xD9\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBC"],
        ["\xB1\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBD"],
        ["\xC2\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAB\xBF"],
        ["\xC3\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x80"],
        ["\xE4\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x81"],
        ["\xC2\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x82"],
        ["\xBC\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x83"],
        ["\xB0\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x84"],
        ["\xB0\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x85"],
        ["\xB0\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x87"],
        ["\xB0\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x88"],
        ["\xB0\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x89"],
        ["\xB0\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8A"],
        ["\xB1\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8B"],
        ["\xB1\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8C"],
        ["\xB1\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8D"],
        ["\xB1\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8E"],
        ["\xB1\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x8F"],
        ["\xB1\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x90"],
        ["\xB1\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x91"],
        ["\xB1\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x92"],
        ["\xB1\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x93"],
        ["\xB1\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x94"],
        ["\xB1\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x95"],
        ["\xB1\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x96"],
        ["\xB2\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x97"],
        ["\xB2\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x99"],
        ["\xB2\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9A"],
        ["\xB2\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9B"],
        ["\xB2\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9C"],
        ["\xB2\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9D"],
        ["\xB3\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\x9F"],
        ["\xB3\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA0"],
        ["\xB3\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA1"],
        ["\xB3\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA2"],
        ["\xB3\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA3"],
        ["\xB3\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA4"],
        ["\xB4\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA7"],
        ["\xB4\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA8"],
        ["\xB4\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xA9"],
        ["\xB4\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAA"],
        ["\xB5\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAC"],
        ["\xB5\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAE"],
        ["\xB5\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xAF"],
        ["\xB5\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB0"],
        ["\xB7\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB2"],
        ["\xB7\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB3"],
        ["\xB7\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB4"],
        ["\xB7\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB5"],
        ["\xB8\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xB9"],
        ["\xB8\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBA"],
        ["\xB8\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBB"],
        ["\xB8\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBC"],
        ["\xB8\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBD"],
        ["\xB8\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBE"],
        ["\xB9\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAC\xBF"],
        ["\xB9\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x80"],
        ["\xBA\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x81"],
        ["\xBA\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x82"],
        ["\xCD\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x83"],
        ["\xBA\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x84"],
        ["\xBA\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x86"],
        ["\xBB\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x87"],
        ["\xBB\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x88"],
        ["\xBB\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8A"],
        ["\xBB\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8D"],
        ["\xBB\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8E"],
        ["\xBB\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x8F"],
        ["\xBB\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x90"],
        ["\xBB\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x91"],
        ["\xBC\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x92"],
        ["\xBC\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x93"],
        ["\xBC\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x94"],
        ["\xBD\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x96"],
        ["\xBD\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x97"],
        ["\xBD\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x99"],
        ["\xBE\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9A"],
        ["\xBE\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9B"],
        ["\xBE\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9D"],
        ["\xBE\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9E"],
        ["\xBE\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\x9F"],
        ["\xBE\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA0"],
        ["\xBE\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA1"],
        ["\xBF\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA2"],
        ["\xBF\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA3"],
        ["\xC0\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA4"],
        ["\xC0\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA5"],
        ["\xC0\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA6"],
        ["\xC1\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA7"],
        ["\xC1\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xA9"],
        ["\xC1\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAA"],
        ["\xC1\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAC"],
        ["\xC2\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAD"],
        ["\xC2\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAE"],
        ["\xC2\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xAF"],
        ["\xC2\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB1"],
        ["\xC2\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB2"],
        ["\xC2\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB4"],
        ["\xC2\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB5"],
        ["\xC2\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB6"],
        ["\xC2\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB7"],
        ["\xC2\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB8"],
        ["\xC2\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xB9"],
        ["\xC2\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBA"],
        ["\xC3\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBC"],
        ["\xC3\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBD"],
        ["\xC3\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBE"],
        ["\xC3\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAD\xBF"],
        ["\xC3\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x81"],
        ["\xC3\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x82"],
        ["\xC4\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x84"],
        ["\xC4\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x86"],
        ["\xC4\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x87"],
        ["\xC4\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x88"],
        ["\xC5\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8A"],
        ["\xC5\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8B"],
        ["\xC5\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8C"],
        ["\xC5\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8E"],
        ["\xC6\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x8F"],
        ["\xC6\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x90"],
        ["\xC6\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x91"],
        ["\xC6\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x92"],
        ["\xC6\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x93"],
        ["\xC7\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x94"],
        ["\xC7\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x95"],
        ["\xC7\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x96"],
        ["\xC7\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x97"],
        ["\xC7\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x98"],
        ["\xC7\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x99"],
        ["\xC7\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9A"],
        ["\xC7\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9D"],
        ["\xC7\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9E"],
        ["\xC7\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\x9F"],
        ["\xC7\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA0"],
        ["\xC7\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA1"],
        ["\xC8\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA2"],
        ["\xC8\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA3"],
        ["\xC8\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA4"],
        ["\xC9\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA5"],
        ["\xC9\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA6"],
        ["\xC9\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA7"],
        ["\xC9\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xA9"],
        ["\xC9\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAA"],
        ["\xC9\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAB"],
        ["\xC9\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAC"],
        ["\xC9\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAD"],
        ["\xC9\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAE"],
        ["\xC9\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xAF"],
        ["\xCA\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB1"],
        ["\xCA\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB2"],
        ["\xCA\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB3"],
        ["\xCA\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB4"],
        ["\xCB\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB5"],
        ["\xCB\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB7"],
        ["\xCB\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB8"],
        ["\xCB\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xB9"],
        ["\xCB\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBA"],
        ["\xCB\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBB"],
        ["\xCB\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBC"],
        ["\xCC\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBD"],
        ["\xCB\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBE"],
        ["\xCC\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAE\xBF"],
        ["\xCC\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x80"],
        ["\xCC\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x81"],
        ["\xCC\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x82"],
        ["\xCC\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x83"],
        ["\xCC\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x84"],
        ["\xCC\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x85"],
        ["\xCD\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x87"],
        ["\xCE\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x89"],
        ["\xCE\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8B"],
        ["\xCE\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8C"],
        ["\xCE\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8E"],
        ["\xB3\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x8F"],
        ["\xCF\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x90"],
        ["\xCF\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x91"],
        ["\xCF\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x92"],
        ["\xCF\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x93"],
        ["\xD0\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x98"],
        ["\xD0\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9A"],
        ["\xD1\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9B"],
        ["\xD1\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9E"],
        ["\xD2\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\x9F"],
        ["\xD3\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA1"],
        ["\xD3\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA2"],
        ["\xD4\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA3"],
        ["\xD4\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA6"],
        ["\xD4\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA7"],
        ["\xD5\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xA8"],
        ["\xD7\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAA"],
        ["\xD8\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAC"],
        ["\xD8\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAD"],
        ["\xD8\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAE"],
        ["\xD8\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xAF"],
        ["\xD8\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB0"],
        ["\xD9\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB1"],
        ["\xD9\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB2"],
        ["\xD9\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB3"],
        ["\xDC\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xB9"],
        ["\xDD\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBA"],
        ["\xDD\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBB"],
        ["\xDD\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBC"],
        ["\xDD\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBD"],
        ["\xDE\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBE"],
        ["\xDE\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xAF\xBF"],
        ["\xDE\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x81"],
        ["\xDE\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x82"],
        ["\xDF\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x84"],
        ["\xDF\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x86"],
        ["\xE0\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x89"],
        ["\xE1\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x8C"],
        ["\xE2\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x90"],
        ["\xE3\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x91"],
        ["\xE3\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x92"],
        ["\xE3\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x93"],
        ["\xE3\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x94"],
        ["\xE3\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x95"],
        ["\xE3\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x96"],
        ["\xE3\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x97"],
        ["\xE3\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x98"],
        ["\xE3\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x99"],
        ["\xE3\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9A"],
        ["\xE3\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9B"],
        ["\xE3\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9C"],
        ["\xE3\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9D"],
        ["\xE3\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9E"],
        ["\xE3\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\x9F"],
        ["\xE3\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA0"],
        ["\xE3\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA1"],
        ["\xE3\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA2"],
        ["\xE4\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA3"],
        ["\xE3\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA4"],
        ["\xE3\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA5"],
        ["\xE4\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA6"],
        ["\xE4\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA7"],
        ["\xE4\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA8"],
        ["\xE4\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xA9"],
        ["\xE4\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAB"],
        ["\xE4\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAC"],
        ["\xE4\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAD"],
        ["\xE4\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAE"],
        ["\xE4\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xAF"],
        ["\xE4\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB0"],
        ["\xE4\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB2"],
        ["\xE4\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB3"],
        ["\xE4\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB4"],
        ["\xE4\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB5"],
        ["\xE4\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB6"],
        ["\xE4\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB7"],
        ["\xE5\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB8"],
        ["\xE5\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xB9"],
        ["\xE5\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBA"],
        ["\xE5\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBB"],
        ["\xE5\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBC"],
        ["\xE5\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBD"],
        ["\xE5\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB0\xBE"],
        ["\xE6\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x82"],
        ["\xE6\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x83"],
        ["\xE7\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x84"],
        ["\xE7\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x86"],
        ["\xE7\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x88"],
        ["\xE7\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8A"],
        ["\xE8\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8B"],
        ["\xE8\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8C"],
        ["\xE8\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x8F"],
        ["\xE9\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x92"],
        ["\xE9\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x94"],
        ["\xEA\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x95"],
        ["\xEA\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x97"],
        ["\xEA\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x98"],
        ["\xEA\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x99"],
        ["\xEB\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9A"],
        ["\xEB\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9B"],
        ["\xEB\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9C"],
        ["\xEC\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB1\x9E"],
        ["\xA1\xC2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB4\xB1"],
        ["\xA1\xDD",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB5\x8C"],
        ["\xA1\xF1",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB5\xA0"],
        ["\xA1\xF2",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB5\xA1"],
        ["\xA2\xCC",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xB6\x99"],
        ["\xA6\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBC\x9E"],
        ["\xAA\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB0"],
        ["\xAB\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB1"],
        ["\xAB\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB2"],
        ["\xAA\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB7"],
        ["\xAB\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB8"],
        ["\xAB\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xB9"],
        ["\xAB\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBA"],
        ["\xAB\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBB"],
        ["\xAB\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBC"],
        ["\xAB\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB2\xBF\xBD"],
        ["\xA2\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x82"],
        ["\xA2\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x83"],
        ["\xA2\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x84"],
        ["\xA2\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x85"],
        ["\xA2\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x86"],
        ["\xA2\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x89"],
        ["\xA2\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8A"],
        ["\xA2\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x8E"],
        ["\xA2\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x90"],
        ["\xA2\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x95"],
        ["\xAA\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x96"],
        ["\xAA\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x97"],
        ["\xAA\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x98"],
        ["\xAA\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x99"],
        ["\xAA\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9A"],
        ["\xAA\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9B"],
        ["\xA9\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9C"],
        ["\xAA\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9D"],
        ["\xAA\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9E"],
        ["\xAA\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\x9F"],
        ["\xAA\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA0"],
        ["\xAA\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA1"],
        ["\xAA\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA2"],
        ["\xAA\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA3"],
        ["\xAA\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA4"],
        ["\xAA\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA5"],
        ["\xAA\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA7"],
        ["\xAA\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA8"],
        ["\xAA\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xA9"],
        ["\xAA\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAA"],
        ["\xAA\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAB"],
        ["\xAA\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAC"],
        ["\xA9\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAD"],
        ["\xAA\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAE"],
        ["\xAA\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xAF"],
        ["\xAA\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB0"],
        ["\xAA\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB1"],
        ["\xAA\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB2"],
        ["\xA9\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB3"],
        ["\xA9\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB4"],
        ["\xAB\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB5"],
        ["\xAB\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB6"],
        ["\xAB\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB7"],
        ["\xAB\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB8"],
        ["\xAB\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xB9"],
        ["\xAB\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBA"],
        ["\xA9\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBB"],
        ["\xAB\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBC"],
        ["\xAB\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBD"],
        ["\xAB\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBE"],
        ["\xAB\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x80\xBF"],
        ["\xAB\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x80"],
        ["\xAB\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x81"],
        ["\xAB\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x82"],
        ["\xAB\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x83"],
        ["\xAB\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x84"],
        ["\xA9\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x85"],
        ["\xAB\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x86"],
        ["\xAB\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x87"],
        ["\xAB\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x88"],
        ["\xAB\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x89"],
        ["\xAB\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8A"],
        ["\xAB\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8B"],
        ["\xA9\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8C"],
        ["\xAB\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8D"],
        ["\xAB\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8E"],
        ["\xAB\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x8F"],
        ["\xAB\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x90"],
        ["\xAB\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x91"],
        ["\xA9\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x92"],
        ["\xAB\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x93"],
        ["\xAA\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x94"],
        ["\xAA\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x95"],
        ["\xAA\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x96"],
        ["\xAA\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x97"],
        ["\xAA\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x98"],
        ["\xAB\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x99"],
        ["\xAB\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9A"],
        ["\xAB\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9B"],
        ["\xAB\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9C"],
        ["\xAB\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9D"],
        ["\xAA\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9E"],
        ["\xA2\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\x9F"],
        ["\xA9\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA0"],
        ["\xAA\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA1"],
        ["\xAA\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA2"],
        ["\xAA\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA3"],
        ["\xAA\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA4"],
        ["\xAA\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA5"],
        ["\xAA\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA6"],
        ["\xAA\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA7"],
        ["\xAA\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA8"],
        ["\xAB\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xA9"],
        ["\xA2\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAA"],
        ["\xA9\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAB"],
        ["\xAB\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAC"],
        ["\xAB\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAD"],
        ["\xA2\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAE"],
        ["\xAB\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xAF"],
        ["\xAB\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB0"],
        ["\xAB\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB1"],
        ["\xAB\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB2"],
        ["\xA2\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB3"],
        ["\xAB\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB4"],
        ["\xAB\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB5"],
        ["\xAA\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB6"],
        ["\xAA\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB7"],
        ["\xAA\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB8"],
        ["\xAA\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xB9"],
        ["\xAA\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBA"],
        ["\xAA\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBB"],
        ["\xAA\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBC"],
        ["\xAA\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBD"],
        ["\xAA\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBE"],
        ["\xAA\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x81\xBF"],
        ["\xAA\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x80"],
        ["\xAA\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x81"],
        ["\xAA\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x82"],
        ["\xAA\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x83"],
        ["\xAA\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x84"],
        ["\xAB\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x85"],
        ["\xAB\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x86"],
        ["\xAB\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x87"],
        ["\xAB\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x88"],
        ["\xAB\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x89"],
        ["\xAB\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8A"],
        ["\xAB\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8B"],
        ["\xAB\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8C"],
        ["\xA9\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8D"],
        ["\xAB\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8E"],
        ["\xAB\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x8F"],
        ["\xAB\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x90"],
        ["\xAB\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x91"],
        ["\xAB\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x92"],
        ["\xAB\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x93"],
        ["\xAB\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x94"],
        ["\xA2\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x95"],
        ["\xAA\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x96"],
        ["\xAA\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x97"],
        ["\xAA\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x98"],
        ["\xAA\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x99"],
        ["\xAA\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9A"],
        ["\xAA\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9B"],
        ["\xAB\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9C"],
        ["\xAB\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9D"],
        ["\xAB\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9E"],
        ["\xAB\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\x9F"],
        ["\xAB\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA0"],
        ["\xAB\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xA1"],
        ["\xA9\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xB7"],
        ["\xA9\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x82\xBA"],
        ["\xA9\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x85"],
        ["\xA9\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x83\x86"],
        ["\xB0\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9A"],
        ["\xB0\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9B"],
        ["\xB0\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9C"],
        ["\xB0\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9E"],
        ["\xB0\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\x9F"],
        ["\xB0\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA1"],
        ["\xB0\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA2"],
        ["\xB0\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA3"],
        ["\xB0\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA4"],
        ["\xB0\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA6"],
        ["\xB0\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA7"],
        ["\xB0\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA8"],
        ["\xB0\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xA9"],
        ["\xB1\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAC"],
        ["\xB1\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xAF"],
        ["\xB1\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB0"],
        ["\xB1\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB2"],
        ["\xB1\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB3"],
        ["\xB1\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB4"],
        ["\xB1\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB5"],
        ["\xB1\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB7"],
        ["\xB1\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xB8"],
        ["\xB2\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBA"],
        ["\xB2\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBB"],
        ["\xB2\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBC"],
        ["\xB2\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBD"],
        ["\xB2\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x87\xBF"],
        ["\xB2\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x80"],
        ["\xB2\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x81"],
        ["\xB2\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x82"],
        ["\xB2\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x83"],
        ["\xB2\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x86"],
        ["\xB2\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x87"],
        ["\xB3\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8C"],
        ["\xB3\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8D"],
        ["\xB3\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8E"],
        ["\xB3\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x8F"],
        ["\xB3\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x91"],
        ["\xB3\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x93"],
        ["\xB3\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x94"],
        ["\xB3\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x95"],
        ["\xB3\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x96"],
        ["\xB3\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x97"],
        ["\xB3\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x99"],
        ["\xB3\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9B"],
        ["\xB3\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\x9E"],
        ["\xB4\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA2"],
        ["\xB4\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA4"],
        ["\xB4\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA5"],
        ["\xB4\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xA8"],
        ["\xB4\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAB"],
        ["\xB4\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAC"],
        ["\xB4\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAE"],
        ["\xB4\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xAF"],
        ["\xB4\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB0"],
        ["\xB5\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB1"],
        ["\xB5\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB2"],
        ["\xB5\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB3"],
        ["\xB5\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB5"],
        ["\xB5\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB7"],
        ["\xB5\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB8"],
        ["\xB5\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xB9"],
        ["\xB5\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBA"],
        ["\xB5\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBB"],
        ["\xB5\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBC"],
        ["\xB5\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x88\xBE"],
        ["\xB5\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x80"],
        ["\xB5\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x81"],
        ["\xB6\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x83"],
        ["\xB6\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x84"],
        ["\xB6\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x85"],
        ["\xB6\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x86"],
        ["\xB6\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x88"],
        ["\xB6\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8A"],
        ["\xB6\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8B"],
        ["\xB6\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8C"],
        ["\xB6\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8D"],
        ["\xB6\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8E"],
        ["\xB6\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x8F"],
        ["\xB6\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x90"],
        ["\xB6\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x91"],
        ["\xB6\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x92"],
        ["\xB6\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x93"],
        ["\xB7\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x94"],
        ["\xB7\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x97"],
        ["\xB7\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x98"],
        ["\xB7\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x99"],
        ["\xB7\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9A"],
        ["\xB7\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9B"],
        ["\xB7\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9C"],
        ["\xB7\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\x9D"],
        ["\xB7\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA0"],
        ["\xB7\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA3"],
        ["\xB7\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA4"],
        ["\xB7\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA5"],
        ["\xB7\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA6"],
        ["\xB7\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA7"],
        ["\xB7\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA8"],
        ["\xB7\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xA9"],
        ["\xB8\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAB"],
        ["\xB8\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAC"],
        ["\xB8\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAE"],
        ["\xB8\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xAF"],
        ["\xB8\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB2"],
        ["\xB8\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB4"],
        ["\xB8\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB5"],
        ["\xB8\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB6"],
        ["\xB8\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB7"],
        ["\xB8\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xB9"],
        ["\xB8\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBA"],
        ["\xB8\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBB"],
        ["\xB8\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBD"],
        ["\xB9\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBE"],
        ["\xB9\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x89\xBF"],
        ["\xB9\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x81"],
        ["\xB9\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x82"],
        ["\xB9\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x83"],
        ["\xB9\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x84"],
        ["\xB9\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x85"],
        ["\xB9\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x86"],
        ["\xB9\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x87"],
        ["\xB9\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x88"],
        ["\xB9\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x89"],
        ["\xB9\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8B"],
        ["\xB9\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8C"],
        ["\xBA\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8D"],
        ["\xBA\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x8F"],
        ["\xBA\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\x8A\x90"],
        ["\xBA\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xA8"],
        ["\xBA\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAA"],
        ["\xBA\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xAB"],
        ["\xBA\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB0"],
        ["\xBA\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB1"],
        ["\xBA\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB3"],
        ["\xBB\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB7"],
        ["\xBB\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB8"],
        ["\xBB\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xB9"],
        ["\xBB\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBA"],
        ["\xBB\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBB"],
        ["\xBB\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBD"],
        ["\xBB\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB8\xBF"],
        ["\xBB\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x80"],
        ["\xBB\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x83"],
        ["\xBB\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x86"],
        ["\xBB\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x89"],
        ["\xBB\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8B"],
        ["\xBB\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8C"],
        ["\xBB\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x8E"],
        ["\xBB\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB3\xB9\x90"],
        ["\xD7\xBB",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\x83\xBE"],
        ["\xBC\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x92"],
        ["\xBC\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x93"],
        ["\xBC\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x94"],
        ["\xBC\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x95"],
        ["\xBC\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x96"],
        ["\xBC\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x98"],
        ["\xBC\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9B"],
        ["\xBC\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9C"],
        ["\xBC\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9D"],
        ["\xBC\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\x9E"],
        ["\xBC\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA0"],
        ["\xBC\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA1"],
        ["\xBC\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA2"],
        ["\xBC\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA4"],
        ["\xBC\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA5"],
        ["\xBC\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA6"],
        ["\xBD\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA8"],
        ["\xBD\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xA9"],
        ["\xBD\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAA"],
        ["\xBD\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAB"],
        ["\xBD\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAC"],
        ["\xBD\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xAF"],
        ["\xBD\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB1"],
        ["\xBD\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB2"],
        ["\xBD\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB3"],
        ["\xBD\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB4"],
        ["\xBD\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB5"],
        ["\xBD\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB6"],
        ["\xBD\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB7"],
        ["\xBD\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xB8"],
        ["\xBD\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBA"],
        ["\xBD\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBB"],
        ["\xBE\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBC"],
        ["\xBE\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBD"],
        ["\xBE\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAE\xBF"],
        ["\xBE\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x80"],
        ["\xBE\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x81"],
        ["\xBE\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x82"],
        ["\xBE\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x86"],
        ["\xBE\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x88"],
        ["\xBE\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x89"],
        ["\xBF\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8B"],
        ["\xBF\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8D"],
        ["\xBF\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8E"],
        ["\xBF\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x8F"],
        ["\xBF\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x90"],
        ["\xBF\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x92"],
        ["\xBF\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x93"],
        ["\xBF\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x94"],
        ["\xBF\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x95"],
        ["\xBF\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x96"],
        ["\xBF\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x97"],
        ["\xBF\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x98"],
        ["\xBF\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x99"],
        ["\xC0\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9A"],
        ["\xC0\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9B"],
        ["\xC0\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9E"],
        ["\xC0\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\x9F"],
        ["\xC0\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA0"],
        ["\xC0\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA2"],
        ["\xC0\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA4"],
        ["\xC0\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA6"],
        ["\xC0\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA7"],
        ["\xC1\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA8"],
        ["\xC1\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xA9"],
        ["\xC1\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAA"],
        ["\xC1\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAB"],
        ["\xC1\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAC"],
        ["\xC1\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAD"],
        ["\xC1\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xAE"],
        ["\xC1\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB0"],
        ["\xC1\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB1"],
        ["\xC2\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xB8"],
        ["\xC2\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBA"],
        ["\xC2\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBB"],
        ["\xC2\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xAF\xBD"],
        ["\xC2\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x80"],
        ["\xC2\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x84"],
        ["\xC2\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x87"],
        ["\xC2\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x88"],
        ["\xC2\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x89"],
        ["\xC2\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8D"],
        ["\xC2\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x8F"],
        ["\xC2\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x91"],
        ["\xC2\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x92"],
        ["\xC2\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x94"],
        ["\xC2\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x96"],
        ["\xC2\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x98"],
        ["\xC2\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x99"],
        ["\xC3\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9A"],
        ["\xC3\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9B"],
        ["\xC3\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9C"],
        ["\xC3\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9D"],
        ["\xC3\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\x9E"],
        ["\xC3\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA0"],
        ["\xC3\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA2"],
        ["\xC3\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA6"],
        ["\xC3\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA7"],
        ["\xC3\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA8"],
        ["\xC3\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xA9"],
        ["\xC3\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAA"],
        ["\xC3\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAB"],
        ["\xC3\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAD"],
        ["\xC3\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAE"],
        ["\xC3\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xAF"],
        ["\xC4\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB1"],
        ["\xC4\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB2"],
        ["\xC4\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB3"],
        ["\xC4\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB4"],
        ["\xC4\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB5"],
        ["\xC4\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB6"],
        ["\xC4\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB7"],
        ["\xC4\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xB8"],
        ["\xC4\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBA"],
        ["\xC4\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBB"],
        ["\xC4\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBC"],
        ["\xC4\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBD"],
        ["\xC4\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB0\xBE"],
        ["\xC4\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x80"],
        ["\xC4\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x82"],
        ["\xC4\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x83"],
        ["\xC4\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8A"],
        ["\xC4\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8C"],
        ["\xC4\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8D"],
        ["\xC5\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x8F"],
        ["\xC5\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x90"],
        ["\xC5\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x91"],
        ["\xC5\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x92"],
        ["\xC5\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x93"],
        ["\xC5\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x94"],
        ["\xC5\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x98"],
        ["\xC5\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9A"],
        ["\xC5\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9B"],
        ["\xC5\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9C"],
        ["\xC5\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\x9E"],
        ["\xC5\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA1"],
        ["\xC5\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA2"],
        ["\xC5\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA3"],
        ["\xC5\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA4"],
        ["\xC5\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA5"],
        ["\xC5\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA6"],
        ["\xC5\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA7"],
        ["\xC5\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xA9"],
        ["\xC6\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAB"],
        ["\xC6\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAC"],
        ["\xC6\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xAD"],
        ["\xC6\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB2"],
        ["\xC6\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB3"],
        ["\xC6\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB4"],
        ["\xC6\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB5"],
        ["\xC6\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB6"],
        ["\xC6\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xB9"],
        ["\xC6\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBA"],
        ["\xC6\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBB"],
        ["\xC6\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBD"],
        ["\xC6\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB1\xBE"],
        ["\xC6\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x80"],
        ["\xC6\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x81"],
        ["\xC7\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x82"],
        ["\xC7\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x83"],
        ["\xC7\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x84"],
        ["\xC7\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x87"],
        ["\xC7\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x88"],
        ["\xC7\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x89"],
        ["\xC7\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8A"],
        ["\xC7\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8B"],
        ["\xC7\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8D"],
        ["\xC7\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x8F"],
        ["\xC7\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x92"],
        ["\xC7\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x93"],
        ["\xC7\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x95"],
        ["\xC7\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x96"],
        ["\xC7\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x97"],
        ["\xC7\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x99"],
        ["\xC7\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9A"],
        ["\xC7\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\x9E"],
        ["\xC7\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA0"],
        ["\xC8\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA2"],
        ["\xC8\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA3"],
        ["\xC8\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA4"],
        ["\xC8\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA5"],
        ["\xC8\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA7"],
        ["\xC8\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xA9"],
        ["\xC8\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAA"],
        ["\xC8\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAB"],
        ["\xC8\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAC"],
        ["\xC8\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAD"],
        ["\xC8\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAE"],
        ["\xC8\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xAF"],
        ["\xC8\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB0"],
        ["\xC8\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB1"],
        ["\xC8\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB3"],
        ["\xC8\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB4"],
        ["\xC8\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB5"],
        ["\xC8\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB6"],
        ["\xC8\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB7"],
        ["\xC8\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB8"],
        ["\xC8\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xB9"],
        ["\xC8\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBA"],
        ["\xC8\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBB"],
        ["\xC9\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBC"],
        ["\xC9\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB2\xBD"],
        ["\xC9\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x80"],
        ["\xC9\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x82"],
        ["\xC9\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x83"],
        ["\xC9\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x84"],
        ["\xC9\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x85"],
        ["\xC9\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x86"],
        ["\xC9\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x87"],
        ["\xC9\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x89"],
        ["\xC9\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8B"],
        ["\xC9\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8C"],
        ["\xC9\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8D"],
        ["\xC9\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x8E"],
        ["\xC9\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x90"],
        ["\xC9\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x91"],
        ["\xC9\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x92"],
        ["\xC9\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x94"],
        ["\xC9\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x99"],
        ["\xC9\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9B"],
        ["\xCA\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9C"],
        ["\xCA\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9E"],
        ["\xCA\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\x9F"],
        ["\xCA\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA0"],
        ["\xCA\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA2"],
        ["\xCA\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA3"],
        ["\xCA\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA5"],
        ["\xCA\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA7"],
        ["\xCA\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xA8"],
        ["\xCA\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAA"],
        ["\xCA\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAB"],
        ["\xCA\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xAE"],
        ["\xCB\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB0"],
        ["\xCB\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB1"],
        ["\xCB\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB3"],
        ["\xCB\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB4"],
        ["\xCB\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB5"],
        ["\xCB\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB6"],
        ["\xCB\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB7"],
        ["\xCB\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB8"],
        ["\xCB\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xB9"],
        ["\xCB\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBA"],
        ["\xCB\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBB"],
        ["\xCB\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBD"],
        ["\xCB\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB3\xBF"],
        ["\xCB\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x81"],
        ["\xCC\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x83"],
        ["\xCC\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x84"],
        ["\xCC\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x85"],
        ["\xCC\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x88"],
        ["\xCC\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8A"],
        ["\xCC\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8B"],
        ["\xCC\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8D"],
        ["\xCC\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8E"],
        ["\xCC\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x8F"],
        ["\xCC\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x90"],
        ["\xCC\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x91"],
        ["\xCC\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x92"],
        ["\xCC\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x93"],
        ["\xCC\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x95"],
        ["\xCC\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x96"],
        ["\xCC\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x97"],
        ["\xCC\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x98"],
        ["\xCC\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9A"],
        ["\xCC\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9B"],
        ["\xCC\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9D"],
        ["\xCC\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9E"],
        ["\xCC\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\x9F"],
        ["\xCC\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA0"],
        ["\xCC\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA1"],
        ["\xCC\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA2"],
        ["\xCC\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA3"],
        ["\xCC\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA4"],
        ["\xCC\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA5"],
        ["\xCC\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA6"],
        ["\xCC\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA7"],
        ["\xCD\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xA9"],
        ["\xCD\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAC"],
        ["\xCD\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAD"],
        ["\xCD\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xAF"],
        ["\xCD\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB0"],
        ["\xCD\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB1"],
        ["\xCD\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB2"],
        ["\xCD\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB3"],
        ["\xCD\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB4"],
        ["\xCD\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB5"],
        ["\xCD\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB6"],
        ["\xCD\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB7"],
        ["\xCD\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB8"],
        ["\xCD\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xB9"],
        ["\xCE\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBA"],
        ["\xCE\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBB"],
        ["\xCE\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBC"],
        ["\xCE\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBD"],
        ["\xCE\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBE"],
        ["\xCE\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB4\xBF"],
        ["\xCE\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x80"],
        ["\xCE\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x81"],
        ["\xCE\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x83"],
        ["\xCE\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x86"],
        ["\xCE\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x88"],
        ["\xCE\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x89"],
        ["\xCE\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8A"],
        ["\xCE\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8B"],
        ["\xCE\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8C"],
        ["\xCE\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8D"],
        ["\xCE\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8E"],
        ["\xCE\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x8F"],
        ["\xCE\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x90"],
        ["\xCE\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x91"],
        ["\xCE\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x92"],
        ["\xCE\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x94"],
        ["\xCE\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x95"],
        ["\xCE\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x96"],
        ["\xCE\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x97"],
        ["\xCE\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x98"],
        ["\xCF\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x99"],
        ["\xCF\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9A"],
        ["\xCF\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9B"],
        ["\xCF\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9C"],
        ["\xCF\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9D"],
        ["\xCF\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\x9E"],
        ["\xCF\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA0"],
        ["\xCF\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA4"],
        ["\xCF\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA5"],
        ["\xCF\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA7"],
        ["\xCF\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xA9"],
        ["\xD0\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAA"],
        ["\xD0\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAB"],
        ["\xD0\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAC"],
        ["\xD0\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAD"],
        ["\xD0\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xAE"],
        ["\xD0\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB0"],
        ["\xD0\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB1"],
        ["\xD0\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB4"],
        ["\xD0\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB5"],
        ["\xD0\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xB9"],
        ["\xD0\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB5\xBD"],
        ["\xD0\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x81"],
        ["\xD0\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x82"],
        ["\xD0\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x83"],
        ["\xD0\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x84"],
        ["\xD0\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x85"],
        ["\xD0\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x87"],
        ["\xD0\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x88"],
        ["\xD1\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x89"],
        ["\xD1\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8A"],
        ["\xD1\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8B"],
        ["\xD1\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8D"],
        ["\xD1\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8E"],
        ["\xD1\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x8F"],
        ["\xD1\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x91"],
        ["\xD1\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x92"],
        ["\xD1\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x94"],
        ["\xD1\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x95"],
        ["\xD1\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x96"],
        ["\xD1\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x98"],
        ["\xD1\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9A"],
        ["\xD2\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9C"],
        ["\xD2\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9D"],
        ["\xD2\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9E"],
        ["\xD2\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\x9F"],
        ["\xD2\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA0"],
        ["\xD2\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA1"],
        ["\xD2\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA4"],
        ["\xD2\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA5"],
        ["\xD2\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA6"],
        ["\xD2\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA7"],
        ["\xD2\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xA9"],
        ["\xD2\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAA"],
        ["\xD2\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAB"],
        ["\xD2\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAE"],
        ["\xD3\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xAF"],
        ["\xD3\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB0"],
        ["\xD3\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB1"],
        ["\xD3\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB2"],
        ["\xD3\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB3"],
        ["\xD3\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB4"],
        ["\xD3\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB5"],
        ["\xD3\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB6"],
        ["\xD3\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB7"],
        ["\xD3\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB8"],
        ["\xD3\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xB9"],
        ["\xD3\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBA"],
        ["\xD3\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBB"],
        ["\xD3\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBC"],
        ["\xD3\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBD"],
        ["\xD3\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB6\xBE"],
        ["\xD3\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x80"],
        ["\xD3\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x82"],
        ["\xD3\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x83"],
        ["\xD3\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x84"],
        ["\xD4\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x86"],
        ["\xD4\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x87"],
        ["\xD4\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x88"],
        ["\xD4\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8C"],
        ["\xD4\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8D"],
        ["\xD4\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8E"],
        ["\xD4\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x8F"],
        ["\xD4\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x91"],
        ["\xD4\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x93"],
        ["\xD4\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x95"],
        ["\xD5\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x98"],
        ["\xD5\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x99"],
        ["\xD5\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9A"],
        ["\xD5\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9B"],
        ["\xD5\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9C"],
        ["\xD5\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9D"],
        ["\xD5\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9E"],
        ["\xD5\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\x9F"],
        ["\xD5\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA0"],
        ["\xD5\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA2"],
        ["\xD5\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA3"],
        ["\xD5\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA4"],
        ["\xD5\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA5"],
        ["\xD5\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA6"],
        ["\xD5\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA8"],
        ["\xD5\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xA9"],
        ["\xD6\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAA"],
        ["\xD6\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAB"],
        ["\xD6\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAC"],
        ["\xD6\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAD"],
        ["\xD6\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAE"],
        ["\xD6\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xAF"],
        ["\xD6\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB0"],
        ["\xD6\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB1"],
        ["\xD6\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB2"],
        ["\xD6\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB3"],
        ["\xD6\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB4"],
        ["\xD7\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB8"],
        ["\xD7\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xB9"],
        ["\xD7\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBB"],
        ["\xD7\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBC"],
        ["\xD7\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBD"],
        ["\xD7\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBE"],
        ["\xD7\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB7\xBF"],
        ["\xD7\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x80"],
        ["\xD7\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x81"],
        ["\xD7\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x82"],
        ["\xD7\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x83"],
        ["\xD7\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x84"],
        ["\xD7\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x85"],
        ["\xD7\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x86"],
        ["\xD7\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x87"],
        ["\xD7\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x88"],
        ["\xD7\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8B"],
        ["\xD7\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8C"],
        ["\xD7\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8D"],
        ["\xD7\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8E"],
        ["\xD7\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x8F"],
        ["\xD7\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x90"],
        ["\xD7\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x91"],
        ["\xD8\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x92"],
        ["\xD8\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x93"],
        ["\xD8\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x94"],
        ["\xD8\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x95"],
        ["\xD8\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x96"],
        ["\xD8\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x97"],
        ["\xD8\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x98"],
        ["\xD8\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x99"],
        ["\xD8\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9B"],
        ["\xD8\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9C"],
        ["\xD8\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9E"],
        ["\xD8\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\x9F"],
        ["\xD8\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA0"],
        ["\xD8\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA1"],
        ["\xD8\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA5"],
        ["\xD8\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA6"],
        ["\xD8\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA7"],
        ["\xD8\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA8"],
        ["\xD8\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xA9"],
        ["\xD8\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAB"],
        ["\xD8\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAC"],
        ["\xD8\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAD"],
        ["\xD9\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xAF"],
        ["\xD9\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB0"],
        ["\xD9\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB1"],
        ["\xD9\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB2"],
        ["\xD9\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB4"],
        ["\xD9\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB6"],
        ["\xD9\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB7"],
        ["\xD9\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB8"],
        ["\xD9\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xB9"],
        ["\xD9\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBA"],
        ["\xD9\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBC"],
        ["\xD9\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBD"],
        ["\xD9\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBE"],
        ["\xDA\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB8\xBF"],
        ["\xDA\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x80"],
        ["\xDA\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x81"],
        ["\xDA\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x82"],
        ["\xDA\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x83"],
        ["\xDA\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x85"],
        ["\xDA\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x86"],
        ["\xDA\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x87"],
        ["\xDA\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x88"],
        ["\xDA\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8B"],
        ["\xDA\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8D"],
        ["\xDA\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8E"],
        ["\xDA\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x8F"],
        ["\xDA\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x90"],
        ["\xDA\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x91"],
        ["\xDA\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x92"],
        ["\xDA\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x93"],
        ["\xDA\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x94"],
        ["\xDB\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x95"],
        ["\xDB\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x96"],
        ["\xDB\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x97"],
        ["\xDB\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x98"],
        ["\xDB\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x99"],
        ["\xDB\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9A"],
        ["\xDB\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9C"],
        ["\xDB\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9E"],
        ["\xDB\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\x9F"],
        ["\xDB\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA0"],
        ["\xDB\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA1"],
        ["\xDB\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA2"],
        ["\xDC\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA3"],
        ["\xDC\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA4"],
        ["\xDC\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA5"],
        ["\xDC\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xA6"],
        ["\xDC\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAB"],
        ["\xDC\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAC"],
        ["\xDC\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAD"],
        ["\xDC\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAE"],
        ["\xDC\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xAF"],
        ["\xDC\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB0"],
        ["\xDC\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB1"],
        ["\xDC\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB2"],
        ["\xDD\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB3"],
        ["\xDD\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB5"],
        ["\xDD\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB6"],
        ["\xDD\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB7"],
        ["\xDD\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xB9"],
        ["\xDD\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBA"],
        ["\xDD\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBC"],
        ["\xDD\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBD"],
        ["\xDD\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBE"],
        ["\xDD\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xB9\xBF"],
        ["\xDD\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x80"],
        ["\xDE\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x85"],
        ["\xDE\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8A"],
        ["\xDE\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8B"],
        ["\xDE\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8C"],
        ["\xDE\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x8F"],
        ["\xDE\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x90"],
        ["\xDF\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x92"],
        ["\xDF\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x94"],
        ["\xDF\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x95"],
        ["\xDF\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x98"],
        ["\xDF\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x99"],
        ["\xDF\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9A"],
        ["\xDF\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9B"],
        ["\xDF\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9C"],
        ["\xDF\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9D"],
        ["\xE0\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9E"],
        ["\xE0\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\x9F"],
        ["\xE0\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA0"],
        ["\xE0\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA1"],
        ["\xE0\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA3"],
        ["\xE0\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA5"],
        ["\xE0\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA6"],
        ["\xE0\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA7"],
        ["\xE0\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA8"],
        ["\xE1\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xA9"],
        ["\xE1\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAB"],
        ["\xE1\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAC"],
        ["\xE1\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAD"],
        ["\xE1\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAE"],
        ["\xE1\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xAF"],
        ["\xE1\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB0"],
        ["\xE1\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB1"],
        ["\xE1\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB3"],
        ["\xE1\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB4"],
        ["\xE1\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB5"],
        ["\xE1\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB6"],
        ["\xE1\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB7"],
        ["\xE1\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB8"],
        ["\xE1\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xB9"],
        ["\xE1\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBA"],
        ["\xE2\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBB"],
        ["\xE2\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBC"],
        ["\xE2\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBD"],
        ["\xE2\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBE"],
        ["\xE2\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBA\xBF"],
        ["\xE2\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x81"],
        ["\xE2\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x82"],
        ["\xE2\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x84"],
        ["\xE2\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x86"],
        ["\xE2\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x87"],
        ["\xE2\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x88"],
        ["\xE2\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8A"],
        ["\xE2\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8B"],
        ["\xE2\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8C"],
        ["\xE2\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8D"],
        ["\xE2\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8E"],
        ["\xE2\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x8F"],
        ["\xE2\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x90"],
        ["\xE2\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x91"],
        ["\xE2\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x92"],
        ["\xE2\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x93"],
        ["\xE2\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x94"],
        ["\xE3\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x96"],
        ["\xE3\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9A"],
        ["\xE3\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9B"],
        ["\xE3\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\x9D"],
        ["\xE3\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA2"],
        ["\xE3\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA3"],
        ["\xE4\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA6"],
        ["\xE4\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA7"],
        ["\xE4\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xA8"],
        ["\xE4\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xAD"],
        ["\xE4\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB1"],
        ["\xE4\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB3"],
        ["\xE4\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB4"],
        ["\xE4\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB5"],
        ["\xE5\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB7"],
        ["\xE5\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB8"],
        ["\xE5\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xB9"],
        ["\xE5\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBC"],
        ["\xE5\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBD"],
        ["\xE5\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBE"],
        ["\xE5\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBB\xBF"],
        ["\xE5\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x80"],
        ["\xE5\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x81"],
        ["\xE5\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x82"],
        ["\xE5\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x83"],
        ["\xE5\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x84"],
        ["\xE6\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x85"],
        ["\xE6\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x86"],
        ["\xE6\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x87"],
        ["\xE6\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x88"],
        ["\xE6\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x89"],
        ["\xE6\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8A"],
        ["\xE6\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8B"],
        ["\xE6\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8C"],
        ["\xE6\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8D"],
        ["\xE6\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x8E"],
        ["\xE6\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x90"],
        ["\xE6\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x91"],
        ["\xE6\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x92"],
        ["\xE6\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x93"],
        ["\xE6\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x96"],
        ["\xE6\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x97"],
        ["\xE6\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x98"],
        ["\xE6\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x99"],
        ["\xE6\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9B"],
        ["\xE6\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\x9C"],
        ["\xE7\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA0"],
        ["\xE7\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA2"],
        ["\xE7\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA3"],
        ["\xE7\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA4"],
        ["\xE7\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA5"],
        ["\xE7\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA6"],
        ["\xE7\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA7"],
        ["\xE7\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA8"],
        ["\xE7\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xA9"],
        ["\xE7\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAA"],
        ["\xE7\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAB"],
        ["\xE7\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAC"],
        ["\xE7\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAE"],
        ["\xE7\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xAF"],
        ["\xE8\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB0"],
        ["\xE8\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB1"],
        ["\xE8\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB3"],
        ["\xE8\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB4"],
        ["\xE8\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB5"],
        ["\xE8\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB7"],
        ["\xE8\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xB8"],
        ["\xE8\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBB"],
        ["\xE8\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBC"],
        ["\xE8\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBD"],
        ["\xE8\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBE"],
        ["\xE8\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBC\xBF"],
        ["\xE9\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x81"],
        ["\xE9\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x82"],
        ["\xE9\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x83"],
        ["\xE9\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x84"],
        ["\xE9\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x85"],
        ["\xE9\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x86"],
        ["\xE9\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x87"],
        ["\xE9\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8A"],
        ["\xE9\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8B"],
        ["\xE9\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8C"],
        ["\xE9\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8D"],
        ["\xE9\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8E"],
        ["\xE9\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x8F"],
        ["\xE9\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x90"],
        ["\xEA\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x91"],
        ["\xEA\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x92"],
        ["\xEA\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x94"],
        ["\xEA\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x95"],
        ["\xEA\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x96"],
        ["\xEA\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x97"],
        ["\xEA\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9A"],
        ["\xEA\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9B"],
        ["\xEA\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9D"],
        ["\xEA\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9E"],
        ["\xEA\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\x9F"],
        ["\xEA\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA0"],
        ["\xEA\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA1"],
        ["\xEA\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA2"],
        ["\xEB\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA3"],
        ["\xEB\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA5"],
        ["\xEB\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA6"],
        ["\xEB\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA7"],
        ["\xEB\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA8"],
        ["\xEB\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xA9"],
        ["\xEB\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAA"],
        ["\xEB\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAC"],
        ["\xEB\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAD"],
        ["\xEB\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAE"],
        ["\xEB\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xAF"],
        ["\xEB\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB0"],
        ["\xEB\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB2"],
        ["\xEC\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB4"],
        ["\xEC\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB5"],
        ["\xEC\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB6"],
        ["\xEC\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB8"],
        ["\xEC\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xB9"],
        ["\xEC\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBA"],
        ["\xEC\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBC"],
        ["\xEC\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBD"],
        ["\xEC\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBE"],
        ["\xEC\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBD\xBF"],
        ["\xEC\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x80"],
        ["\xEC\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x81"],
        ["\xEC\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x82"],
        ["\xEC\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x83"],
        ["\xEC\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x84"],
        ["\xEC\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x85"],
        ["\xED\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x88"],
        ["\xED\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x89"],
        ["\xED\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8A"],
        ["\xED\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8B"],
        ["\xED\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8C"],
        ["\xED\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8D"],
        ["\xED\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x8E"],
        ["\xCD\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x92"],
        ["\xD4\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x93"],
        ["\xB0\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x95"],
        ["\xB0\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x97"],
        ["\xB0\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x99"],
        ["\xB0\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9A"],
        ["\xB0\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9B"],
        ["\xB0\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9C"],
        ["\xB0\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\x9F"],
        ["\xB0\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA2"],
        ["\xB0\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA3"],
        ["\xB0\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA4"],
        ["\xB0\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xA7"],
        ["\xB0\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAB"],
        ["\xB0\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAD"],
        ["\xB0\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xAF"],
        ["\xB0\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB0"],
        ["\xB0\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB1"],
        ["\xB0\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB3"],
        ["\xB0\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB5"],
        ["\xB0\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB6"],
        ["\xB0\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB7"],
        ["\xB0\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xB8"],
        ["\xB0\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBA"],
        ["\xB0\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBB"],
        ["\xB0\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBC"],
        ["\xB0\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBD"],
        ["\xB0\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBE"],
        ["\xB1\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBE\xBF"],
        ["\xB1\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x83"],
        ["\xB1\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x84"],
        ["\xB1\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x85"],
        ["\xB1\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x86"],
        ["\xB1\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x87"],
        ["\xB1\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x88"],
        ["\xB1\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8A"],
        ["\xB1\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8B"],
        ["\xB1\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8C"],
        ["\xB1\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8D"],
        ["\xB1\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x8E"],
        ["\xB1\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x94"],
        ["\xB1\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x95"],
        ["\xB1\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x96"],
        ["\xB1\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x97"],
        ["\xB1\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x98"],
        ["\xB1\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x99"],
        ["\xB2\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9D"],
        ["\xB2\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\x9E"],
        ["\xB2\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA0"],
        ["\xB2\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA1"],
        ["\xB2\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA2"],
        ["\xB2\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA5"],
        ["\xB2\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA7"],
        ["\xB2\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xA8"],
        ["\xB2\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAB"],
        ["\xB2\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xAD"],
        ["\xB2\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB0"],
        ["\xBA\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB2"],
        ["\xBA\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB3"],
        ["\xBA\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xB8"],
        ["\xBA\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBB"],
        ["\xBA\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBC"],
        ["\xBA\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB4\xBF\xBF"],
        ["\xBA\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x80"],
        ["\xBA\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x83"],
        ["\xBA\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x84"],
        ["\xBA\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x85"],
        ["\xBA\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x86"],
        ["\xBB\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x87"],
        ["\xBB\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8A"],
        ["\xBB\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8D"],
        ["\xBB\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x8E"],
        ["\xBB\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x92"],
        ["\xBB\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x93"],
        ["\xBB\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x98"],
        ["\xBB\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9A"],
        ["\xBB\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9D"],
        ["\xBB\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\x9F"],
        ["\xBB\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA2"],
        ["\xBB\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA3"],
        ["\xBB\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA4"],
        ["\xBB\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA5"],
        ["\xBB\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA8"],
        ["\xBB\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xA9"],
        ["\xBB\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAB"],
        ["\xBB\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xAE"],
        ["\xBB\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB0"],
        ["\xBB\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB1"],
        ["\xBB\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB3"],
        ["\xBB\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB4"],
        ["\xE6\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB5"],
        ["\xBB\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xB6"],
        ["\xBB\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBB"],
        ["\xBB\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBC"],
        ["\xBB\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBE"],
        ["\xBC\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x80\xBF"],
        ["\xBC\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x81"],
        ["\xBC\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x83"],
        ["\xBC\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x84"],
        ["\xBC\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x86"],
        ["\xBC\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x87"],
        ["\xBC\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x88"],
        ["\xBC\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x89"],
        ["\xBC\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8B"],
        ["\xBC\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8D"],
        ["\xBC\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8E"],
        ["\xBC\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x8F"],
        ["\xB2\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x90"],
        ["\xB2\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x92"],
        ["\xB2\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x93"],
        ["\xB2\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x98"],
        ["\xB2\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x99"],
        ["\xB2\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9B"],
        ["\xB2\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9C"],
        ["\xB2\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9D"],
        ["\xB2\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\x9F"],
        ["\xB3\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA2"],
        ["\xB3\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA3"],
        ["\xB3\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA4"],
        ["\xB3\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA5"],
        ["\xB3\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA6"],
        ["\xB3\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA8"],
        ["\xB3\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xA9"],
        ["\xB3\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAB"],
        ["\xB3\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAD"],
        ["\xB3\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xAF"],
        ["\xB3\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB1"],
        ["\xB3\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB4"],
        ["\xB3\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB5"],
        ["\xB3\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xB8"],
        ["\xB3\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBA"],
        ["\xB3\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBB"],
        ["\xB3\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBC"],
        ["\xB4\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBE"],
        ["\xB4\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x81\xBF"],
        ["\xB4\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x80"],
        ["\xB4\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x84"],
        ["\xB4\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x86"],
        ["\xB4\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x87"],
        ["\xB4\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x89"],
        ["\xB4\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8A"],
        ["\xB4\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8E"],
        ["\xB4\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x8F"],
        ["\xB4\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x92"],
        ["\xB4\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x95"],
        ["\xB4\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x97"],
        ["\xB4\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x98"],
        ["\xB4\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x99"],
        ["\xB5\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9C"],
        ["\xB5\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9D"],
        ["\xB5\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\x9F"],
        ["\xB5\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA0"],
        ["\xB5\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA1"],
        ["\xB5\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA2"],
        ["\xB5\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA3"],
        ["\xB5\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA4"],
        ["\xB5\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA7"],
        ["\xB5\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xA8"],
        ["\xB5\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAB"],
        ["\xB5\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAC"],
        ["\xB5\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAD"],
        ["\xB5\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAE"],
        ["\xB5\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xAF"],
        ["\xB5\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB1"],
        ["\xB5\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB2"],
        ["\xB5\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB4"],
        ["\xB5\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB5"],
        ["\xB5\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB6"],
        ["\xB5\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xB9"],
        ["\xB5\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBA"],
        ["\xB5\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBB"],
        ["\xB5\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x82\xBD"],
        ["\xB5\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x80"],
        ["\xB5\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x81"],
        ["\xB5\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x82"],
        ["\xB5\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x83"],
        ["\xB6\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x86"],
        ["\xB6\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x88"],
        ["\xB6\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8C"],
        ["\xB6\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8D"],
        ["\xB6\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x8E"],
        ["\xB6\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x90"],
        ["\xB6\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x91"],
        ["\xB6\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x92"],
        ["\xB6\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x94"],
        ["\xB6\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x95"],
        ["\xB6\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x96"],
        ["\xB6\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x98"],
        ["\xB6\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x99"],
        ["\xB6\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9A"],
        ["\xB6\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9B"],
        ["\xB6\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9C"],
        ["\xB6\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9D"],
        ["\xB6\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\x9E"],
        ["\xB6\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA0"],
        ["\xB6\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA1"],
        ["\xB6\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA2"],
        ["\xB6\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA3"],
        ["\xB7\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA4"],
        ["\xB7\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA5"],
        ["\xB7\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA7"],
        ["\xB7\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xA8"],
        ["\xB7\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAA"],
        ["\xB7\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAC"],
        ["\xB7\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAD"],
        ["\xB7\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAE"],
        ["\xB7\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xAF"],
        ["\xB7\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB1"],
        ["\xB7\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB2"],
        ["\xB7\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB3"],
        ["\xB7\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB4"],
        ["\xB7\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB5"],
        ["\xB7\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xB6"],
        ["\xB7\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBA"],
        ["\xB7\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBB"],
        ["\xB7\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBC"],
        ["\xB7\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x83\xBD"],
        ["\xB7\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x80"],
        ["\xB7\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x83"],
        ["\xB7\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x84"],
        ["\xB7\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x85"],
        ["\xB7\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x87"],
        ["\xB7\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x89"],
        ["\xB7\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8A"],
        ["\xB8\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8B"],
        ["\xB8\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8C"],
        ["\xB8\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8D"],
        ["\xB8\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8E"],
        ["\xB8\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x8F"],
        ["\xB8\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x91"],
        ["\xB8\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x92"],
        ["\xB8\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x93"],
        ["\xB8\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x94"],
        ["\xB8\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x96"],
        ["\xB8\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x97"],
        ["\xB8\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x98"],
        ["\xB8\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x99"],
        ["\xB8\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9A"],
        ["\xB8\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9C"],
        ["\xB8\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\x9F"],
        ["\xB8\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA0"],
        ["\xB8\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA1"],
        ["\xB8\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA3"],
        ["\xB8\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA4"],
        ["\xB8\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA7"],
        ["\xB8\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xA8"],
        ["\xB8\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xAD"],
        ["\xB8\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB1"],
        ["\xB9\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB3"],
        ["\xB9\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB4"],
        ["\xB9\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB5"],
        ["\xB9\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB6"],
        ["\xB9\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB7"],
        ["\xB9\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB8"],
        ["\xB9\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xB9"],
        ["\xB9\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBA"],
        ["\xB9\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBB"],
        ["\xB9\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBC"],
        ["\xB9\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBD"],
        ["\xB9\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBE"],
        ["\xB9\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x84\xBF"],
        ["\xB9\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x83"],
        ["\xB9\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x84"],
        ["\xB9\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x86"],
        ["\xB9\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x87"],
        ["\xB9\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x88"],
        ["\xB9\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x89"],
        ["\xB9\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8A"],
        ["\xB9\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8B"],
        ["\xB9\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8C"],
        ["\xB9\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8D"],
        ["\xB9\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8E"],
        ["\xB9\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x8F"],
        ["\xB9\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x90"],
        ["\xB9\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x91"],
        ["\xB9\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x92"],
        ["\xB9\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x93"],
        ["\xB9\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x94"],
        ["\xBA\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x95"],
        ["\xBA\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x96"],
        ["\xBA\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x97"],
        ["\xBA\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x98"],
        ["\xBA\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9A"],
        ["\xBA\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9B"],
        ["\xBA\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9C"],
        ["\xBA\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9D"],
        ["\xBA\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9E"],
        ["\xBA\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\x9F"],
        ["\xBA\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA0"],
        ["\xBA\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA1"],
        ["\xBA\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA2"],
        ["\xBA\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA3"],
        ["\xBA\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA4"],
        ["\xBA\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA5"],
        ["\xBA\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA6"],
        ["\xBA\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA7"],
        ["\xBA\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xA8"],
        ["\xBC\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAA"],
        ["\xBC\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAC"],
        ["\xBC\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAD"],
        ["\xBC\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xAE"],
        ["\xBC\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB0"],
        ["\xBC\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB1"],
        ["\xBC\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB2"],
        ["\xBC\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB6"],
        ["\xBC\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB7"],
        ["\xBC\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xB8"],
        ["\xBC\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBB"],
        ["\xBC\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBC"],
        ["\xBD\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBD"],
        ["\xBD\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBE"],
        ["\xBD\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x85\xBF"],
        ["\xBD\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x80"],
        ["\xBD\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x81"],
        ["\xBD\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x82"],
        ["\xBD\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x83"],
        ["\xBD\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x85"],
        ["\xBD\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x86"],
        ["\xBD\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x87"],
        ["\xBD\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x88"],
        ["\xBD\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x89"],
        ["\xBD\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8A"],
        ["\xBD\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8B"],
        ["\xBD\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8C"],
        ["\xBD\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8D"],
        ["\xBD\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x8E"],
        ["\xBD\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x90"],
        ["\xBD\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x92"],
        ["\xBD\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x94"],
        ["\xBD\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x95"],
        ["\xBD\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x97"],
        ["\xBD\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x98"],
        ["\xBD\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9A"],
        ["\xBD\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9B"],
        ["\xBE\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9C"],
        ["\xBE\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9D"],
        ["\xBE\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9E"],
        ["\xBE\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\x9F"],
        ["\xBE\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA2"],
        ["\xBE\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA3"],
        ["\xBE\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA4"],
        ["\xBE\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA5"],
        ["\xBE\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA6"],
        ["\xBE\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xA7"],
        ["\xBE\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAA"],
        ["\xBE\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAB"],
        ["\xBE\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAC"],
        ["\xBE\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAD"],
        ["\xBE\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xAF"],
        ["\xBE\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB0"],
        ["\xBE\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB1"],
        ["\xBE\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB3"],
        ["\xBE\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB4"],
        ["\xBE\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB5"],
        ["\xBE\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB7"],
        ["\xBE\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB8"],
        ["\xBE\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xB9"],
        ["\xBF\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBC"],
        ["\xBF\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBD"],
        ["\xBF\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBE"],
        ["\xBF\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x86\xBF"],
        ["\xBF\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x80"],
        ["\xBF\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x81"],
        ["\xBF\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x82"],
        ["\xBF\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x84"],
        ["\xBF\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x86"],
        ["\xBF\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x87"],
        ["\xBF\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8A"],
        ["\xBF\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8C"],
        ["\xBF\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8D"],
        ["\xBF\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8E"],
        ["\xBF\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x8F"],
        ["\xBF\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x93"],
        ["\xBF\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x95"],
        ["\xBF\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x96"],
        ["\xBF\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x97"],
        ["\xBF\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x98"],
        ["\xBF\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9D"],
        ["\xC0\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9E"],
        ["\xC0\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\x9F"],
        ["\xC0\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA1"],
        ["\xC0\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA2"],
        ["\xC0\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA4"],
        ["\xC0\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA5"],
        ["\xC0\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA6"],
        ["\xC0\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA7"],
        ["\xC0\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xA9"],
        ["\xC0\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAA"],
        ["\xC0\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAB"],
        ["\xC0\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAC"],
        ["\xC0\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAD"],
        ["\xC0\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAE"],
        ["\xC0\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xAF"],
        ["\xC0\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB0"],
        ["\xC0\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB1"],
        ["\xC0\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB2"],
        ["\xC0\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB3"],
        ["\xC0\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB4"],
        ["\xC0\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB5"],
        ["\xC0\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB6"],
        ["\xC0\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB8"],
        ["\xC1\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xB9"],
        ["\xC1\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBA"],
        ["\xC1\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBB"],
        ["\xC1\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBC"],
        ["\xC1\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBE"],
        ["\xC1\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x87\xBF"],
        ["\xC1\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x80"],
        ["\xC1\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x81"],
        ["\xC1\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x83"],
        ["\xC1\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x84"],
        ["\xC1\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x85"],
        ["\xC1\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x87"],
        ["\xC1\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8A"],
        ["\xC1\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8B"],
        ["\xC1\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8C"],
        ["\xC1\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8D"],
        ["\xC1\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x8F"],
        ["\xC1\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x90"],
        ["\xC1\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x91"],
        ["\xC1\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x94"],
        ["\xC1\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x95"],
        ["\xC1\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x96"],
        ["\xC1\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x97"],
        ["\xC1\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x99"],
        ["\xC1\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9A"],
        ["\xC1\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9C"],
        ["\xC1\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9D"],
        ["\xC2\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9E"],
        ["\xC2\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\x9F"],
        ["\xC2\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA0"],
        ["\xC2\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA1"],
        ["\xC2\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA2"],
        ["\xC2\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xA6"],
        ["\xC2\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAA"],
        ["\xC2\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAB"],
        ["\xC2\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAC"],
        ["\xC2\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAE"],
        ["\xC2\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xAF"],
        ["\xC2\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB0"],
        ["\xC2\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB1"],
        ["\xC2\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB4"],
        ["\xC2\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB5"],
        ["\xC2\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xB6"],
        ["\xC2\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBA"],
        ["\xC2\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x88\xBD"],
        ["\xC2\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x80"],
        ["\xC2\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x83"],
        ["\xC2\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x85"],
        ["\xC2\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x86"],
        ["\xC3\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8A"],
        ["\xC3\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x8B"],
        ["\xC3\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x91"],
        ["\xC3\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x92"],
        ["\xC3\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x93"],
        ["\xC3\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x94"],
        ["\xC3\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x95"],
        ["\xC3\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x96"],
        ["\xC3\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x98"],
        ["\xC3\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x99"],
        ["\xC3\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9E"],
        ["\xC3\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\x9F"],
        ["\xC3\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA1"],
        ["\xC3\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA2"],
        ["\xC3\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA5"],
        ["\xC3\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA7"],
        ["\xC3\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA8"],
        ["\xC3\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xA9"],
        ["\xC3\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAB"],
        ["\xC3\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAC"],
        ["\xC3\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAD"],
        ["\xC3\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAE"],
        ["\xC3\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xAF"],
        ["\xC3\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB1"],
        ["\xC3\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB3"],
        ["\xC3\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB5"],
        ["\xC3\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB6"],
        ["\xC3\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xB7"],
        ["\xC3\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBA"],
        ["\xC4\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x89\xBB"],
        ["\xC3\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x80"],
        ["\xC3\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x81"],
        ["\xC4\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x83"],
        ["\xC4\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x84"],
        ["\xC4\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x86"],
        ["\xC4\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x87"],
        ["\xC4\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x8E"],
        ["\xC4\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x91"],
        ["\xC4\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x92"],
        ["\xC4\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x93"],
        ["\xC4\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x94"],
        ["\xC4\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x95"],
        ["\xC4\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x96"],
        ["\xC4\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x98"],
        ["\xC4\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9A"],
        ["\xC4\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9C"],
        ["\xC4\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9D"],
        ["\xC4\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\x9E"],
        ["\xC4\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA0"],
        ["\xC4\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA1"],
        ["\xC4\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA8"],
        ["\xC4\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xA9"],
        ["\xC4\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAA"],
        ["\xC4\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAD"],
        ["\xC4\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAE"],
        ["\xC4\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xAF"],
        ["\xC4\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB0"],
        ["\xC4\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB2"],
        ["\xC5\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB4"],
        ["\xC5\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB5"],
        ["\xC5\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB7"],
        ["\xC5\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xB9"],
        ["\xC5\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBA"],
        ["\xC5\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBB"],
        ["\xC5\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBE"],
        ["\xC5\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8A\xBF"],
        ["\xC5\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x81"],
        ["\xC5\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x82"],
        ["\xC5\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x85"],
        ["\xC5\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x86"],
        ["\xC5\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x87"],
        ["\xC5\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x88"],
        ["\xC5\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x89"],
        ["\xC5\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8A"],
        ["\xC5\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8B"],
        ["\xC5\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8E"],
        ["\xC5\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x8F"],
        ["\xC5\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x90"],
        ["\xC5\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x92"],
        ["\xC5\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x95"],
        ["\xC5\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x96"],
        ["\xC5\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x97"],
        ["\xC5\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x99"],
        ["\xC5\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9B"],
        ["\xC5\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9C"],
        ["\xC5\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9D"],
        ["\xC5\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\x9F"],
        ["\xC6\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA2"],
        ["\xC6\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA3"],
        ["\xC6\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA5"],
        ["\xC6\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA6"],
        ["\xC6\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xA9"],
        ["\xC6\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAA"],
        ["\xC6\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAB"],
        ["\xC6\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAC"],
        ["\xC6\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAD"],
        ["\xC6\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAE"],
        ["\xC6\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xAF"],
        ["\xC6\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB1"],
        ["\xC6\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB2"],
        ["\xC6\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB3"],
        ["\xC6\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB4"],
        ["\xC6\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB7"],
        ["\xC6\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB8"],
        ["\xC6\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xB9"],
        ["\xC6\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBB"],
        ["\xC6\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBD"],
        ["\xC6\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBE"],
        ["\xC6\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8B\xBF"],
        ["\xC6\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x81"],
        ["\xC6\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x82"],
        ["\xC6\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x84"],
        ["\xC7\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x86"],
        ["\xC7\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x87"],
        ["\xC7\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x88"],
        ["\xC7\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8C"],
        ["\xC7\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8E"],
        ["\xC7\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x8F"],
        ["\xC7\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x90"],
        ["\xC7\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x91"],
        ["\xC7\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x92"],
        ["\xC7\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x94"],
        ["\xC7\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x96"],
        ["\xC7\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9B"],
        ["\xC7\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\x9C"],
        ["\xC7\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA4"],
        ["\xC7\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA7"],
        ["\xC7\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xA8"],
        ["\xC7\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAB"],
        ["\xC7\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAC"],
        ["\xC7\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAD"],
        ["\xC7\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAE"],
        ["\xC7\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xAF"],
        ["\xC7\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB0"],
        ["\xC7\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB3"],
        ["\xC7\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB5"],
        ["\xC7\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB6"],
        ["\xC7\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB7"],
        ["\xC7\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xB9"],
        ["\xC7\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBA"],
        ["\xC7\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBB"],
        ["\xC7\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBC"],
        ["\xC7\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBD"],
        ["\xC8\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8C\xBE"],
        ["\xC8\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x80"],
        ["\xC8\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x81"],
        ["\xC8\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x84"],
        ["\xC8\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x85"],
        ["\xC8\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x88"],
        ["\xC8\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x89"],
        ["\xC8\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8A"],
        ["\xC8\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8B"],
        ["\xC8\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8C"],
        ["\xC8\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8D"],
        ["\xC8\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x8F"],
        ["\xC8\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x90"],
        ["\xC8\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x92"],
        ["\xC8\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x93"],
        ["\xC8\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x94"],
        ["\xC8\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x96"],
        ["\xC8\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x98"],
        ["\xC8\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x99"],
        ["\xC8\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9A"],
        ["\xC8\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9C"],
        ["\xC8\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9D"],
        ["\xC8\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\x9E"],
        ["\xC8\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA1"],
        ["\xC9\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA3"],
        ["\xC9\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA4"],
        ["\xC9\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA5"],
        ["\xC9\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA7"],
        ["\xC9\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xA8"],
        ["\xC9\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAB"],
        ["\xC9\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAD"],
        ["\xC9\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xAF"],
        ["\xC9\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB0"],
        ["\xC9\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB2"],
        ["\xC9\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB4"],
        ["\xC9\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB5"],
        ["\xC9\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB7"],
        ["\xC9\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB8"],
        ["\xC9\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xB9"],
        ["\xC9\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBA"],
        ["\xC9\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBB"],
        ["\xC9\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBC"],
        ["\xC9\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBD"],
        ["\xC9\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8D\xBE"],
        ["\xC9\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x82"],
        ["\xC9\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x85"],
        ["\xC9\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x86"],
        ["\xC9\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x87"],
        ["\xC9\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x88"],
        ["\xC9\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x89"],
        ["\xC9\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8B"],
        ["\xC9\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8C"],
        ["\xC9\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x8E"],
        ["\xC9\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x90"],
        ["\xC9\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x91"],
        ["\xC9\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x92"],
        ["\xC9\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x93"],
        ["\xC9\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x95"],
        ["\xCA\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x98"],
        ["\xCA\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x99"],
        ["\xCA\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9A"],
        ["\xCA\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9B"],
        ["\xCA\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9D"],
        ["\xCA\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\x9E"],
        ["\xCA\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA0"],
        ["\xCA\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA1"],
        ["\xCA\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA2"],
        ["\xCA\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA3"],
        ["\xCA\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA4"],
        ["\xCA\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA7"],
        ["\xCA\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA8"],
        ["\xCA\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xA9"],
        ["\xCA\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAA"],
        ["\xCA\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAC"],
        ["\xCA\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAD"],
        ["\xCA\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xAF"],
        ["\xCA\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB1"],
        ["\xCA\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB2"],
        ["\xCA\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB3"],
        ["\xCA\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB4"],
        ["\xCA\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB5"],
        ["\xCA\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB7"],
        ["\xCA\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xB8"],
        ["\xCA\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBB"],
        ["\xCA\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8E\xBD"],
        ["\xCA\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x80"],
        ["\xCA\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x81"],
        ["\xCB\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x82"],
        ["\xCB\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x83"],
        ["\xCB\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x84"],
        ["\xCB\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x85"],
        ["\xCB\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x88"],
        ["\xCB\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x89"],
        ["\xCB\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8B"],
        ["\xCB\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8C"],
        ["\xCB\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8E"],
        ["\xCB\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x8F"],
        ["\xCB\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x91"],
        ["\xCB\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x92"],
        ["\xCB\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x93"],
        ["\xCB\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x95"],
        ["\xCB\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x96"],
        ["\xCB\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x99"],
        ["\xCB\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9A"],
        ["\xCB\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9B"],
        ["\xCB\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9C"],
        ["\xCB\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9E"],
        ["\xCB\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\x9F"],
        ["\xCB\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA0"],
        ["\xCB\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA1"],
        ["\xCB\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA2"],
        ["\xCB\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA3"],
        ["\xCB\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA4"],
        ["\xCB\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA5"],
        ["\xCB\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA6"],
        ["\xCB\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA7"],
        ["\xCB\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xA9"],
        ["\xCC\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAA"],
        ["\xCC\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAB"],
        ["\xCC\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAC"],
        ["\xCC\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAD"],
        ["\xCC\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xAF"],
        ["\xCC\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB0"],
        ["\xCC\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB1"],
        ["\xCC\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB2"],
        ["\xCC\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB3"],
        ["\xCC\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB4"],
        ["\xCC\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB5"],
        ["\xCC\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB6"],
        ["\xCC\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xB9"],
        ["\xCC\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBB"],
        ["\xCC\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBC"],
        ["\xCC\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBD"],
        ["\xCC\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x8F\xBF"],
        ["\xCC\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x80"],
        ["\xCC\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x81"],
        ["\xCC\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x82"],
        ["\xCC\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x85"],
        ["\xCC\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x86"],
        ["\xCC\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x87"],
        ["\xCC\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x88"],
        ["\xCC\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8A"],
        ["\xCD\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8C"],
        ["\xCD\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8D"],
        ["\xCD\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x8E"],
        ["\xCD\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x91"],
        ["\xCD\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x92"],
        ["\xCD\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x93"],
        ["\xCD\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x94"],
        ["\xCD\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x95"],
        ["\xCD\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x96"],
        ["\xCD\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x97"],
        ["\xCD\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9A"],
        ["\xCD\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9B"],
        ["\xCD\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9C"],
        ["\xCD\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9D"],
        ["\xCD\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\x9E"],
        ["\xCD\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA2"],
        ["\xCD\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA6"],
        ["\xCD\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA7"],
        ["\xCD\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA8"],
        ["\xCD\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xA9"],
        ["\xCD\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAC"],
        ["\xCD\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAD"],
        ["\xCD\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAE"],
        ["\xCD\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xAF"],
        ["\xCD\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB0"],
        ["\xCD\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB1"],
        ["\xCD\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB2"],
        ["\xCD\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB3"],
        ["\xCD\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB5"],
        ["\xCD\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB6"],
        ["\xCD\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xB9"],
        ["\xCD\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBA"],
        ["\xCD\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBB"],
        ["\xCD\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBD"],
        ["\xCE\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x90\xBF"],
        ["\xCD\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x80"],
        ["\xCE\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x83"],
        ["\xCE\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x85"],
        ["\xCE\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x86"],
        ["\xCE\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x88"],
        ["\xCE\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x89"],
        ["\xCE\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8C"],
        ["\xCE\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8D"],
        ["\xCE\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x8E"],
        ["\xCE\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x91"],
        ["\xCE\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x93"],
        ["\xCE\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x94"],
        ["\xCE\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x96"],
        ["\xCE\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x97"],
        ["\xCE\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x98"],
        ["\xCE\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x99"],
        ["\xCE\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\x9F"],
        ["\xCF\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA0"],
        ["\xCF\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA2"],
        ["\xCF\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA4"],
        ["\xCF\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA7"],
        ["\xCF\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA8"],
        ["\xCF\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xA9"],
        ["\xCF\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAC"],
        ["\xCF\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAD"],
        ["\xCF\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAE"],
        ["\xCF\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xAF"],
        ["\xCF\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB0"],
        ["\xCF\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB1"],
        ["\xCF\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB3"],
        ["\xCF\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB4"],
        ["\xCF\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB5"],
        ["\xCF\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB7"],
        ["\xCF\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB8"],
        ["\xCF\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xB9"],
        ["\xCF\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBA"],
        ["\xCF\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x91\xBE"],
        ["\xCF\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x80"],
        ["\xCF\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x82"],
        ["\xCF\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x83"],
        ["\xCF\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x84"],
        ["\xCF\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x85"],
        ["\xCF\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x86"],
        ["\xCF\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x87"],
        ["\xD0\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x88"],
        ["\xD0\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x89"],
        ["\xD0\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8A"],
        ["\xD0\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8B"],
        ["\xD0\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8C"],
        ["\xD0\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8D"],
        ["\xD0\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8E"],
        ["\xD0\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x8F"],
        ["\xD0\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x91"],
        ["\xD0\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x92"],
        ["\xD0\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x95"],
        ["\xD0\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x98"],
        ["\xD0\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x99"],
        ["\xD0\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9A"],
        ["\xD0\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9B"],
        ["\xD0\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9C"],
        ["\xD0\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9E"],
        ["\xD0\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\x9F"],
        ["\xD0\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA1"],
        ["\xD0\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA2"],
        ["\xD0\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA4"],
        ["\xD0\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA5"],
        ["\xD0\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA6"],
        ["\xD0\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA7"],
        ["\xD0\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA8"],
        ["\xD0\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xA9"],
        ["\xD0\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xAC"],
        ["\xD1\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB1"],
        ["\xD1\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB2"],
        ["\xD1\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB3"],
        ["\xD1\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB4"],
        ["\xD1\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB5"],
        ["\xD1\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB7"],
        ["\xD1\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB8"],
        ["\xD1\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xB9"],
        ["\xD1\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBA"],
        ["\xD1\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBB"],
        ["\xD1\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBC"],
        ["\xD1\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBD"],
        ["\xD1\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBE"],
        ["\xD1\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x92\xBF"],
        ["\xD1\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x80"],
        ["\xD1\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x81"],
        ["\xD1\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x82"],
        ["\xD1\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x83"],
        ["\xD1\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x84"],
        ["\xD1\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x85"],
        ["\xD1\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x86"],
        ["\xD1\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x87"],
        ["\xD1\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x88"],
        ["\xD1\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8B"],
        ["\xD1\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8C"],
        ["\xD1\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x8F"],
        ["\xD1\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x92"],
        ["\xD1\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x93"],
        ["\xD1\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x96"],
        ["\xD2\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x98"],
        ["\xD1\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x99"],
        ["\xD1\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9A"],
        ["\xD1\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9B"],
        ["\xD1\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9C"],
        ["\xD2\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\x9D"],
        ["\xD2\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA1"],
        ["\xD2\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA3"],
        ["\xD2\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA5"],
        ["\xD2\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA6"],
        ["\xD2\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA7"],
        ["\xD2\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xA8"],
        ["\xD2\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAB"],
        ["\xD2\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAC"],
        ["\xD2\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAD"],
        ["\xD2\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xAF"],
        ["\xD2\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB0"],
        ["\xD2\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB1"],
        ["\xD2\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB2"],
        ["\xD2\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB3"],
        ["\xD2\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB6"],
        ["\xD2\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB7"],
        ["\xD2\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB8"],
        ["\xD2\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xB9"],
        ["\xD2\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBB"],
        ["\xD2\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBC"],
        ["\xD2\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBD"],
        ["\xD2\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBE"],
        ["\xD2\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x93\xBF"],
        ["\xD2\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x81"],
        ["\xD2\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x82"],
        ["\xD2\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x84"],
        ["\xD3\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x85"],
        ["\xD3\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x86"],
        ["\xD3\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x87"],
        ["\xD3\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x89"],
        ["\xD3\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8D"],
        ["\xD3\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x8F"],
        ["\xD3\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x90"],
        ["\xD3\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x91"],
        ["\xD3\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x93"],
        ["\xD3\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x95"],
        ["\xD3\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x96"],
        ["\xD3\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x98"],
        ["\xD3\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9A"],
        ["\xD3\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9B"],
        ["\xD3\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9D"],
        ["\xD3\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9E"],
        ["\xD3\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\x9F"],
        ["\xD3\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA1"],
        ["\xD3\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA2"],
        ["\xD3\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA5"],
        ["\xD3\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA6"],
        ["\xD3\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA7"],
        ["\xD3\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xA8"],
        ["\xD3\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAC"],
        ["\xD3\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAD"],
        ["\xD3\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAE"],
        ["\xD3\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xAF"],
        ["\xD3\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB1"],
        ["\xD3\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB3"],
        ["\xD3\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB4"],
        ["\xD3\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB5"],
        ["\xD3\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB6"],
        ["\xD3\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB8"],
        ["\xD4\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xB9"],
        ["\xD4\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBA"],
        ["\xD4\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBB"],
        ["\xD4\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBE"],
        ["\xD4\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x94\xBF"],
        ["\xD4\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x80"],
        ["\xD4\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x81"],
        ["\xD4\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x82"],
        ["\xD4\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x86"],
        ["\xD4\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x87"],
        ["\xD4\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x88"],
        ["\xD4\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x89"],
        ["\xD4\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8A"],
        ["\xD4\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8B"],
        ["\xD4\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8C"],
        ["\xD4\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8D"],
        ["\xD4\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x8F"],
        ["\xD4\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x90"],
        ["\xD4\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x91"],
        ["\xD4\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x93"],
        ["\xD4\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x94"],
        ["\xD4\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x95"],
        ["\xD4\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x97"],
        ["\xD4\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x98"],
        ["\xD4\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x99"],
        ["\xD4\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9A"],
        ["\xD4\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9B"],
        ["\xD4\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9C"],
        ["\xD4\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\x9F"],
        ["\xD4\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA1"],
        ["\xD4\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA2"],
        ["\xD4\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA3"],
        ["\xD4\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA4"],
        ["\xD5\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA5"],
        ["\xD5\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA6"],
        ["\xD5\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xA8"],
        ["\xD5\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAB"],
        ["\xD5\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAC"],
        ["\xD5\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAD"],
        ["\xD5\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xAF"],
        ["\xD5\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB0"],
        ["\xD5\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB1"],
        ["\xD5\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB2"],
        ["\xD5\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB3"],
        ["\xD5\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB4"],
        ["\xD5\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB6"],
        ["\xD5\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB7"],
        ["\xD5\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB8"],
        ["\xD5\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xB9"],
        ["\xD5\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBA"],
        ["\xD5\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBB"],
        ["\xD5\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBC"],
        ["\xD5\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBD"],
        ["\xD5\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x95\xBF"],
        ["\xD5\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x80"],
        ["\xD5\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x81"],
        ["\xD5\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x84"],
        ["\xD5\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x86"],
        ["\xD5\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x87"],
        ["\xD5\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8A"],
        ["\xD5\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x8B"],
        ["\xD6\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x92"],
        ["\xD6\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x93"],
        ["\xD6\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x94"],
        ["\xD6\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x96"],
        ["\xD6\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x97"],
        ["\xD6\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x98"],
        ["\xD6\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9C"],
        ["\xD6\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\x9E"],
        ["\xD6\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA0"],
        ["\xD6\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA1"],
        ["\xD6\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA3"],
        ["\xD6\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA4"],
        ["\xD6\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA6"],
        ["\xD6\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xA8"],
        ["\xD6\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAA"],
        ["\xD6\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAC"],
        ["\xD6\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAE"],
        ["\xD6\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xAF"],
        ["\xD6\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB3"],
        ["\xD6\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB4"],
        ["\xD6\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB5"],
        ["\xD6\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB7"],
        ["\xD6\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xB8"],
        ["\xD6\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBA"],
        ["\xD6\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBC"],
        ["\xD7\x21",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x96\xBE"],
        ["\xD7\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x80"],
        ["\xD7\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x84"],
        ["\xD7\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x85"],
        ["\xD7\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8B"],
        ["\xD7\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8C"],
        ["\xD7\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8D"],
        ["\xD7\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x8E"],
        ["\xD7\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x90"],
        ["\xD7\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x91"],
        ["\xD7\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x92"],
        ["\xD7\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x93"],
        ["\xD7\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x94"],
        ["\xD7\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x95"],
        ["\xD7\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x96"],
        ["\xD7\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x97"],
        ["\xD7\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x98"],
        ["\xD7\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x99"],
        ["\xD7\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9A"],
        ["\xD7\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9C"],
        ["\xD7\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9D"],
        ["\xD7\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9E"],
        ["\xD7\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\x9F"],
        ["\xD7\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA0"],
        ["\xD7\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA1"],
        ["\xD7\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA2"],
        ["\xD8\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA7"],
        ["\xD8\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA8"],
        ["\xD8\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xA9"],
        ["\xD8\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAA"],
        ["\xD8\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAB"],
        ["\xD8\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAC"],
        ["\xD8\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAD"],
        ["\xD8\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAE"],
        ["\xD8\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xAF"],
        ["\xD8\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB1"],
        ["\xD8\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB2"],
        ["\xD8\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB3"],
        ["\xD8\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB4"],
        ["\xD8\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB7"],
        ["\xD8\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB8"],
        ["\xD8\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xB9"],
        ["\xD8\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBA"],
        ["\xD8\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBB"],
        ["\xD8\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBC"],
        ["\xD8\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBD"],
        ["\xD8\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x97\xBE"],
        ["\xD8\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x80"],
        ["\xD8\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x81"],
        ["\xD8\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x82"],
        ["\xD8\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x83"],
        ["\xD8\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x84"],
        ["\xD8\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x88"],
        ["\xD8\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x89"],
        ["\xD8\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8C"],
        ["\xD8\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8D"],
        ["\xD9\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x8F"],
        ["\xD9\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x90"],
        ["\xD9\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x91"],
        ["\xD9\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x92"],
        ["\xD9\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x93"],
        ["\xD9\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x94"],
        ["\xD9\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x95"],
        ["\xD9\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x96"],
        ["\xD9\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x98"],
        ["\xD9\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x99"],
        ["\xD9\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9A"],
        ["\xD9\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9B"],
        ["\xD9\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9C"],
        ["\xD9\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\x9D"],
        ["\xD9\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA1"],
        ["\xD9\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA3"],
        ["\xD9\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA4"],
        ["\xD9\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA5"],
        ["\xD9\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA7"],
        ["\xD9\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA8"],
        ["\xD9\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xA9"],
        ["\xD9\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAA"],
        ["\xD9\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAB"],
        ["\xD9\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAC"],
        ["\xD9\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAD"],
        ["\xD9\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xAE"],
        ["\xD9\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB2"],
        ["\xD9\x6B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB3"],
        ["\xD9\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB4"],
        ["\xD9\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB5"],
        ["\xD9\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB6"],
        ["\xD9\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xB8"],
        ["\xD9\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBA"],
        ["\xD9\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBB"],
        ["\xDA\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBC"],
        ["\xDA\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBD"],
        ["\xDA\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBE"],
        ["\xDA\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x98\xBF"],
        ["\xDA\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x81"],
        ["\xDA\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x84"],
        ["\xDA\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x86"],
        ["\xDA\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x88"],
        ["\xDA\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x89"],
        ["\xDA\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8A"],
        ["\xDA\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8B"],
        ["\xDA\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8C"],
        ["\xDA\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x8F"],
        ["\xDA\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x90"],
        ["\xDA\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x91"],
        ["\xDA\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x93"],
        ["\xDA\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x95"],
        ["\xDA\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x96"],
        ["\xDA\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x97"],
        ["\xDA\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x98"],
        ["\xDA\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x99"],
        ["\xDA\x65",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9A"],
        ["\xDA\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9B"],
        ["\xDA\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9C"],
        ["\xDA\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\x9F"],
        ["\xDA\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA0"],
        ["\xDA\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA1"],
        ["\xDA\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA2"],
        ["\xDA\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA3"],
        ["\xDA\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA4"],
        ["\xDA\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA5"],
        ["\xDA\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA6"],
        ["\xDA\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA7"],
        ["\xDB\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA8"],
        ["\xDB\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xA9"],
        ["\xDB\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAA"],
        ["\xDB\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAB"],
        ["\xDB\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAC"],
        ["\xDB\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAE"],
        ["\xDB\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xAF"],
        ["\xDB\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB0"],
        ["\xDB\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB1"],
        ["\xDB\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB5"],
        ["\xDB\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB6"],
        ["\xDB\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB7"],
        ["\xDB\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB8"],
        ["\xDB\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xB9"],
        ["\xDB\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBC"],
        ["\xDB\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBE"],
        ["\xDB\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x99\xBF"],
        ["\xDB\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x81"],
        ["\xDB\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x83"],
        ["\xDB\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x86"],
        ["\xDB\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x87"],
        ["\xDB\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x88"],
        ["\xDB\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x89"],
        ["\xDB\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8A"],
        ["\xDB\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8B"],
        ["\xDB\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8C"],
        ["\xDB\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8D"],
        ["\xDB\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8E"],
        ["\xDB\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x8F"],
        ["\xDC\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x90"],
        ["\xDC\x28",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x92"],
        ["\xDC\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x93"],
        ["\xDC\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x94"],
        ["\xDC\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x95"],
        ["\xDC\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x98"],
        ["\xDC\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9B"],
        ["\xDC\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9D"],
        ["\xDC\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9E"],
        ["\xDC\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\x9F"],
        ["\xDC\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA0"],
        ["\xDC\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA2"],
        ["\xDC\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA3"],
        ["\xDC\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA4"],
        ["\xDC\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA5"],
        ["\xDC\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA6"],
        ["\xDC\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xA8"],
        ["\xDC\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAC"],
        ["\xDC\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAD"],
        ["\xDC\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xAE"],
        ["\xDC\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB1"],
        ["\xDD\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB3"],
        ["\xDD\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB4"],
        ["\xDD\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB5"],
        ["\xDD\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB6"],
        ["\xDD\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB7"],
        ["\xDD\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB8"],
        ["\xDD\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xB9"],
        ["\xDD\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBA"],
        ["\xDD\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBC"],
        ["\xDD\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBD"],
        ["\xDD\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBE"],
        ["\xDD\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9A\xBF"],
        ["\xDD\x47",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x81"],
        ["\xDD\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x82"],
        ["\xDD\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x85"],
        ["\xDD\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x86"],
        ["\xDD\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x87"],
        ["\xDD\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x88"],
        ["\xDD\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x89"],
        ["\xDD\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8A"],
        ["\xDD\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8B"],
        ["\xDE\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8C"],
        ["\xDE\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8E"],
        ["\xDE\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x8F"],
        ["\xDE\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x91"],
        ["\xDE\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x92"],
        ["\xDE\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x94"],
        ["\xDE\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x95"],
        ["\xDE\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x96"],
        ["\xDE\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x97"],
        ["\xDE\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9A"],
        ["\xDE\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9B"],
        ["\xDE\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9D"],
        ["\xDE\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9E"],
        ["\xDE\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\x9F"],
        ["\xDE\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA0"],
        ["\xDE\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA1"],
        ["\xDE\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA2"],
        ["\xDE\x63",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA3"],
        ["\xDE\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA5"],
        ["\xDE\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA8"],
        ["\xDE\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xA9"],
        ["\xDE\x6A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xAA"],
        ["\xDE\x6D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xAB"],
        ["\xDF\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB6"],
        ["\xDF\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB7"],
        ["\xDF\x32",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB8"],
        ["\xDF\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xB9"],
        ["\xDF\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9B\xBE"],
        ["\xDF\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x80"],
        ["\xDF\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x81"],
        ["\xDF\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x82"],
        ["\xDF\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x83"],
        ["\xDF\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x85"],
        ["\xDF\x62",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x86"],
        ["\xDF\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x87"],
        ["\xDF\x73",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x8B"],
        ["\xDF\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\x91"],
        ["\xE1\x3C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9C\xBB"],
        ["\xE1\x5B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x86"],
        ["\xE1\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x87"],
        ["\xE2\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9D\x9C"],
        ["\xE3\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x83"],
        ["\xE3\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x8B"],
        ["\xE3\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x93"],
        ["\xE3\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9E\x95"],
        ["\xE5\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x80"],
        ["\xE6\x25",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\x9D"],
        ["\xE6\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA5"],
        ["\xE6\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA6"],
        ["\xE6\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xA9"],
        ["\xE6\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xAD"],
        ["\xE6\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\x9F\xB9"],
        ["\xE7\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x84"],
        ["\xE7\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x86"],
        ["\xE7\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x90"],
        ["\xE7\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x98"],
        ["\xE7\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9A"],
        ["\xE7\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9B"],
        ["\xE7\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA0\x9E"],
        ["\xE8\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x81"],
        ["\xE8\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x90"],
        ["\xE9\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\x9D"],
        ["\xE9\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA0"],
        ["\xE9\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA3"],
        ["\xE9\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA5"],
        ["\xE9\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA6"],
        ["\xE9\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xA7"],
        ["\xE9\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAA"],
        ["\xE9\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xAE"],
        ["\xE9\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB0"],
        ["\xE9\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB1"],
        ["\xE9\x68",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB2"],
        ["\xE9\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB3"],
        ["\xE9\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB6"],
        ["\xE9\x70",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB7"],
        ["\xE9\x72",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB8"],
        ["\xE9\x7E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xB9"],
        ["\xEA\x26",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBA"],
        ["\xEA\x29",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBB"],
        ["\xEA\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBC"],
        ["\xEA\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBD"],
        ["\xEA\x2E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBE"],
        ["\xEA\x31",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA1\xBF"],
        ["\xEA\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x80"],
        ["\xEA\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x81"],
        ["\xEA\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x83"],
        ["\xEA\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x84"],
        ["\xEA\x44",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x85"],
        ["\xEA\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x86"],
        ["\xEA\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x87"],
        ["\xEA\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x88"],
        ["\xEA\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8A"],
        ["\xEA\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8B"],
        ["\xEA\x64",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x8C"],
        ["\xEA\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x90"],
        ["\xEA\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x91"],
        ["\xEA\x6C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x92"],
        ["\xEA\x6F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x93"],
        ["\xEA\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x94"],
        ["\xEA\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x95"],
        ["\xEA\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x96"],
        ["\xEA\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x97"],
        ["\xEA\x79",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x98"],
        ["\xEA\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x99"],
        ["\xEA\x7B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9A"],
        ["\xEB\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9D"],
        ["\xEA\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\x9F"],
        ["\xEB\x2A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA1"],
        ["\xEB\x2B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA2"],
        ["\xEB\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA3"],
        ["\xEB\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA4"],
        ["\xEB\x30",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA6"],
        ["\xEB\x33",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA7"],
        ["\xEB\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA8"],
        ["\xEB\x36",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xA9"],
        ["\xEB\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAB"],
        ["\xEB\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAC"],
        ["\xEB\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAD"],
        ["\xEB\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAE"],
        ["\xEB\x50",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xAF"],
        ["\xEB\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB1"],
        ["\xEB\x41",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB2"],
        ["\xEB\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB4"],
        ["\xEB\x48",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB5"],
        ["\xEB\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB6"],
        ["\xEB\x4A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB7"],
        ["\xEB\x4C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB8"],
        ["\xEB\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xB9"],
        ["\xEB\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBA"],
        ["\xEB\x51",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBB"],
        ["\xEB\x53",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBD"],
        ["\xEB\x54",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBE"],
        ["\xEB\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA2\xBF"],
        ["\xEB\x56",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x80"],
        ["\xEB\x59",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x82"],
        ["\xEB\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x83"],
        ["\xEB\x5D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x84"],
        ["\xEB\x5E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x85"],
        ["\xEB\x5F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x87"],
        ["\xEB\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x88"],
        ["\xEB\x61",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x89"],
        ["\xEB\x67",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8D"],
        ["\xEB\x6E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x8F"],
        ["\xEB\x71",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x90"],
        ["\xEB\x74",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x91"],
        ["\xEB\x76",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x92"],
        ["\xEB\x78",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x94"],
        ["\xEB\x7C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x98"],
        ["\xEB\x7D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x99"],
        ["\xEC\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9A"],
        ["\xEC\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9B"],
        ["\xEC\x27",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9C"],
        ["\xEC\x2F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9E"],
        ["\xEC\x37",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\x9F"],
        ["\xEC\x34",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA0"],
        ["\xEC\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA1"],
        ["\xEC\x38",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA3"],
        ["\xEC\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA4"],
        ["\xEC\x3A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA5"],
        ["\xEC\x3E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA6"],
        ["\xEC\x40",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA7"],
        ["\xEC\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA8"],
        ["\xEC\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xA9"],
        ["\xEC\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAB"],
        ["\xEC\x4D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAD"],
        ["\xEC\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xAE"],
        ["\xEC\x57",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB1"],
        ["\xEC\x58",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB2"],
        ["\xEC\x5A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB3"],
        ["\xEC\x5C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB5"],
        ["\xEC\x60",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB6"],
        ["\xEC\x66",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB7"],
        ["\xEC\x69",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xB8"],
        ["\xEC\x75",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBC"],
        ["\xEC\x77",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBD"],
        ["\xEC\x7A",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBE"],
        ["\xED\x22",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA3\xBF"],
        ["\xED\x23",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x80"],
        ["\xED\x24",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x82"],
        ["\xED\x2C",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x83"],
        ["\xED\x2D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x84"],
        ["\xED\x35",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x85"],
        ["\xED\x39",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x86"],
        ["\xED\x3B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x87"],
        ["\xED\x3D",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x88"],
        ["\xED\x3F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x89"],
        ["\xED\x42",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8A"],
        ["\xED\x43",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8B"],
        ["\xED\x45",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8C"],
        ["\xED\x46",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8D"],
        ["\xED\x49",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x8E"],
        ["\xED\x4B",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x90"],
        ["\xED\x4E",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x92"],
        ["\xED\x4F",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x94"],
        ["\xED\x52",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x95"],
        ["\xED\x55",'utf8jp','letsj',{'INPUT_LAYOUT'=>'D'},"\xF3\xB5\xA4\x96"],
    );
    $|=1; print "1..",scalar(@test),"\n"; my $testno=1; sub ok { print $_[0]?'ok ':'not ok ',$testno++,$_[1]?" - $_[1]\n":"\n" }
}

use Jacode4e;

for my $test (@test) {
    my($give,$OUTPUT_encoding,$INPUT_encoding,$option,$want) = @{$test};
    my $got = $give;
    my $return = Jacode4e::convert(\$got,$OUTPUT_encoding,$INPUT_encoding,$option);

    my $option_content = '';
    if (defined $option) {
        my @option_content = ();
        push(@option_content, qq{INPUT_LAYOUT=>$option->{'INPUT_LAYOUT'}})        if exists $option->{'INPUT_LAYOUT'};
        push(@option_content, qq{OUTPUT_SHIFTING=>$option->{'OUTPUT_SHIFTING'}})  if exists $option->{'OUTPUT_SHIFTING'};
        push(@option_content, qq{SPACE=>@{[uc unpack('H*',$option->{'SPACE'})]}}) if exists $option->{'SPACE'};
        push(@option_content, qq{GETA=>@{[uc unpack('H*',$option->{'GETA'})]}})   if exists $option->{'GETA'};
        $option_content = "{@option_content}";
    }

    ok(($return > 0) and ($got eq $want),
        sprintf(qq{$INPUT_encoding(%s) to $OUTPUT_encoding(%s), $option_content => return=$return,got=(%s)},
            uc unpack('H*',$give),
            uc unpack('H*',$want),
            uc unpack('H*',$got),
        )
    );
}

__END__
