package Graphics::Grid::Grob::Zero;

# ABSTRACT: Empty grob with minimal size

use Graphics::Grid::Class;

our $VERSION = '0.001'; # VERSION

use Graphics::Grid::Extents;
use Graphics::Grid::Unit;

with qw(
  Graphics::Grid::Grob
);

method _build_elems () { 0 }

method _draw ($grid) { }

method extents ($grid) {
    my $zero = Graphics::Grid::Unit->new(0, 'cm');
    return Graphics::Grid::Extents->new(
        x      => $zero,
        y      => $zero,
        width  => $zero,
        height => $zero,
    );
}

1;

__END__

=pod

=encoding UTF-8

=head1 NAME

Graphics::Grid::Grob::Zero - Empty grob with minimal size

=head1 VERSION

version 0.001

=head1 SYNOPSIS

    use Graphics::Grid::Grob::Zero;
    my $grob = Graphics::Grid::Grob::Zero->new();

    # or use the function interface
    use Graphics::Grid::Functions qw(:all);
    my $grob = zero_grob();

=head1 DESCRIPTION

A "zero" grob is even simpler than a "null" grob.

=head1 SEE ALSO

L<Graphics::Grid::Grob>

=head1 AUTHOR

Stephan Loyd <sloyd@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2018-2023 by Stephan Loyd.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
