use 5.014;

use strict;
use warnings;
use routines;

use Test::Auto;
use Test::More;

=name

Pluto::Engine

=cut

=abstract

Functional Scripting for Perl 5

=cut

=includes

method: call

=cut

=synopsis

  package Example;

  use Pluto::Engine;

  my $engine = Pluto::Engine->new(
    package => 'example',
    config => { tempdir => { package => 'File/Temp' } },
  );

=cut

=libraries

Types::Standard

=cut

=attributes

package: ro, req, Str
config: ro, opt, HashRef
library: ro, opt, Object
services: ro, opt, Object
space: ro, opt, Object

=cut

=description

This package provides an engine for resolving dependencies and dispatching
function calls, enabling a functional programming environment for Perl 5. See
L<Rewire> for more information on dependency injection.

=cut

=method call

The call method dispatches a routine call.

=signature call

call(Str | Object $invocant, Str $routine, Any @arguments) : Any

=example-1 call

  # given: synopsis

  $engine->call('File::Temp', 'new', 'File::Temp');

=cut

package main;

my $test = testauto(__FILE__);

my $subs = $test->standard;

$subs->synopsis(fun($tryable) {
  ok my $result = $tryable->result;
  ok $result->isa('Pluto::Engine');
  is $result->package, 'example';

  $result
});

$subs->example(-1, 'call', 'method', fun($tryable) {
  ok my $result = $tryable->result;

  $result
});

ok 1 and done_testing;
