# Generated by default/object.tt
package Paws::ACMPCA::AccessMethod;
  use Moose;
  has AccessMethodType => (is => 'ro', isa => 'Str');
  has CustomObjectIdentifier => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ACMPCA::AccessMethod

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ACMPCA::AccessMethod object:

  $service_obj->Method(Att1 => { AccessMethodType => $value, ..., CustomObjectIdentifier => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ACMPCA::AccessMethod object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessMethodType

=head1 DESCRIPTION

Describes the type and format of extension access. Only one of
C<CustomObjectIdentifier> or C<AccessMethodType> may be provided.
Providing both results in C<InvalidArgsException>.

=head1 ATTRIBUTES


=head2 AccessMethodType => Str

Specifies the C<AccessMethod>.


=head2 CustomObjectIdentifier => Str

An object identifier (OID) specifying the C<AccessMethod>. The OID must
satisfy the regular expression shown below. For more information, see
NIST's definition of Object Identifier (OID)
(https://csrc.nist.gov/glossary/term/Object_Identifier).



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ACMPCA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

