# Generated by default/object.tt
package Paws::Amplify::App;
  use Moose;
  has AppArn => (is => 'ro', isa => 'Str', request_name => 'appArn', traits => ['NameInRequest'], required => 1);
  has AppId => (is => 'ro', isa => 'Str', request_name => 'appId', traits => ['NameInRequest'], required => 1);
  has AutoBranchCreationConfig => (is => 'ro', isa => 'Paws::Amplify::AutoBranchCreationConfig', request_name => 'autoBranchCreationConfig', traits => ['NameInRequest']);
  has AutoBranchCreationPatterns => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'autoBranchCreationPatterns', traits => ['NameInRequest']);
  has BasicAuthCredentials => (is => 'ro', isa => 'Str', request_name => 'basicAuthCredentials', traits => ['NameInRequest']);
  has BuildSpec => (is => 'ro', isa => 'Str', request_name => 'buildSpec', traits => ['NameInRequest']);
  has CreateTime => (is => 'ro', isa => 'Str', request_name => 'createTime', traits => ['NameInRequest'], required => 1);
  has CustomHeaders => (is => 'ro', isa => 'Str', request_name => 'customHeaders', traits => ['NameInRequest']);
  has CustomRules => (is => 'ro', isa => 'ArrayRef[Paws::Amplify::CustomRule]', request_name => 'customRules', traits => ['NameInRequest']);
  has DefaultDomain => (is => 'ro', isa => 'Str', request_name => 'defaultDomain', traits => ['NameInRequest'], required => 1);
  has Description => (is => 'ro', isa => 'Str', request_name => 'description', traits => ['NameInRequest'], required => 1);
  has EnableAutoBranchCreation => (is => 'ro', isa => 'Bool', request_name => 'enableAutoBranchCreation', traits => ['NameInRequest']);
  has EnableBasicAuth => (is => 'ro', isa => 'Bool', request_name => 'enableBasicAuth', traits => ['NameInRequest'], required => 1);
  has EnableBranchAutoBuild => (is => 'ro', isa => 'Bool', request_name => 'enableBranchAutoBuild', traits => ['NameInRequest'], required => 1);
  has EnableBranchAutoDeletion => (is => 'ro', isa => 'Bool', request_name => 'enableBranchAutoDeletion', traits => ['NameInRequest']);
  has EnvironmentVariables => (is => 'ro', isa => 'Paws::Amplify::EnvironmentVariables', request_name => 'environmentVariables', traits => ['NameInRequest'], required => 1);
  has IamServiceRoleArn => (is => 'ro', isa => 'Str', request_name => 'iamServiceRoleArn', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest'], required => 1);
  has Platform => (is => 'ro', isa => 'Str', request_name => 'platform', traits => ['NameInRequest'], required => 1);
  has ProductionBranch => (is => 'ro', isa => 'Paws::Amplify::ProductionBranch', request_name => 'productionBranch', traits => ['NameInRequest']);
  has Repository => (is => 'ro', isa => 'Str', request_name => 'repository', traits => ['NameInRequest'], required => 1);
  has Tags => (is => 'ro', isa => 'Paws::Amplify::TagMap', request_name => 'tags', traits => ['NameInRequest']);
  has UpdateTime => (is => 'ro', isa => 'Str', request_name => 'updateTime', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Amplify::App

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Amplify::App object:

  $service_obj->Method(Att1 => { AppArn => $value, ..., UpdateTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Amplify::App object:

  $result = $service_obj->Method(...);
  $result->Att1->AppArn

=head1 DESCRIPTION

Represents the different branches of a repository for building,
deploying, and hosting an Amplify app.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AppArn => Str

The Amazon Resource Name (ARN) of the Amplify app.


=head2 B<REQUIRED> AppId => Str

The unique ID of the Amplify app.


=head2 AutoBranchCreationConfig => L<Paws::Amplify::AutoBranchCreationConfig>

Describes the automated branch creation configuration for the Amplify
app.


=head2 AutoBranchCreationPatterns => ArrayRef[Str|Undef]

Describes the automated branch creation glob patterns for the Amplify
app.


=head2 BasicAuthCredentials => Str

The basic authorization credentials for branches for the Amplify app.


=head2 BuildSpec => Str

Describes the content of the build specification (build spec) for the
Amplify app.


=head2 B<REQUIRED> CreateTime => Str

Creates a date and time for the Amplify app.


=head2 CustomHeaders => Str

Describes the custom HTTP headers for the Amplify app.


=head2 CustomRules => ArrayRef[L<Paws::Amplify::CustomRule>]

Describes the custom redirect and rewrite rules for the Amplify app.


=head2 B<REQUIRED> DefaultDomain => Str

The default domain for the Amplify app.


=head2 B<REQUIRED> Description => Str

The description for the Amplify app.


=head2 EnableAutoBranchCreation => Bool

Enables automated branch creation for the Amplify app.


=head2 B<REQUIRED> EnableBasicAuth => Bool

Enables basic authorization for the Amplify app's branches.


=head2 B<REQUIRED> EnableBranchAutoBuild => Bool

Enables the auto-building of branches for the Amplify app.


=head2 EnableBranchAutoDeletion => Bool

Automatically disconnect a branch in the Amplify Console when you
delete a branch from your Git repository.


=head2 B<REQUIRED> EnvironmentVariables => L<Paws::Amplify::EnvironmentVariables>

The environment variables for the Amplify app.


=head2 IamServiceRoleArn => Str

The AWS Identity and Access Management (IAM) service role for the
Amazon Resource Name (ARN) of the Amplify app.


=head2 B<REQUIRED> Name => Str

The name for the Amplify app.


=head2 B<REQUIRED> Platform => Str

The platform for the Amplify app.


=head2 ProductionBranch => L<Paws::Amplify::ProductionBranch>

Describes the information about a production branch of the Amplify app.


=head2 B<REQUIRED> Repository => Str

The repository for the Amplify app.


=head2 Tags => L<Paws::Amplify::TagMap>

The tag for the Amplify app.


=head2 B<REQUIRED> UpdateTime => Str

Updates the date and time for the Amplify app.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Amplify>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

