
package Paws::Amplify::UpdateBranch;
  use Moose;
  has AppId => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'appId', required => 1);
  has BackendEnvironmentArn => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'backendEnvironmentArn');
  has BasicAuthCredentials => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'basicAuthCredentials');
  has BranchName => (is => 'ro', isa => 'Str', traits => ['ParamInURI'], uri_name => 'branchName', required => 1);
  has BuildSpec => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'buildSpec');
  has Description => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'description');
  has DisplayName => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'displayName');
  has EnableAutoBuild => (is => 'ro', isa => 'Bool', traits => ['NameInRequest'], request_name => 'enableAutoBuild');
  has EnableBasicAuth => (is => 'ro', isa => 'Bool', traits => ['NameInRequest'], request_name => 'enableBasicAuth');
  has EnableNotification => (is => 'ro', isa => 'Bool', traits => ['NameInRequest'], request_name => 'enableNotification');
  has EnablePerformanceMode => (is => 'ro', isa => 'Bool', traits => ['NameInRequest'], request_name => 'enablePerformanceMode');
  has EnablePullRequestPreview => (is => 'ro', isa => 'Bool', traits => ['NameInRequest'], request_name => 'enablePullRequestPreview');
  has EnvironmentVariables => (is => 'ro', isa => 'Paws::Amplify::EnvironmentVariables', traits => ['NameInRequest'], request_name => 'environmentVariables');
  has Framework => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'framework');
  has PullRequestEnvironmentName => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'pullRequestEnvironmentName');
  has Stage => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'stage');
  has Ttl => (is => 'ro', isa => 'Str', traits => ['NameInRequest'], request_name => 'ttl');

  use MooseX::ClassAttribute;

  class_has _api_call => (isa => 'Str', is => 'ro', default => 'UpdateBranch');
  class_has _api_uri  => (isa => 'Str', is => 'ro', default => '/apps/{appId}/branches/{branchName}');
  class_has _api_method  => (isa => 'Str', is => 'ro', default => 'POST');
  class_has _returns => (isa => 'Str', is => 'ro', default => 'Paws::Amplify::UpdateBranchResult');
1;

### main pod documentation begin ###

=head1 NAME

Paws::Amplify::UpdateBranch - Arguments for method UpdateBranch on L<Paws::Amplify>

=head1 DESCRIPTION

This class represents the parameters used for calling the method UpdateBranch on the
L<AWS Amplify|Paws::Amplify> service. Use the attributes of this class
as arguments to method UpdateBranch.

You shouldn't make instances of this class. Each attribute should be used as a named argument in the call to UpdateBranch.

=head1 SYNOPSIS

    my $amplify = Paws->service('Amplify');
    my $UpdateBranchResult = $amplify->UpdateBranch(
      AppId                    => 'MyAppId',
      BranchName               => 'MyBranchName',
      BackendEnvironmentArn    => 'MyBackendEnvironmentArn',    # OPTIONAL
      BasicAuthCredentials     => 'MyBasicAuthCredentials',     # OPTIONAL
      BuildSpec                => 'MyBuildSpec',                # OPTIONAL
      Description              => 'MyDescription',              # OPTIONAL
      DisplayName              => 'MyDisplayName',              # OPTIONAL
      EnableAutoBuild          => 1,                            # OPTIONAL
      EnableBasicAuth          => 1,                            # OPTIONAL
      EnableNotification       => 1,                            # OPTIONAL
      EnablePerformanceMode    => 1,                            # OPTIONAL
      EnablePullRequestPreview => 1,                            # OPTIONAL
      EnvironmentVariables     => {
        'MyEnvKey' => 'MyEnvValue',    # key: max: 255, value: max: 1000
      },    # OPTIONAL
      Framework                  => 'MyFramework',                    # OPTIONAL
      PullRequestEnvironmentName => 'MyPullRequestEnvironmentName',   # OPTIONAL
      Stage                      => 'PRODUCTION',                     # OPTIONAL
      Ttl                        => 'MyTTL',                          # OPTIONAL
    );

    # Results:
    my $Branch = $UpdateBranchResult->Branch;

    # Returns a L<Paws::Amplify::UpdateBranchResult> object.

Values for attributes that are native types (Int, String, Float, etc) can passed as-is (scalar values). Values for complex Types (objects) can be passed as a HashRef. The keys and values of the hashref will be used to instance the underlying object.
For the AWS API documentation, see L<https://docs.aws.amazon.com/goto/WebAPI/amplify/UpdateBranch>

=head1 ATTRIBUTES


=head2 B<REQUIRED> AppId => Str

The unique ID for an Amplify app.



=head2 BackendEnvironmentArn => Str

The Amazon Resource Name (ARN) for a backend environment that is part
of an Amplify app.



=head2 BasicAuthCredentials => Str

The basic authorization credentials for the branch.



=head2 B<REQUIRED> BranchName => Str

The name for the branch.



=head2 BuildSpec => Str

The build specification (build spec) for the branch.



=head2 Description => Str

The description for the branch.



=head2 DisplayName => Str

The display name for a branch. This is used as the default domain
prefix.



=head2 EnableAutoBuild => Bool

Enables auto building for the branch.



=head2 EnableBasicAuth => Bool

Enables basic authorization for the branch.



=head2 EnableNotification => Bool

Enables notifications for the branch.



=head2 EnablePerformanceMode => Bool

Enables performance mode for the branch.

Performance mode optimizes for faster hosting performance by keeping
content cached at the edge for a longer interval. When performance mode
is enabled, hosting configuration or code changes can take up to 10
minutes to roll out.



=head2 EnablePullRequestPreview => Bool

Enables pull request previews for this branch.



=head2 EnvironmentVariables => L<Paws::Amplify::EnvironmentVariables>

The environment variables for the branch.



=head2 Framework => Str

The framework for the branch.



=head2 PullRequestEnvironmentName => Str

The Amplify environment name for the pull request.



=head2 Stage => Str

Describes the current stage for the branch.

Valid values are: C<"PRODUCTION">, C<"BETA">, C<"DEVELOPMENT">, C<"EXPERIMENTAL">, C<"PULL_REQUEST">

=head2 Ttl => Str

The content Time to Live (TTL) for the website in seconds.




=head1 SEE ALSO

This class forms part of L<Paws>, documenting arguments for method UpdateBranch in L<Paws::Amplify>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

