# Generated by default/object.tt
package Paws::Appflow::TriggerProperties;
  use Moose;
  has Scheduled => (is => 'ro', isa => 'Paws::Appflow::ScheduledTriggerProperties');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::TriggerProperties

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::TriggerProperties object:

  $service_obj->Method(Att1 => { Scheduled => $value, ..., Scheduled => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::TriggerProperties object:

  $result = $service_obj->Method(...);
  $result->Att1->Scheduled

=head1 DESCRIPTION

Specifies the configuration details that control the trigger for a
flow. Currently, these settings only apply to the C<Scheduled> trigger
type.

=head1 ATTRIBUTES


=head2 Scheduled => L<Paws::Appflow::ScheduledTriggerProperties>

Specifies the configuration details of a schedule-triggered flow as
defined by the user.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

