# Generated by default/object.tt
package Paws::ApplicationMigration::LaunchedInstance;
  use Moose;
  has Ec2InstanceID => (is => 'ro', isa => 'Str', request_name => 'ec2InstanceID', traits => ['NameInRequest']);
  has FirstBoot => (is => 'ro', isa => 'Str', request_name => 'firstBoot', traits => ['NameInRequest']);
  has JobID => (is => 'ro', isa => 'Str', request_name => 'jobID', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ApplicationMigration::LaunchedInstance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ApplicationMigration::LaunchedInstance object:

  $service_obj->Method(Att1 => { Ec2InstanceID => $value, ..., JobID => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ApplicationMigration::LaunchedInstance object:

  $result = $service_obj->Method(...);
  $result->Att1->Ec2InstanceID

=head1 DESCRIPTION

Configure launced instance.

=head1 ATTRIBUTES


=head2 Ec2InstanceID => Str

Configure launced instance EC2 ID.


=head2 FirstBoot => Str

Configure launced instance first boot.


=head2 JobID => Str

Configure launced instance Job ID.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ApplicationMigration>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

