# Generated by default/object.tt
package Paws::DevOpsGuru::AnomalySourceDetails;
  use Moose;
  has CloudWatchMetrics => (is => 'ro', isa => 'ArrayRef[Paws::DevOpsGuru::CloudWatchMetricsDetail]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DevOpsGuru::AnomalySourceDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DevOpsGuru::AnomalySourceDetails object:

  $service_obj->Method(Att1 => { CloudWatchMetrics => $value, ..., CloudWatchMetrics => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DevOpsGuru::AnomalySourceDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->CloudWatchMetrics

=head1 DESCRIPTION

Details about the source of the anomalous operational data that
triggered the anomaly. The one supported source is Amazon CloudWatch
metrics.

=head1 ATTRIBUTES


=head2 CloudWatchMetrics => ArrayRef[L<Paws::DevOpsGuru::CloudWatchMetricsDetail>]

An array of C<CloudWatchMetricsDetail> object that contains information
about the analyzed metrics that displayed anomalous behavior.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DevOpsGuru>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

