# Generated by default/object.tt
package Paws::ECS::Session;
  use Moose;
  has SessionId => (is => 'ro', isa => 'Str', request_name => 'sessionId', traits => ['NameInRequest']);
  has StreamUrl => (is => 'ro', isa => 'Str', request_name => 'streamUrl', traits => ['NameInRequest']);
  has TokenValue => (is => 'ro', isa => 'Str', request_name => 'tokenValue', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECS::Session

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECS::Session object:

  $service_obj->Method(Att1 => { SessionId => $value, ..., TokenValue => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECS::Session object:

  $result = $service_obj->Method(...);
  $result->Att1->SessionId

=head1 DESCRIPTION

The details of the execute command session.

=head1 ATTRIBUTES


=head2 SessionId => Str

The ID of the execute command session.


=head2 StreamUrl => Str

A URL back to managed agent on the container that the SSM Session
Manager client uses to send commands and receive output from the
container.


=head2 TokenValue => Str

An encrypted token value containing session and caller information.
Used to authenticate the connection to the container.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

