# Generated by default/object.tt
package Paws::ES::PackageVersionHistory;
  use Moose;
  has CommitMessage => (is => 'ro', isa => 'Str');
  has CreatedAt => (is => 'ro', isa => 'Str');
  has PackageVersion => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ES::PackageVersionHistory

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ES::PackageVersionHistory object:

  $service_obj->Method(Att1 => { CommitMessage => $value, ..., PackageVersion => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ES::PackageVersionHistory object:

  $result = $service_obj->Method(...);
  $result->Att1->CommitMessage

=head1 DESCRIPTION

Details of a package version.

=head1 ATTRIBUTES


=head2 CommitMessage => Str

A message associated with the version.


=head2 CreatedAt => Str

Timestamp which tells creation time of the package version.


=head2 PackageVersion => Str

Version of the package.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ES>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

