# Generated by default/object.tt
package Paws::GlobalAccelerator::CustomRoutingDestinationConfiguration;
  use Moose;
  has FromPort => (is => 'ro', isa => 'Int', required => 1);
  has Protocols => (is => 'ro', isa => 'ArrayRef[Str|Undef]', required => 1);
  has ToPort => (is => 'ro', isa => 'Int', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlobalAccelerator::CustomRoutingDestinationConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlobalAccelerator::CustomRoutingDestinationConfiguration object:

  $service_obj->Method(Att1 => { FromPort => $value, ..., ToPort => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlobalAccelerator::CustomRoutingDestinationConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->FromPort

=head1 DESCRIPTION

For a custom routing accelerator, sets the port range and protocol for
all endpoints (virtual private cloud subnets) in an endpoint group to
accept client traffic on.

=head1 ATTRIBUTES


=head2 B<REQUIRED> FromPort => Int

The first port, inclusive, in the range of ports for the endpoint group
that is associated with a custom routing accelerator.


=head2 B<REQUIRED> Protocols => ArrayRef[Str|Undef]

The protocol for the endpoint group that is associated with a custom
routing accelerator. The protocol can be either TCP or UDP.


=head2 B<REQUIRED> ToPort => Int

The last port, inclusive, in the range of ports for the endpoint group
that is associated with a custom routing accelerator.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlobalAccelerator>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

