# Generated by default/object.tt
package Paws::Glue::ColumnStatisticsData;
  use Moose;
  has BinaryColumnStatisticsData => (is => 'ro', isa => 'Paws::Glue::BinaryColumnStatisticsData');
  has BooleanColumnStatisticsData => (is => 'ro', isa => 'Paws::Glue::BooleanColumnStatisticsData');
  has DateColumnStatisticsData => (is => 'ro', isa => 'Paws::Glue::DateColumnStatisticsData');
  has DecimalColumnStatisticsData => (is => 'ro', isa => 'Paws::Glue::DecimalColumnStatisticsData');
  has DoubleColumnStatisticsData => (is => 'ro', isa => 'Paws::Glue::DoubleColumnStatisticsData');
  has LongColumnStatisticsData => (is => 'ro', isa => 'Paws::Glue::LongColumnStatisticsData');
  has StringColumnStatisticsData => (is => 'ro', isa => 'Paws::Glue::StringColumnStatisticsData');
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Glue::ColumnStatisticsData

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Glue::ColumnStatisticsData object:

  $service_obj->Method(Att1 => { BinaryColumnStatisticsData => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Glue::ColumnStatisticsData object:

  $result = $service_obj->Method(...);
  $result->Att1->BinaryColumnStatisticsData

=head1 DESCRIPTION

Contains the individual types of column statistics data. Only one data
object should be set and indicated by the C<Type> attribute.

=head1 ATTRIBUTES


=head2 BinaryColumnStatisticsData => L<Paws::Glue::BinaryColumnStatisticsData>

Binary column statistics data.


=head2 BooleanColumnStatisticsData => L<Paws::Glue::BooleanColumnStatisticsData>

Boolean column statistics data.


=head2 DateColumnStatisticsData => L<Paws::Glue::DateColumnStatisticsData>

Date column statistics data.


=head2 DecimalColumnStatisticsData => L<Paws::Glue::DecimalColumnStatisticsData>

Decimal column statistics data.


=head2 DoubleColumnStatisticsData => L<Paws::Glue::DoubleColumnStatisticsData>

Double column statistics data.


=head2 LongColumnStatisticsData => L<Paws::Glue::LongColumnStatisticsData>

Long column statistics data.


=head2 StringColumnStatisticsData => L<Paws::Glue::StringColumnStatisticsData>

String column statistics data.


=head2 B<REQUIRED> Type => Str

The type of column statistics data.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Glue>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

