# Generated by default/object.tt
package Paws::GlueDataBrew::DatasetParameter;
  use Moose;
  has CreateColumn => (is => 'ro', isa => 'Bool');
  has DatetimeOptions => (is => 'ro', isa => 'Paws::GlueDataBrew::DatetimeOptions');
  has Filter => (is => 'ro', isa => 'Paws::GlueDataBrew::FilterExpression');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has Type => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::DatasetParameter

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::DatasetParameter object:

  $service_obj->Method(Att1 => { CreateColumn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::DatasetParameter object:

  $result = $service_obj->Method(...);
  $result->Att1->CreateColumn

=head1 DESCRIPTION

Represents a dataset paramater that defines type and conditions for a
parameter in the Amazon S3 path of the dataset.

=head1 ATTRIBUTES


=head2 CreateColumn => Bool

Optional boolean value that defines whether the captured value of this
parameter should be used to create a new column in a dataset.


=head2 DatetimeOptions => L<Paws::GlueDataBrew::DatetimeOptions>

Additional parameter options such as a format and a timezone. Required
for datetime parameters.


=head2 Filter => L<Paws::GlueDataBrew::FilterExpression>

The optional filter expression structure to apply additional matching
criteria to the parameter.


=head2 B<REQUIRED> Name => Str

The name of the parameter that is used in the dataset's Amazon S3 path.


=head2 B<REQUIRED> Type => Str

The type of the dataset parameter, can be one of a 'String', 'Number'
or 'Datetime'.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

