# Generated by default/object.tt
package Paws::GlueDataBrew::Recipe;
  use Moose;
  has CreateDate => (is => 'ro', isa => 'Str');
  has CreatedBy => (is => 'ro', isa => 'Str');
  has Description => (is => 'ro', isa => 'Str');
  has LastModifiedBy => (is => 'ro', isa => 'Str');
  has LastModifiedDate => (is => 'ro', isa => 'Str');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has ProjectName => (is => 'ro', isa => 'Str');
  has PublishedBy => (is => 'ro', isa => 'Str');
  has PublishedDate => (is => 'ro', isa => 'Str');
  has RecipeVersion => (is => 'ro', isa => 'Str');
  has ResourceArn => (is => 'ro', isa => 'Str');
  has Steps => (is => 'ro', isa => 'ArrayRef[Paws::GlueDataBrew::RecipeStep]');
  has Tags => (is => 'ro', isa => 'Paws::GlueDataBrew::TagMap');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GlueDataBrew::Recipe

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GlueDataBrew::Recipe object:

  $service_obj->Method(Att1 => { CreateDate => $value, ..., Tags => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GlueDataBrew::Recipe object:

  $result = $service_obj->Method(...);
  $result->Att1->CreateDate

=head1 DESCRIPTION

Represents one or more actions to be performed on a DataBrew dataset.

=head1 ATTRIBUTES


=head2 CreateDate => Str

The date and time that the recipe was created.


=head2 CreatedBy => Str

The Amazon Resource Name (ARN) of the user who created the recipe.


=head2 Description => Str

The description of the recipe.


=head2 LastModifiedBy => Str

The Amazon Resource Name (ARN) of the user who last modified the
recipe.


=head2 LastModifiedDate => Str

The last modification date and time of the recipe.


=head2 B<REQUIRED> Name => Str

The unique name for the recipe.


=head2 ProjectName => Str

The name of the project that the recipe is associated with.


=head2 PublishedBy => Str

The Amazon Resource Name (ARN) of the user who published the recipe.


=head2 PublishedDate => Str

The date and time when the recipe was published.


=head2 RecipeVersion => Str

The identifier for the version for the recipe. Must be one of the
following:

=over

=item *

Numeric version (C<X.Y>) - C<X> and C<Y> stand for major and minor
version numbers. The maximum length of each is 6 digits, and neither
can be negative values. Both C<X> and C<Y> are required, and "0.0"
isn't a valid version.

=item *

C<LATEST_WORKING> - the most recent valid version being developed in a
DataBrew project.

=item *

C<LATEST_PUBLISHED> - the most recent published version.

=back



=head2 ResourceArn => Str

The Amazon Resource Name (ARN) for the recipe.


=head2 Steps => ArrayRef[L<Paws::GlueDataBrew::RecipeStep>]

A list of steps that are defined by the recipe.


=head2 Tags => L<Paws::GlueDataBrew::TagMap>

Metadata tags that have been applied to the recipe.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GlueDataBrew>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

