# Generated by default/object.tt
package Paws::GuardDuty::S3BucketDetail;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has DefaultServerSideEncryption => (is => 'ro', isa => 'Paws::GuardDuty::DefaultServerSideEncryption', request_name => 'defaultServerSideEncryption', traits => ['NameInRequest']);
  has Name => (is => 'ro', isa => 'Str', request_name => 'name', traits => ['NameInRequest']);
  has Owner => (is => 'ro', isa => 'Paws::GuardDuty::Owner', request_name => 'owner', traits => ['NameInRequest']);
  has PublicAccess => (is => 'ro', isa => 'Paws::GuardDuty::PublicAccess', request_name => 'publicAccess', traits => ['NameInRequest']);
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::GuardDuty::Tag]', request_name => 'tags', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::S3BucketDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GuardDuty::S3BucketDetail object:

  $service_obj->Method(Att1 => { Arn => $value, ..., Type => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GuardDuty::S3BucketDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Contains information on the S3 bucket.

=head1 ATTRIBUTES


=head2 Arn => Str

The Amazon Resource Name (ARN) of the S3 bucket.


=head2 CreatedAt => Str

The date and time the bucket was created at.


=head2 DefaultServerSideEncryption => L<Paws::GuardDuty::DefaultServerSideEncryption>

Describes the server side encryption method used in the S3 bucket.


=head2 Name => Str

The name of the S3 bucket.


=head2 Owner => L<Paws::GuardDuty::Owner>

The owner of the S3 bucket.


=head2 PublicAccess => L<Paws::GuardDuty::PublicAccess>

Describes the public access policies that apply to the S3 bucket.


=head2 Tags => ArrayRef[L<Paws::GuardDuty::Tag>]

All tags attached to the S3 bucket


=head2 Type => Str

Describes whether the bucket is a source or destination bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

