# Generated by default/object.tt
package Paws::IoTSiteWise::Alarms;
  use Moose;
  has AlarmRoleArn => (is => 'ro', isa => 'Str', request_name => 'alarmRoleArn', traits => ['NameInRequest'], required => 1);
  has NotificationLambdaArn => (is => 'ro', isa => 'Str', request_name => 'notificationLambdaArn', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::Alarms

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::Alarms object:

  $service_obj->Method(Att1 => { AlarmRoleArn => $value, ..., NotificationLambdaArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::Alarms object:

  $result = $service_obj->Method(...);
  $result->Att1->AlarmRoleArn

=head1 DESCRIPTION

Contains the configuration information of an alarm created in an AWS
IoT SiteWise Monitor portal. You can use the alarm to monitor an asset
property and get notified when the asset property value is outside a
specified range. For more information, see .

=head1 ATTRIBUTES


=head2 B<REQUIRED> AlarmRoleArn => Str

The ARN
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
of the IAM role that allows the alarm to perform actions and access AWS
resources, including AWS IoT Events.


=head2 NotificationLambdaArn => Str

The ARN
(https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
of the AWS Lambda function that manages alarm notifications. For more
information, see Managing alarm notifications
(https://docs.aws.amazon.com/) in the I<AWS IoT Events Developer
Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

