# Generated by default/object.tt
package Paws::Kendra::BatchGetDocumentStatusResponseError;
  use Moose;
  has DocumentId => (is => 'ro', isa => 'Str');
  has ErrorCode => (is => 'ro', isa => 'Str');
  has ErrorMessage => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Kendra::BatchGetDocumentStatusResponseError

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Kendra::BatchGetDocumentStatusResponseError object:

  $service_obj->Method(Att1 => { DocumentId => $value, ..., ErrorMessage => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Kendra::BatchGetDocumentStatusResponseError object:

  $result = $service_obj->Method(...);
  $result->Att1->DocumentId

=head1 DESCRIPTION

Provides a response when the status of a document could not be
retrieved.

=head1 ATTRIBUTES


=head2 DocumentId => Str

The unique identifier of the document whose status could not be
retrieved.


=head2 ErrorCode => Str

Indicates the source of the error.


=head2 ErrorMessage => Str

States that the API could not get the status of a document. This could
be because the request is not valid or there is a system error.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Kendra>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

