# Generated by default/object.tt
package Paws::KinesisAnalyticsV2::ZeppelinApplicationConfigurationDescription;
  use Moose;
  has CatalogConfigurationDescription => (is => 'ro', isa => 'Paws::KinesisAnalyticsV2::CatalogConfigurationDescription');
  has CustomArtifactsConfigurationDescription => (is => 'ro', isa => 'ArrayRef[Paws::KinesisAnalyticsV2::CustomArtifactConfigurationDescription]');
  has DeployAsApplicationConfigurationDescription => (is => 'ro', isa => 'Paws::KinesisAnalyticsV2::DeployAsApplicationConfigurationDescription');
  has MonitoringConfigurationDescription => (is => 'ro', isa => 'Paws::KinesisAnalyticsV2::ZeppelinMonitoringConfigurationDescription', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::KinesisAnalyticsV2::ZeppelinApplicationConfigurationDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::KinesisAnalyticsV2::ZeppelinApplicationConfigurationDescription object:

  $service_obj->Method(Att1 => { CatalogConfigurationDescription => $value, ..., MonitoringConfigurationDescription => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::KinesisAnalyticsV2::ZeppelinApplicationConfigurationDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->CatalogConfigurationDescription

=head1 DESCRIPTION

The configuration of a Kinesis Data Analytics Studio notebook.

=head1 ATTRIBUTES


=head2 CatalogConfigurationDescription => L<Paws::KinesisAnalyticsV2::CatalogConfigurationDescription>

The AWS Glue Data Catalog that is associated with the Kinesis Data
Analytics Studio notebook.


=head2 CustomArtifactsConfigurationDescription => ArrayRef[L<Paws::KinesisAnalyticsV2::CustomArtifactConfigurationDescription>]

Custom artifacts are dependency JARs and user-defined functions (UDF).


=head2 DeployAsApplicationConfigurationDescription => L<Paws::KinesisAnalyticsV2::DeployAsApplicationConfigurationDescription>

The parameters required to deploy a Kinesis Data Analytics Studio
notebook as an application with durable state..


=head2 B<REQUIRED> MonitoringConfigurationDescription => L<Paws::KinesisAnalyticsV2::ZeppelinMonitoringConfigurationDescription>

The monitoring configuration of a Kinesis Data Analytics Studio
notebook.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::KinesisAnalyticsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

