# Generated by default/object.tt
package Paws::Lightsail::ContainerServiceRegistryLogin;
  use Moose;
  has ExpiresAt => (is => 'ro', isa => 'Str', request_name => 'expiresAt', traits => ['NameInRequest']);
  has Password => (is => 'ro', isa => 'Str', request_name => 'password', traits => ['NameInRequest']);
  has Registry => (is => 'ro', isa => 'Str', request_name => 'registry', traits => ['NameInRequest']);
  has Username => (is => 'ro', isa => 'Str', request_name => 'username', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::ContainerServiceRegistryLogin

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::ContainerServiceRegistryLogin object:

  $service_obj->Method(Att1 => { ExpiresAt => $value, ..., Username => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::ContainerServiceRegistryLogin object:

  $result = $service_obj->Method(...);
  $result->Att1->ExpiresAt

=head1 DESCRIPTION

Describes the login information for the container image registry of an
Amazon Lightsail account.

=head1 ATTRIBUTES


=head2 ExpiresAt => Str

The timestamp of when the container image registry username and
password expire.

The log in credentials expire 12 hours after they are created, at which
point you will need to create a new set of log in credentials using the
C<CreateContainerServiceRegistryLogin> action.


=head2 Password => Str

The container service registry password to use to push container images
to the container image registry of a Lightsail account


=head2 Registry => Str

The address to use to push container images to the container image
registry of a Lightsail account.


=head2 Username => Str

The container service registry username to use to push container images
to the container image registry of a Lightsail account.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

