# Generated by default/object.tt
package Paws::Lightsail::RenewalSummary;
  use Moose;
  has DomainValidationRecords => (is => 'ro', isa => 'ArrayRef[Paws::Lightsail::DomainValidationRecord]', request_name => 'domainValidationRecords', traits => ['NameInRequest']);
  has RenewalStatus => (is => 'ro', isa => 'Str', request_name => 'renewalStatus', traits => ['NameInRequest']);
  has RenewalStatusReason => (is => 'ro', isa => 'Str', request_name => 'renewalStatusReason', traits => ['NameInRequest']);
  has UpdatedAt => (is => 'ro', isa => 'Str', request_name => 'updatedAt', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::RenewalSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::RenewalSummary object:

  $service_obj->Method(Att1 => { DomainValidationRecords => $value, ..., UpdatedAt => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::RenewalSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->DomainValidationRecords

=head1 DESCRIPTION

Describes the status of a SSL/TLS certificate renewal managed by Amazon
Lightsail.

=head1 ATTRIBUTES


=head2 DomainValidationRecords => ArrayRef[L<Paws::Lightsail::DomainValidationRecord>]

An array of objects that describe the domain validation records of the
certificate.


=head2 RenewalStatus => Str

The renewal status of the certificate.

The following renewal status are possible:

=over

=item *

B<C<PendingAutoRenewal> > - Lightsail is attempting to automatically
validate the domain names of the certificate. No further action is
required.

=item *

B<C<PendingValidation> > - Lightsail couldn't automatically validate
one or more domain names of the certificate. You must take action to
validate these domain names or the certificate won't be renewed. Check
to make sure your certificate's domain validation records exist in your
domain's DNS, and that your certificate remains in use.

=item *

B<C<Success> > - All domain names in the certificate are validated, and
Lightsail renewed the certificate. No further action is required.

=item *

B<C<Failed> > - One or more domain names were not validated before the
certificate expired, and Lightsail did not renew the certificate. You
can request a new certificate using the C<CreateCertificate> action.

=back



=head2 RenewalStatusReason => Str

The reason for the renewal status of the certificate.


=head2 UpdatedAt => Str

The timestamp when the certificate was last updated.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

