# Generated by default/object.tt
package Paws::LocationService::ListRouteCalculatorsResponseEntry;
  use Moose;
  has CalculatorName => (is => 'ro', isa => 'Str', required => 1);
  has CreateTime => (is => 'ro', isa => 'Str', required => 1);
  has DataSource => (is => 'ro', isa => 'Str', required => 1);
  has Description => (is => 'ro', isa => 'Str', required => 1);
  has PricingPlan => (is => 'ro', isa => 'Str', required => 1);
  has UpdateTime => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LocationService::ListRouteCalculatorsResponseEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LocationService::ListRouteCalculatorsResponseEntry object:

  $service_obj->Method(Att1 => { CalculatorName => $value, ..., UpdateTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LocationService::ListRouteCalculatorsResponseEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->CalculatorName

=head1 DESCRIPTION

A route calculator resource listed in your AWS account.

=head1 ATTRIBUTES


=head2 B<REQUIRED> CalculatorName => Str

The name of the route calculator resource.


=head2 B<REQUIRED> CreateTime => Str

The timestamp when the route calculator resource was created in ISO
8601 (https://www.iso.org/iso-8601-date-and-time-format.html) format:
C<YYYY-MM-DDThh:mm:ss.sssZ>.

=over

=item *

For example, C<2020E<ndash>07-2T12:15:20.000Z+01:00>

=back



=head2 B<REQUIRED> DataSource => Str

The data provider of traffic and road network data. Indicates one of
the available providers:

=over

=item *

C<Esri>

=item *

C<Here>

=back

For more information about data providers, see Amazon Location Service
data providers
(https://docs.aws.amazon.com/location/latest/developerguide/what-is-data-provider.html).


=head2 B<REQUIRED> Description => Str

The optional description of the route calculator resource.


=head2 B<REQUIRED> PricingPlan => Str

The pricing plan for the specified route calculator resource.

For additional details and restrictions on each pricing plan option,
see Amazon Location Service pricing
(https://aws.amazon.com/location/pricing/).


=head2 B<REQUIRED> UpdateTime => Str

The timestamp when the route calculator resource was last updated in
ISO 8601 (https://www.iso.org/iso-8601-date-and-time-format.html)
format: C<YYYY-MM-DDThh:mm:ss.sssZ>.

=over

=item *

For example, C<2020E<ndash>07-2T12:15:20.000Z+01:00>

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LocationService>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

