# Generated by default/object.tt
package Paws::MWAA::LoggingConfiguration;
  use Moose;
  has DagProcessingLogs => (is => 'ro', isa => 'Paws::MWAA::ModuleLoggingConfiguration');
  has SchedulerLogs => (is => 'ro', isa => 'Paws::MWAA::ModuleLoggingConfiguration');
  has TaskLogs => (is => 'ro', isa => 'Paws::MWAA::ModuleLoggingConfiguration');
  has WebserverLogs => (is => 'ro', isa => 'Paws::MWAA::ModuleLoggingConfiguration');
  has WorkerLogs => (is => 'ro', isa => 'Paws::MWAA::ModuleLoggingConfiguration');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MWAA::LoggingConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MWAA::LoggingConfiguration object:

  $service_obj->Method(Att1 => { DagProcessingLogs => $value, ..., WorkerLogs => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MWAA::LoggingConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->DagProcessingLogs

=head1 DESCRIPTION

Defines the Apache Airflow logs to send to CloudWatch Logs:
C<DagProcessingLogs>, C<SchedulerLogs>, C<TaskLogs>, C<WebserverLogs>,
C<WorkerLogs>.

=head1 ATTRIBUTES


=head2 DagProcessingLogs => L<Paws::MWAA::ModuleLoggingConfiguration>




=head2 SchedulerLogs => L<Paws::MWAA::ModuleLoggingConfiguration>




=head2 TaskLogs => L<Paws::MWAA::ModuleLoggingConfiguration>




=head2 WebserverLogs => L<Paws::MWAA::ModuleLoggingConfiguration>




=head2 WorkerLogs => L<Paws::MWAA::ModuleLoggingConfiguration>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MWAA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

