# Generated by default/object.tt
package Paws::MWAA::ModuleLoggingConfigurationInput;
  use Moose;
  has Enabled => (is => 'ro', isa => 'Bool', required => 1);
  has LogLevel => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MWAA::ModuleLoggingConfigurationInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MWAA::ModuleLoggingConfigurationInput object:

  $service_obj->Method(Att1 => { Enabled => $value, ..., LogLevel => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MWAA::ModuleLoggingConfigurationInput object:

  $result = $service_obj->Method(...);
  $result->Att1->Enabled

=head1 DESCRIPTION

Defines the type of logs to send for the Apache Airflow log type (e.g.
C<DagProcessingLogs>). Valid values: C<CloudWatchLogGroupArn>,
C<Enabled>, C<LogLevel>.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Enabled => Bool

Indicates whether to enable the Apache Airflow log type (e.g.
C<DagProcessingLogs>) in CloudWatch Logs.


=head2 B<REQUIRED> LogLevel => Str

Defines the Apache Airflow logs to send for the log type (e.g.
C<DagProcessingLogs>) to CloudWatch Logs. Valid values: C<CRITICAL>,
C<ERROR>, C<WARNING>, C<INFO>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MWAA>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

