# Generated by default/object.tt
package Paws::Macie2::BucketLevelPermissions;
  use Moose;
  has AccessControlList => (is => 'ro', isa => 'Paws::Macie2::AccessControlList', request_name => 'accessControlList', traits => ['NameInRequest']);
  has BlockPublicAccess => (is => 'ro', isa => 'Paws::Macie2::BlockPublicAccess', request_name => 'blockPublicAccess', traits => ['NameInRequest']);
  has BucketPolicy => (is => 'ro', isa => 'Paws::Macie2::BucketPolicy', request_name => 'bucketPolicy', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::BucketLevelPermissions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::BucketLevelPermissions object:

  $service_obj->Method(Att1 => { AccessControlList => $value, ..., BucketPolicy => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::BucketLevelPermissions object:

  $result = $service_obj->Method(...);
  $result->Att1->AccessControlList

=head1 DESCRIPTION

Provides information about the bucket-level permissions settings for an
S3 bucket.

=head1 ATTRIBUTES


=head2 AccessControlList => L<Paws::Macie2::AccessControlList>

The permissions settings of the access control list (ACL) for the
bucket. This value is null if an ACL hasn't been defined for the
bucket.


=head2 BlockPublicAccess => L<Paws::Macie2::BlockPublicAccess>

The block public access settings for the bucket.


=head2 BucketPolicy => L<Paws::Macie2::BucketPolicy>

The permissions settings of the bucket policy for the bucket. This
value is null if a bucket policy hasn't been defined for the bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

