# Generated by default/object.tt
package Paws::Macie2::SessionIssuer;
  use Moose;
  has AccountId => (is => 'ro', isa => 'Str', request_name => 'accountId', traits => ['NameInRequest']);
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has PrincipalId => (is => 'ro', isa => 'Str', request_name => 'principalId', traits => ['NameInRequest']);
  has Type => (is => 'ro', isa => 'Str', request_name => 'type', traits => ['NameInRequest']);
  has UserName => (is => 'ro', isa => 'Str', request_name => 'userName', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::SessionIssuer

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::SessionIssuer object:

  $service_obj->Method(Att1 => { AccountId => $value, ..., UserName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::SessionIssuer object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountId

=head1 DESCRIPTION

Provides information about the source and type of temporary security
credentials that were issued to an entity.

=head1 ATTRIBUTES


=head2 AccountId => Str

The unique identifier for the Amazon Web Services account that owns the
entity that was used to get the credentials.


=head2 Arn => Str

The Amazon Resource Name (ARN) of the source account, IAM user, or role
that was used to get the credentials.


=head2 PrincipalId => Str

The unique identifier for the entity that was used to get the
credentials.


=head2 Type => Str

The source of the temporary security credentials, such as Root,
IAMUser, or Role.


=head2 UserName => Str

The name or alias of the user or role that issued the session. This
value is null if the credentials were obtained from a root account that
doesn't have an alias.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

