# Generated by default/object.tt
package Paws::PersonalizeEvents::Item;
  use Moose;
  has ItemId => (is => 'ro', isa => 'Str', request_name => 'itemId', traits => ['NameInRequest'], required => 1);
  has Properties => (is => 'ro', isa => 'Str', request_name => 'properties', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::PersonalizeEvents::Item

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::PersonalizeEvents::Item object:

  $service_obj->Method(Att1 => { ItemId => $value, ..., Properties => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::PersonalizeEvents::Item object:

  $result = $service_obj->Method(...);
  $result->Att1->ItemId

=head1 DESCRIPTION

Represents item metadata added to an Items dataset using the
C<PutItems> API. For more information see Importing Items Incrementally
(https://docs.aws.amazon.com/personalize/latest/dg/importing-items.html).

=head1 ATTRIBUTES


=head2 B<REQUIRED> ItemId => Str

The ID associated with the item.


=head2 Properties => Str

A string map of item-specific metadata. Each element in the map
consists of a key-value pair. For example, C<{"numberOfRatings":
"12"}>.

The keys use camel case names that match the fields in the schema for
the Items dataset. In the previous example, the C<numberOfRatings>
matches the 'NUMBER_OF_RATINGS' field defined in the Items schema. For
categorical string data, to include multiple categories for a single
item, separate each category with a pipe separator (C<|>). For example,
C<\"Horror|Action\">.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::PersonalizeEvents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

