# Generated by default/object.tt
package Paws::Rekognition::ProjectDescription;
  use Moose;
  has CreationTimestamp => (is => 'ro', isa => 'Str');
  has ProjectArn => (is => 'ro', isa => 'Str');
  has Status => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Rekognition::ProjectDescription

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Rekognition::ProjectDescription object:

  $service_obj->Method(Att1 => { CreationTimestamp => $value, ..., Status => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Rekognition::ProjectDescription object:

  $result = $service_obj->Method(...);
  $result->Att1->CreationTimestamp

=head1 DESCRIPTION

A description of a Amazon Rekognition Custom Labels project.

=head1 ATTRIBUTES


=head2 CreationTimestamp => Str

The Unix timestamp for the date and time that the project was created.


=head2 ProjectArn => Str

The Amazon Resource Name (ARN) of the project.


=head2 Status => Str

The current status of the project.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Rekognition>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

