# Generated by default/object.tt
package Paws::SESv2::ListManagementOptions;
  use Moose;
  has ContactListName => (is => 'ro', isa => 'Str', required => 1);
  has TopicName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SESv2::ListManagementOptions

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SESv2::ListManagementOptions object:

  $service_obj->Method(Att1 => { ContactListName => $value, ..., TopicName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SESv2::ListManagementOptions object:

  $result = $service_obj->Method(...);
  $result->Att1->ContactListName

=head1 DESCRIPTION

An object used to specify a list or topic to which an email belongs,
which will be used when a contact chooses to unsubscribe.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ContactListName => Str

The name of the contact list.


=head2 TopicName => Str

The name of the topic.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SESv2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

