# Generated by default/object.tt
package Paws::SSMIncidents::Action;
  use Moose;
  has SsmAutomation => (is => 'ro', isa => 'Paws::SSMIncidents::SsmAutomation', request_name => 'ssmAutomation', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::Action

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::Action object:

  $service_obj->Method(Att1 => { SsmAutomation => $value, ..., SsmAutomation => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::Action object:

  $result = $service_obj->Method(...);
  $result->Att1->SsmAutomation

=head1 DESCRIPTION

The action that starts at the beginning of an incident. The response
plan defines the action.

=head1 ATTRIBUTES


=head2 SsmAutomation => L<Paws::SSMIncidents::SsmAutomation>

The Systems Manager automation document to start as the runbook at the
beginning of the incident.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

