# Generated by default/object.tt
package Paws::SageMaker::OidcConfigForResponse;
  use Moose;
  has AuthorizationEndpoint => (is => 'ro', isa => 'Str');
  has ClientId => (is => 'ro', isa => 'Str');
  has Issuer => (is => 'ro', isa => 'Str');
  has JwksUri => (is => 'ro', isa => 'Str');
  has LogoutEndpoint => (is => 'ro', isa => 'Str');
  has TokenEndpoint => (is => 'ro', isa => 'Str');
  has UserInfoEndpoint => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::OidcConfigForResponse

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::OidcConfigForResponse object:

  $service_obj->Method(Att1 => { AuthorizationEndpoint => $value, ..., UserInfoEndpoint => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::OidcConfigForResponse object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorizationEndpoint

=head1 DESCRIPTION

Your OIDC IdP workforce configuration.

=head1 ATTRIBUTES


=head2 AuthorizationEndpoint => Str

The OIDC IdP authorization endpoint used to configure your private
workforce.


=head2 ClientId => Str

The OIDC IdP client ID used to configure your private workforce.


=head2 Issuer => Str

The OIDC IdP issuer used to configure your private workforce.


=head2 JwksUri => Str

The OIDC IdP JSON Web Key Set (Jwks) URI used to configure your private
workforce.


=head2 LogoutEndpoint => Str

The OIDC IdP logout endpoint used to configure your private workforce.


=head2 TokenEndpoint => Str

The OIDC IdP token endpoint used to configure your private workforce.


=head2 UserInfoEndpoint => Str

The OIDC IdP user information endpoint used to configure your private
workforce.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

