# Generated by default/object.tt
package Paws::Snowball::WirelessConnection;
  use Moose;
  has IsWifiEnabled => (is => 'ro', isa => 'Bool');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Snowball::WirelessConnection

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Snowball::WirelessConnection object:

  $service_obj->Method(Att1 => { IsWifiEnabled => $value, ..., IsWifiEnabled => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Snowball::WirelessConnection object:

  $result = $service_obj->Method(...);
  $result->Att1->IsWifiEnabled

=head1 DESCRIPTION

Configures the wireless connection on an AWS Snowcone device.

=head1 ATTRIBUTES


=head2 IsWifiEnabled => Bool

Enables the Wi-Fi adapter on an AWS Snowcone device.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Snowball>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

