# Generated by default/object.tt
package Paws::WAFV2::WebACL;
  use Moose;
  has ARN => (is => 'ro', isa => 'Str', required => 1);
  has Capacity => (is => 'ro', isa => 'Int');
  has CustomResponseBodies => (is => 'ro', isa => 'Paws::WAFV2::CustomResponseBodies');
  has DefaultAction => (is => 'ro', isa => 'Paws::WAFV2::DefaultAction', required => 1);
  has Description => (is => 'ro', isa => 'Str');
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has LabelNamespace => (is => 'ro', isa => 'Str');
  has ManagedByFirewallManager => (is => 'ro', isa => 'Bool');
  has Name => (is => 'ro', isa => 'Str', required => 1);
  has PostProcessFirewallManagerRuleGroups => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::FirewallManagerRuleGroup]');
  has PreProcessFirewallManagerRuleGroups => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::FirewallManagerRuleGroup]');
  has Rules => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::Rule]');
  has VisibilityConfig => (is => 'ro', isa => 'Paws::WAFV2::VisibilityConfig', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::WebACL

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::WebACL object:

  $service_obj->Method(Att1 => { ARN => $value, ..., VisibilityConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::WebACL object:

  $result = $service_obj->Method(...);
  $result->Att1->ARN

=head1 DESCRIPTION

A web ACL defines a collection of rules to use to inspect and control
web requests. Each rule has an action defined (allow, block, or count)
for requests that match the statement of the rule. In the web ACL, you
assign a default action to take (allow, block) for any request that
does not match any of the rules. The rules in a web ACL can be a
combination of the types Rule, RuleGroup, and managed rule group. You
can associate a web ACL with one or more Amazon Web Services resources
to protect. The resources can be an Amazon CloudFront distribution, an
Amazon API Gateway REST API, an Application Load Balancer, or an
AppSync GraphQL API.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ARN => Str

The Amazon Resource Name (ARN) of the web ACL that you want to
associate with the resource.


=head2 Capacity => Int

The web ACL capacity units (WCUs) currently being used by this web ACL.

WAF uses WCUs to calculate and control the operating resources that are
used to run your rules, rule groups, and web ACLs. WAF calculates
capacity differently for each rule type, to reflect the relative cost
of each rule. Simple rules that cost little to run use fewer WCUs than
more complex rules that use more processing power. Rule group capacity
is fixed at creation, which helps users plan their web ACL WCU usage
when they use a rule group. The WCU limit for web ACLs is 1,500.


=head2 CustomResponseBodies => L<Paws::WAFV2::CustomResponseBodies>

A map of custom response keys and content bodies. When you create a
rule with a block action, you can send a custom response to the web
request. You define these for the web ACL, and then use them in the
rules and default actions that you define in the web ACL.

For information about customizing web requests and responses, see
Customizing web requests and responses in WAF
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-custom-request-response.html)
in the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).

For information about the limits on count and size for custom request
and response settings, see WAF quotas
(https://docs.aws.amazon.com/waf/latest/developerguide/limits.html) in
the WAF Developer Guide
(https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).


=head2 B<REQUIRED> DefaultAction => L<Paws::WAFV2::DefaultAction>

The action to perform if none of the C<Rules> contained in the
C<WebACL> match.


=head2 Description => Str

A description of the web ACL that helps with identification.


=head2 B<REQUIRED> Id => Str

A unique identifier for the C<WebACL>. This ID is returned in the
responses to create and list commands. You use this ID to do things
like get, update, and delete a C<WebACL>.


=head2 LabelNamespace => Str

The label namespace prefix for this web ACL. All labels added by rules
in this web ACL have this prefix.

=over

=item *

The syntax for the label namespace prefix for a web ACL is the
following:

C<awswaf:E<lt>account IDE<gt>:webacl:E<lt>web ACL nameE<gt>:>

=item *

When a rule with a label matches a web request, WAF adds the fully
qualified label to the request. A fully qualified label is made up of
the label namespace from the rule group or web ACL where the rule is
defined and the label from the rule, separated by a colon:

C<E<lt>label namespaceE<gt>:E<lt>label from ruleE<gt>>

=back



=head2 ManagedByFirewallManager => Bool

Indicates whether this web ACL is managed by Firewall Manager. If true,
then only Firewall Manager can delete the web ACL or any Firewall
Manager rule groups in the web ACL.


=head2 B<REQUIRED> Name => Str

The name of the web ACL. You cannot change the name of a web ACL after
you create it.


=head2 PostProcessFirewallManagerRuleGroups => ArrayRef[L<Paws::WAFV2::FirewallManagerRuleGroup>]

The last set of rules for WAF to process in the web ACL. This is
defined in an Firewall Manager WAF policy and contains only rule group
references. You can't alter these. Any rules and rule groups that you
define for the web ACL are prioritized before these.

In the Firewall Manager WAF policy, the Firewall Manager administrator
can define a set of rule groups to run first in the web ACL and a set
of rule groups to run last. Within each set, the administrator
prioritizes the rule groups, to determine their relative processing
order.


=head2 PreProcessFirewallManagerRuleGroups => ArrayRef[L<Paws::WAFV2::FirewallManagerRuleGroup>]

The first set of rules for WAF to process in the web ACL. This is
defined in an Firewall Manager WAF policy and contains only rule group
references. You can't alter these. Any rules and rule groups that you
define for the web ACL are prioritized after these.

In the Firewall Manager WAF policy, the Firewall Manager administrator
can define a set of rule groups to run first in the web ACL and a set
of rule groups to run last. Within each set, the administrator
prioritizes the rule groups, to determine their relative processing
order.


=head2 Rules => ArrayRef[L<Paws::WAFV2::Rule>]

The Rule statements used to identify the web requests that you want to
allow, block, or count. Each rule includes one top-level statement that
WAF uses to identify matching web requests, and parameters that govern
how WAF handles them.


=head2 B<REQUIRED> VisibilityConfig => L<Paws::WAFV2::VisibilityConfig>

Defines and enables Amazon CloudWatch metrics and web request sample
collection.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

