#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patches the header file to move uuid_compare() to
# myuuid_compare().
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrc/uuid/uuid.h.in	2023-11-29 23:03:41.793858673 -0500
+++ usrcP/uuid/uuid.h.in	2023-12-04 03:37:47.176805357 -0500
@@ -70,7 +70,7 @@
 void uuid_clear(uuid_t uu);
 
 /* compare.c */
-int uuid_compare(const uuid_t uu1, const uuid_t uu2);
+int myuuid_compare(const uuid_t uu1, const uuid_t uu2);
 
 /* copy.c */
 void uuid_copy(uuid_t dst, const uuid_t src);
