use strict;
use warnings;
use Benchmark qw(:hireswallclock cmpthese countit);
use UUID qw(generate_random generate_time uuid1 uuid4 unparse);

my $seconds = $ARGV[0] || 1;

print "\ncomparing speeds...\n\n";

my $r = cmpthese({
    'v4str' => countit($seconds, 'my $s = uuid4()'),
    'v4bin' => countit($seconds, 'generate_random(my $b)'),
    'v1str' => countit($seconds, 'my $s = uuid1()'),
    'v1bin' => countit($seconds, 'generate_time(my $b)'),
    #'vtst1' => countit($seconds, 'UUID::testlock1()'),
    #'vtst2' => countit($seconds, 'my $s = UUID::testlock2()'),
    #'vtst3' => countit($seconds, 'UUID::testlock3(my $b)'),
    #'vtst4' => countit($seconds, 'my $s = UUID::testlock4(my $b)'),
}, 'none');

#printf("%9s %11s %6s %6s %6s %6s %6s %6s %6s %6s\n", @$_) for @$r;
printf("%9s %11s %6s %6s %6s %6s\n", @$_) for @$r;

print <<'EOT';

    v1bin  ->  eval 'generate_time(my $b)'
    v4bin  ->  eval 'generate_random(my $b)'
    v1str  ->  eval 'my $s = uuid1()'
    v4str  ->  eval 'my $s = uuid4()'
EOT

print "\n\ncomparing styles...\n\n";

$r = cmpthese({
    'case1' => countit(2*$seconds, 'my $s = uuid1()'),
    'case2' => countit(2*$seconds, 'generate_time(my $b); unparse($b, my $s)'),
    'case3' => countit(2*$seconds, 'my($b,$s); generate_time($b); unparse($b,$s)'),
}, 'none');

printf("%9s %11s %6s %6s %6s\n", @$_) for @$r;

print <<'EOT';

    case1  ->  eval 'my $s = uuid1()'
    case2  ->  eval 'my($b,$s); generate_time($b); unparse($b,$s)'
    case3  ->  eval 'generate_time(my $b); unparse($b, my $s)'


EOT

exit 0;
