#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Add EUMM.h to end.
#   - Add guards.
#   - Localize dirpaths.h include.
#   - Move to uuconfig.h.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- ulib/uuconfig.h.new	Tue Jan  9 02:08:52 2024
+++ ulib/uuconfig.h	Tue Jan  9 02:13:54 2024
@@ -1,4 +1,6 @@
 /* lib/config.h.in.  Generated from configure.ac by autoheader.  */
+#ifndef UUID_UUCONFIG_H
+#define UUID_UUCONFIG_H
 
 /* Define if building universal (internal helper macro) */
 #undef AC_APPLE_UNIVERSAL_BUILD
@@ -662,4 +664,7 @@
 /* Define for large files, on AIX-style hosts. */
 #undef _LARGE_FILES
 
-#include <dirpaths.h>
+#include "dirpaths.h"
+#include "EUMM.h"
+
+#endif /* UUID_UUCONFIG_H */

