#
# Patch given file with DATA hunks and print to STDOUT.
#
#
# Patch to:
#   - Localize dirpaths.h inclusion.
#
use strict;
use warnings;
use Text::Patch 'patch';

my $in = $ARGV[0];

my ($txt, $patch);
{
    local $/;
    open my $fh, '<', $in or die "open: $in: $!";
    $txt   = <$fh>;
    $patch = <DATA>;
}

#print $txt;
#print $patch;
#exit;

my $out = patch( $txt, $patch, STYLE => 'Unified' );

print $out;
exit 0;

__END__
--- usrcP/uuid/uuidP.h	Tue Jan  9 02:23:58 2024
+++ ulib/uuid/uuidP.h	Tue Jan  9 02:33:18 2024
@@ -32,10 +32,9 @@
  * %End-Header%
  */
 
-#include <uuid/uuid_types.h>
-#include <sys/types.h>
-
-#include <uuid/uuid.h>
+#include "config.h"
+#include "uuid/uuid_types.h"
+#include "uuid/uuid.h"
 
 /*
  * Offset between 15-Oct-1582 and 1-Jan-70

