#!/usr/bin/perl

package eBay::API::XML::Call::SetStoreCategories::SetStoreCategoriesRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. SetStoreCategoriesRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::SetStoreCategories::SetStoreCategoriesRequestType

=head1 DESCRIPTION

Requests changes to the category structure for a store. Use this
call to add, delete, move, or rename a list of categories.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::SetStoreCategories::SetStoreCategoriesRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::StoreCustomCategoryArrayType;
use eBay::API::XML::DataType::Enum::StoreCategoryUpdateActionCodeType;


my @gaProperties = ( [ 'Action', 'ns:StoreCategoryUpdateActionCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::StoreCategoryUpdateActionCodeType', '' ]
	, [ 'DestinationParentCategoryID', 'xs:long', '', '', '' ]
	, [ 'ItemDestinationCategoryID', 'xs:long', '', '', '' ]
	, [ 'StoreCategories', 'ns:StoreCustomCategoryArrayType', ''
	     ,'eBay::API::XML::DataType::StoreCustomCategoryArrayType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAction()

Specifies the type of action (Add, Move, Delete, or Rename) to carry out
for the specified categories.

  RequiredInput: Yes
#    Argument: 'ns:StoreCategoryUpdateActionCodeType'

=cut

sub setAction {
  my $self = shift;
  $self->{'Action'} = shift
}

=head2 getAction()

#    Returns: 'ns:StoreCategoryUpdateActionCodeType'

=cut

sub getAction {
  my $self = shift;
  return $self->{'Action'};
}


=head2 setDestinationParentCategoryID()

When adding or moving store categories, specifies the category under
which the listed categories will be located. To add or move categories to
the top level, set the value to -999.

  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut

sub setDestinationParentCategoryID {
  my $self = shift;
  $self->{'DestinationParentCategoryID'} = shift
}

=head2 getDestinationParentCategoryID()

#    Returns: 'xs:long'

=cut

sub getDestinationParentCategoryID {
  my $self = shift;
  return $self->{'DestinationParentCategoryID'};
}


=head2 setItemDestinationCategoryID()

Items can only be contained within child categories. A parent category
cannot contain items. If adding, moving, or deleting categories displaces
items, you must specify a destination child category under which the
displaced items will be moved. The destination category must have no
child categories.

  RequiredInput: Conditionally
#    Argument: 'xs:long'

=cut

sub setItemDestinationCategoryID {
  my $self = shift;
  $self->{'ItemDestinationCategoryID'} = shift
}

=head2 getItemDestinationCategoryID()

#    Returns: 'xs:long'

=cut

sub getItemDestinationCategoryID {
  my $self = shift;
  return $self->{'ItemDestinationCategoryID'};
}


=head2 setStoreCategories()

Contains information for specifying the store categories being acted on.

  RequiredInput: Yes
#    Argument: 'ns:StoreCustomCategoryArrayType'

=cut

sub setStoreCategories {
  my $self = shift;
  $self->{'StoreCategories'} = shift
}

=head2 getStoreCategories()

#    Returns: 'ns:StoreCustomCategoryArrayType'

=cut

sub getStoreCategories {
  my $self = shift;
  return $self->_getDataTypeInstance( 'StoreCategories'
		,'eBay::API::XML::DataType::StoreCustomCategoryArrayType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
