#!/usr/bin/perl

package eBay::API::XML::DataType::BidderDetailType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. BidderDetailType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::BidderDetailType

=head1 DESCRIPTION

Contains the data for a user who is interested in bidding on items in a Live Auctions catalog.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::BidderDetailType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::LiveAuctionBidType;
use eBay::API::XML::DataType::UserIDType;


my @gaProperties = ( [ 'Email', 'xs:string', '', '', '' ]
	, [ 'FeedbackScore', 'xs:int', '', '', '' ]
	, [ 'LiveAuctionBidResult', 'ns:LiveAuctionBidType', ''
	     ,'eBay::API::XML::DataType::LiveAuctionBidType', '1' ]
	, [ 'UniqueNegativeFeedbackCount', 'xs:int', '', '', '' ]
	, [ 'UniqueNeutralFeedbackCount', 'xs:int', '', '', '' ]
	, [ 'UniquePositiveFeedbackCount', 'xs:int', '', '', '' ]
	, [ 'UserID', 'ns:UserIDType', ''
	     ,'eBay::API::XML::DataType::UserIDType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setEmail()

E-mail address of the bidder.
You cannot retrieve an email address for any user with whom
you do not have a transactional relationship, regardless of
site. Email is only returned for applicable calls when you
are retrieving your own user data OR when you and the other
user are in a transactional relationship and the call is
being executed within a certain amount of time after the
transaction is created.
Returned as CDATA. When an email address can not be returned,
the string "Invalid Request" is returned instead.

#    Argument: 'xs:string'

=cut

sub setEmail {
  my $self = shift;
  $self->{'Email'} = shift
}

=head2 getEmail()

  Calls: GetLiveAuctionBidders
  Returned: Always

#    Returns: 'xs:string'

=cut

sub getEmail {
  my $self = shift;
  return $self->{'Email'};
}


=head2 setFeedbackScore()

Aggegate feedback score for the specified user.
Feedback score is only return if the user has not chosen to make his
or her feeback private.

#    Argument: 'xs:int'

=cut

sub setFeedbackScore {
  my $self = shift;
  $self->{'FeedbackScore'} = shift
}

=head2 getFeedbackScore()

  Calls: GetLiveAuctionBidders
  Returned: Conditionally

#    Returns: 'xs:int'

=cut

sub getFeedbackScore {
  my $self = shift;
  return $self->{'FeedbackScore'};
}


=head2 setLiveAuctionBidResult()

Contains the bidder details that match the bidder query
passed in the request.
Always returned when bidder search results are found.

#    Argument: 'ns:LiveAuctionBidType'

=cut

sub setLiveAuctionBidResult {
  my $self = shift;
  $self->{'LiveAuctionBidResult'} = shift
}

=head2 getLiveAuctionBidResult()

  Calls: GetLiveAuctionBidders
  Returned: Always

#    Returns: 'ns:LiveAuctionBidType'

=cut

sub getLiveAuctionBidResult {
  my $self = shift;
  return $self->_getDataTypeInstance( 'LiveAuctionBidResult'
		,'eBay::API::XML::DataType::LiveAuctionBidType');
}


=head2 setUniqueNegativeFeedbackCount()

Total count of negative Feedback entries received by the user, including weekly repeats.

#    Argument: 'xs:int'

=cut

sub setUniqueNegativeFeedbackCount {
  my $self = shift;
  $self->{'UniqueNegativeFeedbackCount'} = shift
}

=head2 getUniqueNegativeFeedbackCount()

  Calls: GetLiveAuctionBidders
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getUniqueNegativeFeedbackCount {
  my $self = shift;
  return $self->{'UniqueNegativeFeedbackCount'};
}


=head2 setUniqueNeutralFeedbackCount()

Total count of neutral Feedback entries received by the user, including weekly repeats.

#    Argument: 'xs:int'

=cut

sub setUniqueNeutralFeedbackCount {
  my $self = shift;
  $self->{'UniqueNeutralFeedbackCount'} = shift
}

=head2 getUniqueNeutralFeedbackCount()

  Calls: GetLiveAuctionBidders
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getUniqueNeutralFeedbackCount {
  my $self = shift;
  return $self->{'UniqueNeutralFeedbackCount'};
}


=head2 setUniquePositiveFeedbackCount()

Total count of positive Feedback entries received by the user, including weekly repeats.

#    Argument: 'xs:int'

=cut

sub setUniquePositiveFeedbackCount {
  my $self = shift;
  $self->{'UniquePositiveFeedbackCount'} = shift
}

=head2 getUniquePositiveFeedbackCount()

  Calls: GetLiveAuctionBidders
  Returned: Always

#    Returns: 'xs:int'

=cut

sub getUniquePositiveFeedbackCount {
  my $self = shift;
  return $self->{'UniquePositiveFeedbackCount'};
}


=head2 setUserID()

ID of the user requesting approval.

#    Argument: 'ns:UserIDType'

=cut

sub setUserID {
  my $self = shift;
  $self->{'UserID'} = shift
}

=head2 getUserID()

  Calls: GetLiveAuctionBidders
  Returned: Always

#    Returns: 'ns:UserIDType'

=cut

sub getUserID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'UserID'
		,'eBay::API::XML::DataType::UserIDType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
