#!/usr/bin/perl

package eBay::API::XML::DataType::ExpressHistogramProductType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ExpressHistogramProductType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::ExpressHistogramProductType

=head1 DESCRIPTION

Details about an Express product type and matching item and catalog product counts 
in that product type, if any.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::ExpressHistogramProductType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::ExpressHistogramDomainDetailsType;


my @gaProperties = ( [ 'DomainDetails', 'ns:ExpressHistogramDomainDetailsType', ''
	     ,'eBay::API::XML::DataType::ExpressHistogramDomainDetailsType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDomainDetails()

Identifies an Express product type and provides item and 
eBay catalog product counts in that product type.
Only returned if a product type matched the request.<br>
<br>
A product type domain can stand alone, or it can be grouped with other product types into 
an aisle or a department.

#    Argument: 'ns:ExpressHistogramDomainDetailsType'

=cut

sub setDomainDetails {
  my $self = shift;
  $self->{'DomainDetails'} = shift
}

=head2 getDomainDetails()

#    Returns: 'ns:ExpressHistogramDomainDetailsType'

=cut

sub getDomainDetails {
  my $self = shift;
  return $self->_getDataTypeInstance( 'DomainDetails'
		,'eBay::API::XML::DataType::ExpressHistogramDomainDetailsType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
