/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.dt.VariableSimpleSubclass;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonRect;

public class MultiTrajectoryObsDataset
extends TypedDatasetImpl
implements TrajectoryObsDataset {
    protected Dimension trajDim;
    protected Variable trajVar;
    protected Dimension timeDim;
    protected Variable timeVar;
    protected Structure recordVar = null;
    protected Variable latVar;
    protected Variable lonVar;
    protected Variable elevVar;
    protected String timeVarUnitsString;
    protected double elevVarUnitsConversionFactor;
    protected List trajectoryIds;
    protected List trajectories;
    protected HashMap trajectoriesMap;
    protected int trajectoryNumPoint;
    protected HashMap trajectoryVarsMap;

    public MultiTrajectoryObsDataset() {
    }

    public MultiTrajectoryObsDataset(NetcdfDataset ncfile) {
        super(ncfile);
    }

    public void setTrajectoryInfo(Dimension trajDim, Variable trajVar, Dimension timeDim, Variable timeVar, Variable latVar, Variable lonVar, Variable elevVar) throws IOException {
        String endTimeString;
        String startTimeString;
        Array endTimeArray;
        Array startTimeArray;
        Variable elevVarInRecVar;
        Attribute elevVarUnitsAtt;
        Variable lonVarInRecVar;
        Attribute lonVarUnitsAtt;
        this.trajDim = trajDim;
        this.trajVar = trajVar;
        this.timeDim = timeDim;
        this.timeVar = timeVar;
        this.latVar = latVar;
        this.lonVar = lonVar;
        this.elevVar = elevVar;
        this.trajectoryNumPoint = this.timeDim.getLength();
        this.timeVarUnitsString = this.timeVar.findAttribute("units").getStringValue();
        if (DateUnit.getStandardDate(this.timeVarUnitsString) == null) {
            throw new IllegalArgumentException("Units of time variable <" + this.timeVarUnitsString + "> not a date unit.");
        }
        String latVarUnitsString = this.latVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(latVarUnitsString, "degrees_north")) {
            throw new IllegalArgumentException("Units of lat var <" + latVarUnitsString + "> not compatible with \"degrees_north\".");
        }
        String lonVarUnitsString = this.lonVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(lonVarUnitsString, "degrees_east")) {
            throw new IllegalArgumentException("Units of lon var <" + lonVarUnitsString + "> not compatible with \"degrees_east\".");
        }
        String elevVarUnitsString = this.elevVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(elevVarUnitsString, "meters")) {
            throw new IllegalArgumentException("Units of elev var <" + elevVarUnitsString + "> not compatible with \"meters\".");
        }
        try {
            this.elevVarUnitsConversionFactor = MultiTrajectoryObsDataset.getMetersConversionFactor(elevVarUnitsString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception on getMetersConversionFactor() for the units of elev var <" + elevVarUnitsString + ">.");
        }
        if (this.ncfile.hasUnlimitedDimension() && this.ncfile.getUnlimitedDimension().equals(timeDim)) {
            this.ncfile.sendIospMessage("AddRecordStructure");
            this.recordVar = (Structure)this.ncfile.getRootGroup().findVariable("record");
        } else {
            this.recordVar = new StructurePseudo((NetcdfFile)this.ncfile, null, "record", timeDim);
        }
        Variable latVarInRecVar = this.recordVar.findVariable(this.latVar.getName());
        Attribute latVarUnitsAtt = latVarInRecVar.findAttribute("units");
        if (latVarUnitsAtt != null && !latVarUnitsString.equals(latVarUnitsAtt.getStringValue())) {
            latVarInRecVar.addAttribute(new Attribute("units", latVarUnitsString));
        }
        if ((lonVarUnitsAtt = (lonVarInRecVar = this.recordVar.findVariable(this.lonVar.getName())).findAttribute("units")) != null && !lonVarUnitsString.equals(lonVarUnitsAtt.getStringValue())) {
            lonVarInRecVar.addAttribute(new Attribute("units", lonVarUnitsString));
        }
        if ((elevVarUnitsAtt = (elevVarInRecVar = this.recordVar.findVariable(this.elevVar.getName())).findAttribute("units")) != null && !elevVarUnitsString.equals(elevVarUnitsAtt.getStringValue())) {
            elevVarInRecVar.addAttribute(new Attribute("units", elevVarUnitsString));
        }
        this.trajectoryVarsMap = new HashMap();
        for (Variable curVar : this.ncfile.getRootGroup().getVariables()) {
            if (curVar.getRank() < 2 || curVar.equals(this.latVar) || curVar.equals(this.lonVar) || curVar.equals(this.elevVar) || this.recordVar != null && curVar.equals(this.recordVar)) continue;
            MyTypedDataVariable typedVar = new MyTypedDataVariable(new VariableDS(null, curVar, true));
            this.dataVariables.add(typedVar);
            this.trajectoryVarsMap.put(typedVar.getName(), typedVar);
        }
        Range startPointRange = null;
        Range endPointRange = null;
        try {
            startPointRange = new Range(0, 0);
            endPointRange = new Range(this.trajectoryNumPoint - 1, this.trajectoryNumPoint - 1);
        }
        catch (InvalidRangeException e) {
            IOException ioe = new IOException("Start or end point range invalid: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        ArrayList<Range> section0 = new ArrayList<Range>(1);
        ArrayList<Range> section1 = new ArrayList<Range>(1);
        section0.add(startPointRange);
        section1.add(endPointRange);
        try {
            startTimeArray = this.timeVar.read(section0);
            endTimeArray = this.timeVar.read(section1);
        }
        catch (InvalidRangeException e) {
            IOException ioe = new IOException("Invalid range during read of start or end point: " + e.getMessage());
            ioe.initCause(e);
            throw ioe;
        }
        if (this.timeVar.getDataType().equals((Object)DataType.DOUBLE)) {
            startTimeString = startTimeArray.getDouble(startTimeArray.getIndex()) + " " + this.timeVarUnitsString;
            endTimeString = endTimeArray.getDouble(endTimeArray.getIndex()) + " " + this.timeVarUnitsString;
        } else if (this.timeVar.getDataType().equals((Object)DataType.FLOAT)) {
            startTimeString = startTimeArray.getFloat(startTimeArray.getIndex()) + " " + this.timeVarUnitsString;
            endTimeString = endTimeArray.getFloat(endTimeArray.getIndex()) + " " + this.timeVarUnitsString;
        } else if (this.timeVar.getDataType().equals((Object)DataType.INT)) {
            startTimeString = startTimeArray.getInt(startTimeArray.getIndex()) + " " + this.timeVarUnitsString;
            endTimeString = endTimeArray.getInt(endTimeArray.getIndex()) + " " + this.timeVarUnitsString;
        } else {
            String tmpMsg = "Time var <" + this.timeVar.getName() + "> is not a double, float, or integer <" + timeVar.getDataType().toString() + ">.";
            throw new IllegalArgumentException(tmpMsg);
        }
        this.startDate = DateUnit.getStandardDate(startTimeString);
        this.endDate = DateUnit.getStandardDate(endTimeString);
        this.trajectoryIds = new ArrayList();
        this.trajectories = new ArrayList();
        this.trajectoriesMap = new HashMap();
        Array trajArray = this.trajVar.read();
        Index index = trajArray.getIndex();
        int i = 0;
        while ((long)i < trajArray.getSize()) {
            String curTrajId;
            if (this.trajVar.getDataType().equals((Object)DataType.STRING)) {
                curTrajId = (String)trajArray.getObject(index.set(i));
            } else if (this.trajVar.getDataType().equals((Object)DataType.DOUBLE)) {
                curTrajId = String.valueOf(trajArray.getDouble(index.set(i)));
            } else if (this.trajVar.getDataType().equals((Object)DataType.FLOAT)) {
                curTrajId = String.valueOf(trajArray.getFloat(index.set(i)));
            } else if (this.trajVar.getDataType().equals((Object)DataType.INT)) {
                curTrajId = String.valueOf(trajArray.getInt(index.set(i)));
            } else {
                String tmpMsg = "Trajectory var <" + this.trajVar.getName() + "> is not a string, double, float, or integer <" + this.trajVar.getDataType().toString() + ">.";
                throw new IllegalStateException(tmpMsg);
            }
            MultiTrajectory curTraj = new MultiTrajectory(curTrajId, i, this.trajectoryNumPoint, this.startDate, this.endDate, this.trajVar, this.timeVar, this.timeVarUnitsString, this.latVar, this.lonVar, this.elevVar, this.dataVariables, this.trajectoryVarsMap);
            this.trajectoryIds.add(curTrajId);
            this.trajectories.add(curTraj);
            this.trajectoriesMap.put(curTrajId, curTraj);
            ++i;
        }
    }

    protected static double getMetersConversionFactor(String unitsString) throws Exception {
        SimpleUnit unit = SimpleUnit.factoryWithExceptions(unitsString);
        return unit.convertTo(1.0, SimpleUnit.meterUnit);
    }

    public boolean syncExtend() {
        return false;
    }

    protected void setStartDate() {
    }

    protected void setEndDate() {
    }

    protected void setBoundingBox() {
    }

    public List getTrajectoryIds() {
        return this.trajectoryIds;
    }

    public List getTrajectories() {
        return this.trajectories;
    }

    public TrajectoryObsDatatype getTrajectory(String trajectoryId) {
        if (trajectoryId == null) {
            return null;
        }
        return (TrajectoryObsDatatype)this.trajectoriesMap.get(trajectoryId);
    }

    public String getDetailInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("TrajectoryObsDataset\n");
        sbuff.append("  adapter   = " + this.getClass().getName() + "\n");
        sbuff.append("  trajectories:\n");
        Iterator it = this.getTrajectoryIds().iterator();
        while (it.hasNext()) {
            sbuff.append("      " + (String)it.next() + "\n");
        }
        sbuff.append(super.getDetailInfo());
        return sbuff.toString();
    }

    private class MyTypedDataVariable
    extends VariableSimpleSubclass {
        private int rank;
        private int[] shape;

        private MyTypedDataVariable(VariableDS v) {
            super(v);
            this.rank = super.getRank();
            if (MultiTrajectoryObsDataset.this.timeDim != null) {
                --this.rank;
            }
            if (MultiTrajectoryObsDataset.this.trajDim != null) {
                --this.rank;
            }
            this.shape = new int[this.rank];
            int[] varShape = super.getShape();
            int trajDimIndex = v.findDimensionIndex(MultiTrajectoryObsDataset.this.trajDim.getName());
            int timeDimIndex = v.findDimensionIndex(MultiTrajectoryObsDataset.this.timeDim.getName());
            int j = 0;
            for (int i = 0; i < varShape.length; ++i) {
                if (i == trajDimIndex || i == timeDimIndex) continue;
                this.shape[j++] = varShape[i];
            }
        }

        public int getRank() {
            return this.rank;
        }

        public int[] getShape() {
            return this.shape;
        }
    }

    private class MultiTrajectory
    implements TrajectoryObsDatatype {
        private String id;
        private int trajNum;
        private String description = null;
        private int numPoints;
        private Date startDate;
        private Date endDate;
        private String timeVarUnitsString;
        private Variable trajVar;
        private Variable timeVar;
        private Variable latVar;
        private Variable lonVar;
        private Variable elevVar;
        private List variables;
        private HashMap variablesMap;
        private Range trajPointRange;

        private MultiTrajectory(String id, int idNum, int numPoints, Date startDate, Date endDate, Variable trajVar, Variable timeVar, String timeVarUnitsString, Variable latVar, Variable lonVar, Variable elevVar, List variables, HashMap variablesMap) {
            this.id = id;
            this.trajNum = idNum;
            this.numPoints = numPoints;
            this.startDate = startDate;
            this.endDate = endDate;
            this.timeVarUnitsString = timeVarUnitsString;
            this.timeVar = timeVar;
            this.trajVar = trajVar;
            this.variables = variables;
            this.variablesMap = variablesMap;
            this.latVar = latVar;
            this.lonVar = lonVar;
            this.elevVar = elevVar;
            try {
                this.trajPointRange = new Range(this.trajNum, this.trajNum);
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException(e.getMessage());
                iae.initCause(e);
                throw iae;
            }
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public int getNumberPoints() {
            return this.numPoints;
        }

        public List getDataVariables() {
            return this.variables;
        }

        public VariableSimpleIF getDataVariable(String name) {
            return (VariableSimpleIF)this.variablesMap.get(name);
        }

        public PointObsDatatype getPointObsData(int point) throws IOException {
            return new MyPointObsDatatype(point);
        }

        public Date getStartDate() {
            return this.startDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public LatLonRect getBoundingBox() {
            return null;
        }

        public Date getTime(int point) throws IOException {
            return DateUnit.getStandardDate(this.getTimeValue(point) + " " + this.timeVarUnitsString);
        }

        public EarthLocation getLocation(int point) throws IOException {
            return new MyEarthLocation(point);
        }

        public String getTimeUnitsIdentifier() {
            return this.timeVarUnitsString;
        }

        public double getTimeValue(int point) throws IOException {
            Array array = null;
            try {
                array = this.getTime(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            if (array instanceof ArrayInt) {
                return array.getInt(array.getIndex());
            }
            throw new IOException("Time variable not float, double, or integer <" + array.getElementType().toString() + ">.");
        }

        public double getLatitude(int point) throws IOException {
            Array array = null;
            try {
                array = this.getLatitude(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Latitude variable not float or double <" + array.getElementType().toString() + ">.");
        }

        public double getLongitude(int point) throws IOException {
            Array array = null;
            try {
                array = this.getLongitude(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Longitude variable not float or double <" + array.getElementType().toString() + ">.");
        }

        public double getElevation(int point) throws IOException {
            Array array = null;
            try {
                array = this.getElevation(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Elevation variable not float or double <" + array.getElementType().toString() + ">.");
        }

        public StructureData getData(int point) throws IOException, InvalidRangeException {
            return MultiTrajectoryObsDataset.this.recordVar.readStructure(point);
        }

        public Array getData(int point, String parameterName) throws IOException {
            try {
                return this.getData(this.getPointRange(point), parameterName);
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
        }

        public Range getFullRange() {
            Range range = null;
            try {
                range = new Range(0, this.getNumberPoints() - 1);
            }
            catch (InvalidRangeException e) {
                IllegalStateException ise = new IllegalStateException("Full trajectory range invalid <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                ise.initCause(e);
                throw ise;
            }
            return range;
        }

        public Range getPointRange(int point) throws InvalidRangeException {
            if (point >= this.getNumberPoints()) {
                throw new InvalidRangeException("Point <" + point + "> not in acceptible range <0, " + (this.getNumberPoints() - 1) + ">.");
            }
            return new Range(point, point);
        }

        public Range getRange(int start, int end, int stride) throws InvalidRangeException {
            if (end >= this.getNumberPoints()) {
                throw new InvalidRangeException("End point <" + end + "> not in acceptible range <0, " + (this.getNumberPoints() - 1) + ">.");
            }
            return new Range(start, end, stride);
        }

        public Array getTime(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            return this.timeVar.read(section);
        }

        public Array getLatitude(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(2);
            section.add(range);
            section.add(this.trajPointRange);
            return this.latVar.read(section).reduce();
        }

        public Array getLongitude(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(2);
            section.add(range);
            section.add(this.trajPointRange);
            return this.lonVar.read(section);
        }

        public Array getElevation(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(2);
            section.add(range);
            section.add(this.trajPointRange);
            Array a = this.elevVar.read(section);
            if (MultiTrajectoryObsDataset.this.elevVarUnitsConversionFactor == 1.0) {
                return a;
            }
            IndexIterator it = a.getIndexIterator();
            while (it.hasNext()) {
                if (this.elevVar.getDataType() == DataType.DOUBLE) {
                    double val = it.getDoubleNext();
                    it.setDoubleCurrent(val * MultiTrajectoryObsDataset.this.elevVarUnitsConversionFactor);
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.FLOAT) {
                    float val = it.getFloatNext();
                    it.setFloatCurrent((float)((double)val * MultiTrajectoryObsDataset.this.elevVarUnitsConversionFactor));
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.INT) {
                    int val = it.getIntNext();
                    it.setIntCurrent((int)((double)val * MultiTrajectoryObsDataset.this.elevVarUnitsConversionFactor));
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.LONG) {
                    long val = it.getLongNext();
                    it.setLongCurrent((long)((double)val * MultiTrajectoryObsDataset.this.elevVarUnitsConversionFactor));
                    continue;
                }
                throw new IllegalStateException("Elevation variable type <" + this.elevVar.getDataType().toString() + "> not double, float, int, or long.");
            }
            return a;
        }

        public Array getData(Range range, String parameterName) throws IOException, InvalidRangeException {
            Variable variable = MultiTrajectoryObsDataset.this.ncfile.getRootGroup().findVariable(parameterName);
            int varRank = variable.getRank();
            int[] varShape = variable.getShape();
            ArrayList<Range> section = new ArrayList<Range>(varRank);
            section.add(range);
            section.add(this.trajPointRange);
            for (int i = 2; i < varRank; ++i) {
                section.add(new Range(0, varShape[i] - 1));
            }
            Array array = variable.read(section);
            if ((array = array.reduce(1)).getShape()[0] == 1) {
                return array.reduce(0);
            }
            return array;
        }

        public DataIterator getDataIterator(int bufferSize) throws IOException {
            return null;
        }

        private class MyEarthLocation
        extends EarthLocationImpl {
            private double latitude;
            private double longitude;
            private double elevation;

            private MyEarthLocation(int point) throws IOException {
                this.latitude = MultiTrajectory.this.getLatitude(point);
                this.longitude = MultiTrajectory.this.getLongitude(point);
                this.elevation = MultiTrajectory.this.getElevation(point);
            }

            public double getLatitude() {
                return this.latitude;
            }

            public double getLongitude() {
                return this.longitude;
            }

            public double getAltitude() {
                return this.elevation;
            }
        }

        private class MyPointObsDatatype
        implements PointObsDatatype {
            private int point;
            private double time;
            private EarthLocation earthLoc;

            private MyPointObsDatatype(int point) throws IOException {
                this.point = point;
                this.time = MultiTrajectory.this.getTimeValue(point);
                this.earthLoc = MultiTrajectory.this.getLocation(point);
            }

            public double getNominalTime() {
                return this.time;
            }

            public double getObservationTime() {
                return this.time;
            }

            public Date getNominalTimeAsDate() {
                String dateStr = this.getNominalTime() + " " + MultiTrajectory.this.timeVarUnitsString;
                return DateUnit.getStandardDate(dateStr);
            }

            public Date getObservationTimeAsDate() {
                String dateStr = this.getObservationTime() + " " + MultiTrajectory.this.timeVarUnitsString;
                return DateUnit.getStandardDate(dateStr);
            }

            public EarthLocation getLocation() {
                return this.earthLoc;
            }

            public StructureData getData() throws IOException {
                try {
                    return MultiTrajectory.this.getData(this.point);
                }
                catch (InvalidRangeException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
        }
    }
}

