/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdfparser.PDFParser;
import org.apache.pdfbox.pdfwriter.COSWriter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.util.Splitter;

public class PDFSplit {
    private static final String PASSWORD = "-password";
    private static final String SPLIT = "-split";

    private PDFSplit() {
    }

    public static void main(String[] args) throws Exception {
        PDFSplit split = new PDFSplit();
        split.split(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void split(String[] args) throws Exception {
        String password = "";
        String split = "1";
        Splitter splitter = new Splitter();
        String pdfFile = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PDFSplit.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(SPLIT)) {
                if (++i >= args.length) {
                    PDFSplit.usage();
                }
                split = args[i];
                continue;
            }
            if (pdfFile != null) continue;
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PDFSplit.usage();
        } else {
            PDDocument doc;
            int i;
            FileInputStream input = null;
            PDDocument document = null;
            List documents = null;
            try {
                input = new FileInputStream(pdfFile);
                document = PDFSplit.parseDocument(input);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt(password);
                    }
                    catch (InvalidPasswordException e) {
                        if (args.length == 4) {
                            System.err.println("Error: The supplied password is incorrect.");
                            System.exit(2);
                        }
                        System.err.println("Error: The document is encrypted.");
                        PDFSplit.usage();
                    }
                }
                splitter.setSplitAtPage(Integer.parseInt(split));
                documents = splitter.split(document);
                for (i = 0; i < documents.size(); ++i) {
                    doc = (PDDocument)documents.get(i);
                    String fileName = pdfFile.substring(0, pdfFile.length() - 4) + "-" + i + ".pdf";
                    PDFSplit.writeDocument(doc, fileName);
                    doc.close();
                }
            }
            finally {
                if (input != null) {
                    ((InputStream)input).close();
                }
                if (document != null) {
                    document.close();
                }
                for (i = 0; documents != null && i < documents.size(); ++i) {
                    doc = (PDDocument)documents.get(i);
                    doc.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void writeDocument(PDDocument doc, String fileName) throws IOException, COSVisitorException {
        FileOutputStream output = null;
        COSWriter writer = null;
        try {
            output = new FileOutputStream(fileName);
            writer = new COSWriter(output);
            writer.write(doc);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    private static PDDocument parseDocument(InputStream input) throws IOException {
        PDFParser parser = new PDFParser(input);
        parser.parse();
        return parser.getPDDocument();
    }

    private static void usage() {
        System.err.println("Usage: java org.apache.pdfbox.PDFSplit [OPTIONS] <PDF file>\n  -password  <password>        Password to decrypt document\n  -split     <integer>         split after this many pages\n  <PDF file>                   The PDF document to use\n");
        System.exit(1);
    }
}

