/*
 * Decompiled with CFR 0.152.
 */
package com.touchgraph.wikibrowser;

import com.touchgraph.graphlayout.Node;
import com.touchgraph.graphlayout.TGPanel;
import java.awt.Color;
import java.awt.Graphics;

public class WikiNode
extends Node {
    public static Color MOUSE_OVER_HYPERLINK_COLOR = Color.cyan;
    String url;
    int hintWidth = 300;
    int hintHeight = 300;
    boolean mouseOverHyperlink;

    public WikiNode() {
        this(null, "", "");
    }

    public WikiNode(String string) {
        this(null, string, "");
    }

    public WikiNode(String string, String string2, String string3) {
        super(string, string2);
        this.url = string3;
        this.mouseOverHyperlink = false;
    }

    public void setURL(String string) {
        this.url = string;
    }

    public String getURL() {
        return this.url;
    }

    public void setMouseOverHyperlink(boolean bl) {
        this.mouseOverHyperlink = bl;
    }

    public boolean getMouseOverHyperlink() {
        return this.mouseOverHyperlink;
    }

    public int getWidth() {
        if (this.fontMetrics != null && this.lbl != null) {
            if (this.typ != 3) {
                return this.fontMetrics.stringWidth(this.lbl) + 8;
            }
            return this.fontMetrics.stringWidth(this.lbl) + 28;
        }
        return 8;
    }

    public int getHeight() {
        if (this.fontMetrics != null) {
            return this.fontMetrics.getHeight() + 2;
        }
        return 8;
    }

    Color myBrighter(Color color) {
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        if (n3 > n + 64 && n3 > n2 + 64) {
            n += 32;
            n2 += 32;
        }
        n = Math.min(n + 144, 255);
        n2 = Math.min(n2 + 144, 255);
        n3 = Math.min(n3 + 144, 255);
        return new Color(n, n2, n3);
    }

    public void paint(Graphics graphics, TGPanel tGPanel) {
        if (!this.intersects(tGPanel.getSize())) {
            return;
        }
        this.paintNodeBody(graphics, tGPanel);
        int n = (int)this.drawx;
        int n2 = (int)this.drawy;
        int n3 = this.getHeight();
        int n4 = this.getWidth();
        if (this.visibleEdgeCount() < this.edgeCount()) {
            int n5 = n + (n4 - 6) / 2 - 2 + n4 % 2;
            int n6 = n2 - n3 / 2 - 3;
            String string = String.valueOf(this.edgeCount() - this.visibleEdgeCount());
            graphics.setColor(Color.red);
            graphics.fillRect(n5, n6, 3 + 5 * string.length(), 8);
            graphics.setColor(Color.white);
            graphics.setFont(Node.SMALL_TAG_FONT);
            graphics.drawString(string, n5 + 2, n6 + 7);
        }
    }

    public Color getPaintUnselectedBackColor() {
        if (this.fixed) {
            return Node.BACK_FIXED_COLOR;
        }
        if (this.markedForRemoval) {
            return this.backColor.darker().darker();
        }
        if (this.justMadeLocal) {
            return this.myBrighter(this.backColor);
        }
        return this.backColor;
    }

    public Color getPaintTextColor(TGPanel tGPanel) {
        if (this == tGPanel.getSelect()) {
            return this.getPaintUnselectedBackColor();
        }
        return this.textColor;
    }

    public Color getPaintBackColor(TGPanel tGPanel) {
        if (this.mouseOverHyperlink) {
            return MOUSE_OVER_HYPERLINK_COLOR;
        }
        if (this == tGPanel.getSelect()) {
            return Node.BACK_SELECT_COLOR;
        }
        return this.getPaintUnselectedBackColor();
    }

    public Color getPaintBorderColor(TGPanel tGPanel) {
        if (this == tGPanel.getSelect()) {
            if (this.fixed) {
                return Node.BACK_FIXED_COLOR;
            }
            if (this.markedForRemoval) {
                return new Color(100, 60, 40);
            }
            if (this.justMadeLocal) {
                return new Color(255, 220, 200);
            }
            return this.backColor;
        }
        return super.getPaintBorderColor(tGPanel);
    }
}

