/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fontbox.cff;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.fontbox.cff.CharStringCommand;
import org.apache.fontbox.cff.DataInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Type1CharStringParser {
    private DataInput input = null;
    private List<Object> sequence = null;

    public List<Object> parse(byte[] bytes) throws IOException {
        this.input = new DataInput(bytes);
        this.sequence = new ArrayList<Object>();
        while (this.input.hasRemaining()) {
            int b0 = this.input.readUnsignedByte();
            if (b0 >= 0 && b0 <= 31) {
                this.sequence.add(this.readCommand(b0));
                continue;
            }
            if (b0 >= 32 && b0 <= 255) {
                this.sequence.add(this.readNumber(b0));
                continue;
            }
            throw new IllegalArgumentException();
        }
        return this.sequence;
    }

    private CharStringCommand readCommand(int b0) throws IOException {
        if (b0 == 12) {
            int b1 = this.input.readUnsignedByte();
            return new CharStringCommand(b0, b1);
        }
        return new CharStringCommand(b0);
    }

    private Integer readNumber(int b0) throws IOException {
        if (b0 >= 32 && b0 <= 246) {
            return b0 - 139;
        }
        if (b0 >= 247 && b0 <= 250) {
            int b1 = this.input.readUnsignedByte();
            return (b0 - 247) * 256 + b1 + 108;
        }
        if (b0 >= 251 && b0 <= 254) {
            int b1 = this.input.readUnsignedByte();
            return -(b0 - 251) * 256 - b1 - 108;
        }
        if (b0 == 255) {
            int b1 = this.input.readUnsignedByte();
            int b2 = this.input.readUnsignedByte();
            int b3 = this.input.readUnsignedByte();
            int b4 = this.input.readUnsignedByte();
            return b1 << 24 | b2 << 16 | b3 << 8 | b4;
        }
        throw new IllegalArgumentException();
    }
}

