/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.ogc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.util.Parameter;

public class EPSG_OGC_CF_Helper {
    private static Logger log = LoggerFactory.getLogger(EPSG_OGC_CF_Helper.class);

    public static String getWcs1_0CrsId(Projection proj) {
        String paramName = null;
        if (proj == null) {
            paramName = "LatLon";
        } else {
            for (Parameter curParam : proj.getProjectionParameters()) {
                if (!curParam.getName().equalsIgnoreCase("grid_mapping_name") || !curParam.isString()) continue;
                paramName = curParam.getStringValue();
            }
        }
        if (paramName == null) {
            return null;
        }
        if (paramName.equalsIgnoreCase("LatLon")) {
            paramName = "latitude_longitude";
            return "OGC:CRS84";
        }
        ProjectionStandardsInfo psi = ProjectionStandardsInfo.getProjectionByCfName(paramName);
        return "EPSG:" + psi.getEpsgCode() + "[" + psi.name() + "]";
    }

    public String getWcs1_0CrsId(GridDatatype gridDatatype, GridDataset gridDataset) throws IllegalArgumentException {
        gridDataset.getTitle();
        gridDatatype.getName();
        StringBuilder buf = new StringBuilder();
        Attribute gridMappingAtt = gridDatatype.findAttributeIgnoreCase("grid_mapping");
        String gridMapping = gridMappingAtt.getStringValue();
        Variable gridMapVar = gridDataset.getNetcdfFile().findTopVariable(gridMapping);
        Attribute gridMappingNameAtt = gridMapVar.findAttributeIgnoreCase("grid_mapping_name");
        String gridMappingName = gridMappingNameAtt.getStringValue();
        buf.append("EPSG:").append((Object)ProjectionStandardsInfo.getProjectionByCfName(gridMappingName));
        return buf.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectionStandardsInfo {
        Albers_Conic_Equal_Area(9822, "Albers Equal Area", "albers_conical_equal_area"),
        Azimuthal_Equidistant(-1, "", "azimuthal_equidistant"),
        Lambert_Azimuthal_Equal_Area(9820, "Lambert Azimuthal Equal Area", "lambert_azimuthal_equal_area"),
        Lambert_Conformal_Conic_2SP(9802, "Lambert Conic Conformal (2SP)", "lambert_conformal_conic"),
        Polar_Stereographic(9810, "Polar Stereographic (Variant A)", "polar_stereographic"),
        Rotated_Pole(-2, "", "rotated_latitude_longitude"),
        Stereographic(-3, "", "stereographic"),
        Transverse_Mercator(9807, "Transverse Mercator", "transverse_mercator"),
        Latitude_Longitude(0, "", "latitude_longitude"),
        Vertical_Perspective(9838, "Vertical Perspective", "vertical_perspective"),
        Lambert_Cylindrical_Equal_Area(9835, "Lambert Cylindrical Equal Area", "lambert_cylindrical_equal_area"),
        Mercator(9805, "Mercator (2SP)", "mercator"),
        Orthographic(9840, "Orthographic", "orthographic");

        private final int epsgCode;
        private final String epsgName;
        private final String cfName;

        public String getOgcName() {
            return this.name();
        }

        public int getEpsgCode() {
            return this.epsgCode;
        }

        public String getEpsgName() {
            return this.epsgName;
        }

        public String getCfName() {
            return this.cfName;
        }

        private ProjectionStandardsInfo(int epsgCode, String epsgName, String cfName) {
            this.epsgCode = epsgCode;
            this.epsgName = epsgName;
            this.cfName = cfName;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("[[OGC: ").append(this.name()).append("] [EPSG ").append(this.getEpsgCode()).append(": ").append(this.getEpsgName()).append("] [CF: ").append(this.getCfName()).append("]]");
            return buf.toString();
        }

        public static ProjectionStandardsInfo getProjectionByOgcName(String ogcName) {
            for (ProjectionStandardsInfo curProjStdInfo : ProjectionStandardsInfo.values()) {
                if (!curProjStdInfo.name().equals(ogcName)) continue;
                return curProjStdInfo;
            }
            throw new IllegalArgumentException("No such instance <" + ogcName + ">.");
        }

        public static ProjectionStandardsInfo getProjectionByEpsgCode(int epsgCode) {
            for (ProjectionStandardsInfo curProjStdInfo : ProjectionStandardsInfo.values()) {
                if (curProjStdInfo.getEpsgCode() != epsgCode) continue;
                return curProjStdInfo;
            }
            throw new IllegalArgumentException("No such instance <" + epsgCode + ">.");
        }

        public static ProjectionStandardsInfo getProjectionByEpsgName(String epsgName) {
            for (ProjectionStandardsInfo curProjStdInfo : ProjectionStandardsInfo.values()) {
                if (!curProjStdInfo.getEpsgName().equals(epsgName)) continue;
                return curProjStdInfo;
            }
            throw new IllegalArgumentException("No such instance <" + epsgName + ">.");
        }

        public static ProjectionStandardsInfo getProjectionByCfName(String cfName) {
            for (ProjectionStandardsInfo curProjStdInfo : ProjectionStandardsInfo.values()) {
                if (!curProjStdInfo.getCfName().equals(cfName)) continue;
                return curProjStdInfo;
            }
            throw new IllegalArgumentException("No such instance <" + cfName + ">.");
        }
    }
}

