/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccessFile;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDCcitt;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;

public class AddImageToPDF {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createPDFFromImage(String inputFile, String image, String outputFile) throws IOException, COSVisitorException {
        PDDocument doc = null;
        try {
            doc = PDDocument.load(inputFile);
            PDPage page = (PDPage)doc.getDocumentCatalog().getAllPages().get(0);
            PDXObjectImage ximage = null;
            if (image.toLowerCase().endsWith(".jpg")) {
                ximage = new PDJpeg(doc, new FileInputStream(image));
            } else if (image.toLowerCase().endsWith(".tif") || image.toLowerCase().endsWith(".tiff")) {
                ximage = new PDCcitt(doc, new RandomAccessFile(new File(image), "r"));
            } else {
                throw new IOException("Image type not supported:" + image);
            }
            PDPageContentStream contentStream = new PDPageContentStream(doc, page, true, true);
            contentStream.drawImage(ximage, 20.0f, 20.0f);
            contentStream.close();
            doc.save(outputFile);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        AddImageToPDF app = new AddImageToPDF();
        try {
            if (args.length != 3) {
                app.usage();
            } else {
                app.createPDFFromImage(args[0], args[1], args[2]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <input-pdf> <image> <output-pdf>");
    }
}

