/*
 * Decompiled with CFR 0.152.
 */
package com.jmatio.types;

public class MLArray {
    public static final int mxUNKNOWN_CLASS = 0;
    public static final int mxCELL_CLASS = 1;
    public static final int mxSTRUCT_CLASS = 2;
    public static final int mxOBJECT_CLASS = 3;
    public static final int mxCHAR_CLASS = 4;
    public static final int mxSPARSE_CLASS = 5;
    public static final int mxDOUBLE_CLASS = 6;
    public static final int mxSINGLE_CLASS = 7;
    public static final int mxINT8_CLASS = 8;
    public static final int mxUINT8_CLASS = 9;
    public static final int mxINT16_CLASS = 10;
    public static final int mxUINT16_CLASS = 11;
    public static final int mxINT32_CLASS = 12;
    public static final int mxUINT32_CLASS = 13;
    public static final int mxINT64_CLASS = 14;
    public static final int mxUINT64_CLASS = 15;
    public static final int mxFUNCTION_CLASS = 16;
    public static final int mxOPAQUE_CLASS = 17;
    public static final int mtFLAG_COMPLEX = 2048;
    public static final int mtFLAG_GLOBAL = 1024;
    public static final int mtFLAG_LOGICAL = 512;
    public static final int mtFLAG_TYPE = 255;
    protected int[] dims;
    public String name;
    protected int attributes;
    protected int type;

    public MLArray(String name, int[] dims, int type, int attributes) {
        this.dims = new int[dims.length];
        System.arraycopy(dims, 0, this.dims, 0, dims.length);
        this.name = name != null && !name.equals("") ? name : "@";
        this.type = type;
        this.attributes = attributes;
    }

    public String getName() {
        return this.name;
    }

    public int getFlags() {
        int flags = this.type & 0xFF | this.attributes & 0xFFFFFF00;
        return flags;
    }

    public byte[] getNameToByteArray() {
        return this.name.getBytes();
    }

    public int[] getDimensions() {
        int[] ai = null;
        if (this.dims != null) {
            ai = new int[this.dims.length];
            System.arraycopy(this.dims, 0, ai, 0, this.dims.length);
        }
        return ai;
    }

    public int getM() {
        int i = 0;
        if (this.dims != null) {
            i = this.dims[0];
        }
        return i;
    }

    public int getN() {
        int i = 0;
        if (this.dims != null) {
            if (this.dims.length > 2) {
                i = 1;
                for (int j = 1; j < this.dims.length; ++j) {
                    i *= this.dims[j];
                }
            } else {
                i = this.dims[1];
            }
        }
        return i;
    }

    public int getNDimensions() {
        int i = 0;
        if (this.dims != null) {
            i = this.dims.length;
        }
        return i;
    }

    public int getSize() {
        return this.getM() * this.getN();
    }

    public int getType() {
        return this.type;
    }

    public boolean isEmpty() {
        return this.getN() == 0;
    }

    public static final String typeToString(int type) {
        String s;
        switch (type) {
            case 0: {
                s = "unknown";
                break;
            }
            case 1: {
                s = "cell";
                break;
            }
            case 2: {
                s = "struct";
                break;
            }
            case 4: {
                s = "char";
                break;
            }
            case 5: {
                s = "sparse";
                break;
            }
            case 6: {
                s = "double";
                break;
            }
            case 7: {
                s = "single";
                break;
            }
            case 8: {
                s = "int8";
                break;
            }
            case 9: {
                s = "uint8";
                break;
            }
            case 10: {
                s = "int16";
                break;
            }
            case 11: {
                s = "uint16";
                break;
            }
            case 12: {
                s = "int32";
                break;
            }
            case 13: {
                s = "uint32";
                break;
            }
            case 14: {
                s = "int64";
                break;
            }
            case 15: {
                s = "uint64";
                break;
            }
            case 16: {
                s = "function_handle";
                break;
            }
            case 17: {
                s = "opaque";
                break;
            }
            case 3: {
                s = "object";
                break;
            }
            default: {
                s = "unknown";
            }
        }
        return s;
    }

    public boolean isCell() {
        return this.type == 1;
    }

    public boolean isChar() {
        return this.type == 4;
    }

    public boolean isComplex() {
        return (this.attributes & 0x800) == 2048;
    }

    public boolean isSparse() {
        return this.type == 5;
    }

    public boolean isStruct() {
        return this.type == 2;
    }

    public boolean isDouble() {
        return this.type == 6;
    }

    public boolean isSingle() {
        return this.type == 7;
    }

    public boolean isInt8() {
        return this.type == 8;
    }

    public boolean isUint8() {
        return this.type == 9;
    }

    public boolean isInt16() {
        return this.type == 10;
    }

    public boolean isUint16() {
        return this.type == 11;
    }

    public boolean isInt32() {
        return this.type == 12;
    }

    public boolean isUint32() {
        return this.type == 13;
    }

    public boolean isInt64() {
        return this.type == 14;
    }

    public boolean isUint64() {
        return this.type == 15;
    }

    public boolean isObject() {
        return this.type == 3;
    }

    public boolean isOpaque() {
        return this.type == 17;
    }

    public boolean isLogical() {
        return (this.attributes & 0x200) == 512;
    }

    public boolean isFunctionObject() {
        return this.type == 16;
    }

    public boolean isUnknown() {
        return this.type == 0;
    }

    protected int getIndex(int m, int n) {
        return m + n * this.getM();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.dims != null) {
            sb.append('[');
            if (this.dims.length > 3) {
                sb.append(this.dims.length);
                sb.append('D');
            } else {
                sb.append(this.dims[0]);
                sb.append('x');
                sb.append(this.dims[1]);
                if (this.dims.length == 3) {
                    sb.append('x');
                    sb.append(this.dims[2]);
                }
            }
            sb.append("  ");
            sb.append(MLArray.typeToString(this.type));
            if (this.isLogical()) {
                sb.append(" (logical)");
            }
            sb.append(" array");
            if (this.isSparse()) {
                sb.append(" (sparse");
                if (this.isComplex()) {
                    sb.append(" complex");
                }
                sb.append(")");
            } else if (this.isComplex()) {
                sb.append(" (complex)");
            }
            sb.append(']');
        } else {
            sb.append("[invalid]");
        }
        return sb.toString();
    }

    public String contentToString() {
        return "content cannot be displayed";
    }

    public void dispose() {
    }
}

