/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.factory.sql;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import javax.measure.IncommensurableException;
import javax.measure.Unit;
import org.apache.sis.internal.referencing.ExtentSelector;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.datum.BursaWolfParameters;
import org.apache.sis.referencing.factory.FactoryDataException;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.util.resources.Errors;
import org.opengis.metadata.extent.Extent;
import org.opengis.util.FactoryException;

final class BursaWolfInfo {
    static final int TARGET_CRS = 4326;
    static final int TARGET_DATUM = 6326;
    static final int MIN_METHOD_CODE = 9603;
    static final int MAX_METHOD_CODE = 9607;
    private static final int ROTATION_FRAME_CODE = 9607;
    final int operation;
    final int method;
    final int target;
    private final int domainOfValidity;
    private Extent extent;

    static void setBursaWolfParameter(BursaWolfParameters bursaWolfParameters, int n, double d, Unit<?> unit, Locale locale) throws FactoryDataException {
        Unit<Object> unit2 = unit;
        if (n >= 8605) {
            if (n <= 8607) {
                unit2 = Units.METRE;
            } else if (n <= 8610) {
                unit2 = Units.ARC_SECOND;
            } else if (n == 8611) {
                unit2 = Units.PPM;
            }
        }
        if (unit2 != unit) {
            try {
                d = unit.getConverterToAny(unit2).convert(d);
            }
            catch (IncommensurableException incommensurableException) {
                throw new FactoryDataException(Errors.getResources(locale).getString((short)65, unit), incommensurableException);
            }
        }
        switch (n) {
            case 8605: {
                bursaWolfParameters.tX = d;
                break;
            }
            case 8606: {
                bursaWolfParameters.tY = d;
                break;
            }
            case 8607: {
                bursaWolfParameters.tZ = d;
                break;
            }
            case 8608: {
                bursaWolfParameters.rX = d;
                break;
            }
            case 8609: {
                bursaWolfParameters.rY = d;
                break;
            }
            case 8610: {
                bursaWolfParameters.rZ = d;
                break;
            }
            case 8611: {
                bursaWolfParameters.dS = d;
                break;
            }
            default: {
                throw new FactoryDataException(Errors.getResources(locale).getString((short)140, n));
            }
        }
    }

    BursaWolfInfo(int n, int n2, int n3, int n4) {
        this.operation = n;
        this.method = n2;
        this.domainOfValidity = n4;
        switch (n3) {
            case 4326: {
                this.target = 6326;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n3));
            }
        }
    }

    boolean isFrameRotation() {
        return this.method == 9607;
    }

    public String toString() {
        return String.valueOf(this.operation);
    }

    Extent getDomainOfValidity(GeodeticAuthorityFactory geodeticAuthorityFactory) throws FactoryException {
        if (this.extent == null && this.domainOfValidity != 0) {
            this.extent = geodeticAuthorityFactory.createExtent(String.valueOf(this.domainOfValidity));
        }
        return this.extent;
    }

    static void filter(GeodeticAuthorityFactory geodeticAuthorityFactory, BursaWolfInfo[] bursaWolfInfoArray, List<BursaWolfInfo> list) throws FactoryException {
        LinkedHashMap<Integer, ExtentSelector<BursaWolfInfo>> linkedHashMap = new LinkedHashMap<Integer, ExtentSelector<BursaWolfInfo>>();
        for (BursaWolfInfo bursaWolfInfo : bursaWolfInfoArray) {
            Integer n = bursaWolfInfo.target;
            ExtentSelector<BursaWolfInfo> extentSelector = (ExtentSelector<BursaWolfInfo>)linkedHashMap.get(n);
            if (extentSelector == null) {
                extentSelector = new ExtentSelector<BursaWolfInfo>(null);
                linkedHashMap.put(n, extentSelector);
            }
            extentSelector.evaluate(bursaWolfInfo.getDomainOfValidity(geodeticAuthorityFactory), bursaWolfInfo);
        }
        for (ExtentSelector extentSelector : linkedHashMap.values()) {
            list.add((BursaWolfInfo)extentSelector.best());
        }
    }
}

