/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.util.logging;

import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Classes;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Static;
import org.apache.sis.util.logging.DualLoggerFactory;
import org.apache.sis.util.logging.LoggerFactory;
import org.apache.sis.util.logging.WarningListeners;

public final class Logging
extends Static {
    private static final int LEVEL_THRESHOLD_FOR_STACKTRACE = 600;
    private static volatile LoggerFactory<?> factory;

    private Logging() {
    }

    public static void setLoggerFactory(LoggerFactory<?> loggerFactory) {
        factory = loggerFactory;
    }

    public static LoggerFactory<?> getLoggerFactory() {
        return factory;
    }

    public static Logger getLogger(String string) {
        Logger logger;
        LoggerFactory<?> loggerFactory = factory;
        if (loggerFactory != null && (logger = loggerFactory.getLogger(string)) != null) {
            return logger;
        }
        return Logger.getLogger(string);
    }

    static Logger getLogger(Class<?> clazz) {
        Class<?> clazz2;
        while ((clazz2 = clazz.getEnclosingClass()) != null) {
            clazz = clazz2;
        }
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        String string2 = string = n >= 1 ? string.substring(0, n) : "";
        if (string.startsWith("org.apache.sis.internal.")) {
            string = "org.apache.sis." + string.substring("org.apache.sis.internal.".length());
        }
        return Logging.getLogger(string);
    }

    public static void log(Class<?> clazz, String string, LogRecord logRecord) {
        Logger logger;
        ArgumentChecks.ensureNonNull("record", logRecord);
        String string2 = logRecord.getLoggerName();
        if (string2 == null) {
            logger = Logging.getLogger(clazz);
            logRecord.setLoggerName(logger.getName());
        } else {
            logger = Logging.getLogger(string2);
        }
        if (clazz != null && string != null) {
            logRecord.setSourceClassName(clazz.getCanonicalName());
            logRecord.setSourceMethodName(string);
        } else {
            logger = Logging.inferCaller(logger, clazz != null ? clazz.getCanonicalName() : null, string, Thread.currentThread().getStackTrace(), logRecord);
        }
        logger.log(logRecord);
    }

    private static Logger inferCaller(Logger logger, String string, String string2, StackTraceElement[] stackTraceElementArray, LogRecord logRecord) {
        for (StackTraceElement stackTraceElement : stackTraceElementArray) {
            String string3 = stackTraceElement.getClassName();
            if (string != null ? !string3.equals(string) : !WarningListeners.isPublic(stackTraceElement)) continue;
            String string4 = stackTraceElement.getMethodName();
            if (string2 != null && !string4.equals(string2)) continue;
            if (logger == null) {
                int n = string3.lastIndexOf(46);
                logger = Logging.getLogger(n >= 1 ? string3.substring(0, n - 1) : "");
            }
            if (string == null) {
                string = string3;
            }
            if (string2 != null) break;
            string2 = string4;
            break;
        }
        if (logger == null) {
            logger = Logging.getLogger("global");
        }
        if (string != null) {
            logRecord.setSourceClassName(string);
        }
        if (string2 != null) {
            logRecord.setSourceMethodName(string2);
        }
        return logger;
    }

    public static boolean unexpectedException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.WARNING);
    }

    private static boolean unexpectedException(Logger logger, String string, String string2, Throwable throwable, Level level) {
        String string3;
        if (throwable == null) {
            return false;
        }
        if (logger == null && string != null) {
            int n = string.lastIndexOf(46);
            string3 = n >= 1 ? string.substring(0, n - 1) : "";
            logger = Logging.getLogger(string3);
        }
        if (logger != null && !logger.isLoggable(level)) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder(256).append(Classes.getShortClassName(throwable));
        string3 = throwable.getMessage();
        if (string3 != null) {
            stringBuilder.append(": ").append(string3);
        }
        string3 = stringBuilder.toString();
        string3 = Exceptions.formatChainedMessages(null, string3, throwable);
        LogRecord logRecord = new LogRecord(level, string3);
        if (level.intValue() >= 600) {
            logRecord.setThrown(throwable);
        }
        if (logger == null || string == null || string2 == null) {
            logger = Logging.inferCaller(logger, string, string2, throwable.getStackTrace(), logRecord);
        } else {
            logRecord.setSourceClassName(string);
            logRecord.setSourceMethodName(string2);
        }
        logRecord.setLoggerName(logger.getName());
        logger.log(logRecord);
        return true;
    }

    static boolean configurationException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.CONFIG);
    }

    public static boolean recoverableException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.FINE);
    }

    public static boolean severeException(Logger logger, Class<?> clazz, String string, Throwable throwable) {
        String string2 = clazz != null ? clazz.getName() : null;
        return Logging.unexpectedException(logger, string2, string, throwable, Level.SEVERE);
    }

    static {
        LoggerFactory loggerFactory = null;
        for (LoggerFactory loggerFactory2 : ServiceLoader.load(LoggerFactory.class)) {
            if (loggerFactory == null) {
                loggerFactory = loggerFactory2;
                continue;
            }
            loggerFactory = new DualLoggerFactory(loggerFactory, loggerFactory2);
        }
        factory = loggerFactory;
    }
}

