/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.print.PrintService;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPageable;

public final class PrintPDF {
    private static final String PASSWORD = "-password";
    private static final String SILENT = "-silentPrint";
    private static final String PRINTER_NAME = "-printerName";
    private static final String ORIENTATION = "-orientation";
    private static final String BORDER = "-border";
    private static final String DPI = "-dpi";

    private PrintPDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws PrinterException, IOException {
        try {
            Class.forName("sun.java2d.cmm.kcms.KcmsServiceProvider");
            System.setProperty("sun.java2d.cmm", "sun.java2d.cmm.kcms.KcmsServiceProvider");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        System.setProperty("apple.awt.UIElement", "true");
        String password = "";
        String pdfFile = null;
        boolean silentPrint = false;
        String printerName = null;
        Orientation orientation = Orientation.AUTO;
        boolean showPageBorder = false;
        int dpi = 0;
        HashMap<String, Orientation> orientationMap = new HashMap<String, Orientation>();
        orientationMap.put("auto", Orientation.AUTO);
        orientationMap.put("landscape", Orientation.LANDSCAPE);
        orientationMap.put("portrait", Orientation.PORTRAIT);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(PRINTER_NAME)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                printerName = args[i];
                continue;
            }
            if (args[i].equals(SILENT)) {
                silentPrint = true;
                continue;
            }
            if (args[i].equals(ORIENTATION)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                if ((orientation = (Orientation)((Object)orientationMap.get(args[i]))) != null) continue;
                PrintPDF.usage();
                continue;
            }
            if (args[i].equals(BORDER)) {
                showPageBorder = true;
                continue;
            }
            if (args[i].equals(DPI)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                dpi = Integer.parseInt(args[i]);
                continue;
            }
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PrintPDF.usage();
        }
        PDDocument document = null;
        try {
            document = PDDocument.load(new File(pdfFile), password);
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName(new File(pdfFile).getName());
            if (printerName != null) {
                PrintService[] printService = PrinterJob.lookupPrintServices();
                boolean printerFound = false;
                for (int i = 0; !printerFound && i < printService.length; ++i) {
                    if (!printService[i].getName().contains(printerName)) continue;
                    printJob.setPrintService(printService[i]);
                    printerFound = true;
                }
            }
            printJob.setPageable(new PDFPageable(document, orientation, showPageBorder, dpi));
            if (silentPrint || printJob.printDialog()) {
                printJob.print();
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar PrintPDF [options] <inputfile>\n\nOptions:\n  -password  <password>                : Password to decrypt document\n  -printerName <name>                  : Print to specific printer\n  -orientation auto|portrait|landscape : Print using orientation\n                                           (default: auto)\n  -border                              : Print with border\n  -dpi                                 : Render into intermediate image with\n                                           specific dpi and then print\n  -silentPrint                         : Print without printer dialog box\n";
        System.err.println(message);
        System.exit(1);
    }
}

